/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.device.firmware.upgrade.local.monitor;

import com.tplink.smb.device.firmware.upgrade.common.constants.device.DeviceFirmwareUpgradeError;
import com.tplink.smb.device.firmware.upgrade.common.dto.device.DeviceHolder;
import com.tplink.smb.device.firmware.upgrade.common.event.UpgradeDomainEvent;
import com.tplink.smb.device.firmware.upgrade.core.monitor.BaseFirmwareUpgradeMonitor;
import com.tplink.smb.device.firmware.upgrade.local.TokenBucket;
import com.tplink.smb.eventcenter.api.event.DomainEvent;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LocalFirmwareUpgradeMonitor
extends BaseFirmwareUpgradeMonitor {
    private static final Logger log = LoggerFactory.getLogger(LocalFirmwareUpgradeMonitor.class);
    @Autowired
    private TokenBucket tokenBucket;

    protected void doMonitorTask() {
        this.removeTimeoutDevices();
        this.trySendUpgradeRequestForWaitingDevice();
        this.checkWaitingQueue();
        this.checkMonitorQueue();
    }

    private void checkMonitorQueue() {
        if (this.upgradeRepository.getLengthOfMonitorQueue() == 0) {
            this.tokenBucket.fillAllTokens();
        }
    }

    protected void notifyWaitingQueue() {
        DomainEventBusHolder.getPublisher().publish((DomainEvent)new UpgradeDomainEvent());
    }

    private void trySendUpgradeRequestForWaitingDevice() {
        this.tokenBucket.tryUpgradeWaitingDevices();
    }

    private void checkWaitingQueue() {
        List timeoutWaitingList = this.upgradeRepository.pollTimeoutDevicesFromWaitingQueue();
        if (timeoutWaitingList.isEmpty()) {
            return;
        }
        for (String deviceHolderStr : timeoutWaitingList) {
            DeviceHolder deviceHolder = DeviceHolder.toBean((String)deviceHolderStr);
            String deviceMac = deviceHolder.getDeviceMac();
            String sysId = deviceHolder.getSysId();
            log.error("sysId:{}, checkWaitingQueue timeout to update status{}.", (Object)sysId, (Object)DeviceFirmwareUpgradeError.STAGE_REQUEST_TIMEOUT);
            this.upgradeRepository.updateStatusFromTimeoutMonitor(deviceMac, sysId, DeviceFirmwareUpgradeError.STAGE_REQUEST_TIMEOUT);
        }
    }
}

