/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.device.firmware.upgrade.local.manager;

import com.tplink.smb.device.firmware.upgrade.common.constants.FirmwareUpgradeStatusEnum;
import com.tplink.smb.device.firmware.upgrade.common.dto.UpgradeRequestDTO;
import com.tplink.smb.device.firmware.upgrade.common.dto.UpgradeStatusDTO;
import com.tplink.smb.device.firmware.upgrade.common.event.UpgradeDomainEvent;
import com.tplink.smb.device.firmware.upgrade.core.BaseDeviceFirmwareUpgradeManager;
import com.tplink.smb.device.firmware.upgrade.core.po.DeviceUpgradePO;
import com.tplink.smb.device.firmware.upgrade.local.property.LocalFirmwareUpgradeProperties;
import com.tplink.smb.eventcenter.api.Event;
import com.tplink.smb.eventcenter.api.event.DomainEvent;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LocalDeviceFirmwareUpgradeManager
extends BaseDeviceFirmwareUpgradeManager {
    private static final Logger log = LoggerFactory.getLogger(LocalDeviceFirmwareUpgradeManager.class);
    @Autowired
    private LocalFirmwareUpgradeProperties localProperties;

    public void publishMessage(String deviceMac, String sysId) {
        if (this.localProperties.isEventPublish()) {
            this.upgradeRepository.getUpgradePO(deviceMac, sysId).ifPresent(upgradePO -> {
                UpgradeStatusDTO statusDTO = DeviceUpgradePO.toStatusDTO((DeviceUpgradePO)upgradePO);
                Event event = Event.builder().message(statusDTO.toJson()).build();
                log.debug("sysId:{}, to publishMessage.", (Object)sysId);
                this.eventCenter.send(this.localProperties.getUpgradeStatusTopic(), event);
            });
        }
    }

    public void sendUpgradeRequest(List<UpgradeRequestDTO> upgradeRequestList) {
        for (UpgradeRequestDTO upgradeRequest : upgradeRequestList) {
            String deviceMac = upgradeRequest.getDeviceMac();
            String sysId = upgradeRequest.getSysId();
            boolean deviceOkForUpgrading = this.upgradeRepository.initFromUpgradeRequest(upgradeRequest, FirmwareUpgradeStatusEnum.UPGRADE_WAITING);
            if (!deviceOkForUpgrading) continue;
            this.publishMessage(deviceMac, sysId);
            log.debug("sysId:{}, upgrade waiting time {}", (Object)sysId, (Object)this.localProperties.getWaitingTime());
            this.upgradeRepository.addDeviceToWaitingList(deviceMac, sysId, this.localProperties.getWaitingTime());
        }
    }

    public void notifyWaitingQueue() {
        DomainEventBusHolder.getPublisher().publish((DomainEvent)new UpgradeDomainEvent());
    }
}

