/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.device.firmware.upgrade.local.api;

import com.tplink.smb.device.firmware.upgrade.api.FirmwareUpgradeService;
import com.tplink.smb.device.firmware.upgrade.common.dto.UpgradeRequestDTO;
import com.tplink.smb.device.firmware.upgrade.common.dto.UpgradeStatusDTO;
import com.tplink.smb.device.firmware.upgrade.common.dto.device.DeviceHolder;
import com.tplink.smb.device.firmware.upgrade.common.handler.AbstractUpgradeStatusHandler;
import com.tplink.smb.device.firmware.upgrade.core.BaseDeviceFirmwareUpgradeManager;
import com.tplink.smb.device.firmware.upgrade.core.monitor.BaseFirmwareUpgradeMonitor;
import com.tplink.smb.device.firmware.upgrade.local.TokenBucket;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LocalFirmwareUpgradeServiceImpl
implements FirmwareUpgradeService {
    @Autowired
    private BaseDeviceFirmwareUpgradeManager upgradeManager;
    @Autowired
    private TokenBucket tokenBucket;
    @Autowired
    private BaseFirmwareUpgradeMonitor monitor;

    public UpgradeStatusDTO getUpgradeStatus(String deviceMac, String sysId) {
        return this.upgradeManager.getDeviceUpgradeStatus(deviceMac, sysId);
    }

    public List<UpgradeStatusDTO> getUpgradeStatusList(List<DeviceHolder> deviceList) {
        return this.upgradeManager.getDeviceUpgradeStatus(deviceList);
    }

    public UpgradeStatusDTO reportUpgradeFinished(String deviceMac, String sysId) {
        return this.upgradeManager.reportReconnected(deviceMac, sysId);
    }

    public void registerUpgradeStatus(@Nonnull AbstractUpgradeStatusHandler statusHandler) {
        this.upgradeManager.registerUpgradeStatus(statusHandler);
    }

    public void unregisterUpgradeStatus(@Nonnull AbstractUpgradeStatusHandler statusHandler) {
        this.upgradeManager.unregisterUpgradeStatus(statusHandler);
    }

    public void sendUpgradeRequest(UpgradeRequestDTO upgradeRequestDTO) {
        List<UpgradeRequestDTO> upgradeRequestDTOList = Collections.singletonList(upgradeRequestDTO);
        this.batchSendUpgradeRequest(upgradeRequestDTOList);
    }

    public void batchSendUpgradeRequest(List<UpgradeRequestDTO> upgradeRequestDTOList) {
        this.upgradeManager.sendUpgradeRequest(upgradeRequestDTOList);
        this.tokenBucket.tryUpgradeWaitingDevices();
    }
}

