/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.device.firmware.upgrade.local;

import com.tplink.smb.device.firmware.upgrade.common.dto.device.DeviceHolder;
import com.tplink.smb.device.firmware.upgrade.common.event.UpgradeDomainEvent;
import com.tplink.smb.device.firmware.upgrade.core.BaseDeviceFirmwareUpgradeManager;
import com.tplink.smb.device.firmware.upgrade.core.repository.FirmwareUpgradeRepository;
import com.tplink.smb.device.firmware.upgrade.local.property.LocalFirmwareUpgradeProperties;
import com.tplink.smb.eventcenter.api.event.DomainEventSubscriber;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TokenBucket
implements DomainEventSubscriber<UpgradeDomainEvent> {
    private static final Logger log = LoggerFactory.getLogger(TokenBucket.class);
    @Autowired
    private BaseDeviceFirmwareUpgradeManager upgradeManager;
    @Autowired
    private FirmwareUpgradeRepository upgradeRepository;
    @Autowired
    private LocalFirmwareUpgradeProperties localProperties;
    private int maxSize;
    private long waitingTimeout;
    private AtomicInteger currSize;

    @PostConstruct
    public void constructTokenBucket() {
        this.maxSize = this.localProperties.getMaxDownloadingDevices();
        this.waitingTimeout = this.localProperties.getLongestWaitingTime();
        this.currSize = new AtomicInteger(this.maxSize);
        DomainEventBusHolder.getHandlerRegistry().register(UpgradeDomainEvent.class, (DomainEventSubscriber)this);
    }

    public synchronized void fillAllTokens() {
        this.currSize.set(this.maxSize);
    }

    public synchronized boolean getToken() {
        if (this.currSize.get() == 0) {
            return false;
        }
        return this.currSize.getAndDecrement() > 0;
    }

    public synchronized void addToken() {
        if (this.currSize.get() < this.maxSize) {
            this.currSize.incrementAndGet();
        }
    }

    public synchronized void tryUpgradeWaitingDevices() {
        while (this.tryUpgradeOneWaitingDevice()) {
            this.doNothing();
        }
    }

    private void doNothing() {
    }

    public void handleEvent(UpgradeDomainEvent event) {
        this.addToken();
        this.tryUpgradeOneWaitingDevice();
    }

    private synchronized boolean tryUpgradeOneWaitingDevice() {
        if (this.getToken()) {
            DeviceHolder waitingDevice = this.upgradeRepository.getOneWaitingDevice();
            if (Objects.nonNull(waitingDevice)) {
                String waitingDeviceMac = waitingDevice.getDeviceMac();
                String waitingSysId = waitingDevice.getSysId();
                this.upgradeRepository.updateStatusWhenWaitingDeviceReady(waitingDeviceMac, waitingSysId);
                this.upgradeRepository.removeDeviceInWaitingQueue(waitingDeviceMac, waitingSysId);
                this.upgradeManager.sendRequestToDevice(waitingDeviceMac, waitingSysId);
                return true;
            }
            this.addToken();
        }
        return false;
    }

    public BaseDeviceFirmwareUpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    public FirmwareUpgradeRepository getUpgradeRepository() {
        return this.upgradeRepository;
    }

    public LocalFirmwareUpgradeProperties getLocalProperties() {
        return this.localProperties;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public long getWaitingTimeout() {
        return this.waitingTimeout;
    }

    public AtomicInteger getCurrSize() {
        return this.currSize;
    }

    public void setUpgradeManager(BaseDeviceFirmwareUpgradeManager upgradeManager) {
        this.upgradeManager = upgradeManager;
    }

    public void setUpgradeRepository(FirmwareUpgradeRepository upgradeRepository) {
        this.upgradeRepository = upgradeRepository;
    }

    public void setLocalProperties(LocalFirmwareUpgradeProperties localProperties) {
        this.localProperties = localProperties;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setWaitingTimeout(long waitingTimeout) {
        this.waitingTimeout = waitingTimeout;
    }

    public void setCurrSize(AtomicInteger currSize) {
        this.currSize = currSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenBucket)) {
            return false;
        }
        TokenBucket other = (TokenBucket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxSize() != other.getMaxSize()) {
            return false;
        }
        if (this.getWaitingTimeout() != other.getWaitingTimeout()) {
            return false;
        }
        BaseDeviceFirmwareUpgradeManager this$upgradeManager = this.getUpgradeManager();
        BaseDeviceFirmwareUpgradeManager other$upgradeManager = other.getUpgradeManager();
        if (this$upgradeManager == null ? other$upgradeManager != null : !this$upgradeManager.equals(other$upgradeManager)) {
            return false;
        }
        FirmwareUpgradeRepository this$upgradeRepository = this.getUpgradeRepository();
        FirmwareUpgradeRepository other$upgradeRepository = other.getUpgradeRepository();
        if (this$upgradeRepository == null ? other$upgradeRepository != null : !this$upgradeRepository.equals(other$upgradeRepository)) {
            return false;
        }
        LocalFirmwareUpgradeProperties this$localProperties = this.getLocalProperties();
        LocalFirmwareUpgradeProperties other$localProperties = other.getLocalProperties();
        if (this$localProperties == null ? other$localProperties != null : !((Object)((Object)this$localProperties)).equals((Object)other$localProperties)) {
            return false;
        }
        AtomicInteger this$currSize = this.getCurrSize();
        AtomicInteger other$currSize = other.getCurrSize();
        return !(this$currSize == null ? other$currSize != null : !this$currSize.equals(other$currSize));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TokenBucket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxSize();
        long $waitingTimeout = this.getWaitingTimeout();
        result = result * 59 + (int)($waitingTimeout >>> 32 ^ $waitingTimeout);
        BaseDeviceFirmwareUpgradeManager $upgradeManager = this.getUpgradeManager();
        result = result * 59 + ($upgradeManager == null ? 43 : $upgradeManager.hashCode());
        FirmwareUpgradeRepository $upgradeRepository = this.getUpgradeRepository();
        result = result * 59 + ($upgradeRepository == null ? 43 : $upgradeRepository.hashCode());
        LocalFirmwareUpgradeProperties $localProperties = this.getLocalProperties();
        result = result * 59 + ($localProperties == null ? 43 : ((Object)((Object)$localProperties)).hashCode());
        AtomicInteger $currSize = this.getCurrSize();
        result = result * 59 + ($currSize == null ? 43 : $currSize.hashCode());
        return result;
    }

    public String toString() {
        return "TokenBucket(upgradeManager=" + this.getUpgradeManager() + ", upgradeRepository=" + this.getUpgradeRepository() + ", localProperties=" + (Object)((Object)this.getLocalProperties()) + ", maxSize=" + this.getMaxSize() + ", waitingTimeout=" + this.getWaitingTimeout() + ", currSize=" + this.getCurrSize() + ")";
    }
}

