/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.schedule.common.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public final class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static final String EXCEPTION_LOG_PATTERN = "parse json exception. json: {}";
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static ObjectMapper getMapper() {
        return MAPPER;
    }

    @Nullable
    public static String bean2Json(Object object) {
        try {
            return MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.warn("fail to transfer bean to Json. object: {}", object);
            return null;
        }
    }

    @Nullable
    public static <T> T json2bean(String json, Class<T> clazz) {
        try {
            return (T)MAPPER.readValue(json, clazz);
        }
        catch (IOException e) {
            log.warn(EXCEPTION_LOG_PATTERN, (Object)json);
            return null;
        }
    }

    @Nullable
    public static <T> T json2bean(String json, TypeReference<T> typeReference) {
        try {
            return (T)MAPPER.readValue(json, typeReference);
        }
        catch (IOException e) {
            log.warn(EXCEPTION_LOG_PATTERN, (Object)json);
            return null;
        }
    }

    @Nullable
    public static <T> List<T> json2list(String json, Class<T> clazz) {
        JavaType type = JsonUtils.getCollectionType(List.class, clazz);
        try {
            return (List)MAPPER.readValue(json, type);
        }
        catch (IOException e) {
            log.warn("fail to transfer json to list. json: {}", (Object)json);
            return Collections.emptyList();
        }
    }

    public static JavaType getCollectionType(Class<?> collectionClass, Class<?> elementClass) {
        return MAPPER.getTypeFactory().constructParametricType(collectionClass, new Class[]{elementClass});
    }

    @Nullable
    public static Map<String, Object> json2Map(String json) {
        TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
        try {
            return (Map)MAPPER.readValue(json, (TypeReference)typeRef);
        }
        catch (IOException e) {
            log.warn("fail to transfer json to map. json: {}", (Object)json);
            return null;
        }
    }

    public static <T> T object2bean(Object o, Class<?> T) {
        return (T)MAPPER.convertValue(o, T);
    }

    @Nullable
    public static <T> T parseJsonStr(String json, String key, Class<T> valueType) {
        if (key != null) {
            try {
                JsonNode jsonNode = JsonUtils.getMapper().readTree(json).findPath(key);
                json = jsonNode.toString();
            }
            catch (IOException e) {
                log.warn("parse json.key exception. json: {}, key: {}", (Object)json, (Object)key);
                return null;
            }
        }
        Object parseObj = null;
        try {
            parseObj = JsonUtils.getMapper().readValue(json, valueType);
        }
        catch (IOException e) {
            log.warn(EXCEPTION_LOG_PATTERN, (Object)json);
        }
        return (T)parseObj;
    }

    @Nullable
    public static JsonNode readTree(String json) {
        try {
            return JsonUtils.getMapper().readTree(json);
        }
        catch (IOException e) {
            log.warn(EXCEPTION_LOG_PATTERN, (Object)json);
            return null;
        }
    }

    @Nullable
    public static <T> T json2bean(String json, Type type) {
        try {
            return (T)MAPPER.readValue(json, MAPPER.constructType(type));
        }
        catch (IOException e) {
            log.warn("fail to transfer json to list. json: {}", (Object)json);
            return null;
        }
    }

    private JsonUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer(JSONObject.class, (JsonSerializer)new JsonSerializer<JSONObject>(){

            public void serialize(JSONObject value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeRawValue(value.toString());
            }
        });
        module.addSerializer(JSONArray.class, (JsonSerializer)new JsonSerializer<JSONArray>(){

            public void serialize(JSONArray value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeRawValue(value.toString());
            }
        });
        module.addDeserializer(JSONObject.class, (JsonDeserializer)new JsonDeserializer<JSONObject>(){

            public JSONObject deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                JsonToken currentToken = p.getCurrentToken();
                if (currentToken == JsonToken.START_OBJECT) {
                    Map map = (Map)p.readValueAs(Map.class);
                    return new JSONObject(map);
                }
                return (JSONObject)ctxt.handleUnexpectedToken(JSONObject.class, p);
            }
        });
        module.addDeserializer(JSONArray.class, (JsonDeserializer)new JsonDeserializer<JSONArray>(){

            public JSONArray deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                JsonToken currentToken = p.getCurrentToken();
                if (currentToken == JsonToken.START_ARRAY) {
                    List list = (List)p.readValueAs(List.class);
                    return new JSONArray((Collection)list);
                }
                return (JSONArray)ctxt.handleUnexpectedToken(JSONArray.class, p);
            }
        });
        MAPPER.registerModule((Module)module);
        MAPPER.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        MAPPER.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        MAPPER.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        MAPPER.configure(SerializationFeature.INDENT_OUTPUT, false);
        MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        MAPPER.configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, false);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

