/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.schedule.common.domain;

import java.util.Optional;
import java.util.TimeZone;

public class TimeZoneInfo {
    String id;
    Integer rawOffset;

    public static TimeZoneInfo fromTimeZone(TimeZone timeZone) {
        return Optional.ofNullable(timeZone).map(t -> new TimeZoneInfo(t.getID(), t.getRawOffset())).orElse(null);
    }

    public static TimeZone toTimeZone(TimeZoneInfo timeZoneInfo) {
        TimeZone timeZone = null;
        if (timeZoneInfo != null) {
            timeZone = TimeZone.getTimeZone(timeZoneInfo.getId());
            timeZone.setRawOffset(timeZoneInfo.getRawOffset());
        }
        return timeZone;
    }

    public String getId() {
        return this.id;
    }

    public Integer getRawOffset() {
        return this.rawOffset;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRawOffset(Integer rawOffset) {
        this.rawOffset = rawOffset;
    }

    public String toString() {
        return "TimeZoneInfo(id=" + this.getId() + ", rawOffset=" + this.getRawOffset() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeZoneInfo)) {
            return false;
        }
        TimeZoneInfo other = (TimeZoneInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$rawOffset = this.getRawOffset();
        Integer other$rawOffset = other.getRawOffset();
        if (this$rawOffset == null ? other$rawOffset != null : !((Object)this$rawOffset).equals(other$rawOffset)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TimeZoneInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $rawOffset = this.getRawOffset();
        result = result * 59 + ($rawOffset == null ? 43 : ((Object)$rawOffset).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public TimeZoneInfo(String id, Integer rawOffset) {
        this.id = id;
        this.rawOffset = rawOffset;
    }

    public TimeZoneInfo() {
    }
}

