/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.schedule.common.domain;

import com.tplink.smb.component.schedule.api.MisfireStrategy;
import com.tplink.smb.component.schedule.api.ScheduleTask;
import com.tplink.smb.component.schedule.api.ScheduleTrigger;
import com.tplink.smb.component.schedule.api.TaskKey;
import com.tplink.smb.component.schedule.api.exception.ScheduleException;
import com.tplink.smb.component.schedule.api.triggers.CronTrigger;
import com.tplink.smb.component.schedule.api.triggers.FixedRateTrigger;
import com.tplink.smb.component.schedule.api.triggers.TimestampTrigger;
import com.tplink.smb.component.schedule.common.domain.ScheduleTaskIdentityDO;
import com.tplink.smb.component.schedule.common.domain.ScheduleTypeEnum;
import com.tplink.smb.component.schedule.common.domain.TimeZoneInfo;
import com.tplink.smb.component.schedule.common.utils.TimeConverter;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;

public class ScheduleTaskDO {
    private ScheduleTaskIdentityDO identity;
    private Map<String, Object> dataMap;
    private ScheduleTypeEnum scheduleTypeEnum;
    private Long nextTriggerTime;
    private String cron;
    private TimeZoneInfo timeZoneInfo;
    private Integer fixedRate;
    private Integer delay;
    private Long timestamp;
    private Boolean enableSharding;
    private Integer shardingSize;
    private Integer shardBatchSize;
    private Long shardBatchDelayMill;
    private String handlerName;
    private Boolean deleteAfterExecuted;
    private Long lastTriggerTime;
    private String misfireStrategy;

    public ScheduleTask toScheduleTask() {
        ScheduleTrigger scheduleTrigger = this.generateScheduleTrigger();
        return new ScheduleTask(TaskKey.of((String)this.identity.getName(), (String)this.identity.getParam()), scheduleTrigger).setHandlerName(this.handlerName).setDataMap(this.dataMap).setEnableSharding(this.enableSharding).setShardingSize(this.shardingSize).setShardBatchSize(this.shardBatchSize).setShardBatchDelayMill(this.shardBatchDelayMill).setDeleteAfterExecuted(this.deleteAfterExecuted).setMisfireStrategy(Optional.ofNullable(this.misfireStrategy).map(MisfireStrategy::valueOf).orElse(MisfireStrategy.DO_NOTHING));
    }

    public static ScheduleTaskDO fromScheduleTask(ScheduleTask task) {
        ScheduleTaskDO taskDO = ScheduleTaskDO.builder().identity(ScheduleTaskIdentityDO.from(task.getTaskKey())).handlerName(task.getHandlerName()).dataMap(task.getDataMap()).enableSharding(task.getEnableSharding()).shardingSize(task.getShardingSize()).shardBatchSize(task.getShardBatchSize()).shardBatchDelayMill(task.getShardBatchDelayMill()).misfireStrategy(Optional.ofNullable(task.getMisfireStrategy()).map(Enum::name).orElse(MisfireStrategy.DO_NOTHING.name())).deleteAfterExecuted(task.getDeleteAfterExecuted()).build();
        ScheduleTaskDO.setValuesByScheduleTrigger(taskDO, task.getScheduleTrigger());
        return taskDO;
    }

    private ScheduleTrigger generateScheduleTrigger() {
        switch (this.scheduleTypeEnum) {
            case FIX_RATE: {
                return FixedRateTrigger.by((Integer)TimeConverter.sec2Mills(this.fixedRate), (Integer)TimeConverter.sec2Mills(this.delay));
            }
            case CRON: {
                return CronTrigger.by((String)this.cron, (TimeZone)TimeZoneInfo.toTimeZone(this.timeZoneInfo));
            }
            case TIMESTAMP: {
                return TimestampTrigger.by((Long)TimeConverter.sec2Mills(this.timestamp));
            }
        }
        throw new ScheduleException("invalid scheduleTypeEnum.");
    }

    private static void setValuesByScheduleTrigger(ScheduleTaskDO taskDO, ScheduleTrigger scheduleTrigger) {
        if (scheduleTrigger instanceof CronTrigger) {
            CronTrigger cronTrigger = (CronTrigger)scheduleTrigger;
            taskDO.setScheduleTypeEnum(ScheduleTypeEnum.CRON);
            taskDO.setCron(cronTrigger.getCron());
            taskDO.setTimeZoneInfo(TimeZoneInfo.fromTimeZone(cronTrigger.getTimeZone()));
        } else if (scheduleTrigger instanceof FixedRateTrigger) {
            FixedRateTrigger trigger = (FixedRateTrigger)scheduleTrigger;
            taskDO.setScheduleTypeEnum(ScheduleTypeEnum.FIX_RATE);
            taskDO.setFixedRate(TimeConverter.mills2Sec(trigger.getFixedRate()));
            taskDO.setDelay(TimeConverter.mills2Sec(trigger.getDelay()));
        } else if (scheduleTrigger instanceof TimestampTrigger) {
            TimestampTrigger trigger = (TimestampTrigger)scheduleTrigger;
            taskDO.setScheduleTypeEnum(ScheduleTypeEnum.TIMESTAMP);
            taskDO.setTimestamp(TimeConverter.mills2Sec(trigger.getTimestamp()));
            taskDO.setNextTriggerTime(taskDO.getTimestamp());
        } else {
            throw new ScheduleException("invalid ScheduleTrigger.");
        }
    }

    public static ScheduleTaskDOBuilder builder() {
        return new ScheduleTaskDOBuilder();
    }

    public ScheduleTaskIdentityDO getIdentity() {
        return this.identity;
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }

    public ScheduleTypeEnum getScheduleTypeEnum() {
        return this.scheduleTypeEnum;
    }

    public Long getNextTriggerTime() {
        return this.nextTriggerTime;
    }

    public String getCron() {
        return this.cron;
    }

    public TimeZoneInfo getTimeZoneInfo() {
        return this.timeZoneInfo;
    }

    public Integer getFixedRate() {
        return this.fixedRate;
    }

    public Integer getDelay() {
        return this.delay;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Boolean getEnableSharding() {
        return this.enableSharding;
    }

    public Integer getShardingSize() {
        return this.shardingSize;
    }

    public Integer getShardBatchSize() {
        return this.shardBatchSize;
    }

    public Long getShardBatchDelayMill() {
        return this.shardBatchDelayMill;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public Boolean getDeleteAfterExecuted() {
        return this.deleteAfterExecuted;
    }

    public Long getLastTriggerTime() {
        return this.lastTriggerTime;
    }

    public String getMisfireStrategy() {
        return this.misfireStrategy;
    }

    public void setIdentity(ScheduleTaskIdentityDO identity) {
        this.identity = identity;
    }

    public void setDataMap(Map<String, Object> dataMap) {
        this.dataMap = dataMap;
    }

    public void setScheduleTypeEnum(ScheduleTypeEnum scheduleTypeEnum) {
        this.scheduleTypeEnum = scheduleTypeEnum;
    }

    public void setNextTriggerTime(Long nextTriggerTime) {
        this.nextTriggerTime = nextTriggerTime;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public void setTimeZoneInfo(TimeZoneInfo timeZoneInfo) {
        this.timeZoneInfo = timeZoneInfo;
    }

    public void setFixedRate(Integer fixedRate) {
        this.fixedRate = fixedRate;
    }

    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public void setEnableSharding(Boolean enableSharding) {
        this.enableSharding = enableSharding;
    }

    public void setShardingSize(Integer shardingSize) {
        this.shardingSize = shardingSize;
    }

    public void setShardBatchSize(Integer shardBatchSize) {
        this.shardBatchSize = shardBatchSize;
    }

    public void setShardBatchDelayMill(Long shardBatchDelayMill) {
        this.shardBatchDelayMill = shardBatchDelayMill;
    }

    public void setHandlerName(String handlerName) {
        this.handlerName = handlerName;
    }

    public void setDeleteAfterExecuted(Boolean deleteAfterExecuted) {
        this.deleteAfterExecuted = deleteAfterExecuted;
    }

    public void setLastTriggerTime(Long lastTriggerTime) {
        this.lastTriggerTime = lastTriggerTime;
    }

    public void setMisfireStrategy(String misfireStrategy) {
        this.misfireStrategy = misfireStrategy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScheduleTaskDO)) {
            return false;
        }
        ScheduleTaskDO other = (ScheduleTaskDO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$nextTriggerTime = this.getNextTriggerTime();
        Long other$nextTriggerTime = other.getNextTriggerTime();
        if (this$nextTriggerTime == null ? other$nextTriggerTime != null : !((Object)this$nextTriggerTime).equals(other$nextTriggerTime)) {
            return false;
        }
        Integer this$fixedRate = this.getFixedRate();
        Integer other$fixedRate = other.getFixedRate();
        if (this$fixedRate == null ? other$fixedRate != null : !((Object)this$fixedRate).equals(other$fixedRate)) {
            return false;
        }
        Integer this$delay = this.getDelay();
        Integer other$delay = other.getDelay();
        if (this$delay == null ? other$delay != null : !((Object)this$delay).equals(other$delay)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Boolean this$enableSharding = this.getEnableSharding();
        Boolean other$enableSharding = other.getEnableSharding();
        if (this$enableSharding == null ? other$enableSharding != null : !((Object)this$enableSharding).equals(other$enableSharding)) {
            return false;
        }
        Integer this$shardingSize = this.getShardingSize();
        Integer other$shardingSize = other.getShardingSize();
        if (this$shardingSize == null ? other$shardingSize != null : !((Object)this$shardingSize).equals(other$shardingSize)) {
            return false;
        }
        Integer this$shardBatchSize = this.getShardBatchSize();
        Integer other$shardBatchSize = other.getShardBatchSize();
        if (this$shardBatchSize == null ? other$shardBatchSize != null : !((Object)this$shardBatchSize).equals(other$shardBatchSize)) {
            return false;
        }
        Long this$shardBatchDelayMill = this.getShardBatchDelayMill();
        Long other$shardBatchDelayMill = other.getShardBatchDelayMill();
        if (this$shardBatchDelayMill == null ? other$shardBatchDelayMill != null : !((Object)this$shardBatchDelayMill).equals(other$shardBatchDelayMill)) {
            return false;
        }
        Boolean this$deleteAfterExecuted = this.getDeleteAfterExecuted();
        Boolean other$deleteAfterExecuted = other.getDeleteAfterExecuted();
        if (this$deleteAfterExecuted == null ? other$deleteAfterExecuted != null : !((Object)this$deleteAfterExecuted).equals(other$deleteAfterExecuted)) {
            return false;
        }
        Long this$lastTriggerTime = this.getLastTriggerTime();
        Long other$lastTriggerTime = other.getLastTriggerTime();
        if (this$lastTriggerTime == null ? other$lastTriggerTime != null : !((Object)this$lastTriggerTime).equals(other$lastTriggerTime)) {
            return false;
        }
        ScheduleTaskIdentityDO this$identity = this.getIdentity();
        ScheduleTaskIdentityDO other$identity = other.getIdentity();
        if (this$identity == null ? other$identity != null : !((Object)this$identity).equals(other$identity)) {
            return false;
        }
        Map<String, Object> this$dataMap = this.getDataMap();
        Map<String, Object> other$dataMap = other.getDataMap();
        if (this$dataMap == null ? other$dataMap != null : !((Object)this$dataMap).equals(other$dataMap)) {
            return false;
        }
        ScheduleTypeEnum this$scheduleTypeEnum = this.getScheduleTypeEnum();
        ScheduleTypeEnum other$scheduleTypeEnum = other.getScheduleTypeEnum();
        if (this$scheduleTypeEnum == null ? other$scheduleTypeEnum != null : !((Object)((Object)this$scheduleTypeEnum)).equals((Object)other$scheduleTypeEnum)) {
            return false;
        }
        String this$cron = this.getCron();
        String other$cron = other.getCron();
        if (this$cron == null ? other$cron != null : !this$cron.equals(other$cron)) {
            return false;
        }
        TimeZoneInfo this$timeZoneInfo = this.getTimeZoneInfo();
        TimeZoneInfo other$timeZoneInfo = other.getTimeZoneInfo();
        if (this$timeZoneInfo == null ? other$timeZoneInfo != null : !((Object)this$timeZoneInfo).equals(other$timeZoneInfo)) {
            return false;
        }
        String this$handlerName = this.getHandlerName();
        String other$handlerName = other.getHandlerName();
        if (this$handlerName == null ? other$handlerName != null : !this$handlerName.equals(other$handlerName)) {
            return false;
        }
        String this$misfireStrategy = this.getMisfireStrategy();
        String other$misfireStrategy = other.getMisfireStrategy();
        return !(this$misfireStrategy == null ? other$misfireStrategy != null : !this$misfireStrategy.equals(other$misfireStrategy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScheduleTaskDO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $nextTriggerTime = this.getNextTriggerTime();
        result = result * 59 + ($nextTriggerTime == null ? 43 : ((Object)$nextTriggerTime).hashCode());
        Integer $fixedRate = this.getFixedRate();
        result = result * 59 + ($fixedRate == null ? 43 : ((Object)$fixedRate).hashCode());
        Integer $delay = this.getDelay();
        result = result * 59 + ($delay == null ? 43 : ((Object)$delay).hashCode());
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Boolean $enableSharding = this.getEnableSharding();
        result = result * 59 + ($enableSharding == null ? 43 : ((Object)$enableSharding).hashCode());
        Integer $shardingSize = this.getShardingSize();
        result = result * 59 + ($shardingSize == null ? 43 : ((Object)$shardingSize).hashCode());
        Integer $shardBatchSize = this.getShardBatchSize();
        result = result * 59 + ($shardBatchSize == null ? 43 : ((Object)$shardBatchSize).hashCode());
        Long $shardBatchDelayMill = this.getShardBatchDelayMill();
        result = result * 59 + ($shardBatchDelayMill == null ? 43 : ((Object)$shardBatchDelayMill).hashCode());
        Boolean $deleteAfterExecuted = this.getDeleteAfterExecuted();
        result = result * 59 + ($deleteAfterExecuted == null ? 43 : ((Object)$deleteAfterExecuted).hashCode());
        Long $lastTriggerTime = this.getLastTriggerTime();
        result = result * 59 + ($lastTriggerTime == null ? 43 : ((Object)$lastTriggerTime).hashCode());
        ScheduleTaskIdentityDO $identity = this.getIdentity();
        result = result * 59 + ($identity == null ? 43 : ((Object)$identity).hashCode());
        Map<String, Object> $dataMap = this.getDataMap();
        result = result * 59 + ($dataMap == null ? 43 : ((Object)$dataMap).hashCode());
        ScheduleTypeEnum $scheduleTypeEnum = this.getScheduleTypeEnum();
        result = result * 59 + ($scheduleTypeEnum == null ? 43 : ((Object)((Object)$scheduleTypeEnum)).hashCode());
        String $cron = this.getCron();
        result = result * 59 + ($cron == null ? 43 : $cron.hashCode());
        TimeZoneInfo $timeZoneInfo = this.getTimeZoneInfo();
        result = result * 59 + ($timeZoneInfo == null ? 43 : ((Object)$timeZoneInfo).hashCode());
        String $handlerName = this.getHandlerName();
        result = result * 59 + ($handlerName == null ? 43 : $handlerName.hashCode());
        String $misfireStrategy = this.getMisfireStrategy();
        result = result * 59 + ($misfireStrategy == null ? 43 : $misfireStrategy.hashCode());
        return result;
    }

    public ScheduleTaskDO() {
    }

    public ScheduleTaskDO(ScheduleTaskIdentityDO identity, Map<String, Object> dataMap, ScheduleTypeEnum scheduleTypeEnum, Long nextTriggerTime, String cron, TimeZoneInfo timeZoneInfo, Integer fixedRate, Integer delay, Long timestamp, Boolean enableSharding, Integer shardingSize, Integer shardBatchSize, Long shardBatchDelayMill, String handlerName, Boolean deleteAfterExecuted, Long lastTriggerTime, String misfireStrategy) {
        this.identity = identity;
        this.dataMap = dataMap;
        this.scheduleTypeEnum = scheduleTypeEnum;
        this.nextTriggerTime = nextTriggerTime;
        this.cron = cron;
        this.timeZoneInfo = timeZoneInfo;
        this.fixedRate = fixedRate;
        this.delay = delay;
        this.timestamp = timestamp;
        this.enableSharding = enableSharding;
        this.shardingSize = shardingSize;
        this.shardBatchSize = shardBatchSize;
        this.shardBatchDelayMill = shardBatchDelayMill;
        this.handlerName = handlerName;
        this.deleteAfterExecuted = deleteAfterExecuted;
        this.lastTriggerTime = lastTriggerTime;
        this.misfireStrategy = misfireStrategy;
    }

    public String toString() {
        return "ScheduleTaskDO(identity=" + this.getIdentity() + ", dataMap=" + this.getDataMap() + ", scheduleTypeEnum=" + (Object)((Object)this.getScheduleTypeEnum()) + ", nextTriggerTime=" + this.getNextTriggerTime() + ", cron=" + this.getCron() + ", timeZoneInfo=" + this.getTimeZoneInfo() + ", fixedRate=" + this.getFixedRate() + ", delay=" + this.getDelay() + ", timestamp=" + this.getTimestamp() + ", enableSharding=" + this.getEnableSharding() + ", shardingSize=" + this.getShardingSize() + ", shardBatchSize=" + this.getShardBatchSize() + ", shardBatchDelayMill=" + this.getShardBatchDelayMill() + ", handlerName=" + this.getHandlerName() + ", deleteAfterExecuted=" + this.getDeleteAfterExecuted() + ", lastTriggerTime=" + this.getLastTriggerTime() + ", misfireStrategy=" + this.getMisfireStrategy() + ")";
    }

    public static class ScheduleTaskDOBuilder {
        private ScheduleTaskIdentityDO identity;
        private Map<String, Object> dataMap;
        private ScheduleTypeEnum scheduleTypeEnum;
        private Long nextTriggerTime;
        private String cron;
        private TimeZoneInfo timeZoneInfo;
        private Integer fixedRate;
        private Integer delay;
        private Long timestamp;
        private Boolean enableSharding;
        private Integer shardingSize;
        private Integer shardBatchSize;
        private Long shardBatchDelayMill;
        private String handlerName;
        private Boolean deleteAfterExecuted;
        private Long lastTriggerTime;
        private String misfireStrategy;

        ScheduleTaskDOBuilder() {
        }

        public ScheduleTaskDOBuilder identity(ScheduleTaskIdentityDO identity) {
            this.identity = identity;
            return this;
        }

        public ScheduleTaskDOBuilder dataMap(Map<String, Object> dataMap) {
            this.dataMap = dataMap;
            return this;
        }

        public ScheduleTaskDOBuilder scheduleTypeEnum(ScheduleTypeEnum scheduleTypeEnum) {
            this.scheduleTypeEnum = scheduleTypeEnum;
            return this;
        }

        public ScheduleTaskDOBuilder nextTriggerTime(Long nextTriggerTime) {
            this.nextTriggerTime = nextTriggerTime;
            return this;
        }

        public ScheduleTaskDOBuilder cron(String cron) {
            this.cron = cron;
            return this;
        }

        public ScheduleTaskDOBuilder timeZoneInfo(TimeZoneInfo timeZoneInfo) {
            this.timeZoneInfo = timeZoneInfo;
            return this;
        }

        public ScheduleTaskDOBuilder fixedRate(Integer fixedRate) {
            this.fixedRate = fixedRate;
            return this;
        }

        public ScheduleTaskDOBuilder delay(Integer delay) {
            this.delay = delay;
            return this;
        }

        public ScheduleTaskDOBuilder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public ScheduleTaskDOBuilder enableSharding(Boolean enableSharding) {
            this.enableSharding = enableSharding;
            return this;
        }

        public ScheduleTaskDOBuilder shardingSize(Integer shardingSize) {
            this.shardingSize = shardingSize;
            return this;
        }

        public ScheduleTaskDOBuilder shardBatchSize(Integer shardBatchSize) {
            this.shardBatchSize = shardBatchSize;
            return this;
        }

        public ScheduleTaskDOBuilder shardBatchDelayMill(Long shardBatchDelayMill) {
            this.shardBatchDelayMill = shardBatchDelayMill;
            return this;
        }

        public ScheduleTaskDOBuilder handlerName(String handlerName) {
            this.handlerName = handlerName;
            return this;
        }

        public ScheduleTaskDOBuilder deleteAfterExecuted(Boolean deleteAfterExecuted) {
            this.deleteAfterExecuted = deleteAfterExecuted;
            return this;
        }

        public ScheduleTaskDOBuilder lastTriggerTime(Long lastTriggerTime) {
            this.lastTriggerTime = lastTriggerTime;
            return this;
        }

        public ScheduleTaskDOBuilder misfireStrategy(String misfireStrategy) {
            this.misfireStrategy = misfireStrategy;
            return this;
        }

        public ScheduleTaskDO build() {
            return new ScheduleTaskDO(this.identity, this.dataMap, this.scheduleTypeEnum, this.nextTriggerTime, this.cron, this.timeZoneInfo, this.fixedRate, this.delay, this.timestamp, this.enableSharding, this.shardingSize, this.shardBatchSize, this.shardBatchDelayMill, this.handlerName, this.deleteAfterExecuted, this.lastTriggerTime, this.misfireStrategy);
        }

        public String toString() {
            return "ScheduleTaskDO.ScheduleTaskDOBuilder(identity=" + this.identity + ", dataMap=" + this.dataMap + ", scheduleTypeEnum=" + (Object)((Object)this.scheduleTypeEnum) + ", nextTriggerTime=" + this.nextTriggerTime + ", cron=" + this.cron + ", timeZoneInfo=" + this.timeZoneInfo + ", fixedRate=" + this.fixedRate + ", delay=" + this.delay + ", timestamp=" + this.timestamp + ", enableSharding=" + this.enableSharding + ", shardingSize=" + this.shardingSize + ", shardBatchSize=" + this.shardBatchSize + ", shardBatchDelayMill=" + this.shardBatchDelayMill + ", handlerName=" + this.handlerName + ", deleteAfterExecuted=" + this.deleteAfterExecuted + ", lastTriggerTime=" + this.lastTriggerTime + ", misfireStrategy=" + this.misfireStrategy + ")";
        }
    }
}

