/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.schedule.common;

import com.tplink.smb.component.schedule.api.ScheduledEvent;
import com.tplink.smb.component.schedule.api.handler.ScheduledEventHandler;
import com.tplink.smb.component.schedule.common.utils.TimeConverter;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutorService {
    private static final Logger log = LoggerFactory.getLogger(TaskExecutorService.class);
    protected Map<String, TaskExecutor> taskExecutorMap = new ConcurrentHashMap<String, TaskExecutor>();

    public void addTaskExecutor(String handlerName, ScheduledEventHandler handler, ExecutorService executor) {
        this.taskExecutorMap.put(handlerName, new TaskExecutor(executor, handler));
    }

    public void deleteTaskExecutor(String handlerName) {
        this.taskExecutorMap.remove(handlerName);
    }

    public TaskExecutor getTaskExecutor(String handlerName) {
        return this.taskExecutorMap.get(handlerName);
    }

    public void executeTask(ScheduledEvent event) {
        String handlerName = Optional.ofNullable(event.getHandlerName()).orElse(event.getTaskName());
        TaskExecutor taskExecutor = this.taskExecutorMap.get(handlerName);
        if (taskExecutor != null) {
            try {
                this.runTask(taskExecutor, event);
            }
            catch (Exception e) {
                log.error("can not execute task ({}, {}) for handler  {} in executor cause {}", new Object[]{event.getTaskName(), event.getTaskParam(), handlerName, e.getMessage(), e});
                this.incTaskExecutorExecuteFailCount();
            }
        } else {
            log.warn("receive scheduled event with identity ({}, {}) but did not execute because corresponding handler {} doesn't exist", new Object[]{event.getTaskName(), event.getTaskParam(), handlerName});
        }
    }

    protected void runTask(TaskExecutor taskExecutor, ScheduledEvent event) {
        this.submitExecuteTask(taskExecutor, event);
    }

    protected void submitExecuteTask(TaskExecutor taskExecutor, ScheduledEvent event) {
        ExecutorService executor = taskExecutor.getExecutor();
        ScheduledEventHandler handler = taskExecutor.getHandler();
        executor.execute(() -> {
            log.debug("smb-schedule execute task with identity ({}, {}), scheduled time: {}", new Object[]{event.getTaskName(), event.getTaskParam(), event.getScheduledTime()});
            this.incTaskCount(event.getTaskName());
            long executeStartTime = System.currentTimeMillis();
            try {
                handler.handle(event);
            }
            catch (Exception ex) {
                try {
                    log.error("execute task {} , {} error: ", new Object[]{event.getTaskName(), event.getTaskParam(), ex});
                    this.incTaskRunExceptionCount();
                }
                catch (Throwable throwable) {
                    long finishTime = System.currentTimeMillis();
                    long costMilliSeconds = finishTime - executeStartTime;
                    log.debug("execute task with identity ({}, {}) finish. total time cost: {} s.", new Object[]{event.getTaskName(), event.getTaskParam(), TimeConverter.mills2Sec(costMilliSeconds)});
                    this.recordTaskExecuteTime(event.getTaskName(), costMilliSeconds);
                    throw throwable;
                }
                long finishTime = System.currentTimeMillis();
                long costMilliSeconds = finishTime - executeStartTime;
                log.debug("execute task with identity ({}, {}) finish. total time cost: {} s.", new Object[]{event.getTaskName(), event.getTaskParam(), TimeConverter.mills2Sec(costMilliSeconds)});
                this.recordTaskExecuteTime(event.getTaskName(), costMilliSeconds);
            }
            long finishTime = System.currentTimeMillis();
            long costMilliSeconds = finishTime - executeStartTime;
            log.debug("execute task with identity ({}, {}) finish. total time cost: {} s.", new Object[]{event.getTaskName(), event.getTaskParam(), TimeConverter.mills2Sec(costMilliSeconds)});
            this.recordTaskExecuteTime(event.getTaskName(), costMilliSeconds);
        });
    }

    protected void incTaskExecutorExecuteFailCount() {
    }

    protected void incTaskRunExceptionCount() {
    }

    protected void recordTaskExecuteTime(String taskName, long milliseconds) {
    }

    protected void incTaskCount(String taskName) {
    }

    public static class TaskExecutor {
        private ExecutorService executor;
        private ScheduledEventHandler handler;
        private ScheduledExecutorService scheduledExecutor;

        public TaskExecutor(ExecutorService executor, ScheduledEventHandler handler) {
            this.executor = executor;
            this.handler = handler;
        }

        public void setExecutor(ExecutorService executor) {
            this.executor = executor;
        }

        public void setHandler(ScheduledEventHandler handler) {
            this.handler = handler;
        }

        public void setScheduledExecutor(ScheduledExecutorService scheduledExecutor) {
            this.scheduledExecutor = scheduledExecutor;
        }

        public ExecutorService getExecutor() {
            return this.executor;
        }

        public ScheduledEventHandler getHandler() {
            return this.handler;
        }

        public ScheduledExecutorService getScheduledExecutor() {
            return this.scheduledExecutor;
        }

        public TaskExecutor(ExecutorService executor, ScheduledEventHandler handler, ScheduledExecutorService scheduledExecutor) {
            this.executor = executor;
            this.handler = handler;
            this.scheduledExecutor = scheduledExecutor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskExecutor)) {
                return false;
            }
            TaskExecutor other = (TaskExecutor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ExecutorService this$executor = this.getExecutor();
            ExecutorService other$executor = other.getExecutor();
            if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
                return false;
            }
            ScheduledEventHandler this$handler = this.getHandler();
            ScheduledEventHandler other$handler = other.getHandler();
            if (this$handler == null ? other$handler != null : !this$handler.equals(other$handler)) {
                return false;
            }
            ScheduledExecutorService this$scheduledExecutor = this.getScheduledExecutor();
            ScheduledExecutorService other$scheduledExecutor = other.getScheduledExecutor();
            return !(this$scheduledExecutor == null ? other$scheduledExecutor != null : !this$scheduledExecutor.equals(other$scheduledExecutor));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TaskExecutor;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExecutorService $executor = this.getExecutor();
            result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
            ScheduledEventHandler $handler = this.getHandler();
            result = result * 59 + ($handler == null ? 43 : $handler.hashCode());
            ScheduledExecutorService $scheduledExecutor = this.getScheduledExecutor();
            result = result * 59 + ($scheduledExecutor == null ? 43 : $scheduledExecutor.hashCode());
            return result;
        }

        public String toString() {
            return "TaskExecutorService.TaskExecutor(executor=" + this.getExecutor() + ", handler=" + this.getHandler() + ", scheduledExecutor=" + this.getScheduledExecutor() + ")";
        }
    }
}

