/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.schedule.common;

import com.tplink.smb.component.schedule.api.ScheduleCenter;
import com.tplink.smb.component.schedule.api.ScheduleTask;
import com.tplink.smb.component.schedule.api.ScheduleTrigger;
import com.tplink.smb.component.schedule.api.TaskKey;
import com.tplink.smb.component.schedule.api.annotation.CronJob;
import com.tplink.smb.component.schedule.api.annotation.FixedRateJob;
import com.tplink.smb.component.schedule.api.exception.ScheduleException;
import com.tplink.smb.component.schedule.api.handler.ScheduledEventHandler;
import com.tplink.smb.component.schedule.api.triggers.CronTrigger;
import com.tplink.smb.component.schedule.api.triggers.FixedRateTrigger;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class ScheduleJobScanner
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(ScheduleJobScanner.class);
    private ScheduleCenter scheduleCenter;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().getParent() == null) {
            Map cronJobBeans = event.getApplicationContext().getBeansWithAnnotation(CronJob.class);
            Map fixedRateJobBeans = event.getApplicationContext().getBeansWithAnnotation(FixedRateJob.class);
            this.jobBeansScan(cronJobBeans, CronJob.class);
            this.jobBeansScan(fixedRateJobBeans, FixedRateJob.class);
        }
    }

    private <A extends Annotation> void jobBeansScan(Map<String, Object> jobBeans, Class<A> annotationClass) {
        jobBeans.values().stream().filter(bean -> ScheduledEventHandler.class.isAssignableFrom(bean.getClass())).forEach(bean -> {
            Object annotation = bean.getClass().getAnnotation(annotationClass);
            ScheduleTask task = this.generateTask(annotation);
            this.scheduleCenter.saveTask(task);
            this.scheduleCenter.registerSimpleConcurrentHandler(task.getTaskKey().getName(), (ScheduledEventHandler)bean, this.getNthreads(annotation));
        });
    }

    private <A extends Annotation> ScheduleTask generateTask(A jobAnnotation) {
        CronTrigger scheduleTrigger;
        int shardingSize;
        String param;
        String name;
        if (jobAnnotation instanceof CronJob) {
            CronJob cronJob = (CronJob)jobAnnotation;
            name = cronJob.name();
            param = cronJob.param();
            shardingSize = cronJob.shardingSize();
            String cron = cronJob.cron();
            scheduleTrigger = CronTrigger.by((String)cron);
        } else if (jobAnnotation instanceof FixedRateJob) {
            FixedRateJob fixedRateJob = (FixedRateJob)jobAnnotation;
            name = fixedRateJob.name();
            param = fixedRateJob.param();
            shardingSize = fixedRateJob.shardingSize();
            int fixedRate = fixedRateJob.fixedRate();
            Integer delay = null;
            if (fixedRateJob.delay() != 0) {
                delay = fixedRateJob.delay();
            }
            scheduleTrigger = FixedRateTrigger.by((Integer)fixedRate, (Integer)delay);
        } else {
            throw new ScheduleException("invalid annotation class");
        }
        if (param.isEmpty()) {
            param = null;
        }
        ScheduleTask task = new ScheduleTask(TaskKey.of((String)name, (String)param), (ScheduleTrigger)scheduleTrigger);
        if (shardingSize > 0) {
            task.setEnableSharding(Boolean.valueOf(true));
            task.setShardingSize(Integer.valueOf(shardingSize));
        }
        return task;
    }

    private <A extends Annotation> int getNthreads(A jobAnnotation) {
        if (jobAnnotation instanceof CronJob) {
            return ((CronJob)jobAnnotation).nThreads();
        }
        if (jobAnnotation instanceof FixedRateJob) {
            return ((FixedRateJob)jobAnnotation).nThreads();
        }
        throw new ScheduleException("invalid annotation class");
    }

    public void setScheduleCenter(ScheduleCenter scheduleCenter) {
        this.scheduleCenter = scheduleCenter;
    }
}

