/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.port.mongo.device;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.UpdateResult;
import com.tplink.nbu.common.utils.CollectionUtil;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.gridquery.c;
import com.tplink.smb.omada.common.gridquery.g;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.manage.message.EcspVersion;
import com.tplink.smb.omada.manager.common.api.devicemanager.device.dto.DeviceDTO;
import com.tplink.smb.omada.manager.common.b.a.a.j;
import com.tplink.smb.omada.manager.common.constants.e;
import com.tplink.smb.omada.manager.configuration.api.web.site.cliconfig.dto.ModelAndModelVersionVO;
import com.tplink.smb.omada.manager.configuration.domain.model.site.g.l;
import com.tplink.smb.omada.manager.configuration.domain.model.site.j.n;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.DeviceOutlineDTO;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.DeviceOutlineSimpleDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.DeviceGridDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.b;
import com.tplink.smb.omada.manager.device.domain.model.device.DeviceFirmwareTypeInfoDTO;
import com.tplink.smb.omada.manager.device.domain.model.device.DeviceHealthScoreDTO;
import com.tplink.smb.omada.manager.device.domain.model.device.G;
import com.tplink.smb.omada.manager.device.domain.model.device.H;
import com.tplink.smb.omada.manager.device.domain.model.device.O;
import com.tplink.smb.omada.manager.device.domain.model.device.SiteModelInfoDTO;
import com.tplink.smb.omada.manager.device.domain.model.device.af;
import com.tplink.smb.omada.manager.device.domain.model.device.ag;
import com.tplink.smb.omada.manager.device.domain.model.device.ap.M;
import com.tplink.smb.omada.manager.device.domain.model.device.e.c;
import com.tplink.smb.omada.manager.device.domain.model.device.o;
import com.tplink.smb.omada.manager.device.domain.model.device.t;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.ComponentInfo;
import com.tplink.smb.omada.manager.j.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.device.DeviceMongoCrudRepository;
import com.tplink.smb.omada.manager.port.mongo.device.DevicePO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.ApMongoCrudRepository;
import com.tplink.smb.omada.manager.port.mongo.device.devicelist.DeviceScoreCount;
import com.tplink.smb.omada.manager.port.mongo.device.devicelist.DeviceTypeCount;
import com.tplink.smb.omada.manager.port.mongo.device.devicelist.DeviceTypeHealthCount;
import com.tplink.smb.omada.manager.port.mongo.device.devicelist.a;
import com.tplink.smb.omada.manager.port.mongo.device.k;
import com.tplink.smb.omada.manager.port.mongo.device.m;
import com.tplink.smb.omada.manager.port.mongo.device.osg.OsgMongoCrudRepository;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswMongoCrudRepository;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswPO;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.ProjectionOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class i
implements O {
    @Generated
    private static final Logger k = LoggerFactory.getLogger(i.class);
    private MongoTemplate l;
    private DeviceMongoCrudRepository m;
    @Autowired
    private k n;
    @Autowired
    @Lazy
    private M o;
    @Autowired
    private ApMongoCrudRepository p;
    @Autowired
    private OsgMongoCrudRepository q;
    @Autowired
    private OswMongoCrudRepository r;
    private static final List<String> s = Lists.newArrayList((Object[])new String[]{"name", "sn", "mac"});
    private static final String t = "type";
    private static final String u = "healthScore";
    private static final String v = "count";
    public static final String a = "oemId";
    public static final String b = "hwId";
    public static final String c = "version";
    public static final String d = "siteId";
    public static final String e = "compound_model";
    public static final String f = "compoundModel";
    public static final String g = "showModel";
    public static final String h = "specialModel";
    public static final String i = "firmware_version";
    public static final String j = "firmwareVersion";
    private static final ProjectionOperation w = Aggregation.project((String[])new String[0]).and("_id").as("_id").and("type").as("type").and("health_score").as("health_score");
    private static final Set<String> x = ImmutableSet.of((Object)"mac", (Object)"omadac_id", (Object)"site_id", (Object)"name", (Object)"type", (Object)"sn", (Object[])new String[]{"show_model", "version", "ip", "device_misc", "_class"});

    private MongoCollection<Document> a() {
        return this.l.getDb().getCollection("device");
    }

    public Optional<o> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, G mac) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)mac.a()));
        DevicePO devicePO = (DevicePO)this.l.findOne(query, DevicePO.class);
        if (devicePO == null) {
            return Optional.empty();
        }
        return Optional.of(this.n.a(devicePO));
    }

    public Optional<o> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, G mac) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)mac.a()));
        DevicePO devicePO = (DevicePO)this.l.findOne(query, DevicePO.class);
        if (devicePO == null) {
            return Optional.empty();
        }
        return Optional.of(this.n.a(devicePO));
    }

    public Optional<o> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, DeviceTypeEnum deviceTypeEnum, G mac) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)t).is((Object)deviceTypeEnum.b()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)mac.a()));
        DevicePO devicePO = (DevicePO)this.l.findOne(query, DevicePO.class);
        if (devicePO == null) {
            return Optional.empty();
        }
        return Optional.of(this.n.a(devicePO));
    }

    public void b(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, DeviceTypeEnum deviceTypeEnum, G mac) {
        if (omadacId == null || siteId == null || deviceTypeEnum == null || mac == null) {
            k.warn("Invalid input parameters: omadacId={}, siteId={}, deviceTypeEnum={}, mac={}", new Object[]{omadacId, siteId, deviceTypeEnum, mac});
            return;
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)t).is((Object)deviceTypeEnum.b()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)mac.a()));
        query.fields().include("p_adopt_info");
        DevicePO devicePO = (DevicePO)this.l.findOne(query, DevicePO.class);
        if (devicePO == null || devicePO.getPendingAdoptInfo() == null) {
            k.warn("No device found or no pendingAdoptInfo for omadacId={}, siteId={}, deviceTypeEnum={}, mac={}", new Object[]{omadacId, siteId, deviceTypeEnum, mac});
            return;
        }
        Update update = new Update();
        update.set("p_adopt_info", null);
        update.set("adopt_info", (Object)devicePO.getPendingAdoptInfo());
        this.l.findAndModify(query, (UpdateDefinition)update, FindAndModifyOptions.options().returnNew(true), DevicePO.class);
    }

    public List<o> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, String ip) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"ip").is((Object)ip));
        return this.l.find(query, DevicePO.class).stream().map(this.n::a).collect(Collectors.toList());
    }

    public List<o> a(String ip) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"ip").is((Object)ip));
        return this.l.find(query, DevicePO.class).stream().map(this.n::a).collect(Collectors.toList());
    }

    public <T extends o<T>> Optional<T> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, G mac, DeviceTypeEnum deviceType, boolean includeWR) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        this.a(deviceType, includeWR, query);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)mac.a()));
        DevicePO devicePO = (DevicePO)this.l.findOne(query, DevicePO.class);
        if (devicePO == null) {
            return Optional.empty();
        }
        return Optional.of(this.n.a(devicePO));
    }

    public List<o> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return Collections.emptyList();
        }
        k.debug("FindByOmadacIdAndSite end. OmadacId : {}, SiteId : {}.", (Object)omadacId, (Object)siteId);
        return devicePOS.parallelStream().map(this.n::a).collect(Collectors.toList());
    }

    public List<o> b(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return Collections.emptyList();
        }
        return devicePOS.stream().map(this.n::b).collect(Collectors.toList());
    }

    public List<o> c(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId) {
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"omadac_id", (Object)omadacId.a()), Filters.eq((String)"site_id", (Object)siteId.a())});
        List devicePOS = (List)this.a().find(filter).into(new ArrayList());
        return devicePOS.stream().map(this.n::a).collect(Collectors.toList());
    }

    public List<o> d(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.fields().exclude(new String[]{"config_sync_status", "component_info", "port_cap"});
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return Collections.emptyList();
        }
        return devicePOS.stream().map(this.n::b).collect(Collectors.toList());
    }

    @Nonnull
    public List<o> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, String searchMac, String searchName, List<String> macListInStatus) {
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || CollectionUtils.isEmpty(macListInStatus)) {
            return Collections.emptyList();
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        if (Objects.nonNull(searchName)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"name").regex(T.g((String)searchName), "i"));
        }
        if (Objects.nonNull(searchMac)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").regex(T.g((String)searchMac), "i"));
            List devicePOS = this.l.find(query, DevicePO.class);
            if (CollectionUtils.isEmpty((Collection)devicePOS)) {
                return Collections.emptyList();
            }
            return devicePOS.stream().filter(devicePO -> macListInStatus.contains(devicePO.getMac())).map(this.n::b).collect(Collectors.toList());
        }
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").in(macListInStatus));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return Collections.emptyList();
        }
        return devicePOS.stream().map(this.n::b).collect(Collectors.toList());
    }

    public Set<String> e(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).andOperator(new Criteria[]{new Criteria().orOperator(new Criteria[]{Criteria.where((String)"remember_device").is((Object)com.tplink.smb.omada.manager.device.domain.model.device.e.c.c.a()), new Criteria().andOperator(new Criteria[]{Criteria.where((String)"remember_device").exists(false), new Criteria().orOperator(new Criteria[]{Criteria.where((String)"remember").is((Object)false), Criteria.where((String)"remember").exists(false)})})})}));
        query.fields().include("mac");
        List devicePOS = this.l.find(query, DevicePO.class);
        HashSet<String> macs = new HashSet<String>();
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return macs;
        }
        for (DevicePO devicePO : devicePOS) {
            macs.add(devicePO.getMac());
        }
        return macs;
    }

    public List<o> f(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).andOperator(new Criteria[]{new Criteria().orOperator(new Criteria[]{Criteria.where((String)"remember_device").is((Object)com.tplink.smb.omada.manager.device.domain.model.device.e.c.c.a()), new Criteria().andOperator(new Criteria[]{Criteria.where((String)"remember_device").exists(false), new Criteria().orOperator(new Criteria[]{Criteria.where((String)"remember").is((Object)false), Criteria.where((String)"remember").exists(false)})})})}));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return new ArrayList<o>();
        }
        return devicePOS.stream().map(this.n::a).collect(Collectors.toList());
    }

    @Nonnull
    public List<DeviceOutlineDTO> g(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        Set fields = DeviceOutlineDTO.getFields();
        query.fields().include(fields.toArray(new String[0]));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (!CollectionUtils.isEmpty((Collection)devicePOS)) {
            return devicePOS.stream().map(m::a).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Nonnull
    public List<DeviceOutlineSimpleDTO> h(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.fields().include("mac").include("dev_cap").include("device_misc");
        List devicePOS = this.l.find(query, OswPO.class);
        if (!CollectionUtils.isEmpty((Collection)devicePOS)) {
            return devicePOS.stream().map(m::b).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Nonnull
    public List<DeviceOutlineDTO> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, DeviceTypeEnum deviceTypeEnum, boolean includeWR) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        this.a(deviceTypeEnum, includeWR, query);
        Set fields = DeviceOutlineDTO.getFields();
        query.fields().include(fields.toArray(new String[0]));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (!CollectionUtils.isEmpty((Collection)devicePOS)) {
            return devicePOS.stream().map(m::a).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Nonnull
    public List<DeviceOutlineSimpleDTO> b(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, DeviceTypeEnum deviceTypeEnum, boolean includeWR) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        this.a(deviceTypeEnum, includeWR, query);
        query.fields().include("mac").include("dev_cap").include("device_misc");
        List devicePOS = this.l.find(query, OswPO.class);
        if (!CollectionUtils.isEmpty((Collection)devicePOS)) {
            return devicePOS.stream().map(m::b).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<o> c(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, DeviceTypeEnum deviceTypeEnum, boolean includeWR) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        this.a(deviceTypeEnum, includeWR, query);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return Collections.emptyList();
        }
        return devicePOS.stream().map(this.n::a).collect(Collectors.toList());
    }

    public long a(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, String type) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and(t).is((Object)type));
        return this.l.count(query, DevicePO.class);
    }

    public long i(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()));
        return this.l.count(query, DevicePO.class);
    }

    public long a(com.tplink.smb.omada.manager.j.a.a.c omadacId, Set<String> siteIds) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").in(siteIds));
        return this.l.count(query, DevicePO.class);
    }

    public long a(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, Collection<String> macs) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("mac").in(macs));
        return this.l.count(query, DevicePO.class);
    }

    public long a(com.tplink.smb.omada.manager.j.a.a.c omadacId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        return this.l.count(query, DevicePO.class);
    }

    public o a(@Nonnull o<?> device) {
        if (k.isDebugEnabled()) {
            k.debug("refresh device {} configSyncMap {} to db when save device", (Object)device.c_(), (Object)com.tplink.smb.omada.common.util.x.a((Object)device.Q().g()));
        }
        if (Boolean.TRUE.equals(device.m()) && device.getClass() == com.tplink.smb.omada.manager.device.domain.model.device.ap.c.class) {
            this.o.a((Object)((com.tplink.smb.omada.manager.device.domain.model.device.ap.c)device));
        }
        return this.n.a((DevicePO)this.l.save((Object)this.n.a(device)));
    }

    public void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, G mac, String username, String password) {
        this.l.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("mac").is((Object)mac.a())), (UpdateDefinition)new Update().set("p_adopt_info.username", (Object)com.tplink.smb.omada.common.util.b.b.c((String)username)).set("p_adopt_info.password", (Object)com.tplink.smb.omada.common.util.b.b.c((String)password)), DevicePO.class);
    }

    public void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, String username, String password) {
        this.l.updateMulti(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a())), (UpdateDefinition)new Update().set("p_adopt_info.username", (Object)com.tplink.smb.omada.common.util.b.b.c((String)username)).set("p_adopt_info.password", (Object)com.tplink.smb.omada.common.util.b.b.c((String)password)), DevicePO.class);
    }

    public void a(List<DeviceHealthScoreDTO> devicesHealthScores) {
        if (CollectionUtils.isEmpty(devicesHealthScores)) {
            return;
        }
        BulkOperations bulkOperations = this.l.bulkOps(BulkOperations.BulkMode.UNORDERED, DevicePO.class);
        for (DeviceHealthScoreDTO deviceHealthScoreDTO : devicesHealthScores) {
            String omadacId = deviceHealthScoreDTO.getOmadacId();
            String siteId = deviceHealthScoreDTO.getSiteId();
            String mac = deviceHealthScoreDTO.getMac();
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId).and("site_id").is((Object)siteId).and("mac").is((Object)mac));
            Update update = new Update();
            update.set("health_score", (Object)deviceHealthScoreDTO.getScore());
            update.set("health_score_time", (Object)deviceHealthScoreDTO.getScoreTime());
            bulkOperations.updateOne(query, update);
        }
        bulkOperations.execute();
    }

    public void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, G mac, Boolean remember) {
        this.l.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("mac").is((Object)mac.a()).andOperator(new Criteria[]{new Criteria().orOperator(new Criteria[]{Criteria.where((String)"remember_device").is((Object)com.tplink.smb.omada.manager.device.domain.model.device.e.c.c.a()), new Criteria().andOperator(new Criteria[]{Criteria.where((String)"remember_device").exists(false), new Criteria().orOperator(new Criteria[]{Criteria.where((String)"remember").is((Object)false), Criteria.where((String)"remember").exists(false)})})})})), (UpdateDefinition)Update.update((String)"remember", (Object)remember), DevicePO.class);
    }

    public Optional<o> b(com.tplink.smb.omada.manager.j.a.a.c omadacId, G macAddress) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("mac").is((Object)macAddress.a()));
        DevicePO devicePO = (DevicePO)this.l.findAndRemove(query, DevicePO.class);
        if (devicePO == null) {
            return Optional.empty();
        }
        return Optional.of(devicePO).map(this.n::a);
    }

    public List<o> b(com.tplink.smb.omada.manager.j.a.a.c omadacId, Set<String> macs) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("mac").in(macs));
        return this.l.findAllAndRemove(query, DevicePO.class).stream().map(this.n::a).collect(Collectors.toList());
    }

    public Set<String> j(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()));
        query.fields().include("mac");
        HashSet<String> macs = new HashSet<String>();
        List devicePOList = this.l.find(query, DevicePO.class, "device");
        for (DevicePO devicePO : devicePOList) {
            macs.add(devicePO.getMac());
        }
        return macs;
    }

    public void b(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, G mac) {
        this.l.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("mac").is((Object)mac.a())), (UpdateDefinition)new Update().unset("p_adopt_info"), DevicePO.class);
    }

    public boolean a(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, Set<String> macs) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("mac").in(macs));
        return this.l.exists(query, DevicePO.class);
    }

    public boolean c(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, G mac) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("mac").is((Object)mac.a()));
        return this.l.exists(query, DevicePO.class);
    }

    public List<o> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, String searchKey, Set<String> ownSiteIds, Map<String, String> siteInfos) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"site_id").in(ownSiteIds)});
        ArrayList<Criteria> orCriteria = new ArrayList<Criteria>();
        for (String field : s) {
            Criteria searchCriteria = Criteria.where((String)field);
            orCriteria.add(searchCriteria.regex(T.g((String)searchKey), "i"));
        }
        for (String siteKey : siteInfos.keySet()) {
            orCriteria.add(Criteria.where((String)"site_id").is((Object)siteKey));
        }
        criteria.orOperator(orCriteria.toArray(new Criteria[0]));
        query.addCriteria((CriteriaDefinition)criteria);
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return Collections.emptyList();
        }
        return devicePOS.stream().map(this.n::a).collect(Collectors.toList());
    }

    public Set<String> b(com.tplink.smb.omada.manager.j.a.a.c omadacId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        List macs = this.l.query(DevicePO.class).distinct("mac").as(String.class).matching(query).all();
        return new HashSet<String>(macs);
    }

    public Set<String> a(Set<String> omadacIds) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").in(omadacIds));
        List macs = this.l.query(DevicePO.class).distinct("mac").as(String.class).matching(query).all();
        return new HashSet<String>(macs);
    }

    public List<String> b(com.tplink.smb.omada.manager.j.a.a.c omadacId, String sortType) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.fields().include("mac");
        if (Objects.equals(com.tplink.smb.omada.common.gridquery.g.b.a(), sortType)) {
            query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"name"}));
        } else if (Objects.equals(com.tplink.smb.omada.common.gridquery.g.a.a(), sortType)) {
            query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"name"}));
        }
        List devicePOList = this.l.find(query, DevicePO.class, "device");
        ArrayList<String> macs = new ArrayList<String>(devicePOList.size());
        for (DevicePO devicePO : devicePOList) {
            macs.add(devicePO.getMac());
        }
        return macs;
    }

    public Map<String, Set<String>> c(com.tplink.smb.omada.manager.j.a.a.c omadacId) {
        Query query = new Query();
        query.fields().include("mac");
        query.fields().include(t);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return Collections.emptyMap();
        }
        return devicePOS.stream().filter(devicePO -> devicePO.getType() != null && devicePO.getMac() != null).collect(Collectors.groupingBy(DevicePO::getType, Collectors.mapping(DevicePO::getMac, Collectors.toSet())));
    }

    public long a(com.tplink.smb.omada.manager.j.a.a.c omadacId, DeviceTypeEnum typeEnum) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)t).is((Object)typeEnum.b()));
        return this.l.count(query, DevicePO.class);
    }

    public long a(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, @Nullable DeviceTypeEnum typeEnum) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        if (typeEnum != null) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)t).is((Object)typeEnum.b()));
        }
        return this.l.count(query, DevicePO.class);
    }

    public List<o> c(com.tplink.smb.omada.manager.j.a.a.c omadacId, Set<String> macs) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").in(macs));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return Collections.emptyList();
        }
        return devicePOS.stream().map(this.n::a).collect(Collectors.toList());
    }

    public List<o> d(com.tplink.smb.omada.manager.j.a.a.c omadacId, Set<String> macs) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").in(macs));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return Collections.emptyList();
        }
        return devicePOS.stream().map(this.n::b).collect(Collectors.toList());
    }

    public List<DeviceOutlineDTO> a(Set<String> omadacIds, Set<String> macs) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").in(omadacIds));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").in(macs));
        Set fields = DeviceOutlineDTO.getFieldsForCloud();
        query.fields().include(fields.toArray(new String[0]));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return Collections.emptyList();
        }
        return devicePOS.stream().map(m::c).collect(Collectors.toList());
    }

    public List<o> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, Collection<String> siteIds) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").in(siteIds));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return Collections.emptyList();
        }
        return devicePOS.stream().map(this.n::a).collect(Collectors.toList());
    }

    public List<o> b(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, Set<String> macs) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").in(macs));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return Collections.emptyList();
        }
        return devicePOS.stream().map(this.n::a).collect(Collectors.toList());
    }

    public List<o> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, Set<String> siteIds, Set<String> macs) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").in(siteIds));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").in(macs));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return Collections.emptyList();
        }
        return devicePOS.stream().map(this.n::a).collect(Collectors.toList());
    }

    public List<o> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, l mapId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"location_mapId").is((Object)mapId.a()));
        List devices = this.l.find(query, DevicePO.class, "device");
        if (CollectionUtils.isEmpty((Collection)devices)) {
            return Collections.emptyList();
        }
        return devices.stream().map(this.n::a).collect(Collectors.toList());
    }

    public void a(List<G> allMacList, String omadacId, boolean migrate) {
        if (CollectionUtils.isEmpty(allMacList)) {
            return;
        }
        Set macs = allMacList.stream().map(G::a).collect(Collectors.toSet());
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").in(macs));
        this.l.updateMulti(query, (UpdateDefinition)Update.update((String)"migrate", (Object)migrate), DevicePO.class);
    }

    public boolean c(@Nonnull com.tplink.smb.omada.manager.j.a.a.c omadacId, @Nonnull G macAddress) {
        return this.l.exists(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a())).addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)macAddress.a())), DevicePO.class);
    }

    public boolean b(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, @Nullable DeviceTypeEnum typeEnum) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        if (Objects.nonNull(typeEnum)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)t).is((Object)typeEnum.b()));
        }
        return this.l.exists(query, DevicePO.class);
    }

    public com.tplink.smb.omada.common.gridquery.a<o> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.common.gridquery.b queryData) {
        return this.a(omadacId, queryData, Collections.emptySet());
    }

    public com.tplink.smb.omada.common.gridquery.a<o> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.common.gridquery.b queryData, Set<String> macs) {
        if (CollectionUtils.isEmpty((Collection)queryData.g())) {
            queryData.a("name", com.tplink.smb.omada.common.gridquery.g.b);
        }
        com.tplink.smb.omada.common.gridquery.a deviceGrid = new com.tplink.smb.omada.common.gridquery.a(queryData);
        deviceGrid.initOmadacIdFilter(omadacId.a());
        Query query = com.tplink.smb.omada.manager.port.mongo.configuration.c.a.b(deviceGrid.getSearchFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)deviceGrid.getFilters());
        if (!CollectionUtils.isEmpty(macs)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").in(macs));
        }
        long count = this.l.count(query, DevicePO.class);
        deviceGrid.setTotalRows(count);
        if (deviceGrid.getQueryPage() != null) {
            query.with((Pageable)PageRequest.of((int)deviceGrid.getQueryPage().a(), (int)deviceGrid.getQueryPage().b()));
        }
        if (!CollectionUtils.isEmpty((Collection)deviceGrid.getQuerySorts())) {
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
            for (com.tplink.smb.omada.common.gridquery.e sort : deviceGrid.getQuerySorts()) {
                Sort.Direction direction = com.tplink.smb.omada.common.gridquery.g.b.equals((Object)sort.a()) ? Sort.Direction.ASC : Sort.Direction.DESC;
                Sort.Order order = new Sort.Order(direction, sort.b());
                orders.add(order);
            }
            Sort sort = Sort.by(orders);
            query.with(sort);
        }
        List devicePOS = this.l.find(query, DevicePO.class);
        deviceGrid.setData(devicePOS.stream().map(this.n::a).collect(Collectors.toList()));
        return deviceGrid;
    }

    public List<t> d(com.tplink.smb.omada.manager.j.a.a.c omadacId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.fields().include(new String[]{"mac", "omadac_id", "site_id", "name", t, "sn", "model", "model_version", "hw_version"});
        return this.l.find(query, DevicePO.class).stream().map(this.n::c).collect(Collectors.toList());
    }

    public List<DeviceGridDTO> e(com.tplink.smb.omada.manager.j.a.a.c omadacId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.fields().include(x.toArray(new String[0]));
        return this.l.find(query, DevicePO.class).stream().map(this.n::d).collect(Collectors.toList());
    }

    public List<DeviceGridDTO> b(com.tplink.smb.omada.manager.j.a.a.c omadacId, Collection<String> siteIds) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").in(siteIds));
        query.fields().include(x.toArray(new String[0]));
        return this.l.find(query, DevicePO.class).stream().map(this.n::d).collect(Collectors.toList());
    }

    public List<DeviceGridDTO> k(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.fields().include(x.toArray(new String[0]));
        return this.l.find(query, DevicePO.class).stream().map(this.n::d).collect(Collectors.toList());
    }

    public List<DeviceGridDTO> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, List<String> macs) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").in(macs));
        query.fields().include(x.toArray(new String[0]));
        return this.l.find(query, DevicePO.class).stream().map(this.n::d).collect(Collectors.toList());
    }

    public List<String> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, String sortType, List<String> macs) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").in(macs));
        query.fields().include("mac");
        if (Objects.equals(com.tplink.smb.omada.common.gridquery.g.b.a(), sortType)) {
            query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"name"}));
        } else if (Objects.equals(com.tplink.smb.omada.common.gridquery.g.a.a(), sortType)) {
            query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"name"}));
        }
        List devicePOList = this.l.find(query, DevicePO.class, "device");
        return devicePOList.stream().map(DevicePO::getMac).collect(Collectors.toList());
    }

    public List<H> c(com.tplink.smb.omada.manager.j.a.a.c omadacId, Collection<String> macList) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").in(macList));
        query.fields().include(new String[]{"mac", "model", "hw_version"});
        return this.l.find(query, DevicePO.class).stream().map(this.n::e).collect(Collectors.toList());
    }

    @Autowired
    public void a(MongoTemplate mongoTemplate) {
        this.l = mongoTemplate;
    }

    @Autowired
    public void a(DeviceMongoCrudRepository deviceMongoCrudRepository) {
        this.m = deviceMongoCrudRepository;
    }

    public Optional<d> d(com.tplink.smb.omada.manager.j.a.a.c omadacId, G mac) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)mac.a()));
        query.fields().include("site_id");
        DevicePO devicePO = (DevicePO)this.l.findOne(query, DevicePO.class);
        if (devicePO != null && devicePO.getSiteId() != null) {
            return Optional.of(new d(devicePO.getSiteId()));
        }
        return Optional.empty();
    }

    public List<o> f(com.tplink.smb.omada.manager.j.a.a.c omadacId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return Collections.emptyList();
        }
        return devicePOS.stream().map(this.n::a).collect(Collectors.toList());
    }

    public List<o> g(com.tplink.smb.omada.manager.j.a.a.c omadacId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"added_in_advance").is((Object)true));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return Collections.emptyList();
        }
        return devicePOS.stream().map(this.n::a).collect(Collectors.toList());
    }

    public List<DeviceOutlineDTO> b(String omadacId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.fields().include(new String[]{"mac", t, "added_in_advance", "added_type"});
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return Collections.emptyList();
        }
        return devicePOS.stream().map(m::d).collect(Collectors.toList());
    }

    public List<DeviceOutlineDTO> a(String omadacId, String siteId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"added_in_advance").is((Object)true));
        Set fields = DeviceOutlineDTO.getFields();
        query.fields().include(fields.toArray(new String[0]));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return Collections.emptyList();
        }
        return devicePOS.stream().map(m::a).collect(Collectors.toList());
    }

    public List<String> l(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"added_in_advance").is((Object)true));
        query.fields().include("mac");
        List devicePOList = this.l.find(query, DevicePO.class);
        ArrayList<String> macs = new ArrayList<String>(devicePOList.size());
        for (DevicePO devicePO : devicePOList) {
            macs.add(devicePO.getMac());
        }
        return macs;
    }

    public List<o> b(Set<String> omadacIds, Set<String> macs) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").in(omadacIds));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").in(macs));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return Collections.emptyList();
        }
        return devicePOS.stream().map(this.n::a).collect(Collectors.toList());
    }

    public List<o> c(Set<String> omadacIds, Set<String> macs) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").in(omadacIds));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").in(macs));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return Collections.emptyList();
        }
        return devicePOS.stream().map(this.n::b).collect(Collectors.toList());
    }

    public Map<DeviceTypeEnum, Set<String>> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, Boolean allSite, Collection<String> siteIds) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        if (!Boolean.TRUE.equals(allSite)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").in(siteIds));
        }
        query.fields().include(new String[]{"mac", t});
        List devicePOS = this.l.find(query, DevicePO.class);
        return devicePOS.stream().collect(Collectors.groupingBy(devicePO -> DeviceTypeEnum.b((String)devicePO.getType()), Collectors.mapping(DevicePO::getMac, Collectors.toSet())));
    }

    public Map<DeviceTypeEnum, Set<String>> m(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.fields().include(new String[]{"mac", t});
        List devicePOS = this.l.find(query, DevicePO.class);
        return devicePOS.stream().collect(Collectors.groupingBy(devicePO -> DeviceTypeEnum.b((String)devicePO.getType()), Collectors.mapping(DevicePO::getMac, Collectors.toSet())));
    }

    public long a(Collection<String> omadacIds) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").in(omadacIds));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"added_in_advance").is((Object)true));
        return this.l.count(query, DevicePO.class);
    }

    public List<t> b(String deviceType, String firmwareVersion) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)t).is((Object)deviceType));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)i).is((Object)firmwareVersion));
        query.fields().include(new String[]{"omadac_id", "mac", t});
        return this.l.find(query, DevicePO.class).stream().map(this.n::c).collect(Collectors.toList());
    }

    public Optional<com.tplink.smb.omada.manager.j.a.a.c> a(G deviceMac, Set<com.tplink.smb.omada.manager.j.a.a.c> customers) {
        if (!CollectionUtils.isEmpty(customers)) {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)deviceMac.a()));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").in((Collection)customers.stream().map(com.tplink.smb.omada.manager.j.a.a.c::a).collect(Collectors.toSet())));
            List omadacs = this.l.query(DevicePO.class).distinct("omadac_id").as(String.class).matching(query).all();
            if (CollectionUtils.isEmpty((Collection)omadacs)) {
                return Optional.empty();
            }
            return Optional.of(new com.tplink.smb.omada.manager.j.a.a.c((String)omadacs.get(0)));
        }
        return Optional.empty();
    }

    public af<o> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, boolean allSite, Set<String> siteIds, com.tplink.smb.omada.common.gridquery.b queryData) {
        af deviceGrid = new af(queryData);
        deviceGrid.initFilter();
        deviceGrid.initSearch(queryData.e(), DeviceGridDTO.getSearchKeys());
        List<com.tplink.smb.omada.common.gridquery.c> filters = this.d(deviceGrid.getFilters());
        long healthQueryTimeSec = System.currentTimeMillis() / 1000L;
        List<Criteria> healthStatusCriteriaList = this.a(deviceGrid.getFilters(), healthQueryTimeSec);
        Query query = com.tplink.smb.omada.manager.port.mongo.configuration.c.a.a(deviceGrid.getSearchFilters(), filters, healthStatusCriteriaList);
        if (OmadacType.s()) {
            query.allowDiskUse(true);
        }
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        if (!allSite) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").in(siteIds));
        }
        long count = this.l.count(query, DevicePO.class);
        deviceGrid.setTotalRows(count);
        if (deviceGrid.getQueryPage() != null) {
            query.with((Pageable)PageRequest.of((int)deviceGrid.getQueryPage().a(), (int)deviceGrid.getQueryPage().b()));
        }
        if (!CollectionUtils.isEmpty((Collection)deviceGrid.getQuerySorts())) {
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
            for (com.tplink.smb.omada.common.gridquery.e sort : deviceGrid.getQuerySorts()) {
                Sort.Direction direction = com.tplink.smb.omada.common.gridquery.g.b.equals((Object)sort.a()) ? Sort.Direction.ASC : Sort.Direction.DESC;
                Sort.Order order = new Sort.Order(direction, sort.b());
                orders.add(order);
            }
            Sort sort = Sort.by(orders);
            query.with(sort);
        }
        List devicePOS = this.l.find(query, DevicePO.class);
        deviceGrid.setData(devicePOS.stream().map(po -> {
            po.setHealthScore(com.tplink.smb.omada.manager.port.mongo.device.devicelist.a.a(healthQueryTimeSec, po.getHealthScoreTime(), po.getHealthScore()));
            return po;
        }).map(this.n::b).collect(Collectors.toList()));
        return deviceGrid;
    }

    public List<o> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, boolean allSite, Set<String> siteIds) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        if (!allSite) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").in(siteIds));
        }
        return this.l.find(query, DevicePO.class).stream().map(this.n::a).collect(Collectors.toList());
    }

    public ag a(com.tplink.smb.omada.manager.j.a.a.c omadacId, boolean allSite, Set<String> siteIds, com.tplink.smb.omada.common.gridquery.b queryData, boolean needQueryHealthStat) {
        af deviceGrid = new af(queryData);
        deviceGrid.initFilter();
        deviceGrid.initSearch(queryData.e(), DeviceGridDTO.getSearchKeys());
        List<com.tplink.smb.omada.common.gridquery.c> filters = this.d(deviceGrid.getFilters());
        long healthQueryTimeSec = System.currentTimeMillis() / 1000L;
        ArrayList<DeviceTypeCount> allDeviceTypeCounts = new ArrayList<DeviceTypeCount>();
        ArrayList<DeviceTypeHealthCount> deviceTypeHealthCounts = new ArrayList<DeviceTypeHealthCount>();
        ArrayList<DeviceTypeCount> deviceTypeCounts = new ArrayList<DeviceTypeCount>();
        AtomicInteger supportMeshCount = new AtomicInteger(0);
        ArrayList<DeviceScoreCount> deviceScoreCounts = new ArrayList<DeviceScoreCount>();
        Criteria omadacIdSiteIdCri = this.b(omadacId.a(), allSite, siteIds);
        if (needQueryHealthStat) {
            allDeviceTypeCounts.addAll(this.b(omadacIdSiteIdCri));
            Criteria deviceTypeHealthCriteria = this.a(omadacId.a(), allSite, siteIds, healthQueryTimeSec);
            deviceTypeHealthCounts.addAll(this.a(deviceTypeHealthCriteria));
        }
        ArrayList<Criteria> deviceTypeCntCri = new ArrayList<Criteria>();
        deviceTypeCntCri.add(omadacIdSiteIdCri);
        Criteria deviceTypeCriteria = com.tplink.smb.omada.manager.port.mongo.configuration.c.a.a(deviceGrid.getSearchFilters(), deviceTypeCntCri);
        deviceTypeCounts.addAll(this.b(deviceTypeCriteria));
        if (this.a((af<o>)deviceGrid)) {
            ArrayList<Criteria> supportMeshCri = new ArrayList<Criteria>();
            supportMeshCri.add(omadacIdSiteIdCri);
            supportMeshCri.add(this.b());
            Criteria supportMeshCriteria = com.tplink.smb.omada.manager.port.mongo.configuration.c.a.a(deviceGrid.getSearchFilters(), supportMeshCri);
            Query meshQuery = Query.query((CriteriaDefinition)supportMeshCriteria);
            long count = this.l.count(meshQuery, this.c());
            supportMeshCount.set((int)count);
        }
        if (needQueryHealthStat) {
            ArrayList<Criteria> healthStatStatusCri = new ArrayList<Criteria>();
            healthStatStatusCri.add(omadacIdSiteIdCri);
            healthStatStatusCri.add(this.a(healthQueryTimeSec));
            Criteria healthStatusCriteria = com.tplink.smb.omada.manager.port.mongo.configuration.c.a.c(deviceGrid.getSearchFilters(), filters, healthStatStatusCri);
            deviceScoreCounts.addAll(this.c(healthStatusCriteria));
        }
        this.a((af<o>)deviceGrid, allDeviceTypeCounts, deviceTypeHealthCounts, deviceTypeCounts, supportMeshCount, deviceScoreCounts);
        return deviceGrid.a();
    }

    public af<o> a(Set<String> customerIds, com.tplink.smb.omada.common.gridquery.b queryData) {
        af deviceGrid = new af(queryData);
        deviceGrid.initFilter();
        deviceGrid.initSearch(queryData.e(), DeviceGridDTO.getSearchKeys());
        List<com.tplink.smb.omada.common.gridquery.c> filters = this.d(deviceGrid.getFilters());
        long healthQueryTimeSec = System.currentTimeMillis() / 1000L;
        List<Criteria> healthStatusCriteriaList = this.a(deviceGrid.getFilters(), healthQueryTimeSec);
        Query query = com.tplink.smb.omada.manager.port.mongo.configuration.c.a.a(deviceGrid.getSearchFilters(), filters, healthStatusCriteriaList);
        if (OmadacType.s()) {
            query.allowDiskUse(true);
        }
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").in(customerIds));
        long count = this.l.count(query, DevicePO.class);
        deviceGrid.setTotalRows(count);
        if (deviceGrid.getQueryPage() != null) {
            query.with((Pageable)PageRequest.of((int)deviceGrid.getQueryPage().a(), (int)deviceGrid.getQueryPage().b()));
        }
        if (!CollectionUtils.isEmpty((Collection)deviceGrid.getQuerySorts())) {
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
            for (com.tplink.smb.omada.common.gridquery.e sort : deviceGrid.getQuerySorts()) {
                Sort.Direction direction = com.tplink.smb.omada.common.gridquery.g.b.equals((Object)sort.a()) ? Sort.Direction.ASC : Sort.Direction.DESC;
                Sort.Order order = new Sort.Order(direction, sort.b());
                orders.add(order);
            }
            Sort sort = Sort.by(orders);
            query.with(sort);
        }
        List devicePOS = this.l.find(query, DevicePO.class);
        deviceGrid.setData(devicePOS.stream().map(po -> {
            po.setHealthScore(com.tplink.smb.omada.manager.port.mongo.device.devicelist.a.a(healthQueryTimeSec, po.getHealthScoreTime(), po.getHealthScore()));
            return po;
        }).map(this.n::a).collect(Collectors.toList()));
        return deviceGrid;
    }

    public ag a(Set<String> customerIds, com.tplink.smb.omada.common.gridquery.b queryData, boolean proController) {
        af deviceGrid = new af(queryData);
        deviceGrid.initFilter();
        deviceGrid.initSearch(queryData.e(), DeviceGridDTO.getSearchKeys());
        List<com.tplink.smb.omada.common.gridquery.c> filters = this.d(deviceGrid.getFilters());
        long healthQueryTimeSec = System.currentTimeMillis() / 1000L;
        ArrayList<DeviceTypeCount> allDeviceTypeCounts = new ArrayList<DeviceTypeCount>();
        ArrayList<DeviceTypeHealthCount> deviceTypeHealthCounts = new ArrayList<DeviceTypeHealthCount>();
        ArrayList<DeviceTypeCount> deviceTypeCounts = new ArrayList<DeviceTypeCount>();
        AtomicInteger supportMeshCount = new AtomicInteger(0);
        ArrayList<DeviceScoreCount> deviceScoreCounts = new ArrayList<DeviceScoreCount>();
        Criteria omadacIdsCri = this.c(customerIds);
        if (proController) {
            allDeviceTypeCounts.addAll(this.b(omadacIdsCri));
            Criteria deviceTypeHealthCriteria = this.a(customerIds, healthQueryTimeSec);
            deviceTypeHealthCounts.addAll(this.a(deviceTypeHealthCriteria));
        }
        ArrayList<Criteria> deviceTypeCri = new ArrayList<Criteria>();
        deviceTypeCri.add(omadacIdsCri);
        Criteria deviceTypeCriteria = com.tplink.smb.omada.manager.port.mongo.configuration.c.a.a(deviceGrid.getSearchFilters(), deviceTypeCri);
        deviceTypeCounts.addAll(this.b(deviceTypeCriteria));
        if (this.a((af<o>)deviceGrid)) {
            ArrayList<Criteria> supportMeshCri = new ArrayList<Criteria>();
            supportMeshCri.add(omadacIdsCri);
            supportMeshCri.add(this.b());
            Criteria supportMeshCriteria = com.tplink.smb.omada.manager.port.mongo.configuration.c.a.a(deviceGrid.getSearchFilters(), supportMeshCri);
            Query meshQuery = Query.query((CriteriaDefinition)supportMeshCriteria);
            long count = this.l.count(meshQuery, this.c());
            supportMeshCount.set((int)count);
        }
        if (proController) {
            ArrayList<Criteria> healthStatusCri = new ArrayList<Criteria>();
            healthStatusCri.add(omadacIdsCri);
            healthStatusCri.add(this.a(healthQueryTimeSec));
            Criteria healthStatusCriteria = com.tplink.smb.omada.manager.port.mongo.configuration.c.a.c(deviceGrid.getSearchFilters(), filters, healthStatusCri);
            deviceScoreCounts.addAll(this.c(healthStatusCriteria));
        }
        this.a((af<o>)deviceGrid, allDeviceTypeCounts, deviceTypeHealthCounts, deviceTypeCounts, supportMeshCount, deviceScoreCounts);
        return deviceGrid.a();
    }

    public List<DeviceDTO> b(Collection<String> omadacIds) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").in(omadacIds));
        query.fields().include(new String[]{"mac", "omadac_id", "last_seen"});
        return this.l.find(query, DevicePO.class).stream().map(devicePO -> new DeviceDTO().setOmadacId(devicePO.getOmadacId()).setMac(devicePO.getMac()).setLastSeen(devicePO.getLastSeen())).collect(Collectors.toList());
    }

    public void b(@Nonnull List<o> deviceList) {
        List devicePOList = deviceList.stream().map(device -> this.n.a((o<?>)device)).collect(Collectors.toList());
        for (DevicePO devicePO : devicePOList) {
            this.l.save((Object)devicePO);
        }
    }

    public List<o> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, n tagId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tag_set").is((Object)tagId.b()));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return Collections.emptyList();
        }
        return devicePOS.stream().map(this.n::a).collect(Collectors.toList());
    }

    private List<com.tplink.smb.omada.common.gridquery.c> c(List<com.tplink.smb.omada.common.gridquery.c> filters) {
        ArrayList<com.tplink.smb.omada.common.gridquery.c> newFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(filters.size());
        Iterator<com.tplink.smb.omada.common.gridquery.c> iterator = filters.iterator();
        while (iterator.hasNext()) {
            com.tplink.smb.omada.common.gridquery.c filter = iterator.next();
            if ("deviceSeriesType".equals(filter.a())) {
                List<String> filterValueList = Arrays.asList(filter.b().toString().split(","));
                List filterTypeList = filterValueList.stream().map(seriesTypeString -> com.tplink.smb.omada.manager.device.api.internal.dto.b.a((Integer)Integer.parseInt(seriesTypeString))).filter(Objects::nonNull).map(b::c).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(filterTypeList) && filterTypeList.contains(com.tplink.smb.omada.manager.common.constants.e.c.a())) {
                    filterTypeList.add(null);
                }
                newFilters.add(new com.tplink.smb.omada.common.gridquery.c("device_misc.model_type", filterTypeList, c.a.h));
                iterator.remove();
                continue;
            }
            if (!"tag".equals(filter.a())) continue;
            List<String> filterTagList = Arrays.asList(filter.b().toString().split(","));
            newFilters.add(new com.tplink.smb.omada.common.gridquery.c("tag_set", filterTagList, c.a.h));
            iterator.remove();
        }
        newFilters.addAll(filters);
        return newFilters;
    }

    private List<com.tplink.smb.omada.common.gridquery.c> d(List<com.tplink.smb.omada.common.gridquery.c> filters) {
        ArrayList<com.tplink.smb.omada.common.gridquery.c> newFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(filters.size());
        filters.forEach(filter -> {
            if ("deviceSeriesType".equals(filter.a())) {
                List<String> filterValueList = Arrays.asList(filter.b().toString().split(","));
                List filterTypeList = filterValueList.stream().map(seriesTypeString -> com.tplink.smb.omada.manager.device.api.internal.dto.b.a((Integer)Integer.parseInt(seriesTypeString))).filter(Objects::nonNull).map(b::c).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(filterTypeList) && filterTypeList.contains(com.tplink.smb.omada.manager.common.constants.e.c.a())) {
                    filterTypeList.add(null);
                }
                newFilters.add(new com.tplink.smb.omada.common.gridquery.c("device_misc.model_type", filterTypeList, c.a.h));
                return;
            }
            if ("supportMesh".equals(filter.a())) {
                Boolean supportMesh = (Boolean)filter.b();
                if (Boolean.TRUE.equals(supportMesh)) {
                    newFilters.add(new com.tplink.smb.omada.common.gridquery.c("device_misc.support_mesh", (Object)0, c.a.e));
                } else if (Boolean.FALSE.equals(supportMesh)) {
                    newFilters.add(new com.tplink.smb.omada.common.gridquery.c("device_misc.support_mesh", (Object)Lists.newArrayList((Object[])new Integer[]{0, null}), c.a.h));
                }
                return;
            }
            if ("deviceType".equals(filter.a())) {
                List<String> filterValueList = Arrays.asList(filter.b().toString().split(","));
                List filterTypeList = filterValueList.stream().map(typeInt -> DeviceTypeEnum.a((Integer)Integer.parseInt(typeInt))).filter(Objects::nonNull).map(DeviceTypeEnum::b).collect(Collectors.toList());
                newFilters.add(new com.tplink.smb.omada.common.gridquery.c(t, filterTypeList, c.a.h));
            }
            if ("tag".equals(filter.a())) {
                List<String> filterTagList = Arrays.asList(filter.b().toString().split(","));
                newFilters.add(new com.tplink.smb.omada.common.gridquery.c("tag_set", filterTagList, c.a.h));
            }
            if (Objects.equals("ecspFirstVersion", filter.a())) {
                try {
                    String ecspFirstVersionString = filter.b().toString();
                    int ecspFirstVersion = Integer.parseInt(ecspFirstVersionString);
                    Pattern ecspVersionPattern = EcspVersion.getEcspVersionPattern((int)ecspFirstVersion);
                    if (Objects.isNull(ecspVersionPattern)) {
                        return;
                    }
                    newFilters.add(new com.tplink.smb.omada.common.gridquery.c("ecspVersion", (Object)ecspVersionPattern.pattern(), c.a.g));
                }
                catch (Exception e2) {
                    k.warn("transDeviceGridFilters error, filterKey{}, filterValue:{}", (Object)filter.a(), filter.b());
                }
            }
        });
        return newFilters;
    }

    public long a(G deviceMac, com.tplink.smb.omada.manager.j.a.a.c srcCustomer, com.tplink.smb.omada.manager.j.a.a.c destCustomer) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)deviceMac.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)srcCustomer.a()));
        if (OmadacType.s()) {
            DevicePO devicePO = (DevicePO)this.l.findOne(query, DevicePO.class);
            if (devicePO == null) {
                return 0L;
            }
            devicePO.setOmadacId(destCustomer.a());
            devicePO.setId(null);
            this.l.insert((Object)devicePO);
            this.l.remove(query, DevicePO.class);
            return 1L;
        }
        UpdateResult updateResult = this.l.updateFirst(query, (UpdateDefinition)Update.update((String)"omadac_id", (Object)destCustomer.a()), DevicePO.class);
        return updateResult.getModifiedCount();
    }

    public com.tplink.smb.omada.common.gridquery.a<o> b(com.tplink.smb.omada.manager.j.a.a.c omadacId, boolean allSite, Set<String> siteIds, com.tplink.smb.omada.common.gridquery.b queryData) {
        com.tplink.smb.omada.common.gridquery.a deviceGrid = new com.tplink.smb.omada.common.gridquery.a(queryData);
        deviceGrid.initFilter();
        deviceGrid.initMultiSearch(queryData.h());
        List<com.tplink.smb.omada.common.gridquery.c> filters = this.c(deviceGrid.getFilters());
        Query query = com.tplink.smb.omada.manager.port.mongo.configuration.c.a.b(deviceGrid.getSearchFilters(), filters);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        if (!allSite) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").in(siteIds));
        }
        long count = this.l.count(query, DevicePO.class);
        deviceGrid.setTotalRows(count);
        if (deviceGrid.getQueryPage() != null) {
            query.with((Pageable)PageRequest.of((int)deviceGrid.getQueryPage().a(), (int)deviceGrid.getQueryPage().b()));
        }
        if (!CollectionUtils.isEmpty((Collection)deviceGrid.getQuerySorts())) {
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
            for (com.tplink.smb.omada.common.gridquery.e sort : deviceGrid.getQuerySorts()) {
                Sort.Direction direction = com.tplink.smb.omada.common.gridquery.g.b.equals((Object)sort.a()) ? Sort.Direction.ASC : Sort.Direction.DESC;
                Sort.Order order = new Sort.Order(direction, sort.b());
                orders.add(order);
            }
            Sort sort = Sort.by(orders);
            query.with(sort);
        }
        List devicePOS = this.l.find(query, DevicePO.class);
        deviceGrid.setData(devicePOS.stream().map(this.n::a).collect(Collectors.toList()));
        return deviceGrid;
    }

    public com.tplink.smb.omada.common.gridquery.a<o> b(Set<String> customerIds, com.tplink.smb.omada.common.gridquery.b queryData) {
        af deviceGrid = new af(queryData);
        deviceGrid.initFilter();
        deviceGrid.initMultiSearch(queryData.h());
        List<com.tplink.smb.omada.common.gridquery.c> filters = this.c(deviceGrid.getFilters());
        Query query = com.tplink.smb.omada.manager.port.mongo.configuration.c.a.b(deviceGrid.getSearchFilters(), filters);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").in(customerIds));
        long count = this.l.count(query, DevicePO.class);
        deviceGrid.setTotalRows(count);
        if (deviceGrid.getQueryPage() != null) {
            query.with((Pageable)PageRequest.of((int)deviceGrid.getQueryPage().a(), (int)deviceGrid.getQueryPage().b()));
        }
        if (!CollectionUtils.isEmpty((Collection)deviceGrid.getQuerySorts())) {
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
            for (com.tplink.smb.omada.common.gridquery.e sort : deviceGrid.getQuerySorts()) {
                Sort.Direction direction = com.tplink.smb.omada.common.gridquery.g.b.equals((Object)sort.a()) ? Sort.Direction.ASC : Sort.Direction.DESC;
                Sort.Order order = new Sort.Order(direction, sort.b());
                orders.add(order);
            }
            Sort sort = Sort.by(orders);
            query.with(sort);
        }
        List devicePOS = this.l.find(query, DevicePO.class);
        deviceGrid.setData(devicePOS.stream().map(this.n::a).collect(Collectors.toList()));
        return deviceGrid;
    }

    public List<ModelAndModelVersionVO> c(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, DeviceTypeEnum deviceType) {
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || Objects.isNull(deviceType)) {
            return Collections.emptyList();
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)t).is((Object)deviceType.b()));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return Collections.emptyList();
        }
        return devicePOS.stream().map(this.n::f).distinct().collect(Collectors.toList());
    }

    private List<DeviceTypeHealthCount> a(Criteria criteria) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), w, Aggregation.group((String[])new String[]{t, "health_score"}).first(t).as(t).first("health_score").as("health_score").count().as(v), Aggregation.project((String[])new String[0]).and(t).as(t).and("health_score").as(u).and(v).as(v)});
        return this.a(aggregation, DeviceTypeHealthCount.class);
    }

    private List<DeviceTypeCount> b(Criteria criteria) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), w, Aggregation.group((String[])new String[]{t}).count().as(v), Aggregation.project((String[])new String[0]).and("_id").as(t).and(v).as(v)});
        return this.a(aggregation, DeviceTypeCount.class);
    }

    private List<DeviceScoreCount> c(Criteria criteria) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), w, Aggregation.group((String[])new String[]{"health_score"}).count().as(v), Aggregation.project((String[])new String[0]).and("_id").as(u).and(v).as(v)});
        return this.a(aggregation, DeviceScoreCount.class);
    }

    private <T> List<T> a(Aggregation aggregation, Class<T> tClass) {
        AggregationResults aggregateResult = this.l.aggregate(aggregation, this.c(), tClass);
        return aggregateResult.getMappedResults();
    }

    private boolean a(af<o> grid) {
        boolean filterAp = false;
        boolean filterOswAndOsg = false;
        List queryFilters = grid.getFilters();
        List<Object> filterTypeList = new ArrayList();
        for (com.tplink.smb.omada.common.gridquery.c queryFilter : queryFilters) {
            if ("deviceType".equals(queryFilter.a())) {
                List<String> filterValueList = Arrays.asList(queryFilter.b().toString().split(","));
                filterTypeList = filterValueList.stream().map(typeInt -> DeviceTypeEnum.a((Integer)Integer.parseInt(typeInt))).filter(Objects::nonNull).collect(Collectors.toList());
                break;
            }
            if (!"supportMesh".equals(queryFilter.a())) continue;
            return true;
        }
        for (DeviceTypeEnum deviceTypeEnum : filterTypeList) {
            switch (deviceTypeEnum) {
                case a: {
                    filterAp = true;
                    break;
                }
                case c: 
                case b: {
                    filterOswAndOsg = true;
                }
            }
        }
        return filterAp && !filterOswAndOsg;
    }

    private void a(af<o> grid, List<DeviceTypeCount> allDeviceTypeCounts, List<DeviceTypeHealthCount> deviceTypeHealthCounts, List<DeviceTypeCount> deviceTypeCounts, AtomicInteger supportMeshNum, List<DeviceScoreCount> deviceScoreCounts) {
        ag stat = grid.a();
        this.a(stat, allDeviceTypeCounts, deviceTypeHealthCounts);
        for (DeviceTypeCount deviceTypeCount : deviceTypeCounts) {
            if (Objects.isNull(deviceTypeCount.getType())) continue;
            DeviceTypeEnum deviceTypeEnum = DeviceTypeEnum.b((String)deviceTypeCount.getType());
            stat.a(deviceTypeEnum, deviceTypeCount.getCount());
        }
        stat.e(Integer.valueOf(supportMeshNum.get()));
        stat.f(stat.h());
        stat.g(stat.h());
        Integer healthAll = this.a(grid, stat);
        for (DeviceScoreCount deviceScoreCount : deviceScoreCounts) {
            com.tplink.smb.omada.manager.device.api.web.device.a.c healthStatusEnum;
            if (Objects.isNull(deviceScoreCount.getHealthScore()) || Objects.isNull(healthStatusEnum = com.tplink.smb.omada.manager.device.api.web.device.a.c.a((Integer)deviceScoreCount.getHealthScore())) || Objects.equals(healthStatusEnum, com.tplink.smb.omada.manager.device.api.web.device.a.c.a)) continue;
            stat.a(healthStatusEnum, deviceScoreCount.getCount());
        }
        stat.n(Integer.valueOf(healthAll - stat.p() - stat.q() - stat.r()));
    }

    private void a(ag stat, List<DeviceTypeCount> allDeviceTypeCounts, List<DeviceTypeHealthCount> deviceTypeHealthCounts) {
        DeviceTypeEnum deviceTypeEnum;
        int allAp = 0;
        int allSwitch = 0;
        int allGateway = 0;
        int allOlt = 0;
        for (DeviceTypeCount deviceTypeCount : allDeviceTypeCounts) {
            if (Objects.isNull(deviceTypeCount.getType())) continue;
            deviceTypeEnum = DeviceTypeEnum.b((String)deviceTypeCount.getType());
            switch (deviceTypeEnum) {
                case a: {
                    allAp += deviceTypeCount.getCount().intValue();
                    break;
                }
                case c: {
                    allSwitch += deviceTypeCount.getCount().intValue();
                    break;
                }
                case b: {
                    allGateway += deviceTypeCount.getCount().intValue();
                    break;
                }
                case d: {
                    allOlt += deviceTypeCount.getCount().intValue();
                }
            }
        }
        for (DeviceTypeHealthCount deviceTypeHealthCount : deviceTypeHealthCounts) {
            if (Objects.isNull(deviceTypeHealthCount.getType()) || Objects.isNull(deviceTypeHealthCount.getHealthScore())) continue;
            deviceTypeEnum = DeviceTypeEnum.b((String)deviceTypeHealthCount.getType());
            com.tplink.smb.omada.manager.device.api.web.device.a.c healthStatusEnum = com.tplink.smb.omada.manager.device.api.web.device.a.c.a((Integer)deviceTypeHealthCount.getHealthScore());
            if (Objects.isNull(healthStatusEnum) || Objects.equals(healthStatusEnum, com.tplink.smb.omada.manager.device.api.web.device.a.c.a)) continue;
            switch (deviceTypeEnum) {
                case a: {
                    stat.d().a(healthStatusEnum, deviceTypeHealthCount.getCount());
                    break;
                }
                case c: {
                    stat.c().a(healthStatusEnum, deviceTypeHealthCount.getCount());
                    break;
                }
                case b: {
                    stat.b().a(healthStatusEnum, deviceTypeHealthCount.getCount());
                    break;
                }
                case d: {
                    stat.e().a(healthStatusEnum, deviceTypeHealthCount.getCount());
                }
            }
        }
        stat.d().a(allAp);
        stat.c().a(allSwitch);
        stat.b().a(allGateway);
        stat.e().a(allOlt);
    }

    private Integer a(af<o> grid, ag globalDeviceStat) {
        boolean filterAp = false;
        boolean filterOswAndOsg = false;
        boolean filterOlt = false;
        List queryFilters = grid.getFilters();
        List<Object> filterTypeList = new ArrayList();
        for (com.tplink.smb.omada.common.gridquery.c queryFilter : queryFilters) {
            if ("deviceType".equals(queryFilter.a())) {
                List<String> filterValueList = Arrays.asList(queryFilter.b().toString().split(","));
                filterTypeList = filterValueList.stream().map(typeInt -> DeviceTypeEnum.a((Integer)Integer.parseInt(typeInt))).filter(Objects::nonNull).collect(Collectors.toList());
            }
            if (!"supportMesh".equals(queryFilter.a())) continue;
            if (Boolean.FALSE.equals(queryFilter.b())) {
                return Math.min(0, globalDeviceStat.h() - globalDeviceStat.j());
            }
            return globalDeviceStat.j();
        }
        for (DeviceTypeEnum deviceTypeEnum : filterTypeList) {
            switch (deviceTypeEnum) {
                case a: {
                    filterAp = true;
                    break;
                }
                case c: 
                case b: {
                    filterOswAndOsg = true;
                    break;
                }
                case d: {
                    filterOlt = true;
                }
            }
        }
        if (filterAp) {
            return globalDeviceStat.h();
        }
        if (filterOswAndOsg) {
            return globalDeviceStat.g();
        }
        if (filterOlt) {
            return globalDeviceStat.i();
        }
        return globalDeviceStat.f();
    }

    private Criteria b(Set<String> omadacIds) {
        return Criteria.where((String)"omadac_id").in(omadacIds);
    }

    private Criteria a(Set<String> omadacIds, long queryTimeSec) {
        long startSec = queryTimeSec - 1200L;
        return Criteria.where((String)"omadac_id").in(omadacIds).and("health_score_time").gt((Object)startSec).lte((Object)queryTimeSec);
    }

    private Criteria c(Set<String> omadacIds) {
        Criteria omadacCriteria = new Criteria();
        omadacCriteria.and("omadac_id").in(omadacIds);
        return omadacCriteria;
    }

    private Criteria a(String omadacId, boolean allSites, Set<String> siteIds) {
        if (allSites) {
            return Criteria.where((String)"omadac_id").is((Object)omadacId);
        }
        return Criteria.where((String)"omadac_id").is((Object)omadacId).and("site_id").in(siteIds);
    }

    private Criteria a(String omadacId, boolean allSites, Set<String> siteIds, long queryTimeSec) {
        long startSec = queryTimeSec - 1200L;
        if (allSites) {
            return Criteria.where((String)"omadac_id").is((Object)omadacId).and("health_score_time").gt((Object)startSec).lte((Object)queryTimeSec);
        }
        return Criteria.where((String)"omadac_id").is((Object)omadacId).and("site_id").in(siteIds).and("health_score_time").gt((Object)startSec).lte((Object)queryTimeSec);
    }

    private Criteria b(String omadacId, boolean allSites, Set<String> siteIds) {
        Criteria omadacCriteria = new Criteria();
        if (allSites) {
            omadacCriteria.and("omadac_id").is((Object)omadacId);
        } else {
            omadacCriteria.and("omadac_id").is((Object)omadacId).and("site_id").in(siteIds);
        }
        return omadacCriteria;
    }

    private Criteria b() {
        Criteria apSupportMeshApCriteria = new Criteria();
        apSupportMeshApCriteria.and(t).is((Object)DeviceTypeEnum.a.b());
        apSupportMeshApCriteria.and("device_misc.support_mesh").gt((Object)0);
        return apSupportMeshApCriteria;
    }

    private Criteria a(long queryTimeSec) {
        Criteria timeCriteria = new Criteria();
        long startSec = queryTimeSec - 1200L;
        timeCriteria.and("health_score_time").gt((Object)startSec).lte((Object)queryTimeSec);
        return timeCriteria;
    }

    private List<Criteria> a(List<com.tplink.smb.omada.common.gridquery.c> queryFilters, long queryTimeSec) {
        if (CollectionUtils.isEmpty(queryFilters)) {
            return Collections.emptyList();
        }
        Object healthStatusFilter = null;
        for (com.tplink.smb.omada.common.gridquery.c queryFilter : queryFilters) {
            if (!"health".equals(queryFilter.a())) continue;
            healthStatusFilter = queryFilter.b();
        }
        if (Objects.isNull(healthStatusFilter)) {
            return Collections.emptyList();
        }
        int[] scoreBound = com.tplink.smb.omada.manager.device.api.web.device.a.b.a(healthStatusFilter);
        if (com.tplink.smb.omada.manager.device.api.web.device.a.b.a((int)scoreBound[0], (int)scoreBound[1])) {
            return Collections.emptyList();
        }
        long startSec = queryTimeSec - 1200L;
        if (scoreBound[1] > -1) {
            Criteria criteria = Criteria.where((String)"health_score_time").gt((Object)startSec).lte((Object)queryTimeSec).and("health_score").gte((Object)scoreBound[0]).lte((Object)scoreBound[1]);
            return Collections.singletonList(criteria);
        }
        Criteria noDataScoreCriteria = Criteria.where((String)"health_score_time").gt((Object)startSec).lte((Object)queryTimeSec).and("health_score").is((Object)-1);
        Criteria disconnectedScoreCriteria = Criteria.where((String)"health_score_time").lte((Object)startSec);
        Criteria noScoreCriteria = Criteria.where((String)"health_score").is(null);
        return new ArrayList<Criteria>(Arrays.asList(noDataScoreCriteria, disconnectedScoreCriteria, noScoreCriteria));
    }

    private String c() {
        return "device";
    }

    public void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, Set<String> macs, String moveSiteId) {
        if (CollectionUtils.isEmpty(macs)) {
            return;
        }
        this.l.updateMulti(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("mac").in(macs)), (UpdateDefinition)Update.update((String)"move_site_id", (Object)moveSiteId), DevicePO.class);
    }

    private void a(DeviceTypeEnum deviceType, boolean includeWR, Query query) {
        if (deviceType == DeviceTypeEnum.a && includeWR) {
            query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)t).is((Object)DeviceTypeEnum.a.b()), Criteria.where((String)t).is((Object)DeviceTypeEnum.b.b()).and("wireless_router").is((Object)true)}));
        } else {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)t).is((Object)deviceType.b()));
        }
    }

    public List<o> n(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and(t).is((Object)DeviceTypeEnum.a.b()).and("device_misc.support_p2p").is((Object)true));
        return this.l.find(query, DevicePO.class).stream().map(this.n::a).collect(Collectors.toList());
    }

    public List<o> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, Collection<String> compoundModels, long time) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("target").is((Object)true).and("adopt_time").gte((Object)time).and(e).in(compoundModels));
        return this.l.find(query, DevicePO.class).stream().map(this.n::a).collect(Collectors.toList());
    }

    public List<SiteModelInfoDTO> c(com.tplink.smb.omada.manager.j.a.a.c omadacId, String showModel) {
        Criteria criteria = new Criteria();
        criteria.and("omadac_id").is((Object)omadacId.a());
        if (T.b((String)showModel)) {
            criteria.and("show_model").regex(T.g((String)showModel), "i");
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"site_id", b, a, c}).first(e).as(e).first(i).as(i).first("show_model").as("show_model"), Aggregation.project((String[])new String[0]).and("site_id").as(d).and(b).as(b).and(a).as(a).and(c).as(c).and(e).as(f).and(i).as(j).and("show_model").as(g)});
        return this.l.aggregate(aggregation, "device", SiteModelInfoDTO.class).getMappedResults();
    }

    public List<SiteModelInfoDTO> e(com.tplink.smb.omada.manager.j.a.a.c omadacId, Set<String> showModels) {
        Criteria criteria = new Criteria();
        criteria.and("omadac_id").is((Object)omadacId.a());
        if (!CollectionUtil.isEmpty(showModels)) {
            criteria.and("show_model").in(showModels);
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"site_id", b, a, c}).first(e).as(e).first(i).as(i).first("show_model").as("show_model"), Aggregation.project((String[])new String[0]).and("site_id").as(d).and(b).as(b).and(a).as(a).and(c).as(c).and(e).as(f).and(i).as(j).and("show_model").as(g)});
        return this.l.aggregate(aggregation, "device", SiteModelInfoDTO.class).getMappedResults();
    }

    public List<SiteModelInfoDTO> f(com.tplink.smb.omada.manager.j.a.a.c omadacId, Set<String> siteIds) {
        Criteria criteria = new Criteria();
        criteria.and("omadac_id").is((Object)omadacId.a());
        if (!CollectionUtil.isEmpty(siteIds)) {
            criteria.and("site_id").in(siteIds);
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"site_id", b, a, c}).first(e).as(e).first(i).as(i).first("show_model").as("show_model").first("special_model").as("special_model"), Aggregation.project((String[])new String[0]).and("site_id").as(d).and(b).as(b).and(a).as(a).and(c).as(c).and(e).as(f).and(i).as(j).and("show_model").as(g).and("special_model").as(h)});
        return this.l.aggregate(aggregation, "device", SiteModelInfoDTO.class).getMappedResults();
    }

    public SiteModelInfoDTO d(com.tplink.smb.omada.manager.j.a.a.c omadacId, String compoundModel) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and(e).is((Object)compoundModel));
        return (SiteModelInfoDTO)this.l.findOne(query, SiteModelInfoDTO.class, "device");
    }

    public List<DeviceFirmwareTypeInfoDTO> h(com.tplink.smb.omada.manager.j.a.a.c omadacId) {
        Criteria criteria = new Criteria();
        criteria.and("omadac_id").is((Object)omadacId.a());
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{a, e}).first(e).as(e).first(t).as(t), Aggregation.project((String[])new String[0]).and(t).as(t).and(e).as(f)});
        return this.l.aggregate(aggregation, "device", DeviceFirmwareTypeInfoDTO.class).getMappedResults();
    }

    public long e(com.tplink.smb.omada.manager.j.a.a.c omadacId, String templateId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("template_id").is((Object)templateId));
        return this.l.count(query, DevicePO.class);
    }

    public long b(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, String templateId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("template_id").is((Object)templateId));
        return this.l.count(query, DevicePO.class);
    }

    public List<o> c(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, String templateId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("template_id").is((Object)templateId));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return Collections.emptyList();
        }
        return devicePOS.stream().map(this.n::a).collect(Collectors.toList());
    }

    public List<o> b(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId, List<String> deviceTemplateIds) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("template_id").in(deviceTemplateIds));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return Collections.emptyList();
        }
        return devicePOS.stream().map(this.n::a).collect(Collectors.toList());
    }

    public boolean a(G deviceMac) {
        return this.l.exists(Query.query((CriteriaDefinition)Criteria.where((String)"mac").is((Object)deviceMac.a())), DevicePO.class);
    }

    public boolean o(com.tplink.smb.omada.manager.j.a.a.c omadacId, d siteId) {
        Query query = new Query();
        query.fields().include(new String[]{t, "component_info"});
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        List devicePOS = this.l.find(query, DevicePO.class);
        if (CollectionUtils.isEmpty((Collection)devicePOS)) {
            return false;
        }
        for (DevicePO devicePO : devicePOS) {
            ComponentInfo componentInfo = com.tplink.smb.omada.manager.port.mongo.device.m.a(devicePO.getComponentInfo());
            if (componentInfo == null) {
                return true;
            }
            switch (DeviceTypeEnum.b((String)devicePO.getType())) {
                case b: {
                    break;
                }
                case c: {
                    boolean supportRadSec = componentInfo.isSupportByComponentVer((com.tplink.smb.omada.manager.common.b.a.a.c)com.tplink.smb.omada.manager.common.b.a.a.j.q, 1, 6);
                    if (supportRadSec) break;
                    return true;
                }
                case a: {
                    boolean supportRadSec = componentInfo.isSupportByComponentVer((com.tplink.smb.omada.manager.common.b.a.a.c)com.tplink.smb.omada.manager.common.b.a.a.a.j, 1, 1);
                    if (supportRadSec) break;
                    return true;
                }
            }
        }
        return false;
    }

    public com.tplink.smb.omada.common.gridquery.a<o> a(com.tplink.smb.omada.common.gridquery.b queryData, com.tplink.smb.omada.manager.j.a.a.c omadacId, String templateId, Set<String> allSiteIds, Set<String> searchSiteIds) {
        com.tplink.smb.omada.common.gridquery.a grid = new com.tplink.smb.omada.common.gridquery.a(queryData);
        grid.initFilter();
        grid.initOmadacIdFilter(omadacId.a());
        grid.initSearch(queryData.e(), new String[]{"name"});
        if (!CollectionUtils.isEmpty(searchSiteIds)) {
            List searchFilters = Optional.ofNullable(grid.getSearchFilters()).orElse(new ArrayList());
            searchFilters.add(new com.tplink.smb.omada.common.gridquery.c("site_id", searchSiteIds, c.a.h));
            grid.setSearchFilters(searchFilters);
        }
        Query query = com.tplink.smb.omada.manager.port.mongo.configuration.c.a.b(grid.getSearchFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters());
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"template_id").is((Object)templateId));
        if (!CollectionUtils.isEmpty(allSiteIds)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").in(allSiteIds));
        }
        grid.setTotalRows(this.l.count(query, DevicePO.class));
        if (!CollectionUtils.isEmpty((Collection)grid.getQuerySorts())) {
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
            for (com.tplink.smb.omada.common.gridquery.e sort : grid.getQuerySorts()) {
                Sort.Direction direction = com.tplink.smb.omada.common.gridquery.g.b.equals((Object)sort.a()) ? Sort.Direction.ASC : Sort.Direction.DESC;
                Sort.Order order = new Sort.Order(direction, sort.b());
                orders.add(order);
            }
            Sort sort = Sort.by(orders);
            query.with(sort);
        }
        com.tplink.smb.omada.manager.port.mongo.configuration.c.a.a(query, grid.getQueryPage());
        List wgList = this.l.find(query, DevicePO.class);
        grid.setData(wgList.stream().map(this.n::a).collect(Collectors.toList()));
        return grid;
    }

    public com.tplink.smb.omada.common.gridquery.a<o> b(com.tplink.smb.omada.common.gridquery.b queryData, com.tplink.smb.omada.manager.j.a.a.c omadacId, String compoundModel, Set<String> allSiteIds, Set<String> searchSiteIds) {
        com.tplink.smb.omada.common.gridquery.a grid = new com.tplink.smb.omada.common.gridquery.a(queryData);
        grid.initFilter();
        grid.initOmadacIdFilter(omadacId.a());
        grid.initSearch(queryData.e(), new String[]{"name"});
        if (!CollectionUtils.isEmpty(searchSiteIds)) {
            List searchFilters = Optional.ofNullable(grid.getSearchFilters()).orElse(new ArrayList());
            searchFilters.add(new com.tplink.smb.omada.common.gridquery.c("site_id", searchSiteIds, c.a.h));
            grid.setSearchFilters(searchFilters);
        }
        Query query = com.tplink.smb.omada.manager.port.mongo.configuration.c.a.b(grid.getSearchFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters());
        query.addCriteria((CriteriaDefinition)Criteria.where((String)e).is((Object)compoundModel).and("template_id").isNull().and("mlag_name").isNull().and("stack_id").isNull());
        if (!CollectionUtils.isEmpty(allSiteIds)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").in(allSiteIds));
        }
        grid.setTotalRows(this.l.count(query, DevicePO.class));
        if (!CollectionUtils.isEmpty((Collection)grid.getQuerySorts())) {
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
            for (com.tplink.smb.omada.common.gridquery.e sort : grid.getQuerySorts()) {
                Sort.Direction direction = com.tplink.smb.omada.common.gridquery.g.b.equals((Object)sort.a()) ? Sort.Direction.ASC : Sort.Direction.DESC;
                Sort.Order order = new Sort.Order(direction, sort.b());
                orders.add(order);
            }
            Sort sort = Sort.by(orders);
            query.with(sort);
        }
        com.tplink.smb.omada.manager.port.mongo.configuration.c.a.a(query, grid.getQueryPage());
        List wgList = this.l.find(query, DevicePO.class);
        grid.setData(wgList.stream().map(this.n::a).collect(Collectors.toList()));
        return grid;
    }

    public void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, List<String> macs, Integer syncStatus) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("mac").in(macs));
        Update update = Update.update((String)"template_sync_status", (Object)syncStatus);
        this.l.updateMulti(query, (UpdateDefinition)update, DevicePO.class);
    }

    public void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, List<String> macs, Integer syncStatus, Integer syncErrorCode) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("mac").in(macs));
        Update update = Update.update((String)"template_sync_status", (Object)syncStatus).set("template_sync_error_code", (Object)syncErrorCode);
        this.l.updateMulti(query, (UpdateDefinition)update, DevicePO.class);
    }

    public Map<String, String> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, @Nonnull List<String> siteIds) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").in(siteIds).and(t).is((Object)DeviceTypeEnum.b.b()).andOperator(new Criteria[]{new Criteria().orOperator(new Criteria[]{Criteria.where((String)"device_misc.ippt").is((Object)false), Criteria.where((String)"device_misc.ippt").is(null)})}));
        query.fields().include(new String[]{"site_id", "public_ip"});
        List gatewayPOS = this.l.find(query, DevicePO.class);
        HashMap<String, String> sitePublicIpMap = new HashMap<String, String>();
        if (gatewayPOS.isEmpty()) {
            return sitePublicIpMap;
        }
        gatewayPOS.forEach(devicePO -> sitePublicIpMap.put(devicePO.getSiteId(), devicePO.getPublicIp()));
        return sitePublicIpMap;
    }

    public long a(com.tplink.smb.omada.manager.j.a.a.c omadacId, @Nullable d siteId, @Nonnull Integer ecspFirstVersion) {
        Pattern ecspVersionPattern = EcspVersion.getEcspVersionPattern((int)ecspFirstVersion);
        if (Objects.isNull(ecspVersionPattern)) {
            return 0L;
        }
        if (k.isTraceEnabled()) {
            k.trace("get ecspFirstVersion pattern success, ecspFirstVersion is :{}", (Object)ecspFirstVersion);
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("ecspVersion").regex(ecspVersionPattern));
        if (Objects.nonNull(siteId)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        }
        return this.l.count(query, DevicePO.class);
    }

    public long a(Set<String> customerIds, @Nonnull Integer ecspFirstVersion) {
        Pattern ecspVersionPattern = EcspVersion.getEcspVersionPattern((int)ecspFirstVersion);
        if (Objects.isNull(ecspVersionPattern)) {
            return 0L;
        }
        if (k.isTraceEnabled()) {
            k.trace("get ecspFirstVersion pattern success, ecspFirstVersion is :{}", (Object)ecspFirstVersion);
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").in(customerIds).and("ecspVersion").regex(ecspVersionPattern));
        return this.l.count(query, DevicePO.class);
    }

    public Map<String, List<String>> b(@Nonnull Set<String> customerIds, @Nonnull Integer ecspFirstVersion) {
        Pattern ecspVersionPattern = EcspVersion.getEcspVersionPattern((int)ecspFirstVersion);
        if (Objects.isNull(ecspVersionPattern)) {
            return new HashMap<String, List<String>>();
        }
        if (k.isTraceEnabled()) {
            k.trace("get ecspFirstVersion pattern success, ecspFirstVersion is :{}", (Object)ecspFirstVersion);
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").in(customerIds).and("ecspVersion").regex(ecspVersionPattern));
        query.fields().include(new String[]{"omadac_id", "mac"});
        List devicePOS = this.l.find(query, DevicePO.class);
        Map<String, List<String>> omadacIdMacMap = devicePOS.stream().collect(Collectors.toMap(DevicePO::getOmadacId, devicePO -> Collections.singletonList(devicePO.getMac()), (list1, list2) -> {
            ArrayList merged = new ArrayList(list1);
            merged.addAll(list2);
            return merged;
        }));
        return omadacIdMacMap;
    }

    public void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, G mac, Boolean upgradeFlag) {
        if (Boolean.TRUE.equals(upgradeFlag)) {
            this.l.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("mac").is((Object)mac.a())), (UpdateDefinition)new Update().set("upgrade_flag", (Object)true).set("upgrade_time", (Object)System.currentTimeMillis()), DevicePO.class);
        } else {
            this.l.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("mac").is((Object)mac.a())), (UpdateDefinition)new Update().set("upgrade_flag", (Object)false), DevicePO.class);
        }
    }
}

