/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.port.mongo.device.configsync;

import com.google.common.collect.HashBasedTable;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.result.UpdateResult;
import com.tplink.smb.eventcenter.api.event.DomainEventSubscriber;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.gridquery.c;
import com.tplink.smb.omada.common.mongo.repository.p;
import com.tplink.smb.omada.common.mongo.repository.q;
import com.tplink.smb.omada.common.mongo.repository.u;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.e;
import com.tplink.smb.omada.manager.c.d;
import com.tplink.smb.omada.manager.device.domain.model.configsync.dL;
import com.tplink.smb.omada.manager.device.domain.model.configsync.dN;
import com.tplink.smb.omada.manager.device.domain.model.configsync.g;
import com.tplink.smb.omada.manager.device.domain.model.configsync.i;
import com.tplink.smb.omada.manager.device.domain.model.configsync.l;
import com.tplink.smb.omada.manager.device.domain.model.device.G;
import com.tplink.smb.omada.manager.device.port.eventcenter.a.a;
import com.tplink.smb.omada.manager.port.mongo.device.configsync.DeviceConfigHistoryPO;
import com.tplink.smb.omada.manager.port.mongo.device.configsync.j;
import com.tplink.smb.omada.manager.port.mongo.device.configsync.k;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.BulkOperationException;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.FindAndReplaceOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class h
extends q<DeviceConfigHistoryPO, com.tplink.smb.omada.manager.j.a.a.c>
implements DomainEventSubscriber<a>,
dN {
    @Generated
    private static final Logger c = LoggerFactory.getLogger(h.class);
    @Autowired
    @Qualifier(value="dataMongoTemplate")
    protected MongoTemplate mongoTemplate;
    @Autowired
    private k d;
    public static final int a = 1;
    public static final int b = 400;

    @PostConstruct
    public void b() {
        DomainEventBusHolder.getHandlerRegistry().registerSync(a.class, (DomainEventSubscriber)this);
    }

    public void a(a event) {
        this.dbMaintenance(event.a());
    }

    protected j c() {
        return j.a();
    }

    public Class<DeviceConfigHistoryPO> d() {
        return DeviceConfigHistoryPO.class;
    }

    protected MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    @Nonnull
    protected String getCollectionNameOrPrefixIfSliced() {
        return "deviceconfighistory";
    }

    protected k e() {
        return this.d;
    }

    protected Class<DeviceConfigHistoryPO> getPOClass() {
        return DeviceConfigHistoryPO.class;
    }

    @Nonnull
    protected IndexDefinition[] getIndexDefinitions() {
        return DeviceConfigHistoryPO.INDEX_DEFINITIONS;
    }

    public com.tplink.smb.omada.manager.device.domain.model.configsync.d a() {
        return new com.tplink.smb.omada.manager.device.domain.model.configsync.d(ObjectId.get().toString());
    }

    public void a(@Nonnull dL deviceConfigHistory) {
        Objects.requireNonNull(deviceConfigHistory);
        DeviceConfigHistoryPO po = this.c().a(deviceConfigHistory);
        this.mongoTemplate.save((Object)po, this.getCollectionNameForSave(po));
    }

    public void a(@Nonnull List<dL> deviceConfigHistoryList) {
        if (CollectionUtils.isEmpty(deviceConfigHistoryList)) {
            return;
        }
        Map<String, List<DeviceConfigHistoryPO>> collectionNameMap = deviceConfigHistoryList.stream().map(this.c()::a).collect(Collectors.groupingBy(x$0 -> this.getCollectionNameForSave(x$0)));
        collectionNameMap.forEach((collectionName, poList) -> {
            int totalSize = poList.size();
            if (totalSize > 400) {
                List batchPoList = e.a((List)poList, (int)totalSize, (int)400);
                batchPoList.forEach(batchPos -> this.a((String)collectionName, (List<DeviceConfigHistoryPO>)batchPos));
            } else {
                this.a((String)collectionName, (List<DeviceConfigHistoryPO>)poList);
            }
            c.debug("mongo.insertAll deviceConfigHistoryList, collection name: {}, size: {}", collectionName, (Object)totalSize);
        });
    }

    public void b(@Nonnull List<dL> deviceConfigHistoryList) {
        if (CollectionUtils.isEmpty(deviceConfigHistoryList)) {
            return;
        }
        Map<String, List<DeviceConfigHistoryPO>> collectionNameMap = deviceConfigHistoryList.stream().filter(this::b).map(this.c()::a).collect(Collectors.groupingBy(x$0 -> this.getCollectionNameForSave(x$0)));
        collectionNameMap.forEach((collectionName, poList) -> {
            int totalSize = poList.size();
            if (totalSize > 400) {
                List batchPoList = e.a((List)poList, (int)totalSize, (int)400);
                batchPoList.forEach(batchPos -> this.a((String)collectionName, (List<DeviceConfigHistoryPO>)batchPos));
            } else {
                this.a((String)collectionName, (List<DeviceConfigHistoryPO>)poList);
            }
            c.debug("mongo.insert before send deviceConfigHistoryList, collection name: {}, size: {}", collectionName, (Object)totalSize);
        });
    }

    private boolean b(dL deviceConfigHistory) {
        i status = deviceConfigHistory.m();
        return !i.b.equals((Object)status) && !i.c.equals((Object)status);
    }

    private void a(String collectionName, List<DeviceConfigHistoryPO> eachPoList) {
        if (CollectionUtils.isEmpty(eachPoList)) {
            return;
        }
        try {
            BulkOperations bulkOperations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, this.d(), collectionName);
            bulkOperations.insert(eachPoList);
            bulkOperations.execute();
        }
        catch (Exception e2) {
            c.debug("mongo.batchInsert deviceConfigHistoryList exception: {}", (Object)e2.getMessage(), (Object)e2);
        }
    }

    public void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, G mac, l componentEnum, String name, d cliConfigType, dL newParams) {
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || Objects.isNull(mac)) {
            return;
        }
        AtomicLong updateCount = new AtomicLong(0L);
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 2592000L;
        Query query = this.a(omadacId, siteId, mac, componentEnum, name, cliConfigType);
        Update update = this.c(newParams);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start, end, omadacId, collectionName -> {
            UpdateResult updateResult = this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, this.d(), collectionName);
            updateCount.getAndAdd(updateResult.getModifiedCount());
        });
        if (updateCount.get() == 0L) {
            newParams.a(omadacId).a(siteId).a(mac).a(l.cD).c(name).a(this.a()).a(g.a);
            this.a(newParams);
        }
    }

    public List<String> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, l componentEnum, String name, d cliConfigType, dL newParams) {
        if (Objects.isNull(omadacId) || Objects.isNull(siteId)) {
            return new ArrayList<String>();
        }
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 2592000L;
        Query query = this.a(omadacId, siteId, null, componentEnum, name, cliConfigType);
        Update update = this.c(newParams);
        HashSet macList = new HashSet();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start, end, omadacId, collectionName -> {
            this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, this.d(), collectionName);
            List deviceConfigHistoryPOList = this.mongoTemplate.find(query, this.d(), collectionName);
            macList.addAll(deviceConfigHistoryPOList.stream().map(DeviceConfigHistoryPO::getMac).collect(Collectors.toList()));
        });
        return new ArrayList<String>(macList);
    }

    public void a(Map<l, List<dL>> oldConfigStatusMap, @Nonnull List<dL> deviceConfigHistoryList) {
        if (CollectionUtils.isEmpty(deviceConfigHistoryList)) {
            return;
        }
        HashBasedTable oldConfigList = HashBasedTable.create();
        ArrayList<dL> toDeleteList = new ArrayList<dL>();
        for (Map.Entry<l, List<dL>> entry : oldConfigStatusMap.entrySet()) {
            for (dL configItemFromDb : entry.getValue()) {
                dL configEntry = (dL)oldConfigList.get((Object)entry.getKey(), (Object)configItemFromDb.h());
                if (Objects.isNull(configEntry)) {
                    oldConfigList.put((Object)entry.getKey(), (Object)configItemFromDb.h(), (Object)configItemFromDb);
                    continue;
                }
                if (!Objects.nonNull(configItemFromDb.x()) || !Objects.nonNull(configEntry.x()) || configItemFromDb.x() <= configEntry.x()) continue;
                oldConfigList.put((Object)entry.getKey(), (Object)configItemFromDb.h(), (Object)configItemFromDb);
                toDeleteList.add(configEntry);
            }
        }
        ArrayList<dL> finalUpdateConfigList = new ArrayList<dL>();
        for (dL deployingItem : deviceConfigHistoryList) {
            dL oldConfig = (dL)oldConfigList.get((Object)deployingItem.f(), (Object)deployingItem.h());
            if (!this.a(oldConfig, deployingItem)) continue;
            finalUpdateConfigList.add(deployingItem);
        }
        Map<String, List<DeviceConfigHistoryPO>> map = finalUpdateConfigList.stream().map(j.a()::a).collect(Collectors.groupingBy(x$0 -> this.getCollectionNameForSave(x$0)));
        map.forEach((collectionName, poList) -> {
            int totalSize = poList.size();
            if (totalSize > 400) {
                List batchPoList = e.a((List)poList, (int)totalSize, (int)400);
                batchPoList.forEach(batchPos -> this.b((String)collectionName, (List<DeviceConfigHistoryPO>)batchPos));
            } else {
                this.b((String)collectionName, (List<DeviceConfigHistoryPO>)poList);
            }
        });
        if (!CollectionUtils.isEmpty(toDeleteList)) {
            c.info("Duplicate config items need be delete when update deploying Items {}", toDeleteList);
            List idList = toDeleteList.stream().map(e2 -> e2.b().a()).collect(Collectors.toList());
            com.tplink.smb.omada.manager.j.a.a.c omadacId = ((dL)toDeleteList.get(0)).c();
            long end = System.currentTimeMillis() / 1000L;
            long start = end - 2592000L;
            this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start, end, omadacId, collectionName -> this.c((String)collectionName, idList));
        }
    }

    private boolean a(dL oldConfig, dL deployingItem) {
        if (Objects.isNull(oldConfig)) {
            return true;
        }
        if (Objects.equals(oldConfig.b().a(), deployingItem.b().a()) && Objects.nonNull(oldConfig.x()) && Objects.nonNull(deployingItem.x()) && oldConfig.x() <= deployingItem.x()) {
            return true;
        }
        return Objects.isNull(oldConfig.x());
    }

    private void b(String collectionName, List<DeviceConfigHistoryPO> eachPoList) {
        BulkOperations bulkOperations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, collectionName);
        try {
            eachPoList.forEach(deviceConfigHistoryPO -> {
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)deviceConfigHistoryPO.getId()));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)deviceConfigHistoryPO.getOmadacId()));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)deviceConfigHistoryPO.getSiteId()));
                bulkOperations.replaceOne(query, deviceConfigHistoryPO, FindAndReplaceOptions.options().upsert());
            });
            BulkWriteResult result = bulkOperations.execute();
            c.debug("Bulk write device config history result: {}", (Object)result);
        }
        catch (BulkOperationException e2) {
            c.debug("mongo.batchUpdate deviceConfigHistoryList exception message: {}", (Object)e2.getMessage(), (Object)e2);
            bulkOperations.execute();
            c.info("retry mongo.batchUpdate deviceConfigHistoryList size {}", (Object)eachPoList.size());
        }
        catch (Exception e3) {
            c.debug("mongo.batchUpdate deviceConfigHistoryList exception: {}", (Object)e3.getMessage(), (Object)e3);
        }
    }

    public void a(DeviceTypeEnum deviceType, com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, G mac, i syncStatusEnum, String uiErrorCode, Long time) {
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || Objects.isNull(mac) || Objects.isNull(syncStatusEnum)) {
            return;
        }
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 2592000L;
        Query query = this.a(omadacId, siteId, mac, (l)null, (String)null, (d)null);
        switch (syncStatusEnum) {
            case b: {
                List<Integer> needUpdateStatusList = Arrays.asList(i.e.a(), i.f.a(), i.c.a());
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").in(needUpdateStatusList));
                break;
            }
            case c: {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").is((Object)i.e.a()));
                break;
            }
            default: {
                return;
            }
        }
        if (DeviceTypeEnum.c.equals((Object)deviceType)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"component").ne((Object)l.cD.c()));
        }
        Update update = new Update();
        update.set("status", (Object)syncStatusEnum.a());
        update.set("ui_error_code", (Object)uiErrorCode);
        update.set("time", (Object)time);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start, end, omadacId, collectionName -> {
            BulkOperations bulkOperations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, this.d(), collectionName);
            bulkOperations.updateMulti(query, update);
            bulkOperations.execute();
        });
    }

    public void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, G mac, long time, Set<l> componentEnumSet) {
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || Objects.isNull(mac)) {
            return;
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)mac.a()));
        if (!CollectionUtils.isEmpty(componentEnumSet)) {
            Set components = componentEnumSet.stream().map(l::c).collect(Collectors.toSet());
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"component").in(components));
        }
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 2592000L;
        Update update = new Update();
        update.set("status", (Object)i.b.a());
        update.set("time", (Object)time);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start, end, omadacId, collectionName -> {
            BulkOperations bulkOperations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, this.d(), collectionName);
            bulkOperations.updateMulti(query, update);
            bulkOperations.execute();
        });
    }

    public void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, G mac, Long time) {
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || Objects.isNull(mac)) {
            return;
        }
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 2592000L;
        Query query = this.a(omadacId, siteId, mac, (l)null, (String)null, (d)null);
        List<Integer> needUpdateStatusList = Arrays.asList(i.e.a(), i.c.a());
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").in(needUpdateStatusList));
        Update update = new Update();
        update.set("status", (Object)1);
        update.set("err_code", (Object)com.tplink.smb.omada.manager.device.domain.model.configsync.c.a.a());
        update.set("ui_error_code", (Object)"0");
        update.set("err_line_num", null);
        update.set("err_cmd", null);
        update.set("time", (Object)time);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start, end, omadacId, collectionName -> {
            BulkOperations bulkOperations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, this.d(), collectionName);
            bulkOperations.updateMulti(query, update);
            bulkOperations.execute();
        });
    }

    private Query a(@Nonnull com.tplink.smb.omada.manager.j.a.a.c omadacId, @Nonnull com.tplink.smb.omada.manager.j.a.a.d siteId, G mac, l componentEnum, String name, d cliConfigType) {
        ArrayList<c> andFilters = new ArrayList<c>();
        andFilters.add(new c("omadac_id", (Object)omadacId.a(), c.a.a));
        andFilters.add(new c("site_id", (Object)siteId.a(), c.a.a));
        if (Objects.nonNull(mac)) {
            andFilters.add(new c("mac", (Object)mac.a(), c.a.a));
        }
        if (Objects.nonNull(componentEnum)) {
            andFilters.add(new c("component", (Object)componentEnum.c(), c.a.a));
        }
        if (T.b((String)name)) {
            andFilters.add(new c("name", (Object)name, c.a.a));
        }
        if (Objects.nonNull(cliConfigType)) {
            andFilters.add(new c("cli_type", (Object)cliConfigType.a(), c.a.a));
        }
        return com.tplink.smb.omada.manager.port.mongo.configuration.c.a.b(null, andFilters);
    }

    private Update c(dL newParams) {
        Update update = new Update();
        if (Objects.nonNull(newParams.j())) {
            update.set("name", (Object)newParams.j());
        }
        if (Objects.nonNull(newParams.k())) {
            update.set("operation", (Object)newParams.k().a());
        }
        if (Objects.nonNull(newParams.l())) {
            update.set("time", (Object)newParams.l());
        }
        if (Objects.nonNull(newParams.m())) {
            update.set("status", (Object)newParams.m().a());
        }
        if (Objects.nonNull(newParams.o())) {
            update.set("ui_error_code", (Object)newParams.o());
        }
        if (Objects.nonNull(newParams.n())) {
            update.set("err_code", (Object)newParams.n().a());
        } else {
            update.set("err_code", null);
        }
        if (Objects.nonNull(newParams.p())) {
            update.set("err_line_num", (Object)newParams.p());
        } else {
            update.set("err_line_num", null);
        }
        if (Objects.nonNull(newParams.q())) {
            update.set("err_cmd", (Object)newParams.q());
        } else {
            update.set("err_cmd", null);
        }
        if (Objects.nonNull(newParams.v())) {
            update.set("ui_error_msg", (Object)newParams.v());
        } else {
            update.set("ui_error_msg", null);
        }
        if (Objects.nonNull(newParams.w())) {
            update.set("position", (Object)newParams.w());
        } else {
            update.set("position", null);
        }
        if (Objects.nonNull(newParams.r())) {
            update.set("ignore", (Object)newParams.r());
        }
        return update;
    }

    protected int a(@Nullable com.tplink.smb.omada.manager.j.a.a.c key) {
        if (Objects.isNull(key)) {
            return 0;
        }
        return key.a().hashCode();
    }

    public void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, G mac, l componentEnum, List<String> ids, Boolean selectAll) {
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || Objects.isNull(mac)) {
            return;
        }
        Query query = new Query();
        if (Boolean.TRUE.equals(selectAll)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)mac.a()));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").nin(ids));
        } else {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)mac.a()));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        }
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 2592000L;
        Update update = new Update();
        update.set("ignore", (Object)1);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start, end, omadacId, collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, this.d(), collectionName));
    }

    public List<dL> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, G mac, l componentEnum) {
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || Objects.isNull(mac)) {
            return new ArrayList<dL>();
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)mac.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"component").is((Object)componentEnum.c()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"ignore").is(null));
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 2592000L;
        ArrayList<dL> deviceConfigHistoryList = new ArrayList<dL>();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start, end, omadacId, collectionName -> deviceConfigHistoryList.addAll(this.mongoTemplate.find(query, this.d(), collectionName).stream().map(this.c()::a).collect(Collectors.toList())));
        return deviceConfigHistoryList;
    }

    public List<dL> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, G mac, Set<l> componentEnumSet) {
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || Objects.isNull(mac)) {
            return Collections.emptyList();
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)mac.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").ne((Object)3));
        if (!CollectionUtils.isEmpty(componentEnumSet)) {
            Set components = componentEnumSet.stream().map(l::c).collect(Collectors.toSet());
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"component").in(components));
        }
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 2592000L;
        ArrayList<dL> deviceConfigHistoryList = new ArrayList<dL>();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start, end, omadacId, collectionName -> deviceConfigHistoryList.addAll(this.mongoTemplate.find(query, this.d(), collectionName).stream().map(this.c()::a).collect(Collectors.toList())));
        c.debug("getByOmadacAndSiteAndMac for {} {}, size: {}", new Object[]{omadacId, mac, deviceConfigHistoryList.size()});
        return deviceConfigHistoryList;
    }

    public Map<l, List<dL>> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, G mac, Long sendMsgTime, Set<l> componentEnumSet) {
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || Objects.isNull(mac)) {
            return new HashMap<l, List<dL>>();
        }
        Query query = this.a(omadacId, siteId, mac, (l)null, (String)null, (d)null);
        if (!CollectionUtils.isEmpty(componentEnumSet)) {
            Set components = componentEnumSet.stream().map(l::c).collect(Collectors.toSet());
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"component").in(components));
        }
        query.fields().include(new String[]{"_id", "component", "status", "ignore", "item_entry_id", "create_time"});
        if (Objects.nonNull(sendMsgTime)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)sendMsgTime));
        }
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 2592000L;
        ArrayList deviceConfigHistoryList = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start, end, omadacId, collectionName -> deviceConfigHistoryList.addAll(this.mongoTemplate.find(query, this.d(), collectionName).stream().map(this.c()::b).collect(Collectors.toList())));
        c.debug("findDeviceComponentStatusMap for {} {}, size: {}", new Object[]{omadacId, mac, deviceConfigHistoryList.size()});
        return deviceConfigHistoryList.stream().collect(Collectors.groupingBy(dL::f));
    }

    public List<dL> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, G mac, l component, g operation) {
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || Objects.isNull(mac)) {
            return new ArrayList<dL>();
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)mac.a()));
        if (Objects.nonNull(component)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"component").is((Object)component.c()));
        }
        if (Objects.nonNull(operation)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"operation").is((Object)operation.a()));
        }
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 2592000L;
        ArrayList<dL> deviceConfigHistoryList = new ArrayList<dL>();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start, end, omadacId, collectionName -> deviceConfigHistoryList.addAll(this.mongoTemplate.find(query, this.d(), collectionName).stream().map(this.c()::a).collect(Collectors.toList())));
        return deviceConfigHistoryList;
    }

    public void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, G mac, l component, String itemEntryId, g operation, String name, d cliConfigType, String feature) {
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || Objects.isNull(mac)) {
            return;
        }
        Query query = new Query();
        query.fields().include("_id");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)mac.a()));
        if (Objects.nonNull(component)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"component").is((Object)component.c()));
        }
        if (Objects.nonNull(itemEntryId)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"item_entry_id").is((Object)itemEntryId));
        }
        if (Objects.nonNull(operation)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"operation").is((Object)operation.a()));
        }
        if (T.b((String)name)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"name").is((Object)name));
        }
        if (Objects.nonNull(cliConfigType)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"cli_type").is((Object)cliConfigType.a()));
        }
        if (Objects.nonNull(feature)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"feature").is((Object)feature));
        }
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 2592000L;
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start, end, omadacId, collectionName -> this.a(query, (String)collectionName));
    }

    private void a(Query query, String collectionName) {
        List<String> idList = this.mongoTemplate.find(query, this.d(), collectionName).stream().map(DeviceConfigHistoryPO::getId).collect(Collectors.toList());
        int totalSize = idList.size();
        if (totalSize > 400) {
            List batchIdList = e.a(idList, (int)totalSize, (int)400);
            batchIdList.forEach(batchIds -> this.c(collectionName, (List<String>)batchIds));
        } else {
            this.c(collectionName, idList);
        }
        c.debug("remove deviceConfigHistoryList, collection name: {}, size: {}", (Object)collectionName, (Object)totalSize);
    }

    private void c(String collectionName, List<String> batchIds) {
        if (CollectionUtils.isEmpty(batchIds)) {
            return;
        }
        try {
            BulkOperations bulkOperations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, this.d(), collectionName);
            bulkOperations.remove(new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(batchIds)));
            bulkOperations.execute();
        }
        catch (Exception e2) {
            c.info("mongo.removeIdList deviceConfigHistoryList exception: {}", (Object)e2.getMessage(), (Object)e2);
        }
    }

    public void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, G mac, @Nullable l component, Long time) {
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || Objects.isNull(mac) || Objects.isNull(time)) {
            return;
        }
        Query query = new Query();
        query.fields().include("_id");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)mac.a()));
        if (Objects.nonNull(component)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"component").is((Object)component.c()));
        }
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").lt((Object)time));
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 2592000L;
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start, end, omadacId, collectionName -> this.a(query, (String)collectionName));
    }

    public void b(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, G mac, @Nullable l exceptComponent, Long time) {
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || Objects.isNull(mac) || Objects.isNull(time)) {
            return;
        }
        Query query = new Query();
        query.fields().include("_id");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)mac.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").lt((Object)time));
        if (Objects.nonNull(exceptComponent)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"component").ne((Object)exceptComponent.c()));
        }
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 2592000L;
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start, end, omadacId, collectionName -> this.a(query, (String)collectionName));
    }

    public void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, l component, Long time, @Nonnull Set<String> macSet, @Nullable Set<String> itemEntryIdSet) {
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || Objects.isNull(time) || CollectionUtils.isEmpty(macSet)) {
            return;
        }
        Query query = this.a(omadacId, siteId, (G)null, component, (String)null, (d)null);
        query.fields().include("_id");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").lt((Object)time));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").in(macSet));
        if (!CollectionUtils.isEmpty(itemEntryIdSet)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"item_entry_id").in(itemEntryIdSet));
        }
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 2592000L;
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start, end, omadacId, collectionName -> this.a(query, (String)collectionName));
    }

    public List<dL> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, G mac, l component, List<com.tplink.smb.omada.manager.device.api.web.configsync.d> infoTypeFilters) {
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || Objects.isNull(mac) || CollectionUtils.isEmpty(infoTypeFilters)) {
            return Collections.emptyList();
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)mac.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"info_type").in(infoTypeFilters.stream().map(com.tplink.smb.omada.manager.device.api.web.configsync.d::a).toList()));
        if (Objects.nonNull(component)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"component").is((Object)component.c()));
        }
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 2592000L;
        ArrayList<dL> deviceConfigHistoryList = new ArrayList<dL>();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start, end, omadacId, collectionName -> deviceConfigHistoryList.addAll(this.mongoTemplate.find(query, this.d(), collectionName).stream().map(this.c()::a).toList()));
        return deviceConfigHistoryList;
    }

    public List<dL> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, G mac, String functionName, Integer configSyncStatus) {
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || Objects.isNull(mac)) {
            return new ArrayList<dL>();
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)mac.a()));
        if (Objects.nonNull(functionName)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"feature").is((Object)functionName));
        }
        if (Objects.nonNull(configSyncStatus)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").is((Object)configSyncStatus));
        }
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 2592000L;
        ArrayList<dL> deviceConfigHistoryList = new ArrayList<dL>();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start, end, omadacId, collectionName -> deviceConfigHistoryList.addAll(this.mongoTemplate.find(query, this.d(), collectionName).stream().map(this.c()::a).collect(Collectors.toList())));
        return deviceConfigHistoryList;
    }

    public List<String> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, i configSyncStatus) {
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || Objects.isNull(configSyncStatus)) {
            return new ArrayList<String>();
        }
        Query query = new Query();
        query.fields().include(new String[]{"_id", "mac"});
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").is((Object)configSyncStatus.a()));
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 2592000L;
        HashSet macSet = new HashSet();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start, end, omadacId, collectionName -> macSet.addAll(this.mongoTemplate.find(query, this.d(), collectionName).stream().map(DeviceConfigHistoryPO::getMac).collect(Collectors.toList())));
        return new ArrayList<String>(macSet);
    }

    public List<String> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, G mac, Integer configSyncStatus) {
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || Objects.isNull(mac)) {
            return new ArrayList<String>();
        }
        Query query = new Query();
        query.fields().include(new String[]{"_id", "component"});
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)mac.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").is((Object)configSyncStatus));
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 2592000L;
        HashSet infoComponentSet = new HashSet();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start, end, omadacId, collectionName -> infoComponentSet.addAll(this.mongoTemplate.find(query, this.d(), collectionName).stream().map(DeviceConfigHistoryPO::getComponent).collect(Collectors.toList())));
        return new ArrayList<String>(infoComponentSet);
    }

    public Long a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, G mac, Integer configSyncStatus, String component, Boolean withComponent) {
        AtomicLong tabNum = new AtomicLong(0L);
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || Objects.isNull(mac)) {
            return tabNum.get();
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)mac.a()));
        if (Objects.nonNull(component)) {
            if (Boolean.TRUE.equals(withComponent)) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"component").is((Object)component));
            } else {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"component").ne((Object)component));
            }
        }
        if (Objects.nonNull(configSyncStatus)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").is((Object)configSyncStatus));
        }
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 2592000L;
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start, end, omadacId, collectionName -> tabNum.updateAndGet(v2 -> v2 + this.mongoTemplate.count(query, this.d(), collectionName)));
        return tabNum.get();
    }

    public dL b(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, G mac, Integer configSyncStatus) {
        AtomicLong latestTime = new AtomicLong(0L);
        AtomicReference deviceConfigHistory = new AtomicReference();
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || Objects.isNull(mac)) {
            return null;
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)mac.a()));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"time"}));
        if (Objects.nonNull(configSyncStatus)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").is((Object)configSyncStatus));
        }
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 2592000L;
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start, end, omadacId, collectionName -> {
            DeviceConfigHistoryPO deviceConfigHistoryPO = (DeviceConfigHistoryPO)this.mongoTemplate.findOne(query, this.d(), collectionName);
            if (!Objects.isNull(deviceConfigHistoryPO) && deviceConfigHistoryPO.getTime() > latestTime.get()) {
                deviceConfigHistory.set(this.c().a(deviceConfigHistoryPO));
                latestTime.set(deviceConfigHistoryPO.getTime());
            }
        });
        return (dL)deviceConfigHistory.get();
    }

    public void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, G mac, DeviceTypeEnum deviceType, i configSyncStatusEnum, String uiErrorCode, Long time) {
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || Objects.isNull(mac) || Objects.isNull(configSyncStatusEnum)) {
            return;
        }
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 2592000L;
        Query query = this.a(omadacId, siteId, mac, (l)null, (String)null, (d)null);
        List<Integer> needUpdateStatusList = Arrays.asList(i.e.a(), i.c.a());
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").in(needUpdateStatusList));
        if (DeviceTypeEnum.c.equals((Object)deviceType)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"component").ne((Object)l.cD.c()));
        }
        Update update = new Update();
        update.set("status", (Object)configSyncStatusEnum.a());
        if (Objects.nonNull(uiErrorCode)) {
            update.set("ui_error_code", (Object)uiErrorCode);
        }
        update.set("time", (Object)time);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start, end, omadacId, collectionName -> {
            BulkOperations bulkOperations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, this.d(), collectionName);
            bulkOperations.updateMulti(query, update);
            bulkOperations.execute();
        });
    }

    protected void dbMaintenance(boolean needClearData) {
        String dataCategory = this.getCollectionNameOrPrefixIfSliced();
        if (!this.isCollectionSliced()) {
            c.debug("Data: {} is NOT a time-based sliced repository, ensuring indexes.", (Object)dataCategory);
            this.ensureIndexes(dataCategory, this.getIndexDefinitions(), true);
            return;
        }
        c.debug("Starting to maintenance collections of {}", (Object)dataCategory);
        this.ensureShardingEnabledOnDB();
        Set collectionNames = this.getCollectionNames();
        c.debug("Starting to check old collections of {}, current collections: {}", (Object)dataCategory, (Object)collectionNames);
        if (Boolean.TRUE.equals(needClearData)) {
            long dataRetentionSec = this.getDataRetentionSec();
            this.tryDropCollectionOrDeleteByTimeLessThan(dataRetentionSec, () -> {});
        }
        c.debug("Refreshing collection name cache of {}...", (Object)dataCategory);
        collectionNamesCache.invalidate((Object)this.getCollectionNameOrPrefixIfSliced());
        collectionNames = this.getCollectionNames(true);
        c.debug("Finished check old data of {}, current collections: {}", (Object)dataCategory, (Object)collectionNames);
    }

    public List<dL> b(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, G mac, Long createTime) {
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || Objects.isNull(mac) || Objects.isNull(createTime)) {
            return Collections.emptyList();
        }
        ArrayList<dL> deviceConfigHistoryList = new ArrayList<dL>();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").is((Object)mac.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"create_time").lte((Object)createTime));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").is((Object)i.e.a()));
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 2592000L;
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start, end, omadacId, collectionName -> deviceConfigHistoryList.addAll(this.mongoTemplate.find(query, this.d(), collectionName).stream().map(this.c()::a).toList()));
        return deviceConfigHistoryList;
    }

    protected /* synthetic */ p getStrategy() {
        return this.e();
    }

    protected /* synthetic */ int hashCodeOfKey(@Nullable Object object) {
        return this.a((com.tplink.smb.omada.manager.j.a.a.c)object);
    }

    protected /* synthetic */ u getStrategy() {
        return this.e();
    }

    public /* synthetic */ void handleEvent(Object object) {
        this.a((a)object);
    }
}

