/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.cluster.grpc.server;

import com.tplink.smb.omada.dispatcher.support.grpc.proto.bo.HeaderDTO;
import com.tplink.smb.omada.dispatcher.support.grpc.proto.bo.RequestEntityDTO;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebUtils {
    private static final Logger log = LoggerFactory.getLogger(WebUtils.class);
    public static final String HEADER_REMOTE_IP = "Omada-Remote-IP-Address";

    private WebUtils() {
    }

    @Nullable
    public static String getRemoteIp(@Nonnull RequestEntityDTO requestDTO) {
        List headersList = requestDTO.getHeadersList();
        Optional<String> optIp = headersList.stream().filter(h -> HEADER_REMOTE_IP.equals(h.getName())).map(HeaderDTO::getValue).findFirst();
        log.debug("Resolved HTTP Header: {}, value: {}", (Object)HEADER_REMOTE_IP, optIp);
        return optIp.orElse(null);
    }
}

