/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.cluster.grpc.server;

import com.tplink.smb.omada.dispatcher.cluster.grpc.server.OmadaClusterUniversalMethodResolveService;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.common.util.JsonUtils;
import com.tplink.smb.omada.dispatcher.support.grpc.proto.dto.ResolveOperationRequestDTO;
import com.tplink.smb.omada.dispatcher.support.grpc.proto.dto.ResolveOperationResponseDTO;
import com.tplink.smb.omada.dispatcher.support.grpc.proto.service.ResolveCallCrossInstanceForLocalServiceGrpc;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.GrpcConstsService;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.OmadaClusterUniversalRequestDTO;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import net.devh.boot.grpc.server.service.GrpcService;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@GrpcService
public class OmadaClusterUniversalMethodResolveServer
extends ResolveCallCrossInstanceForLocalServiceGrpc.ResolveCallCrossInstanceForLocalServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(OmadaClusterUniversalMethodResolveServer.class);
    private OmadaClusterUniversalMethodResolveService resolveService;
    private GrpcConstsService grpcConstsService;

    public void resolveSpringBeanCall(ResolveOperationRequestDTO request, StreamObserver<ResolveOperationResponseDTO> responseObserver) {
        try {
            String reqDecrypt = this.grpcConstsService.decryptAesString(request.getReq());
            OmadaClusterUniversalRequestDTO requestDTO = (OmadaClusterUniversalRequestDTO)JsonUtils.json2bean((String)reqDecrypt, OmadaClusterUniversalRequestDTO.class);
            log.debug("resolve ClusterUniversal Method call: {}", (Object)reqDecrypt);
            for (int i = 0; i < requestDTO.getParameterTypes().length; ++i) {
                Class clazz = requestDTO.getParameterTypes()[i];
                Object parameter = requestDTO.getParameters()[i];
                requestDTO.getParameters()[i] = JsonUtils.json2bean((String)JsonUtils.bean2Json((Object)parameter), (Class)clazz);
            }
            OperationResponse response = this.resolveService.springBeanMethodCall(requestDTO.getCallObject(), requestDTO.getMethodName(), requestDTO.getParameterTypes(), requestDTO.getParameters());
            responseObserver.onNext((Object)ResolveOperationResponseDTO.newBuilder().setResp(this.grpcConstsService.encryptAesString(this.toJson(response.getResult(), requestDTO.getRespMultiElementClasses()))).build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            responseObserver.onError((Throwable)e);
        }
    }

    public void resolveStaticCall(ResolveOperationRequestDTO request, StreamObserver<ResolveOperationResponseDTO> responseObserver) {
        try {
            String reqDecrypt = this.grpcConstsService.decryptAesString(request.getReq());
            OmadaClusterUniversalRequestDTO requestDTO = (OmadaClusterUniversalRequestDTO)JsonUtils.json2bean((String)reqDecrypt, OmadaClusterUniversalRequestDTO.class);
            log.debug("resolve ClusterUniversal Method call: {}", (Object)reqDecrypt);
            OperationResponse response = this.resolveService.staticMethodCall(requestDTO.getCallObject(), requestDTO.getMethodName(), requestDTO.getParameterTypes(), requestDTO.getParameters());
            responseObserver.onNext((Object)ResolveOperationResponseDTO.newBuilder().setResp(this.grpcConstsService.encryptAesString(this.toJson(response.getResult(), requestDTO.getRespMultiElementClasses()))).build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            responseObserver.onError((Throwable)e);
        }
    }

    private String toJson(Object result, Boolean respMultiElementClasses) {
        if (!respMultiElementClasses.booleanValue() || !(result instanceof List)) {
            return JsonUtils.bean2Json((Object)result);
        }
        List resultList = (List)result;
        ArrayList jsonObjectList = new ArrayList(resultList.size());
        resultList.forEach(obj -> {
            JSONObject jsonObject = JsonUtils.fromObject((Object)obj);
            jsonObject.put("_class", (Object)obj.getClass().getName());
            jsonObjectList.add(jsonObject);
        });
        return JsonUtils.bean2Json(jsonObjectList);
    }

    @Autowired
    public void setResolveService(OmadaClusterUniversalMethodResolveService resolveService) {
        this.resolveService = resolveService;
    }

    @Autowired
    public void setGrpcConstsService(GrpcConstsService grpcConstsService) {
        this.grpcConstsService = grpcConstsService;
    }
}

