/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.cluster.grpc.server;

import com.google.protobuf.Any;
import com.tplink.smb.omada.dispatcher.cache.ApiServiceCache;
import com.tplink.smb.omada.dispatcher.cache.ServiceMethodInfo;
import com.tplink.smb.omada.dispatcher.chain.AttributeRequestEntity;
import com.tplink.smb.omada.dispatcher.chain.HandlerChainManager;
import com.tplink.smb.omada.dispatcher.cluster.grpc.server.WebUtils;
import com.tplink.smb.omada.dispatcher.common.access.HttpResponse;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.common.response.ApiResponseWrapper;
import com.tplink.smb.omada.dispatcher.common.util.AccessTokenUtils;
import com.tplink.smb.omada.dispatcher.common.util.SessionUtils;
import com.tplink.smb.omada.dispatcher.common.util.StringUtils;
import com.tplink.smb.omada.dispatcher.common.util.UserIpUtils;
import com.tplink.smb.omada.dispatcher.support.grpc.proto.bo.HttpMethodGrpcEnum;
import com.tplink.smb.omada.dispatcher.support.grpc.proto.bo.OperationResponseDTO;
import com.tplink.smb.omada.dispatcher.support.grpc.proto.bo.RequestEntityDTO;
import com.tplink.smb.omada.dispatcher.support.grpc.proto.dto.DispatchRequestDTO;
import com.tplink.smb.omada.dispatcher.support.grpc.proto.dto.HttpResponseDTO;
import com.tplink.smb.omada.dispatcher.support.grpc.proto.service.NodeGrpcDispatchServiceGrpc;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.response.ApiGrpcResponseWrapper;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.serialize.AnyConverter;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.serialize.ApiGrpcResponseWrapperDeserializer;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.serialize.ApiGrpcResponseWrapperSerializer;
import io.grpc.stub.StreamObserver;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import net.devh.boot.grpc.server.service.GrpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;

@GrpcService
public class NodeGrpcDispatchService
extends NodeGrpcDispatchServiceGrpc.NodeGrpcDispatchServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(NodeGrpcDispatchService.class);
    @Autowired
    private AnyConverter anyConverter;
    @Autowired
    private HandlerChainManager handlerChainManager;
    @Autowired
    private ApiServiceCache apiServiceCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(DispatchRequestDTO requestDTO, StreamObserver<HttpResponseDTO> responseObserver) {
        try {
            HttpResponse httpResponse;
            String path = requestDTO.getPath();
            if (StringUtils.isNull((String)path)) {
                log.error("Omada Dispatcher gRPC: Invalid path: [{}]", (Object)path);
                responseObserver.onCompleted();
                return;
            }
            HttpMethodGrpcEnum httpMethodGrpcEnum = requestDTO.getRequestEntity().getHttpMethod();
            String sessionId = requestDTO.getSessionId();
            SessionUtils.setThreadSessionId((String)sessionId);
            UserIpUtils.setLocalUserIp((String)WebUtils.getRemoteIp(requestDTO.getRequestEntity()));
            com.tplink.smb.omada.dispatcher.common.access.HttpMethod httpMethod = com.tplink.smb.omada.dispatcher.common.access.HttpMethod.resolve((String)httpMethodGrpcEnum.name());
            ServiceMethodInfo serviceMethodInfo = this.apiServiceCache.resolveMethod(path, httpMethod);
            if (serviceMethodInfo == null) {
                log.warn("Unsupported path, path:{}, method:{}", (Object)path, (Object)httpMethod);
                responseObserver.onError((Throwable)new UnsupportedOperationException("gRPC Server Error: Unsupported path return type."));
                return;
            }
            RequestEntityDTO requestEntityDTO = requestDTO.getRequestEntity();
            HttpHeaders headers = new HttpHeaders();
            requestEntityDTO.getHeadersList().forEach(headerDTO -> headers.add(headerDTO.getName(), headerDTO.getValue()));
            AttributeRequestEntity requestEntity = new AttributeRequestEntity(new RequestEntity((Object)(requestEntityDTO.getBody().equals("") ? null : requestEntityDTO.getBody()), (MultiValueMap)headers, HttpMethod.valueOf((String)requestEntityDTO.getHttpMethod().name()), URI.create(requestEntityDTO.getUrl()), String.class));
            HashMap<String, MultipartFile> multipartFileMap = new HashMap<String, MultipartFile>();
            for (Map.Entry entry : requestDTO.getMultipartFileMapMap().entrySet()) {
                multipartFileMap.put((String)entry.getKey(), (MultipartFile)this.anyConverter.unpack((Any)entry.getValue()));
            }
            ApiGrpcResponseWrapper apiResponseWrapper = ApiGrpcResponseWrapperDeserializer.INSTANCE.apply(requestDTO.getApiResponseWrapper());
            Object result = this.handlerChainManager.createHandlerChain(httpMethod, serviceMethodInfo, (RequestEntity)requestEntity, sessionId, requestDTO.getOmadacId(), multipartFileMap, (ApiResponseWrapper)apiResponseWrapper, requestDTO.getOpenApiRequest(), requestDTO.getAccessToken()).execute();
            if (result instanceof OperationResponse) {
                httpResponse = new HttpResponse((OperationResponse)result);
            } else if (result instanceof HttpResponse) {
                httpResponse = (HttpResponse)result;
            } else {
                log.error("Unsupported return type {} of Web API method: {}", result, (Object)serviceMethodInfo.getMethod());
                responseObserver.onError((Throwable)new UnsupportedOperationException("gRPC Server Error: Unsupported method return type."));
                return;
            }
            HttpResponseDTO responseDTO = HttpResponseDTO.newBuilder().setOperationResponse(OperationResponseDTO.newBuilder().setErrorCode(httpResponse.getErrorCode()).setMsg(httpResponse.getMsg()).setResult(this.anyConverter.toAny(httpResponse.getResult())).build()).setResponseWrapper(ApiGrpcResponseWrapperSerializer.INSTANCE.apply((Object)apiResponseWrapper)).build();
            responseObserver.onNext((Object)responseDTO);
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            log.error("Failed to call method at node gRPC Dispatcher server, {}.", (Object)requestDTO, (Object)e);
            responseObserver.onError((Throwable)e);
        }
        finally {
            SessionUtils.clearThreadSession();
            AccessTokenUtils.clearThreadSession();
            UserIpUtils.setLocalUserIp(null);
        }
    }
}

