/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.sitedata.a;

import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.client.port.mongo.data.g;
import com.tplink.smb.omada.common.e.n;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class a<T extends n, R extends g<? extends T>>
extends com.tplink.smb.omada.backup.api.b.a {
    private static final Logger log = LoggerFactory.getLogger(a.class);
    public static final String KEY_COLLECTIONS = "collections";

    public void backup(com.tplink.smb.omada.backup.api.e.a wrapper, c omadacId, com.tplink.smb.omada.maintenance.common.b.a.a.d siteId, int retention) throws IOException, com.tplink.smb.omada.backup.api.d.a {
        long endSec = System.currentTimeMillis() / 1000L;
        long startSec = retention == 0 ? 0L : endSec - TimeUnit.DAYS.toSeconds(retention);
        wrapper.b().writeObjectFieldStart(this.getBackupKey().A());
        wrapper.b().writeObjectFieldStart(KEY_COLLECTIONS);
        for (g repository : this.getRepositoryList()) {
            this.scanCollectionsAndWriteToJson(wrapper, omadacId, siteId, startSec, endSec, repository);
        }
        wrapper.d();
        wrapper.d();
    }

    protected void scanCollectionsAndWriteToJson(com.tplink.smb.omada.backup.api.e.a wrapper, c omadacId, com.tplink.smb.omada.maintenance.common.b.a.a.d siteId, long startSec, long endSec, R repository) throws IOException {
        List collectionNames = repository.getCollectionNameList();
        for (String collectionName : collectionNames) {
            wrapper.a(collectionName);
            try {
                this.scanRepository(collectionName, omadacId, siteId, startSec, endSec, repository, obj -> this.writeObjectValue(wrapper, this.beforeWriteToJson(obj)));
            }
            catch (Exception e2) {
                log.error("Failed to backup {}, write items of collection {} failed, write array end directly", new Object[]{this.getBackupKey(), collectionName, e2});
            }
            wrapper.f();
        }
    }

    protected void scanRepository(String collectionName, c omadacId, com.tplink.smb.omada.maintenance.common.b.a.a.d siteId, long startSec, long endSec, R repository, Consumer<T> consumer) {
        Iterable iterable = repository.findForBackup(collectionName, omadacId, siteId, startSec, endSec);
        iterable.forEach(consumer);
    }

    protected void writeObjectValue(com.tplink.smb.omada.backup.api.e.a wrapper, T obj) {
        try {
            wrapper.b().writeObject(obj);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Nonnull
    protected abstract T beforeWriteToJson(T var1);

    @Nonnull
    protected abstract d getBackupKey();

    @Nonnull
    protected abstract List<R> getRepositoryList();
}

