/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfimg.profile;

import com.tplink.smb.component.storage.api.repository.FileRepository;
import com.tplink.smb.omada.backup.api.c.h;
import com.tplink.smb.omada.backup.core.unit.siteconfig.profile.dto.CertProfileFileDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.profile.dto.ProfileDTO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.cert.BaseCertProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.group.H;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.group.f;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.group.k;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.group.o;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.group.s;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.group.x;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.ppsk.a;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.a(a=com.tplink.smb.omada.backup.api.c.d.PROFILES)
public class ProfileBackupUnit
extends com.tplink.smb.omada.backup.api.b.d<ProfileDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfileBackupUnit.class);
    private final k ipGroupMaintMongoRepository = k.a();
    private final o ipPortGroupMaintMongoRepository = o.a();
    private final H macFilterMaintMongoRepository = H.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.schedule.a scheduleMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.schedule.a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.ratelimit.a rateLimitProfileMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.ratelimit.a.a();
    private final a ppskProfileMongoRepository = a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.mdns.a mdnsProfileMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.mdns.a.a();
    private final s ipv6GroupMaintMongoRepository = s.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.servicetype.a serviceTypeMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.servicetype.a.a();
    private final x ipv6PortGroupMaintMongoRepository = x.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.group.a countryGroupMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.group.a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.apn.a apnProfileMaintMonfoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.apn.a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.b.a ouiProfileMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.b.a.a();
    private final f domainGroupMaintMongoRepository = f.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.a.a certProfileMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.a.a.a();
    private final FileRepository fileRepository = (FileRepository)com.tplink.smb.omada.common.spring.a.b(FileRepository.class);
    private static final ProfileBackupUnit instance = new ProfileBackupUnit();

    private ProfileBackupUnit() {
    }

    public static ProfileBackupUnit getInstance() {
        return instance;
    }

    public ProfileDTO readFromDB(c omadacId, d siteId, boolean siteTemplateRead) throws com.tplink.smb.omada.backup.api.d.a {
        ProfileDTO profileDTO = new ProfileDTO();
        if (siteTemplateRead) {
            List mdnsProfileTemplatePOList;
            List serviceTypeTemplatePOList;
            List domainGroupTemplatePOList;
            List countryGroupTemplatePOList;
            List iPv6PortGroupTemplatePOList;
            List iPv6GroupTemplatePOList;
            List ipPortGroupTemplatePOList;
            List ouiProfileTemplatePOList;
            List ipGroupTemplatePOList;
            List certTemplatePOList;
            List scheduleTemplatePOList;
            List apnProfileTemplates;
            List rateLimitProfilePOList;
            List ppskProfilePOList;
            List macFilterTemplatePOList = this.macFilterMaintMongoRepository.b(omadacId, siteId);
            if (!CollectionUtils.isEmpty((Collection)macFilterTemplatePOList)) {
                profileDTO.setMacFilterTemplates(macFilterTemplatePOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(ppskProfilePOList = this.ppskProfileMongoRepository.a(omadacId, siteId.a())))) {
                profileDTO.setPpskProfileTemplate(ppskProfilePOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(rateLimitProfilePOList = this.rateLimitProfileMongoRepository.a(omadacId, siteId.a())))) {
                profileDTO.setRateLimitProfileTemplate(rateLimitProfilePOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(apnProfileTemplates = this.apnProfileMaintMonfoRepository.a(omadacId, siteId.a())))) {
                profileDTO.setApnProfileTemplate(apnProfileTemplates);
            }
            if (!CollectionUtils.isEmpty((Collection)(scheduleTemplatePOList = this.scheduleMaintMongoRepository.a(omadacId, siteId.a())))) {
                profileDTO.setScheduleTemplate(scheduleTemplatePOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(certTemplatePOList = this.certProfileMaintMongoRepository.a(omadacId, siteId.a())))) {
                profileDTO.setCertProfileTemplates(certTemplatePOList);
                ArrayList<BaseCertProfilePO> baseCertProfilePOS = new ArrayList<BaseCertProfilePO>();
                baseCertProfilePOS.addAll(certTemplatePOList);
                profileDTO.setCertProfileFileTemplates(this.backupCertificateFile(omadacId, siteId.a(), baseCertProfilePOS));
            }
            if (!CollectionUtils.isEmpty((Collection)(ipGroupTemplatePOList = this.ipGroupMaintMongoRepository.a(omadacId, siteId.a())))) {
                profileDTO.setIpGroupTemplate(ipGroupTemplatePOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(ouiProfileTemplatePOList = this.ouiProfileMaintMongoRepository.a(omadacId, siteId.a())))) {
                profileDTO.setOuiProfileTemplate(ouiProfileTemplatePOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(ipPortGroupTemplatePOList = this.ipPortGroupMaintMongoRepository.a(omadacId, siteId.a())))) {
                profileDTO.setIpPortGroupTemplate(ipPortGroupTemplatePOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(iPv6GroupTemplatePOList = this.ipv6GroupMaintMongoRepository.a(omadacId, siteId.a())))) {
                profileDTO.setIPv6GroupTemplate(iPv6GroupTemplatePOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(iPv6PortGroupTemplatePOList = this.ipv6PortGroupMaintMongoRepository.a(omadacId, siteId.a())))) {
                profileDTO.setIPv6PortGroupTemplate(iPv6PortGroupTemplatePOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(countryGroupTemplatePOList = this.countryGroupMaintMongoRepository.a(omadacId, siteId.a())))) {
                profileDTO.setCountryGroupTemplate(countryGroupTemplatePOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(domainGroupTemplatePOList = this.domainGroupMaintMongoRepository.a(omadacId, siteId.a())))) {
                profileDTO.setDomainGroupTemplate(domainGroupTemplatePOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(serviceTypeTemplatePOList = this.serviceTypeMaintMongoRepository.a(omadacId, siteId.a())))) {
                profileDTO.setServiceTypeTemplate(serviceTypeTemplatePOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(mdnsProfileTemplatePOList = this.mdnsProfileMaintMongoRepository.a(omadacId, siteId.a())))) {
                profileDTO.setMdnsProfileTemplates(mdnsProfileTemplatePOList);
            }
        } else {
            List certProfilePOList;
            List serviceTypePOs;
            List mdnsProfilePOS;
            List domainGroupPOList;
            List countryGroupPOList;
            List iPv6PortGroupPOList;
            List iPv6GroupPOList;
            List ipPortGroupPOList;
            List ouiProfilePOList;
            List ipGroupPOList;
            List schedulePOList;
            List apnProfiles;
            List rateLimitProfilePOList;
            List ppskProfilePOList;
            List macFilterPOList = this.macFilterMaintMongoRepository.a(omadacId, siteId);
            if (!CollectionUtils.isEmpty((Collection)macFilterPOList)) {
                profileDTO.setMacFilters(macFilterPOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(ppskProfilePOList = this.ppskProfileMongoRepository.a(omadacId, siteId)))) {
                profileDTO.setPpskProfiles(ppskProfilePOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(rateLimitProfilePOList = this.rateLimitProfileMongoRepository.a(omadacId, siteId)))) {
                profileDTO.setRateLimitProfiles(rateLimitProfilePOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(apnProfiles = this.apnProfileMaintMonfoRepository.b(omadacId, siteId)))) {
                profileDTO.setApnProfiles(apnProfiles);
            }
            if (!CollectionUtils.isEmpty((Collection)(schedulePOList = this.scheduleMaintMongoRepository.a(omadacId, siteId)))) {
                profileDTO.setSchedules(schedulePOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(ipGroupPOList = this.ipGroupMaintMongoRepository.a(omadacId, siteId)))) {
                profileDTO.setIpGroups(ipGroupPOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(ouiProfilePOList = this.ouiProfileMaintMongoRepository.a(omadacId, siteId)))) {
                profileDTO.setOuiProfiles(ouiProfilePOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(ipPortGroupPOList = this.ipPortGroupMaintMongoRepository.a(omadacId, siteId)))) {
                profileDTO.setIpPortGroups(ipPortGroupPOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(iPv6GroupPOList = this.ipv6GroupMaintMongoRepository.a(omadacId, siteId)))) {
                profileDTO.setIpv6Groups(iPv6GroupPOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(iPv6PortGroupPOList = this.ipv6PortGroupMaintMongoRepository.a(omadacId, siteId)))) {
                profileDTO.setIpv6PortGroups(iPv6PortGroupPOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(countryGroupPOList = this.countryGroupMaintMongoRepository.a(omadacId, siteId)))) {
                profileDTO.setCountryGroups(countryGroupPOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(domainGroupPOList = this.domainGroupMaintMongoRepository.a(omadacId, siteId)))) {
                profileDTO.setDomainGroups(domainGroupPOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(mdnsProfilePOS = this.mdnsProfileMaintMongoRepository.a(omadacId, siteId)))) {
                profileDTO.setMdnsProfiles(mdnsProfilePOS);
            }
            if (!CollectionUtils.isEmpty((Collection)(serviceTypePOs = this.serviceTypeMaintMongoRepository.a(omadacId, siteId)))) {
                profileDTO.setServiceTypes(serviceTypePOs);
            }
            if (!CollectionUtils.isEmpty((Collection)(certProfilePOList = this.certProfileMaintMongoRepository.a(omadacId, siteId)))) {
                profileDTO.setCertProfiles(certProfilePOList);
                ArrayList<BaseCertProfilePO> baseCertProfilePOS = new ArrayList<BaseCertProfilePO>();
                baseCertProfilePOS.addAll(certProfilePOList);
                profileDTO.setCertProfileFileDTOs(this.backupCertificateFile(omadacId, siteId.a(), baseCertProfilePOS));
            }
        }
        return profileDTO;
    }

    public void backup(com.tplink.smb.omada.backup.api.e.a wrapper, c omadacId, d siteId, com.tplink.smb.omada.backup.api.c.d keyEnum, h backupTypeEnum) throws IOException, com.tplink.smb.omada.backup.api.d.a {
        ProfileDTO element = this.readFromDB(omadacId, siteId, false);
        if (element != null) {
            if (h.e.equals((Object)backupTypeEnum) && element.getPpskProfiles() != null) {
                element.getPpskProfiles().forEach(ppskProfilePO -> {
                    if (ppskProfilePO.getPpsk() != null) {
                        ppskProfilePO.getPpsk().forEach(pskpo -> pskpo.setPsk(null));
                    }
                });
            }
            wrapper.a(keyEnum.A(), (Object)element);
        }
    }

    private List<CertProfileFileDTO> backupCertificateFile(c omadacId, String siteId, List<BaseCertProfilePO> certificateProfilePO) {
        HashSet<String> fileIds = new HashSet<String>();
        ArrayList<CertProfileFileDTO> ceritifications = new ArrayList<CertProfileFileDTO>();
        for (BaseCertProfilePO po : certificateProfilePO) {
            boolean fileExists;
            AtomicReference fileDataRef;
            CertProfileFileDTO dto;
            if (po.getCaCertFileId() != null && !fileIds.contains(po.getCaCertFileId())) {
                dto = new CertProfileFileDTO();
                dto.setPrefix(omadacId.a());
                dto.setFileId(po.getCaCertFileId());
                dto.setFileName(po.getFileName());
                dto.setFileMd5(po.getCertFileMd5());
                dto.setFormat(po.getFormat());
                fileDataRef = new AtomicReference();
                fileExists = this.fileRepository.readFile(dto.getFileId(), inputStream -> fileDataRef.set(this.streamToString((InputStream)inputStream, po.getFormat())));
                if (fileExists) {
                    dto.setFileData((String)fileDataRef.get());
                }
                fileIds.add(po.getCaCertFileId());
                ceritifications.add(dto);
            }
            if (po.getClientCertFileId() != null && !fileIds.contains(po.getClientCertFileId())) {
                dto = new CertProfileFileDTO();
                dto.setPrefix(omadacId.a());
                dto.setFileId(po.getClientCertFileId());
                dto.setFileName(po.getFileName());
                dto.setFileMd5(po.getCertFileMd5());
                dto.setFormat(po.getFormat());
                fileDataRef = new AtomicReference();
                fileExists = this.fileRepository.readFile(dto.getFileId(), inputStream -> fileDataRef.set(this.streamToString((InputStream)inputStream, po.getFormat())));
                if (fileExists) {
                    dto.setFileData((String)fileDataRef.get());
                }
                fileIds.add(po.getClientCertFileId());
                ceritifications.add(dto);
            }
            if (po.getPrivateKeyFileId() == null || fileIds.contains(po.getPrivateKeyFileId())) continue;
            dto = new CertProfileFileDTO();
            dto.setPrefix(omadacId.a());
            dto.setFileId(po.getPrivateKeyFileId());
            dto.setFileName(po.getPrivateKeyFileName());
            dto.setFileMd5(po.getPrivateKeyFileMd5());
            dto.setFormat(po.getFormat());
            fileDataRef = new AtomicReference();
            fileExists = this.fileRepository.readFile(dto.getFileId(), inputStream -> fileDataRef.set(this.streamToString((InputStream)inputStream, po.getFormat())));
            if (fileExists) {
                dto.setFileData((String)fileDataRef.get());
            }
            fileIds.add(po.getPrivateKeyFileId());
            ceritifications.add(dto);
        }
        return ceritifications;
    }

    private String streamToString(InputStream inputStream, Integer format) {
        if (inputStream != null) {
            try {
                if (format.equals(1)) {
                    byte[] derBytes = IOUtils.toByteArray((InputStream)inputStream);
                    return Base64.getEncoder().encodeToString(derBytes);
                }
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)StandardCharsets.UTF_8.name());
                return writer.toString();
            }
            catch (IOException e2) {
                log.error("error when convert inputStream to string.", (Throwable)e2);
                return null;
            }
        }
        return null;
    }
}

