/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.wirelessnetwork.siteimport;

import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.wirelessnetwork.dto.WirelessNetworkDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.wirelessnetwork.restore.a;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.c.x;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.ssid.BaseSsidPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.ssid.SsidPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.ssid.SsidTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.wlan.BaseWlanGroupPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.wlan.WlanGroupPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.wlan.WlanGroupTemplatePO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.d(a=com.tplink.smb.omada.backup.api.c.d.WIRED_LESS_NETWORK)
public class WirelessNetworkSiteImportUnit
extends com.tplink.smb.omada.backup.api.c {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WirelessNetworkSiteImportUnit.class);
    private static final WirelessNetworkSiteImportUnit instance = new WirelessNetworkSiteImportUnit();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.d wlanGroupMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.d.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c ssidMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.d siteLimitMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.d.a();

    private WirelessNetworkSiteImportUnit() {
    }

    public static WirelessNetworkSiteImportUnit getInstance() {
        return instance;
    }

    public void siteImport(b jsonParserWrapper, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        WirelessNetworkDTO wirelessNetworkDTO = (WirelessNetworkDTO)jsonParserWrapper.a(WirelessNetworkDTO.class);
        this.siteCopyWrite(wirelessNetworkDTO, omadacId, newSiteId, siteImportIdCacheMap);
    }

    public void siteCopyWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        List<WlanGroupPO> wlanGroupPOS = ((WirelessNetworkDTO)dataObject).getWlanGroups();
        List<SsidPO> ssidPOS = ((WirelessNetworkDTO)dataObject).getSsids();
        if (CollectionUtils.isEmpty(wlanGroupPOS)) {
            log.error("The WLAN groups is empty.");
            throw new com.tplink.smb.omada.backup.api.d.c("can not restore WLAN groups setting");
        }
        if (wlanGroupPOS.size() > 1 && this.wlanGroupMaintMongoRepository.b(omadacId) + (long)wlanGroupPOS.size() > (long)this.siteLimitMaintMongoRepository.a(omadacId)) {
            log.warn("The number of WLAN groups has reached the limit");
            throw new com.tplink.smb.omada.backup.api.d.c(com.tplink.smb.omada.common.g.b.fE);
        }
        for (WlanGroupPO wlanGroupDO : wlanGroupPOS) {
            List<SsidPO> importSsids = this.findSsidsBySiteIdAndWlanId(wlanGroupDO.getSiteId(), wlanGroupDO.getId(), ssidPOS);
            this.copyWlanGroup(omadacId, newSiteId, wlanGroupDO, siteImportIdCacheMap, importSsids);
        }
    }

    public void siteTemplateCopyWrite(Object dataObject, c omadacId, d newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        List<WlanGroupTemplatePO> wlanGroupTemplatePOS = ((WirelessNetworkDTO)dataObject).getWlanGroupTemplates();
        List<SsidTemplatePO> ssidTemplatePOS = ((WirelessNetworkDTO)dataObject).getSsidTemplates();
        if (CollectionUtils.isEmpty(wlanGroupTemplatePOS)) {
            log.error("The WLAN groups template is empty.");
            throw new com.tplink.smb.omada.backup.api.d.c("can not restore WLAN groups setting");
        }
        if (this.wlanGroupMaintMongoRepository.c(omadacId) + (long)wlanGroupTemplatePOS.size() > (long)this.siteLimitMaintMongoRepository.a(omadacId)) {
            log.warn("The number of WLAN groups template has reached the limit, only default WLAN Group will be copied.");
            for (WlanGroupTemplatePO wlanGroupTemplatePO : wlanGroupTemplatePOS) {
                if (!wlanGroupTemplatePO.getPrimary().booleanValue()) continue;
                List<SsidTemplatePO> importSsids = this.findSsidTemplatesBySiteIdAndWlanId(wlanGroupTemplatePO.getSiteTemplateId(), wlanGroupTemplatePO.getId(), ssidTemplatePOS);
                this.copyWlanGroupTemplate(omadacId, newSiteTemplateId, wlanGroupTemplatePO, siteImportIdCacheMap, importSsids);
                break;
            }
        } else {
            for (WlanGroupTemplatePO wlanGroupTemplatePO : wlanGroupTemplatePOS) {
                List<SsidTemplatePO> importSsids = this.findSsidTemplatesBySiteIdAndWlanId(wlanGroupTemplatePO.getSiteTemplateId(), wlanGroupTemplatePO.getId(), ssidTemplatePOS);
                this.copyWlanGroupTemplate(omadacId, newSiteTemplateId, wlanGroupTemplatePO, siteImportIdCacheMap, importSsids);
            }
        }
    }

    private void copyWlanGroup(c omadacId, d newSiteId, WlanGroupPO wlanGroupPO, Map<String, Map<String, String>> siteImportIdCacheMap, List<SsidPO> importSsids) {
        String oldWlanId = wlanGroupPO.getId();
        wlanGroupPO.setOmadacId(omadacId.a());
        wlanGroupPO.setSiteId(newSiteId.a());
        Map wirelessIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.ag.A(), k2 -> new HashMap());
        wlanGroupPO.setTemplateId(null);
        wlanGroupPO.setOverride(null);
        wlanGroupPO.setId(null);
        String newWlanId = this.wlanGroupMaintMongoRepository.a((BaseWlanGroupPO)wlanGroupPO);
        wirelessIdMap.put(oldWlanId, newWlanId);
        siteImportIdCacheMap.put(com.tplink.smb.omada.backup.api.c.d.ag.A(), wirelessIdMap);
        this.copySsids(omadacId, newSiteId, newWlanId, siteImportIdCacheMap, importSsids);
    }

    private void copySsids(c omadacId, d siteId, String newWlanId, Map<String, Map<String, String>> siteImportIdCacheMap, List<SsidPO> importSsids) {
        Map<String, String> profileIdMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.Y.A());
        Map<String, String> portalIdMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.ad.A());
        Map<String, String> radiusProfileIdMap = siteImportIdCacheMap.get("radiusProfileIdOriginToCurrent");
        HashMap<String, String> wirelessIdMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.ag.A()) == null ? new HashMap<String, String>() : siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.ag.A());
        Map<String, String> wiredNetworkMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.af.A());
        Map<String, String> ppskPageIdMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.ae.A());
        if (!CollectionUtils.isEmpty(importSsids)) {
            for (SsidPO ssid : importSsids) {
                String oldSsidId = ssid.getId();
                ssid.setTemplateId(null);
                ssid.setOverride(null);
                ssid.setId(null);
                ssid.setOmadacId(omadacId.a());
                ssid.setWlanId(newWlanId);
                ssid.setSiteId(siteId.a());
                if (ssid.getPortalId() == null) {
                    ssid.setPortalId(null);
                } else {
                    ssid.setPortalId(portalIdMap.get(ssid.getPortalId()));
                }
                if (Objects.equals(ssid.getSecurity(), 2) && !CollectionUtils.isEmpty(radiusProfileIdMap) && !T.a((String)radiusProfileIdMap.get(ssid.getWpaSetting().getRadiusProfileId()))) {
                    ssid.getWpaSetting().setRadiusProfileId(radiusProfileIdMap.get(ssid.getWpaSetting().getRadiusProfileId()));
                }
                this.updatePPSK((BaseSsidPO)ssid, radiusProfileIdMap, profileIdMap, ppskPageIdMap);
                if (!CollectionUtils.isEmpty(profileIdMap) && !T.a((String)profileIdMap.get(ssid.getScheduleId()))) {
                    ssid.setScheduleId(profileIdMap.get(ssid.getScheduleId()));
                }
                if (!CollectionUtils.isEmpty(profileIdMap) && !T.a((String)profileIdMap.get(ssid.getMacFilterId()))) {
                    ssid.setMacFilterId(profileIdMap.get(ssid.getMacFilterId()));
                }
                if (!CollectionUtils.isEmpty(profileIdMap) && ssid.getMultiCastSetting() != null && !T.a((String)profileIdMap.get(ssid.getMultiCastSetting().getMacGroupId()))) {
                    ssid.getMultiCastSetting().setMacGroupId(profileIdMap.get(ssid.getMultiCastSetting().getMacGroupId()));
                }
                if (!CollectionUtils.isEmpty(profileIdMap) && !CollectionUtils.isEmpty((Collection)ssid.getOuiProfileIds())) {
                    ArrayList newIdList = new ArrayList();
                    ssid.getOuiProfileIds().forEach(oldId -> {
                        if (!T.a((String)((String)profileIdMap.get(oldId)))) {
                            newIdList.add((String)profileIdMap.get(oldId));
                        }
                    });
                    ssid.setOuiProfileIds(newIdList);
                }
                if (!CollectionUtils.isEmpty(profileIdMap) && !T.a((String)profileIdMap.get(ssid.getRateLimit().getRateLimitId()))) {
                    ssid.getRateLimit().setRateLimitId(profileIdMap.get(ssid.getRateLimit().getRateLimitId()));
                }
                if (Objects.nonNull(ssid.getSsidRateLimit()) && !CollectionUtils.isEmpty(profileIdMap) && !T.a((String)profileIdMap.get(ssid.getSsidRateLimit().getRateLimitId()))) {
                    ssid.getSsidRateLimit().setRateLimitId(profileIdMap.get(ssid.getSsidRateLimit().getRateLimitId()));
                }
                if (ssid.getVlanSetting() != null && ssid.getVlanSetting().getLanNetworkId() != null && !CollectionUtils.isEmpty(wiredNetworkMap)) {
                    ssid.getVlanSetting().setLanNetworkId(wiredNetworkMap.get(ssid.getVlanSetting().getLanNetworkId()));
                }
                if (ssid.getVlanSetting() != null && ssid.getVlanSetting().getLanNetworkVlanIds() != null) {
                    Map oldLanNetworkVlanIds = ssid.getVlanSetting().getLanNetworkVlanIds();
                    Set lanNetworkIds = oldLanNetworkVlanIds.keySet();
                    HashMap newLanNetworkVlanIds = new HashMap();
                    lanNetworkIds.forEach(lanNetworkId -> {
                        List vlanIds = (List)oldLanNetworkVlanIds.get(lanNetworkId);
                        newLanNetworkVlanIds.put((String)wiredNetworkMap.get(lanNetworkId), vlanIds);
                    });
                    ssid.getVlanSetting().setLanNetworkVlanIds(newLanNetworkVlanIds);
                }
                String newSsidId = this.ssidMaintMongoRepository.a((BaseSsidPO)ssid);
                wirelessIdMap.put(oldSsidId, newSsidId);
                DomainEventBusHolder.getPublisher().publishSync(((a.a)((Object)((a.a)((Object)((a.a)((Object)((a.a)((Object)((a.a)((Object)a.a().a(omadacId))).a(siteId))).a(oldSsidId))).b(newSsidId))).a(x.a))).b());
            }
            siteImportIdCacheMap.put(com.tplink.smb.omada.backup.api.c.d.ag.A(), wirelessIdMap);
        }
    }

    private void copyWlanGroupTemplate(c omadacId, d newSiteId, WlanGroupTemplatePO wlanGroupTemplatePO, Map<String, Map<String, String>> siteImportIdCacheMap, List<SsidTemplatePO> ssidTemplatePOS) {
        String oldWlanId = wlanGroupTemplatePO.getId();
        wlanGroupTemplatePO.setOmadacId(omadacId.a());
        wlanGroupTemplatePO.setSiteTemplateId(newSiteId.a());
        Map wirelessIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.ag.A(), k2 -> new HashMap());
        wlanGroupTemplatePO.setId(null);
        String newWlanId = this.wlanGroupMaintMongoRepository.a((BaseWlanGroupPO)wlanGroupTemplatePO);
        wirelessIdMap.put(oldWlanId, newWlanId);
        siteImportIdCacheMap.put(com.tplink.smb.omada.backup.api.c.d.ag.A(), wirelessIdMap);
        this.copySsidsTemplate(omadacId, newSiteId, newWlanId, siteImportIdCacheMap, ssidTemplatePOS);
    }

    private void copySsidsTemplate(c omadacId, d siteId, String newWlanId, Map<String, Map<String, String>> siteImportIdCacheMap, List<SsidTemplatePO> importSsids) {
        Map<String, String> profileIdMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.Y.A());
        Map<String, String> portalIdMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.ad.A());
        Map<String, String> radiusProfileIdMap = siteImportIdCacheMap.get("radiusProfileIdOriginToCurrent");
        HashMap<String, String> wirelessIdMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.ag.A()) == null ? new HashMap<String, String>() : siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.ag.A());
        Map<String, String> wiredNetworkMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.af.A());
        Map<String, String> ppskPageIdMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.ae.A());
        if (!CollectionUtils.isEmpty(importSsids)) {
            for (SsidTemplatePO ssid : importSsids) {
                String oldSsidId = ssid.getId();
                ssid.setId(null);
                ssid.setOmadacId(omadacId.a());
                ssid.setWlanId(newWlanId);
                ssid.setSiteTemplateId(siteId.a());
                if (ssid.getPortalId() == null) {
                    ssid.setPortalId(null);
                } else {
                    ssid.setPortalId(portalIdMap.get(ssid.getPortalId()));
                }
                if (Objects.equals(ssid.getSecurity(), 2) && !CollectionUtils.isEmpty(radiusProfileIdMap) && !T.a((String)radiusProfileIdMap.get(ssid.getWpaSetting().getRadiusProfileId()))) {
                    ssid.getWpaSetting().setRadiusProfileId(radiusProfileIdMap.get(ssid.getWpaSetting().getRadiusProfileId()));
                }
                this.updatePPSK((BaseSsidPO)ssid, radiusProfileIdMap, profileIdMap, ppskPageIdMap);
                if (!CollectionUtils.isEmpty(profileIdMap) && !T.a((String)profileIdMap.get(ssid.getScheduleId()))) {
                    ssid.setScheduleId(profileIdMap.get(ssid.getScheduleId()));
                }
                if (!CollectionUtils.isEmpty(profileIdMap) && !T.a((String)profileIdMap.get(ssid.getMacFilterId()))) {
                    ssid.setMacFilterId(profileIdMap.get(ssid.getMacFilterId()));
                }
                if (!CollectionUtils.isEmpty(profileIdMap) && ssid.getMultiCastSetting() != null && !T.a((String)profileIdMap.get(ssid.getMultiCastSetting().getMacGroupId()))) {
                    ssid.getMultiCastSetting().setMacGroupId(profileIdMap.get(ssid.getMultiCastSetting().getMacGroupId()));
                }
                if (!CollectionUtils.isEmpty(profileIdMap) && !CollectionUtils.isEmpty((Collection)ssid.getOuiProfileIds())) {
                    ArrayList newIdList = new ArrayList();
                    ssid.getOuiProfileIds().forEach(oldId -> {
                        if (!T.a((String)((String)profileIdMap.get(oldId)))) {
                            newIdList.add((String)profileIdMap.get(oldId));
                        }
                    });
                    ssid.setOuiProfileIds(newIdList);
                }
                if (!CollectionUtils.isEmpty(profileIdMap) && !T.a((String)profileIdMap.get(ssid.getRateLimit().getRateLimitId()))) {
                    ssid.getRateLimit().setRateLimitId(profileIdMap.get(ssid.getRateLimit().getRateLimitId()));
                }
                if (Objects.nonNull(ssid.getSsidRateLimit()) && !CollectionUtils.isEmpty(profileIdMap) && !T.a((String)profileIdMap.get(ssid.getSsidRateLimit().getRateLimitId()))) {
                    ssid.getSsidRateLimit().setRateLimitId(profileIdMap.get(ssid.getSsidRateLimit().getRateLimitId()));
                }
                if (ssid.getVlanSetting() != null && ssid.getVlanSetting().getLanNetworkId() != null && !CollectionUtils.isEmpty(wiredNetworkMap)) {
                    ssid.getVlanSetting().setLanNetworkId(wiredNetworkMap.get(ssid.getVlanSetting().getLanNetworkId()));
                }
                if (ssid.getVlanSetting() != null && ssid.getVlanSetting().getLanNetworkVlanIds() != null) {
                    Map oldLanNetworkVlanIds = ssid.getVlanSetting().getLanNetworkVlanIds();
                    Set lanNetworkIds = oldLanNetworkVlanIds.keySet();
                    HashMap newLanNetworkVlanIds = new HashMap();
                    lanNetworkIds.forEach(lanNetworkId -> {
                        List vlanIds = (List)oldLanNetworkVlanIds.get(lanNetworkId);
                        newLanNetworkVlanIds.put((String)wiredNetworkMap.get(lanNetworkId), vlanIds);
                    });
                    ssid.getVlanSetting().setLanNetworkVlanIds(newLanNetworkVlanIds);
                }
                String newSsidId = this.ssidMaintMongoRepository.a((BaseSsidPO)ssid);
                wirelessIdMap.put(oldSsidId, newSsidId);
                DomainEventBusHolder.getPublisher().publishSync(((a.a)((Object)((a.a)((Object)((a.a)((Object)((a.a)((Object)((a.a)((Object)a.a().a(omadacId))).a(siteId))).a(oldSsidId))).b(newSsidId))).a(x.b))).b());
            }
            siteImportIdCacheMap.put(com.tplink.smb.omada.backup.api.c.d.ag.A(), wirelessIdMap);
        }
    }

    private void updatePPSK(BaseSsidPO ssid, Map<String, String> radiusProfileIdMap, Map<String, String> profileIdMap, Map<String, String> ppskPageIdMap) {
        if (Objects.equals(ssid.getSecurity(), 4) && !CollectionUtils.isEmpty(profileIdMap) && !T.a((String)profileIdMap.get(ssid.getPpskSetting().getPpskProfileId()))) {
            ssid.getPpskSetting().setPpskProfileId(profileIdMap.get(ssid.getPpskSetting().getPpskProfileId()));
        }
        if (Objects.equals(ssid.getSecurity(), 5) && !CollectionUtils.isEmpty(radiusProfileIdMap) && !T.a((String)radiusProfileIdMap.get(ssid.getPpskSetting().getRadiusProfileId()))) {
            ssid.getPpskSetting().setRadiusProfileId(radiusProfileIdMap.get(ssid.getPpskSetting().getRadiusProfileId()));
        }
        if (Objects.equals(ssid.getSecurity(), 5) && !CollectionUtils.isEmpty(profileIdMap) && !T.a((String)ssid.getPpskSetting().getPpskProfileId()) && !T.a((String)profileIdMap.get(ssid.getPpskSetting().getPpskProfileId()))) {
            ssid.getPpskSetting().setPpskProfileId(profileIdMap.get(ssid.getPpskSetting().getPpskProfileId()));
        }
        if (Objects.equals(ssid.getSecurity(), 4) && ssid.getPpskSetting().getRegisterPageId() != null) {
            ssid.getPpskSetting().setPpskProfileId(ppskPageIdMap.get(ssid.getPpskSetting().getRegisterPageId()));
        }
    }

    private List<SsidPO> findSsidsBySiteIdAndWlanId(String siteId, String wlanId, List<SsidPO> ssids) {
        if (CollectionUtils.isEmpty(ssids)) {
            return Collections.emptyList();
        }
        ArrayList<SsidPO> result = new ArrayList<SsidPO>(ssids.size());
        for (SsidPO ssid : ssids) {
            if (!Objects.equals(ssid.getSiteId(), siteId) || !Objects.equals(ssid.getWlanId(), wlanId)) continue;
            result.add(ssid);
        }
        return result;
    }

    private List<SsidTemplatePO> findSsidTemplatesBySiteIdAndWlanId(String siteId, String wlanId, List<SsidTemplatePO> ssids) {
        if (CollectionUtils.isEmpty(ssids)) {
            return Collections.emptyList();
        }
        ArrayList<SsidTemplatePO> result = new ArrayList<SsidTemplatePO>(ssids.size());
        for (SsidTemplatePO ssid : ssids) {
            if (!Objects.equals(ssid.getSiteTemplateId(), siteId) || !Objects.equals(ssid.getWlanId(), wlanId)) continue;
            result.add(ssid);
        }
        return result;
    }
}

