/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.wirelessnetwork.restore;

import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.wirelessnetwork.dto.WirelessNetworkDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.wirelessnetwork.restore.a;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.c.x;
import com.tplink.smb.omada.manager.configuration.api.internal.site.wireless.ssid.dto.BatchDeleteSsidDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.wireless.ssid.dto.DeleteSsidInfoDTO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.ssid.BaseSsidPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.ssid.SsidPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.wlan.BaseWlanGroupPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.wlan.WlanGroupPO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V50100, b=com.tplink.smb.omada.backup.api.c.d.WIRED_LESS_NETWORK)
public class WirelessNetworkRestoreUnitV50100
extends com.tplink.smb.omada.backup.api.b {
    private static final WirelessNetworkRestoreUnitV50100 instance = new WirelessNetworkRestoreUnitV50100();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.d wlanGroupMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.d.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c ssidMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c.a();
    private final com.tplink.smb.omada.manager.configuration.api.internal.site.wireless.ssid.a ssidInternalApiService = (com.tplink.smb.omada.manager.configuration.api.internal.site.wireless.ssid.a)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.manager.configuration.api.internal.site.wireless.ssid.a.class);
    private static final int PPSK_TYPE_ORIGIN = 0;

    private WirelessNetworkRestoreUnitV50100() {
    }

    public static WirelessNetworkRestoreUnitV50100 getInstance() {
        return instance;
    }

    public void restore(b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        List<SsidPO> ssids;
        WirelessNetworkDTO wirelessNetworkDTO = (WirelessNetworkDTO)jsonParserWrapper.a(WirelessNetworkDTO.class);
        Map siteMap = (Map)restoreCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Q.A(), k2 -> new HashMap());
        Map profileMap = (Map)restoreCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Y.A(), k2 -> new HashMap());
        Map wirelessIdMap = (Map)restoreCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.ag.A(), k2 -> new HashMap());
        Map portalMap = (Map)restoreCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.ad.A(), k2 -> new HashMap());
        Map radiusProfileIdMap = (Map)restoreCacheMap.computeIfAbsent("radiusProfileIdOriginToCurrent", k2 -> new HashMap());
        Map wiredNetworkMap = (Map)restoreCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), k2 -> new HashMap());
        List<WlanGroupPO> wlanGroups = wirelessNetworkDTO.getWlanGroups();
        if (!CollectionUtils.isEmpty(wlanGroups)) {
            for (WlanGroupPO wlanGroupPO : wlanGroups) {
                wlanGroupPO.setOmadacId(omadacId.a());
                String siteId = (String)siteMap.get(wlanGroupPO.getSiteId());
                if (siteId == null) continue;
                wlanGroupPO.setSiteId(siteId);
                wlanGroupPO.setClone(null);
                wlanGroupPO.setClonedWlanId(null);
                String oldWlanId = wlanGroupPO.getId();
                wlanGroupPO.setId(null);
                wirelessIdMap.put(oldWlanId, this.wlanGroupMaintMongoRepository.a((BaseWlanGroupPO)wlanGroupPO));
            }
        }
        if (!CollectionUtils.isEmpty(ssids = wirelessNetworkDTO.getSsids())) {
            for (SsidPO ssidPO : ssids) {
                ssidPO.setOmadacId(omadacId.a());
                String siteId = (String)siteMap.get(ssidPO.getSiteId());
                if (siteId == null) continue;
                ssidPO.setSiteId(siteId);
                ssidPO.setWlanId((String)wirelessIdMap.get(ssidPO.getWlanId()));
                String oldSsidId = ssidPO.getId();
                ssidPO.setId(null);
                ssidPO.setMacFilterId((String)profileMap.get(ssidPO.getMacFilterId()));
                if (!CollectionUtils.isEmpty((Map)profileMap) && !CollectionUtils.isEmpty((Collection)ssidPO.getOuiProfileIds())) {
                    ArrayList newIdList = new ArrayList();
                    ssidPO.getOuiProfileIds().forEach(oldId -> {
                        if (!T.a((String)((String)profileMap.get(oldId)))) {
                            newIdList.add((String)profileMap.get(oldId));
                        }
                    });
                    ssidPO.setOuiProfileIds(newIdList);
                }
                ssidPO.setPortalId((String)portalMap.get(ssidPO.getPortalId()));
                ssidPO.setScheduleId((String)profileMap.get(ssidPO.getScheduleId()));
                ssidPO.getRateLimit().setRateLimitId((String)profileMap.get(ssidPO.getRateLimit().getRateLimitId()));
                if (ssidPO.getSsidRateLimit() != null) {
                    ssidPO.getSsidRateLimit().setRateLimitId((String)profileMap.get(ssidPO.getSsidRateLimit().getRateLimitId()));
                }
                if (ssidPO.getWpaSetting() != null) {
                    ssidPO.getWpaSetting().setRadiusProfileId((String)radiusProfileIdMap.get(ssidPO.getWpaSetting().getRadiusProfileId()));
                }
                this.updatePPSK(ssidPO, radiusProfileIdMap, profileMap);
                if (ssidPO.getMultiCastSetting() != null && ssidPO.getMultiCastSetting().getMacGroupId() != null) {
                    ssidPO.getMultiCastSetting().setMacGroupId((String)profileMap.get(ssidPO.getMultiCastSetting().getMacGroupId()));
                }
                if (ssidPO.getVlanSetting() != null && ssidPO.getVlanSetting().getLanNetworkId() != null) {
                    ssidPO.getVlanSetting().setLanNetworkId((String)wiredNetworkMap.get(ssidPO.getVlanSetting().getLanNetworkId()));
                }
                String newSsid = this.ssidMaintMongoRepository.a((BaseSsidPO)ssidPO);
                wirelessIdMap.put(oldSsidId, newSsid);
                DomainEventBusHolder.getPublisher().publishSync(((a.a)((Object)((a.a)((Object)((a.a)((Object)((a.a)((Object)a.a().a(omadacId))).a(new d(ssidPO.getSiteId())))).a(oldSsidId))).b(newSsid))).b());
            }
        }
        restoreCacheMap.put(com.tplink.smb.omada.backup.api.c.d.ag.A(), wirelessIdMap);
    }

    private void updatePPSK(SsidPO ssidPO, Map<String, String> radiusProfileIdMap, Map<String, String> profileMap) {
        if (ssidPO.getPpskSetting() == null) {
            return;
        }
        if (!T.a((String)ssidPO.getPpskSetting().getRadiusProfileId())) {
            ssidPO.getPpskSetting().setRadiusProfileId(radiusProfileIdMap.get(ssidPO.getPpskSetting().getRadiusProfileId()));
        }
        if (!T.a((String)ssidPO.getPpskSetting().getPpskProfileId())) {
            ssidPO.getPpskSetting().setPpskProfileId(profileMap.get(ssidPO.getPpskSetting().getPpskProfileId()));
        }
        if (ssidPO.getPpskSetting().getType() == null) {
            ssidPO.getPpskSetting().setType(Integer.valueOf(0));
        }
    }

    public void afterCompatible(c omadacId, Map<String, Object> restoreCacheMap) {
        ArrayList<DeleteSsidInfoDTO> deleteSsidInfoDTOS = new ArrayList<DeleteSsidInfoDTO>();
        List ssids = this.ssidMaintMongoRepository.a(omadacId, Integer.valueOf(5), x.a.b());
        for (BaseSsidPO ssid : ssids) {
            if (ssid.getPpskSetting() == null || ssid.getPpskSetting().getPpskProfileId() == null) continue;
            this.addSsidInfoToList((SsidPO)ssid, deleteSsidInfoDTOS);
        }
        if (!CollectionUtils.isEmpty(deleteSsidInfoDTOS)) {
            Map<String, List<DeleteSsidInfoDTO>> omadacIdSsidInfoMap = deleteSsidInfoDTOS.stream().collect(Collectors.groupingBy(DeleteSsidInfoDTO::getOmadacId));
            omadacIdSsidInfoMap.entrySet().forEach(entry -> {
                if (entry.getKey() == null || CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))) {
                    return;
                }
                this.ssidInternalApiService.a(new BatchDeleteSsidDTO((String)entry.getKey(), (List)entry.getValue()));
            });
        }
    }

    private void addSsidInfoToList(SsidPO ssid, List<DeleteSsidInfoDTO> deleteSsidInfoDTOS) {
        deleteSsidInfoDTOS.add(new DeleteSsidInfoDTO().setOmadacId(ssid.getOmadacId()).setSiteId(ssid.getSiteId()).setId(ssid.getId()).setWlanId(ssid.getWlanId()));
    }
}

