/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.wirelessnetwork.restore;

import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.wirelessnetwork.dto.WirelessNetworkDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.wirelessnetwork.restore.a;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.c.x;
import com.tplink.smb.omada.manager.configuration.api.internal.site.wireless.ssid.dto.BatchDeleteSsidDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.wireless.ssid.dto.DeleteSsidInfoDTO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.ssid.BaseSsidPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.ssid.SsidPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.ssid.SsidTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.wlan.BaseWlanGroupPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.wlan.WlanGroupPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.wlan.WlanGroupTemplatePO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V10000900, b=com.tplink.smb.omada.backup.api.c.d.WIRED_LESS_NETWORK)
public class WirelessNetworkRestoreUnitV1000900
extends com.tplink.smb.omada.backup.api.b {
    private static final WirelessNetworkRestoreUnitV1000900 instance = new WirelessNetworkRestoreUnitV1000900();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.d wlanGroupMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.d.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c ssidMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c.a();
    private final com.tplink.smb.omada.manager.configuration.api.internal.site.wireless.ssid.a ssidInternalApiService = (com.tplink.smb.omada.manager.configuration.api.internal.site.wireless.ssid.a)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.manager.configuration.api.internal.site.wireless.ssid.a.class);
    private static final int PPSK_TYPE_ORIGIN = 0;

    private WirelessNetworkRestoreUnitV1000900() {
    }

    public static WirelessNetworkRestoreUnitV1000900 getInstance() {
        return instance;
    }

    public void restore(b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        WirelessNetworkDTO wirelessNetworkDTO = (WirelessNetworkDTO)jsonParserWrapper.a(WirelessNetworkDTO.class);
        Map siteMap = (Map)restoreCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Q.A(), k2 -> new HashMap());
        Map profileMap = (Map)restoreCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Y.A(), k2 -> new HashMap());
        Map wirelessIdMap = (Map)restoreCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.ag.A(), k2 -> new HashMap());
        Map portalMap = (Map)restoreCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.ad.A(), k2 -> new HashMap());
        Map radiusProfileIdMap = (Map)restoreCacheMap.computeIfAbsent("radiusProfileIdOriginToCurrent", k2 -> new HashMap());
        Map wiredNetworkMap = (Map)restoreCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), k2 -> new HashMap());
        this.restoreWlanGroup(wirelessNetworkDTO, omadacId, siteMap, wirelessIdMap);
        this.restoreSsid(wirelessNetworkDTO, omadacId, siteMap, wirelessIdMap, profileMap, portalMap, radiusProfileIdMap, wiredNetworkMap);
        this.restoreWlanGroupTemplate(wirelessNetworkDTO, omadacId, siteMap, wirelessIdMap);
        this.restoreSsidTemplate(wirelessNetworkDTO, omadacId, siteMap, wirelessIdMap, profileMap, portalMap, radiusProfileIdMap, wiredNetworkMap);
        restoreCacheMap.put(com.tplink.smb.omada.backup.api.c.d.ag.A(), wirelessIdMap);
    }

    private void restoreWlanGroup(WirelessNetworkDTO wirelessNetworkDTO, c omadacId, Map<String, String> siteMap, Map<String, String> wirelessIdMap) {
        List<WlanGroupPO> wlanGroups = wirelessNetworkDTO.getWlanGroups();
        if (!CollectionUtils.isEmpty(wlanGroups)) {
            for (WlanGroupPO wlanGroupPO : wlanGroups) {
                wlanGroupPO.setOmadacId(omadacId.a());
                String siteId = siteMap.get(wlanGroupPO.getSiteId());
                if (siteId == null) continue;
                wlanGroupPO.setSiteId(siteId);
                wlanGroupPO.setClone(null);
                wlanGroupPO.setClonedWlanId(null);
                String oldWlanId = wlanGroupPO.getId();
                wlanGroupPO.setId(null);
                if (wlanGroupPO.getTemplateId() != null) {
                    wlanGroupPO.setTemplateId(wirelessIdMap.get(wlanGroupPO.getTemplateId()));
                }
                wirelessIdMap.put(oldWlanId, this.wlanGroupMaintMongoRepository.a((BaseWlanGroupPO)wlanGroupPO));
            }
        }
    }

    private void restoreSsid(WirelessNetworkDTO wirelessNetworkDTO, c omadacId, Map<String, String> siteMap, Map<String, String> wirelessIdMap, Map<String, String> profileMap, Map<String, String> portalMap, Map<String, String> radiusProfileIdMap, Map<String, String> wiredNetworkMap) {
        List<SsidPO> ssids = wirelessNetworkDTO.getSsids();
        if (!CollectionUtils.isEmpty(ssids)) {
            for (SsidPO ssidPO : ssids) {
                ssidPO.setOmadacId(omadacId.a());
                String siteId = siteMap.get(ssidPO.getSiteId());
                if (siteId == null) continue;
                ssidPO.setSiteId(siteId);
                ssidPO.setWlanId(wirelessIdMap.get(ssidPO.getWlanId()));
                String oldSsidId = ssidPO.getId();
                ssidPO.setId(null);
                if (ssidPO.getTemplateId() != null) {
                    ssidPO.setTemplateId(wirelessIdMap.get(ssidPO.getTemplateId()));
                }
                ssidPO.setMacFilterId(profileMap.get(ssidPO.getMacFilterId()));
                if (!CollectionUtils.isEmpty(profileMap) && !CollectionUtils.isEmpty((Collection)ssidPO.getOuiProfileIds())) {
                    ArrayList newIdList = new ArrayList();
                    ssidPO.getOuiProfileIds().forEach(oldId -> {
                        if (!T.a((String)((String)profileMap.get(oldId)))) {
                            newIdList.add((String)profileMap.get(oldId));
                        }
                    });
                    ssidPO.setOuiProfileIds(newIdList);
                }
                ssidPO.setPortalId(portalMap.get(ssidPO.getPortalId()));
                ssidPO.setScheduleId(profileMap.get(ssidPO.getScheduleId()));
                ssidPO.getRateLimit().setRateLimitId(profileMap.get(ssidPO.getRateLimit().getRateLimitId()));
                if (ssidPO.getSsidRateLimit() != null) {
                    ssidPO.getSsidRateLimit().setRateLimitId(profileMap.get(ssidPO.getSsidRateLimit().getRateLimitId()));
                }
                if (ssidPO.getWpaSetting() != null) {
                    ssidPO.getWpaSetting().setRadiusProfileId(radiusProfileIdMap.get(ssidPO.getWpaSetting().getRadiusProfileId()));
                }
                this.updatePPSK((BaseSsidPO)ssidPO, radiusProfileIdMap, profileMap);
                if (ssidPO.getMultiCastSetting() != null && ssidPO.getMultiCastSetting().getMacGroupId() != null) {
                    ssidPO.getMultiCastSetting().setMacGroupId(profileMap.get(ssidPO.getMultiCastSetting().getMacGroupId()));
                }
                if (ssidPO.getVlanSetting() != null && ssidPO.getVlanSetting().getLanNetworkId() != null) {
                    ssidPO.getVlanSetting().setLanNetworkId(wiredNetworkMap.get(ssidPO.getVlanSetting().getLanNetworkId()));
                }
                String newSsid = this.ssidMaintMongoRepository.a((BaseSsidPO)ssidPO);
                wirelessIdMap.put(oldSsidId, newSsid);
                DomainEventBusHolder.getPublisher().publishSync(((a.a)((Object)((a.a)((Object)((a.a)((Object)((a.a)((Object)((a.a)((Object)a.a().a(omadacId))).a(new d(ssidPO.getSiteId())))).a(oldSsidId))).b(newSsid))).a(x.a))).b());
            }
        }
    }

    private void restoreWlanGroupTemplate(WirelessNetworkDTO wirelessNetworkDTO, c omadacId, Map<String, String> siteMap, Map<String, String> wirelessIdMap) {
        List<WlanGroupTemplatePO> wlanGroupTemplates = wirelessNetworkDTO.getWlanGroupTemplates();
        if (!CollectionUtils.isEmpty(wlanGroupTemplates)) {
            for (WlanGroupTemplatePO wlanGroupTemplatePO : wlanGroupTemplates) {
                wlanGroupTemplatePO.setOmadacId(omadacId.a());
                String siteTemplateId = siteMap.get(wlanGroupTemplatePO.getSiteTemplateId());
                if (siteTemplateId == null) continue;
                wlanGroupTemplatePO.setSiteTemplateId(siteTemplateId);
                wlanGroupTemplatePO.setClone(null);
                wlanGroupTemplatePO.setClonedWlanId(null);
                String oldWlanId = wlanGroupTemplatePO.getId();
                wlanGroupTemplatePO.setId(null);
                wirelessIdMap.put(oldWlanId, this.wlanGroupMaintMongoRepository.a((BaseWlanGroupPO)wlanGroupTemplatePO));
            }
        }
    }

    private void restoreSsidTemplate(WirelessNetworkDTO wirelessNetworkDTO, c omadacId, Map<String, String> siteMap, Map<String, String> wirelessIdMap, Map<String, String> profileMap, Map<String, String> portalMap, Map<String, String> radiusProfileIdMap, Map<String, String> wiredNetworkMap) {
        List<SsidTemplatePO> ssidTemplates = wirelessNetworkDTO.getSsidTemplates();
        if (!CollectionUtils.isEmpty(ssidTemplates)) {
            for (SsidTemplatePO ssidTemplatePO : ssidTemplates) {
                ssidTemplatePO.setOmadacId(omadacId.a());
                String siteTemplateId = siteMap.get(ssidTemplatePO.getSiteTemplateId());
                if (siteTemplateId == null) continue;
                ssidTemplatePO.setSiteTemplateId(siteTemplateId);
                ssidTemplatePO.setWlanId(wirelessIdMap.get(ssidTemplatePO.getWlanId()));
                String oldSsidId = ssidTemplatePO.getId();
                ssidTemplatePO.setId(null);
                ssidTemplatePO.setMacFilterId(profileMap.get(ssidTemplatePO.getMacFilterId()));
                if (!CollectionUtils.isEmpty(profileMap) && !CollectionUtils.isEmpty((Collection)ssidTemplatePO.getOuiProfileIds())) {
                    ArrayList newIdList = new ArrayList();
                    ssidTemplatePO.getOuiProfileIds().forEach(oldId -> {
                        if (!T.a((String)((String)profileMap.get(oldId)))) {
                            newIdList.add((String)profileMap.get(oldId));
                        }
                    });
                    ssidTemplatePO.setOuiProfileIds(newIdList);
                }
                ssidTemplatePO.setPortalId(portalMap.get(ssidTemplatePO.getPortalId()));
                ssidTemplatePO.setScheduleId(profileMap.get(ssidTemplatePO.getScheduleId()));
                ssidTemplatePO.getRateLimit().setRateLimitId(profileMap.get(ssidTemplatePO.getRateLimit().getRateLimitId()));
                if (ssidTemplatePO.getSsidRateLimit() != null) {
                    ssidTemplatePO.getSsidRateLimit().setRateLimitId(profileMap.get(ssidTemplatePO.getSsidRateLimit().getRateLimitId()));
                }
                if (ssidTemplatePO.getWpaSetting() != null) {
                    ssidTemplatePO.getWpaSetting().setRadiusProfileId(radiusProfileIdMap.get(ssidTemplatePO.getWpaSetting().getRadiusProfileId()));
                }
                this.updatePPSK((BaseSsidPO)ssidTemplatePO, radiusProfileIdMap, profileMap);
                if (ssidTemplatePO.getMultiCastSetting() != null && ssidTemplatePO.getMultiCastSetting().getMacGroupId() != null) {
                    ssidTemplatePO.getMultiCastSetting().setMacGroupId(profileMap.get(ssidTemplatePO.getMultiCastSetting().getMacGroupId()));
                }
                if (ssidTemplatePO.getVlanSetting() != null && ssidTemplatePO.getVlanSetting().getLanNetworkId() != null) {
                    ssidTemplatePO.getVlanSetting().setLanNetworkId(wiredNetworkMap.get(ssidTemplatePO.getVlanSetting().getLanNetworkId()));
                }
                String newSsid = this.ssidMaintMongoRepository.a((BaseSsidPO)ssidTemplatePO);
                wirelessIdMap.put(oldSsidId, newSsid);
                DomainEventBusHolder.getPublisher().publishSync(((a.a)((Object)((a.a)((Object)((a.a)((Object)((a.a)((Object)((a.a)((Object)a.a().a(omadacId))).a(new d(ssidTemplatePO.getSiteTemplateId())))).a(oldSsidId))).b(newSsid))).a(x.b))).b());
            }
        }
    }

    private void updatePPSK(BaseSsidPO ssidPO, Map<String, String> radiusProfileIdMap, Map<String, String> profileMap) {
        if (ssidPO.getPpskSetting() == null) {
            return;
        }
        if (!T.a((String)ssidPO.getPpskSetting().getRadiusProfileId())) {
            ssidPO.getPpskSetting().setRadiusProfileId(radiusProfileIdMap.get(ssidPO.getPpskSetting().getRadiusProfileId()));
        }
        if (!T.a((String)ssidPO.getPpskSetting().getPpskProfileId())) {
            ssidPO.getPpskSetting().setPpskProfileId(profileMap.get(ssidPO.getPpskSetting().getPpskProfileId()));
        }
        if (ssidPO.getPpskSetting().getType() == null) {
            ssidPO.getPpskSetting().setType(Integer.valueOf(0));
        }
    }

    public void afterCompatible(c omadacId, Map<String, Object> restoreCacheMap) {
        com.tplink.smb.omada.maintenance.compatible.service.impl.c.a.clear();
        ArrayList<DeleteSsidInfoDTO> deleteSsidInfoDTOS = new ArrayList<DeleteSsidInfoDTO>();
        List ssidTemplates = this.ssidMaintMongoRepository.a(omadacId, Integer.valueOf(5), x.b.b());
        com.tplink.smb.omada.maintenance.compatible.service.impl.c.a.clear();
        for (Object ssid : ssidTemplates) {
            if (ssid.getPpskSetting() == null || ssid.getPpskSetting().getPpskProfileId() == null) continue;
            this.addSsidInfoToList((BaseSsidPO)ssid, deleteSsidInfoDTOS, x.b);
        }
        List ssids = this.ssidMaintMongoRepository.a(omadacId, Integer.valueOf(5), x.a.b());
        for (BaseSsidPO ssid : ssids) {
            if (ssid.getPpskSetting() == null || ssid.getPpskSetting().getPpskProfileId() == null) continue;
            this.addSsidInfoToList(ssid, deleteSsidInfoDTOS, x.a);
        }
        if (!CollectionUtils.isEmpty(deleteSsidInfoDTOS)) {
            Map<String, List<DeleteSsidInfoDTO>> omadacIdSsidInfoMap = deleteSsidInfoDTOS.stream().collect(Collectors.groupingBy(DeleteSsidInfoDTO::getOmadacId));
            omadacIdSsidInfoMap.entrySet().forEach(entry -> {
                if (entry.getKey() == null || CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))) {
                    return;
                }
                this.ssidInternalApiService.a(new BatchDeleteSsidDTO((String)entry.getKey(), (List)entry.getValue()));
            });
        }
    }

    private void addSsidInfoToList(BaseSsidPO ssid, List<DeleteSsidInfoDTO> deleteSsidInfoDTOS, x type) {
        if (Objects.equals(x.a, type)) {
            deleteSsidInfoDTOS.add(new DeleteSsidInfoDTO().setOmadacId(ssid.getOmadacId()).setSiteId(((SsidPO)ssid).getSiteId()).setSiteType(Integer.valueOf(type.a())).setId(ssid.getId()).setWlanId(ssid.getWlanId()));
        } else {
            deleteSsidInfoDTOS.add(new DeleteSsidInfoDTO().setOmadacId(ssid.getOmadacId()).setSiteId(((SsidTemplatePO)ssid).getSiteTemplateId()).setSiteType(Integer.valueOf(type.a())).setId(ssid.getId()).setWlanId(ssid.getWlanId()));
        }
    }
}

