/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.wirednetwork.siteimport;

import com.tplink.smb.omada.backup.api.c.n;
import com.tplink.smb.omada.backup.core.d.j;
import com.tplink.smb.omada.backup.core.unit.siteconfig.wirednetwork.dto.WiredNetworkDTO;
import com.tplink.smb.omada.common.constant.G;
import com.tplink.smb.omada.common.constant.o;
import com.tplink.smb.omada.common.util.e;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.b;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.h;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.virtualwan.VirtualWanPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.virtualwan.VirtualWanTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.BaseInternetPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.InternetPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.LteWanSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.VirtualWanWeightPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.WanLoadBalancePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.osgmodel.OsgModelConfigPO;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.d(a=com.tplink.smb.omada.backup.api.c.d.WIRED_NETWORK)
public class WiredNetworkSiteImportUnit
extends com.tplink.smb.omada.backup.api.c {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WiredNetworkSiteImportUnit.class);
    private final g osgModelConfigMainMongoRepository = g.a();
    private final a internetMaintMongoRepository = a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c lanNetworkMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.e lanProfileMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.e.a();
    private final b lanDnsMaintMongoRepository = b.a();
    private final h virtualWanMaintMongoRepository = h.a();
    private static final WiredNetworkSiteImportUnit instance = new WiredNetworkSiteImportUnit();

    private WiredNetworkSiteImportUnit() {
    }

    public static WiredNetworkSiteImportUnit getInstance() {
        return instance;
    }

    public void siteImport(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        Map profileMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Y.A(), v2 -> new HashMap());
        WiredNetworkDTO wiredNetworkDTO = (WiredNetworkDTO)jsonParserWrapper.a(WiredNetworkDTO.class);
        this.handleOsgModelConfig(omadacId, newSiteId, wiredNetworkDTO, false);
        this.handleInternet(omadacId, newSiteId, wiredNetworkDTO, profileMap, false);
        this.handleLanNetwork(omadacId, newSiteId, wiredNetworkDTO, siteImportIdCacheMap, false);
        this.handleLanProfile(omadacId, newSiteId, wiredNetworkDTO, siteImportIdCacheMap);
        this.handleLanDns(omadacId, newSiteId, wiredNetworkDTO, siteImportIdCacheMap);
        this.handleVirtualWan(omadacId, newSiteId, wiredNetworkDTO, siteImportIdCacheMap);
        this.handleLoadBalance(omadacId, newSiteId, wiredNetworkDTO, siteImportIdCacheMap);
    }

    public void siteCopyWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c {
        Map profileMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Y.A(), v2 -> new HashMap());
        WiredNetworkDTO wiredNetworkDTO = (WiredNetworkDTO)dataObject;
        if (wiredNetworkDTO == null) {
            log.warn("omadacId={},siteId={} Wired Network SiteImport dto is null.", (Object)omadacId.a(), (Object)newSiteId.a());
            return;
        }
        this.handleOsgModelConfig(omadacId, newSiteId, wiredNetworkDTO, true);
        this.handleInternet(omadacId, newSiteId, wiredNetworkDTO, profileMap, true);
        this.handleLanNetwork(omadacId, newSiteId, wiredNetworkDTO, siteImportIdCacheMap, true);
        this.handleLanProfile(omadacId, newSiteId, wiredNetworkDTO, siteImportIdCacheMap);
        this.handleLanDns(omadacId, newSiteId, wiredNetworkDTO, siteImportIdCacheMap);
        this.handleVirtualWan(omadacId, newSiteId, wiredNetworkDTO, siteImportIdCacheMap);
        this.handleLoadBalance(omadacId, newSiteId, wiredNetworkDTO, siteImportIdCacheMap);
        log.debug("omadacId={},siteId={} Wired Network SiteImport Success.", (Object)omadacId.a(), (Object)newSiteId.a());
    }

    public void siteTemplateCopyWrite(Object dataObject, c omadacId, d newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        WiredNetworkDTO wiredNetworkDTO = (WiredNetworkDTO)dataObject;
        Map netIdsMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), v2 -> new HashMap());
        Map<String, String> portalIdMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.ad.A());
        Map profileMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Y.A(), v2 -> new HashMap());
        Optional.ofNullable(wiredNetworkDTO.getLanNetworksTemplate()).ifPresent(lanNetworks -> lanNetworks.forEach(lanNetworkPO -> {
            String oldLanNetworkId = lanNetworkPO.getId();
            lanNetworkPO.setOmadacId(omadacId.a());
            lanNetworkPO.setSiteTemplateId(newSiteTemplateId.a());
            lanNetworkPO.setId(null);
            if (!CollectionUtils.isEmpty((Map)portalIdMap) && portalIdMap.containsKey(lanNetworkPO.getPortalId())) {
                lanNetworkPO.setPortalId((String)portalIdMap.get(lanNetworkPO.getPortalId()));
            }
            String newNetworkId = this.lanNetworkMaintMongoRepository.a(lanNetworkPO);
            netIdsMap.put(oldLanNetworkId, newNetworkId);
        }));
        Optional.ofNullable(wiredNetworkDTO.getInternetTemplate()).ifPresent(internetTemplatePO -> {
            internetTemplatePO.setOmadacId(omadacId.a());
            internetTemplatePO.setSiteTemplateId(newSiteTemplateId.a());
            internetTemplatePO.setId(null);
            this.handleInternetApnProfile(profileMap, (BaseInternetPO)internetTemplatePO);
            this.internetMaintMongoRepository.a(internetTemplatePO);
        });
        Optional.ofNullable(wiredNetworkDTO.getOsgModelConfigTemplate()).ifPresent(osgModelConfigTemplatePO -> {
            osgModelConfigTemplatePO.setOmadacId(omadacId.a());
            osgModelConfigTemplatePO.setSiteTemplateId(newSiteTemplateId.a());
            osgModelConfigTemplatePO.setId(null);
            this.osgModelConfigMainMongoRepository.a(osgModelConfigTemplatePO);
        });
        Optional.ofNullable(wiredNetworkDTO.getLanProfileTemplate()).ifPresent(lanProfileTemplates -> lanProfileTemplates.forEach(lanProfileTemplatePO -> {
            String originalId = lanProfileTemplatePO.getId();
            lanProfileTemplatePO.setOmadacId(omadacId.a());
            lanProfileTemplatePO.setSiteTemplateId(newSiteTemplateId.a());
            lanProfileTemplatePO.setId(null);
            lanProfileTemplatePO.setNativeNetworkId((String)netIdsMap.get(lanProfileTemplatePO.getNativeNetworkId()));
            if (lanProfileTemplatePO.getTagNetworkIds() != null) {
                lanProfileTemplatePO.setTagNetworkIds(e.a((List)lanProfileTemplatePO.getTagNetworkIds(), (Map)netIdsMap));
            }
            if (lanProfileTemplatePO.getTagBridgeVlanMap() != null) {
                lanProfileTemplatePO.setTagBridgeVlanMap(j.a(lanProfileTemplatePO.getTagBridgeVlanMap(), netIdsMap));
            }
            if (lanProfileTemplatePO.getEsEnableTaggedNetworkIds() != null) {
                lanProfileTemplatePO.setEsEnableTaggedNetworkIds(e.a((List)lanProfileTemplatePO.getEsEnableTaggedNetworkIds(), (Map)netIdsMap));
            }
            if (lanProfileTemplatePO.getEsEnableTagBridgeVlanMap() != null) {
                lanProfileTemplatePO.setEsEnableTagBridgeVlanMap(j.a(lanProfileTemplatePO.getEsEnableTagBridgeVlanMap(), netIdsMap));
            }
            if (lanProfileTemplatePO.getUntagNetworkIds() != null) {
                lanProfileTemplatePO.setUntagNetworkIds(e.a((List)lanProfileTemplatePO.getUntagNetworkIds(), (Map)netIdsMap));
            }
            if (lanProfileTemplatePO.getUntagBridgeVlanMap() != null) {
                lanProfileTemplatePO.setUntagBridgeVlanMap(j.a(lanProfileTemplatePO.getUntagBridgeVlanMap(), netIdsMap));
            }
            lanProfileTemplatePO.setVoiceNetworkId((String)netIdsMap.get(lanProfileTemplatePO.getVoiceNetworkId()));
            Optional.ofNullable(this.lanProfileMaintMongoRepository.a(lanProfileTemplatePO)).ifPresent(dbLanProfilePO -> netIdsMap.put(originalId, dbLanProfilePO.getId()));
        }));
        Optional.ofNullable(wiredNetworkDTO.getLanDnsTemplate()).ifPresent(lanDnsTemplates -> lanDnsTemplates.forEach(lanDnsTemplatePO -> {
            lanDnsTemplatePO.setOmadacId(omadacId.a());
            lanDnsTemplatePO.setSiteTemplateId(newSiteTemplateId.a());
            if (!CollectionUtils.isEmpty((Collection)lanDnsTemplatePO.getLanNetworkIds())) {
                lanDnsTemplatePO.setLanNetworkIds(e.a((List)lanDnsTemplatePO.getLanNetworkIds(), (Map)netIdsMap));
            }
            lanDnsTemplatePO.setId(null);
            this.lanDnsMaintMongoRepository.a(lanDnsTemplatePO);
        }));
        Optional.ofNullable(wiredNetworkDTO.getVirtualWanTemplate()).ifPresent(virtualWanTemplatePOs -> virtualWanTemplatePOs.forEach(virtualWanTemplate -> {
            String oldVirtualWanTemplateId = virtualWanTemplate.getId();
            virtualWanTemplate.setOmadacId(omadacId.a());
            virtualWanTemplate.setSiteTemplateId(newSiteTemplateId.a());
            virtualWanTemplate.setId(null);
            VirtualWanTemplatePO virtualWanTemplatePO = this.virtualWanMaintMongoRepository.a(virtualWanTemplate);
            netIdsMap.put(oldVirtualWanTemplateId, virtualWanTemplatePO == null ? null : virtualWanTemplate.getId());
        }));
        Optional.ofNullable(wiredNetworkDTO.getInternetTemplate()).ifPresent(internetTemplatePO -> {
            if (internetTemplatePO.getWanLoadBalance() != null && !CollectionUtils.isEmpty((Collection)internetTemplatePO.getWanLoadBalance().getVirtualWanWeights())) {
                internetTemplatePO.getWanLoadBalance().getVirtualWanWeights().forEach(weight -> weight.setVirtualWanId((String)netIdsMap.get(weight.getVirtualWanId())));
                this.internetMaintMongoRepository.a(internetTemplatePO);
            }
        });
    }

    private void handleOsgModelConfig(@Nonnull c omadacId, @Nonnull d newSiteId, @Nonnull WiredNetworkDTO wiredNetworkDTO, boolean isSiteCopy) {
        List<OsgModelConfigPO> osgModelConfigPOs = Objects.isNull(wiredNetworkDTO.getOsgModelConfig()) ? wiredNetworkDTO.getOsgModelConfigList() : List.of(wiredNetworkDTO.getOsgModelConfig());
        Optional.ofNullable(osgModelConfigPOs).ifPresent(osgModelConfigs -> osgModelConfigs.forEach(osgModelConfigPO -> {
            if (isSiteCopy && !Objects.isNull(osgModelConfigPO.getMac())) {
                return;
            }
            osgModelConfigPO.setOmadacId(omadacId.a());
            osgModelConfigPO.setSiteId(newSiteId.a());
            osgModelConfigPO.setId(null);
            this.osgModelConfigMainMongoRepository.a(osgModelConfigPO);
        }));
    }

    private void handleLanProfile(@Nonnull c omadacId, @Nonnull d newSiteId, @Nonnull WiredNetworkDTO wiredNetworkDTO, Map<String, Map<String, String>> siteImportIdCacheMap) {
        this.lanProfileMaintMongoRepository.a(omadacId, newSiteId, n.a);
        Map netIdsMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), v2 -> new HashMap());
        Optional.ofNullable(wiredNetworkDTO.getLanProfiles()).ifPresent(lanProfiles -> lanProfiles.forEach(lanProfilePO -> {
            String originalId = lanProfilePO.getId();
            lanProfilePO.setOmadacId(omadacId.a());
            lanProfilePO.setSiteId(newSiteId.a());
            lanProfilePO.setId(null);
            lanProfilePO.setTemplateId(null);
            lanProfilePO.setOverride(null);
            if (lanProfilePO.getNativeNetworkId() != null) {
                lanProfilePO.setNativeNetworkId((String)netIdsMap.get(lanProfilePO.getNativeNetworkId()));
            }
            if (lanProfilePO.getTagNetworkIds() != null) {
                lanProfilePO.setTagNetworkIds(e.a((List)lanProfilePO.getTagNetworkIds(), (Map)netIdsMap));
            }
            if (lanProfilePO.getTagBridgeVlanMap() != null) {
                lanProfilePO.setTagBridgeVlanMap(j.a(lanProfilePO.getTagBridgeVlanMap(), netIdsMap));
            }
            if (lanProfilePO.getEsEnableTaggedNetworkIds() != null) {
                lanProfilePO.setEsEnableTaggedNetworkIds(e.a((List)lanProfilePO.getEsEnableTaggedNetworkIds(), (Map)netIdsMap));
            }
            if (lanProfilePO.getEsEnableTagBridgeVlanMap() != null) {
                lanProfilePO.setEsEnableTagBridgeVlanMap(j.a(lanProfilePO.getEsEnableTagBridgeVlanMap(), netIdsMap));
            }
            if (lanProfilePO.getUntagNetworkIds() != null) {
                lanProfilePO.setUntagNetworkIds(e.a((List)lanProfilePO.getUntagNetworkIds(), (Map)netIdsMap));
            }
            if (lanProfilePO.getUntagBridgeVlanMap() != null) {
                lanProfilePO.setUntagBridgeVlanMap(j.a(lanProfilePO.getUntagBridgeVlanMap(), netIdsMap));
            }
            if (lanProfilePO.getVoiceNetworkId() != null) {
                lanProfilePO.setVoiceNetworkId((String)netIdsMap.get(lanProfilePO.getVoiceNetworkId()));
            }
            Optional.ofNullable(this.lanProfileMaintMongoRepository.a(lanProfilePO)).ifPresent(dbLanProfilePO -> netIdsMap.put(originalId, dbLanProfilePO.getId()));
        }));
    }

    private void handleLanNetwork(@Nonnull c omadacId, @Nonnull d newSiteId, @Nonnull WiredNetworkDTO wiredNetworkDTO, Map<String, Map<String, String>> siteImportIdCacheMap, boolean isSiteCopy) {
        this.lanNetworkMaintMongoRepository.c(omadacId, newSiteId).ifPresent(lanNetworkPO -> this.lanNetworkMaintMongoRepository.a(omadacId, newSiteId, lanNetworkPO.getId()));
        Map netIdsMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), v2 -> new HashMap());
        Map<String, String> portalIdMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.ad.A());
        Optional.ofNullable(wiredNetworkDTO.getLanNetworks()).ifPresent(lanNetworks -> lanNetworks.forEach(lanNetworkPO -> {
            String oldLanNetworkId = lanNetworkPO.getId();
            lanNetworkPO.setOmadacId(omadacId.a());
            lanNetworkPO.setSiteId(newSiteId.a());
            lanNetworkPO.setId(null);
            lanNetworkPO.setTemplateId(null);
            lanNetworkPO.setOverride(null);
            if (isSiteCopy) {
                lanNetworkPO.setDeviceMac(null);
                lanNetworkPO.setStackId(null);
            }
            if (!CollectionUtils.isEmpty((Map)portalIdMap) && portalIdMap.containsKey(lanNetworkPO.getPortalId())) {
                lanNetworkPO.setPortalId((String)portalIdMap.get(lanNetworkPO.getPortalId()));
            }
            netIdsMap.put(oldLanNetworkId, (lanNetworkPO = this.lanNetworkMaintMongoRepository.a(lanNetworkPO)) == null ? null : lanNetworkPO.getId());
        }));
    }

    private void handleLanDns(@Nonnull c omadacId, @Nonnull d newSiteId, @Nonnull WiredNetworkDTO wiredNetworkDTO, Map<String, Map<String, String>> siteImportIdCacheMap) {
        this.lanDnsMaintMongoRepository.b(omadacId, newSiteId);
        Map netIdsMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), v2 -> new HashMap());
        Optional.ofNullable(wiredNetworkDTO.getLanDnsList()).ifPresent(lanDnsList -> lanDnsList.forEach(lanDns -> {
            lanDns.setOmadacId(omadacId.a());
            lanDns.setSiteId(newSiteId.a());
            if (!CollectionUtils.isEmpty((Collection)lanDns.getLanNetworkIds())) {
                lanDns.setLanNetworkIds(e.a((List)lanDns.getLanNetworkIds(), (Map)netIdsMap));
            }
            lanDns.setId(null);
            lanDns.setTemplateId(null);
            lanDns.setOverride(null);
            this.lanDnsMaintMongoRepository.a(lanDns);
        }));
    }

    private void handleVirtualWan(@Nonnull c omadacId, @Nonnull d newSiteId, @Nonnull WiredNetworkDTO wiredNetworkDTO, Map<String, Map<String, String>> siteImportIdCacheMap) {
        this.virtualWanMaintMongoRepository.a(omadacId, newSiteId, n.a);
        Map netIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), v2 -> new HashMap());
        Optional.ofNullable(wiredNetworkDTO.getVirtualWanList()).ifPresent(virtualWanList -> virtualWanList.forEach(virtualWan -> {
            virtualWan.setOmadacId(omadacId.a());
            virtualWan.setSiteId(newSiteId.a());
            String oldVirtualWanId = virtualWan.getId();
            virtualWan.setId(null);
            virtualWan.setTemplateId(null);
            virtualWan.setOverride(null);
            VirtualWanPO virtualWanPO = this.virtualWanMaintMongoRepository.a(virtualWan);
            netIdMap.put(oldVirtualWanId, virtualWanPO == null ? null : virtualWanPO.getId());
        }));
    }

    private void handleLoadBalance(@Nonnull c omadacId, @Nonnull d newSiteId, @Nonnull WiredNetworkDTO wiredNetworkDTO, Map<String, Map<String, String>> siteImportIdCacheMap) {
        Map netIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), v2 -> new HashMap());
        List<InternetPO> InternetPOs = Objects.isNull(wiredNetworkDTO.getInternet()) ? wiredNetworkDTO.getInternetList() : List.of(wiredNetworkDTO.getInternet());
        Optional.ofNullable(InternetPOs).ifPresent(internets -> internets.forEach(internetPO -> {
            if (internetPO.getWanLoadBalance() != null && !CollectionUtils.isEmpty((Collection)internetPO.getWanLoadBalance().getVirtualWanWeights())) {
                for (VirtualWanWeightPO virtualWanWeightPO : internetPO.getWanLoadBalance().getVirtualWanWeights()) {
                    virtualWanWeightPO.setVirtualWanId((String)netIdMap.get(virtualWanWeightPO.getVirtualWanId()));
                }
            }
            this.internetMaintMongoRepository.a(internetPO);
        }));
    }

    private void handleInternet(@Nonnull c omadacId, @Nonnull d newSiteId, @Nonnull WiredNetworkDTO wiredNetworkDTO, Map<String, String> profileMap, boolean isSiteCopy) {
        List<InternetPO> InternetPOs = Objects.isNull(wiredNetworkDTO.getInternet()) ? wiredNetworkDTO.getInternetList() : List.of(wiredNetworkDTO.getInternet());
        Optional.ofNullable(InternetPOs).ifPresent(internets -> internets.forEach(internetPO -> {
            if (isSiteCopy && !Objects.isNull(internetPO.getMac())) {
                return;
            }
            internetPO.setOmadacId(omadacId.a());
            internetPO.setSiteId(newSiteId.a());
            internetPO.setId(null);
            internetPO.setTemplateId(null);
            internetPO.setOverride(null);
            if (!CollectionUtils.isEmpty((Collection)internetPO.getWanPortIpv4Settings())) {
                internetPO.getWanPortIpv4Settings().forEach(wanPortIpv4SettingPO -> {
                    if (wanPortIpv4SettingPO.getIpv4Pppoe() != null && wanPortIpv4SettingPO.getIpv4Pppoe().getMru() == null) {
                        wanPortIpv4SettingPO.getIpv4Pppoe().setMru(wanPortIpv4SettingPO.getIpv4Pppoe().getMtu());
                    }
                });
            }
            this.handleInternetApnProfile(profileMap, (BaseInternetPO)internetPO);
            this.internetMaintMongoRepository.a(internetPO);
        }));
    }

    private void handleInternetApnProfile(Map<String, String> profileMap, BaseInternetPO internetPO) {
        if (!CollectionUtils.isEmpty((Collection)internetPO.getLteWanSettings())) {
            for (LteWanSettingPO lteWanSettingPO : internetPO.getLteWanSettings()) {
                if (!CollectionUtils.isEmpty((Collection)lteWanSettingPO.getDialUpSettings())) {
                    lteWanSettingPO.getSingleDialupSettingPO(G.a).ifPresent(dialUpSettingPO -> {
                        if (Objects.equals(dialUpSettingPO.getApnMode(), 1)) {
                            dialUpSettingPO.setApn((String)profileMap.get(dialUpSettingPO.getApn()));
                        }
                    });
                    lteWanSettingPO.getSingleDialupSettingPO(G.b).ifPresent(dialUpSettingPO -> {
                        if (Objects.equals(dialUpSettingPO.getApnMode(), 1)) {
                            dialUpSettingPO.setApn((String)profileMap.get(dialUpSettingPO.getApn()));
                        }
                    });
                    continue;
                }
                if (lteWanSettingPO.getDialupSetting() == null || !Objects.equals(lteWanSettingPO.getDialupSetting().getApnMode(), 1)) continue;
                lteWanSettingPO.getDialupSetting().setApn(profileMap.get(lteWanSettingPO.getDialupSetting().getApn()));
            }
        }
    }

    private void handleWanPortSetting(InternetPO internetPO) {
        List wanPortIpv4SettingPOS = Optional.ofNullable(internetPO.getWanPortIpv4Settings()).orElse(new ArrayList());
        List wanPortIpv6SettingPOS = Optional.ofNullable(internetPO.getWanPortIpv6Settings()).orElse(new ArrayList());
        Optional modelConfigPO = this.osgModelConfigMainMongoRepository.a(new c(internetPO.getOmadacId()), new d(internetPO.getSiteId()));
        modelConfigPO.ifPresent(osgModelConfigPO -> {
            AtomicBoolean needUpdateLoadBalance = new AtomicBoolean(false);
            osgModelConfigPO.getOsgPortInfos().forEach(osgPortPreInfoPO -> {
                if (this.isWanOrSfpWan(osgPortPreInfoPO.getType()) && !internetPO.getWanPortUuids().contains(osgPortPreInfoPO.getPortUuid())) {
                    internetPO.getWanPortUuids().add(osgPortPreInfoPO.getPortUuid());
                    wanPortIpv4SettingPOS.add(com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.a.b((String)osgPortPreInfoPO.getPortUuid()));
                    internetPO.setWanPortIpv4Settings(wanPortIpv4SettingPOS);
                    wanPortIpv6SettingPOS.add(com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.a.a((String)osgPortPreInfoPO.getPortUuid()));
                    internetPO.setWanPortIpv6Settings(wanPortIpv6SettingPOS);
                    needUpdateLoadBalance.set(true);
                }
            });
            if (Boolean.TRUE.equals(needUpdateLoadBalance.get())) {
                WanLoadBalancePO oldWanLoadBalance = internetPO.getWanLoadBalance();
                HashMap osgPortTypeMap = new HashMap();
                ((OsgModelConfigPO)modelConfigPO.get()).getOsgPortInfos().forEach(osgPortPreInfoPO -> osgPortTypeMap.put(osgPortPreInfoPO.getPortUuid(), osgPortPreInfoPO.getType()));
                internetPO.setWanLoadBalance(com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.a.a((WanLoadBalancePO)oldWanLoadBalance, (List)internetPO.getWanPortUuids(), osgPortTypeMap));
            }
        });
    }

    private boolean isWanOrSfpWan(int type) {
        return type == o.g || type == o.d;
    }
}

