/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.wirednetwork.restore.v5;

import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.core.d.j;
import com.tplink.smb.omada.backup.core.unit.siteconfig.wirednetwork.dto.WiredNetworkDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.wirednetwork.restore.v5.a;
import com.tplink.smb.omada.common.constant.G;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.b.b;
import com.tplink.smb.omada.common.util.e;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.h;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.landns.BaseLanDnsPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lannetwork.BaseLanNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lannetwork.LanNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lanprofile.BaseLanProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.virtualwan.VirtualWanPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.virtualwan.VirtualWanTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.BaseInternetPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.DialupSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.InternetPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.LteWanSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.ManuallyConfigPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.UsbLteSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.VirtualWanWeightPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.osgmodel.OsgModelConfigPO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.OsgPO;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V60000, b=d.WIRED_NETWORK)
public class WiredNetworkRestoreUnitV60000
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WiredNetworkRestoreUnitV60000.class);
    private final g osgModelConfigMainMongoRepository = g.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.a internetMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c lanNetworkMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.e lanProfileMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.e.a();
    private final h virtualWanMaintMongoRepository = h.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.b lanDnsMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.b.a();
    private static final WiredNetworkRestoreUnitV60000 instance = new WiredNetworkRestoreUnitV60000();

    private WiredNetworkRestoreUnitV60000() {
    }

    public static WiredNetworkRestoreUnitV60000 getInstance() {
        return instance;
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        WiredNetworkDTO wiredNetworkDTO = (WiredNetworkDTO)jsonParserWrapper.a(WiredNetworkDTO.class);
        if (wiredNetworkDTO == null) {
            log.warn("omadacId={} Wired Network v5 Restore dto is null.", (Object)omadacId.a());
            return;
        }
        Map newSiteIdMap = (Map)restoreCacheMap.computeIfAbsent(d.Q.A(), k2 -> new HashMap());
        Map netIdsMap = (Map)restoreCacheMap.computeIfAbsent(d.af.A(), v2 -> new HashMap());
        Map profileMap = (Map)restoreCacheMap.computeIfAbsent(d.Y.A(), v2 -> new HashMap());
        String aesKeyInFile = (String)restoreCacheMap.get("AES_KEY_IN_FILE");
        this.handleLanNetworkTemplate(omadacId, newSiteIdMap, wiredNetworkDTO, restoreCacheMap, netIdsMap);
        this.handleOsgModelConfigTemplate(omadacId, newSiteIdMap, wiredNetworkDTO);
        this.handleInternetTemplate(omadacId, newSiteIdMap, profileMap, wiredNetworkDTO, aesKeyInFile);
        this.handleLanProfileTemplate(omadacId, newSiteIdMap, wiredNetworkDTO, restoreCacheMap, netIdsMap);
        this.handleLanDnsTemplate(omadacId, newSiteIdMap, wiredNetworkDTO, restoreCacheMap, netIdsMap);
        this.handleVirtualWanTemplate(omadacId, newSiteIdMap, wiredNetworkDTO, restoreCacheMap, netIdsMap);
        this.handleLoadBalanceTemplate(omadacId, newSiteIdMap, wiredNetworkDTO, restoreCacheMap, netIdsMap);
        this.handleOsgModelConfig(omadacId, newSiteIdMap, wiredNetworkDTO);
        this.handleInternet(omadacId, newSiteIdMap, profileMap, wiredNetworkDTO, aesKeyInFile);
        this.handleLanNetwork(omadacId, newSiteIdMap, wiredNetworkDTO, restoreCacheMap, netIdsMap);
        this.handleLanProfile(omadacId, newSiteIdMap, wiredNetworkDTO, restoreCacheMap, netIdsMap);
        this.handleLanDns(omadacId, newSiteIdMap, wiredNetworkDTO, restoreCacheMap, netIdsMap);
        this.handleVirtualWan(omadacId, newSiteIdMap, wiredNetworkDTO, restoreCacheMap, netIdsMap);
        this.handleLoadBalance(omadacId, newSiteIdMap, wiredNetworkDTO, restoreCacheMap, netIdsMap);
    }

    private void handleVirtualWan(@Nonnull c omadacId, @Nonnull Map<String, String> newSiteIdMap, @Nonnull WiredNetworkDTO wiredNetworkDTO, Map<String, Object> restoreCacheMap, Map<String, String> netIdsMap) {
        Optional.ofNullable(wiredNetworkDTO.getVirtualWanList()).ifPresent(virtualWanList -> virtualWanList.forEach(virtualWan -> {
            virtualWan.setOmadacId(omadacId.a());
            if (newSiteIdMap.containsKey(virtualWan.getSiteId())) {
                virtualWan.setSiteId((String)newSiteIdMap.get(virtualWan.getSiteId()));
            }
            String oldVirtualWanId = virtualWan.getId();
            virtualWan.setId(null);
            VirtualWanPO virtualWanPO = this.virtualWanMaintMongoRepository.a(virtualWan);
            netIdsMap.put(oldVirtualWanId, virtualWanPO == null ? null : virtualWanPO.getId());
        }));
    }

    private void handleVirtualWanTemplate(@Nonnull c omadacId, @Nonnull Map<String, String> newSiteIdMap, @Nonnull WiredNetworkDTO wiredNetworkDTO, Map<String, Object> restoreCacheMap, Map<String, String> netIdsMap) {
        Optional.ofNullable(wiredNetworkDTO.getVirtualWanTemplate()).ifPresent(virtualWanTemplateList -> virtualWanTemplateList.forEach(virtualWanTemplate -> {
            virtualWanTemplate.setOmadacId(omadacId.a());
            if (newSiteIdMap.containsKey(virtualWanTemplate.getSiteTemplateId())) {
                virtualWanTemplate.setSiteTemplateId((String)newSiteIdMap.get(virtualWanTemplate.getSiteTemplateId()));
            }
            String oldVirtualWanTemplateId = virtualWanTemplate.getId();
            virtualWanTemplate.setId(null);
            VirtualWanTemplatePO virtualWanTemplatePO = this.virtualWanMaintMongoRepository.a(virtualWanTemplate);
            netIdsMap.put(oldVirtualWanTemplateId, virtualWanTemplatePO == null ? null : virtualWanTemplatePO.getId());
        }));
    }

    private void handleLoadBalance(@Nonnull c omadacId, @Nonnull Map<String, String> newSiteIdMap, @Nonnull WiredNetworkDTO wiredNetworkDTO, Map<String, Object> restoreCacheMap, Map<String, String> netIdsMap) {
        List<InternetPO> InternetPOs = Objects.isNull(wiredNetworkDTO.getInternet()) ? wiredNetworkDTO.getInternetList() : List.of(wiredNetworkDTO.getInternet());
        Optional.ofNullable(InternetPOs).ifPresent(internets -> internets.forEach(internetPO -> {
            if (internetPO.getWanLoadBalance() != null && !CollectionUtils.isEmpty((Collection)internetPO.getWanLoadBalance().getVirtualWanWeights())) {
                for (VirtualWanWeightPO virtualWanWeightPO : internetPO.getWanLoadBalance().getVirtualWanWeights()) {
                    virtualWanWeightPO.setVirtualWanId((String)netIdsMap.get(virtualWanWeightPO.getVirtualWanId()));
                }
            }
            this.internetMaintMongoRepository.a(internetPO);
        }));
    }

    private void handleLoadBalanceTemplate(@Nonnull c omadacId, @Nonnull Map<String, String> newSiteIdMap, @Nonnull WiredNetworkDTO wiredNetworkDTO, Map<String, Object> restoreCacheMap, Map<String, String> netIdsMap) {
        Optional.ofNullable(wiredNetworkDTO.getInternetTemplate()).ifPresent(internetTemplatePO -> {
            if (internetTemplatePO.getWanLoadBalance() != null && !CollectionUtils.isEmpty((Collection)internetTemplatePO.getWanLoadBalance().getVirtualWanWeights())) {
                for (VirtualWanWeightPO virtualWanWeightPO : internetTemplatePO.getWanLoadBalance().getVirtualWanWeights()) {
                    virtualWanWeightPO.setVirtualWanId((String)netIdsMap.get(virtualWanWeightPO.getVirtualWanId()));
                }
            }
            this.internetMaintMongoRepository.a(internetTemplatePO);
        });
    }

    private void handleLanDns(@Nonnull c omadacId, @Nonnull Map<String, String> newSiteIdMap, @Nonnull WiredNetworkDTO wiredNetworkDTO, Map<String, Object> restoreCacheMap, Map<String, String> netIdsMap) {
        Optional.ofNullable(wiredNetworkDTO.getLanDnsList()).ifPresent(lanDnsList -> lanDnsList.forEach(lanDns -> {
            lanDns.setOmadacId(omadacId.a());
            if (newSiteIdMap.containsKey(lanDns.getSiteId())) {
                lanDns.setSiteId((String)newSiteIdMap.get(lanDns.getSiteId()));
            }
            if (Objects.nonNull(lanDns.getLanNetworkIds())) {
                lanDns.setLanNetworkIds(e.a((List)lanDns.getLanNetworkIds(), (Map)netIdsMap));
            }
            lanDns.setId(null);
            if (lanDns.getTemplateId() != null) {
                lanDns.setTemplateId((String)netIdsMap.get(lanDns.getTemplateId()));
            }
            this.lanDnsMaintMongoRepository.a(lanDns);
        }));
    }

    private void handleLanDnsTemplate(@Nonnull c omadacId, @Nonnull Map<String, String> newSiteIdMap, @Nonnull WiredNetworkDTO wiredNetworkDTO, Map<String, Object> restoreCacheMap, Map<String, String> netIdsMap) {
        Optional.ofNullable(wiredNetworkDTO.getLanDnsTemplate()).ifPresent(lanDnsList -> lanDnsList.forEach(lanDns -> {
            lanDns.setOmadacId(omadacId.a());
            if (newSiteIdMap.containsKey(lanDns.getSiteTemplateId())) {
                lanDns.setSiteTemplateId((String)newSiteIdMap.get(lanDns.getSiteTemplateId()));
            }
            if (Objects.nonNull(lanDns.getLanNetworkIds())) {
                lanDns.setLanNetworkIds(e.a((List)lanDns.getLanNetworkIds(), (Map)netIdsMap));
            }
            String originId = lanDns.getId();
            lanDns.setId(null);
            this.lanDnsMaintMongoRepository.a(lanDns);
            netIdsMap.put(originId, Optional.ofNullable(this.lanDnsMaintMongoRepository.a(lanDns)).map(BaseLanDnsPO::getId).orElse(null));
        }));
    }

    private void handleLanProfile(@Nonnull c omadacId, @Nonnull Map<String, String> newSiteIdMap, @Nonnull WiredNetworkDTO wiredNetworkDTO, Map<String, Object> restoreCacheMap, Map<String, String> netIdsMap) {
        Optional.ofNullable(wiredNetworkDTO.getLanProfiles()).ifPresent(lanProfiles -> lanProfiles.forEach(lanProfilePO -> {
            lanProfilePO.setOmadacId(omadacId.a());
            if (newSiteIdMap.containsKey(lanProfilePO.getSiteId())) {
                lanProfilePO.setSiteId((String)newSiteIdMap.get(lanProfilePO.getSiteId()));
            }
            String originalLanProfileId = lanProfilePO.getId();
            lanProfilePO.setId(null);
            if (lanProfilePO.getTemplateId() != null) {
                lanProfilePO.setTemplateId((String)netIdsMap.get(lanProfilePO.getTemplateId()));
            }
            if (lanProfilePO.getNativeNetworkId() != null) {
                lanProfilePO.setNativeNetworkId((String)netIdsMap.get(lanProfilePO.getNativeNetworkId()));
            }
            if (lanProfilePO.getTagNetworkIds() != null) {
                lanProfilePO.setTagNetworkIds(e.a((List)lanProfilePO.getTagNetworkIds(), (Map)netIdsMap));
            }
            if (lanProfilePO.getTagBridgeVlanMap() != null) {
                lanProfilePO.setTagBridgeVlanMap(j.a(lanProfilePO.getTagBridgeVlanMap(), netIdsMap));
            }
            if (lanProfilePO.getEsEnableTaggedNetworkIds() != null) {
                lanProfilePO.setEsEnableTaggedNetworkIds(e.a((List)lanProfilePO.getEsEnableTaggedNetworkIds(), (Map)netIdsMap));
            }
            if (lanProfilePO.getEsEnableTagBridgeVlanMap() != null) {
                lanProfilePO.setEsEnableTagBridgeVlanMap(j.a(lanProfilePO.getEsEnableTagBridgeVlanMap(), netIdsMap));
            }
            if (lanProfilePO.getUntagNetworkIds() != null) {
                lanProfilePO.setUntagNetworkIds(e.a((List)lanProfilePO.getUntagNetworkIds(), (Map)netIdsMap));
            }
            if (lanProfilePO.getUntagBridgeVlanMap() != null) {
                lanProfilePO.setUntagBridgeVlanMap(j.a(lanProfilePO.getUntagBridgeVlanMap(), netIdsMap));
            }
            if (lanProfilePO.getVoiceNetworkId() != null) {
                lanProfilePO.setVoiceNetworkId((String)netIdsMap.get(lanProfilePO.getVoiceNetworkId()));
            }
            netIdsMap.put(originalLanProfileId, Optional.ofNullable(this.lanProfileMaintMongoRepository.a(lanProfilePO)).map(BaseLanProfilePO::getId).orElse(null));
        }));
    }

    private void handleLanProfileTemplate(@Nonnull c omadacId, @Nonnull Map<String, String> newSiteIdMap, @Nonnull WiredNetworkDTO wiredNetworkDTO, Map<String, Object> restoreCacheMap, Map<String, String> netIdsMap) {
        Optional.ofNullable(wiredNetworkDTO.getLanProfileTemplate()).ifPresent(lanProfiles -> lanProfiles.forEach(lanProfilePO -> {
            lanProfilePO.setOmadacId(omadacId.a());
            if (newSiteIdMap.containsKey(lanProfilePO.getSiteTemplateId())) {
                lanProfilePO.setSiteTemplateId((String)newSiteIdMap.get(lanProfilePO.getSiteTemplateId()));
            }
            String originalLanProfileId = lanProfilePO.getId();
            lanProfilePO.setId(null);
            if (lanProfilePO.getNativeNetworkId() != null) {
                lanProfilePO.setNativeNetworkId((String)netIdsMap.get(lanProfilePO.getNativeNetworkId()));
            }
            if (lanProfilePO.getTagNetworkIds() != null) {
                lanProfilePO.setTagNetworkIds(e.a((List)lanProfilePO.getTagNetworkIds(), (Map)netIdsMap));
            }
            if (lanProfilePO.getTagBridgeVlanMap() != null) {
                lanProfilePO.setTagBridgeVlanMap(j.a(lanProfilePO.getTagBridgeVlanMap(), netIdsMap));
            }
            if (lanProfilePO.getEsEnableTaggedNetworkIds() != null) {
                lanProfilePO.setEsEnableTaggedNetworkIds(e.a((List)lanProfilePO.getEsEnableTaggedNetworkIds(), (Map)netIdsMap));
            }
            if (lanProfilePO.getEsEnableTagBridgeVlanMap() != null) {
                lanProfilePO.setEsEnableTagBridgeVlanMap(j.a(lanProfilePO.getEsEnableTagBridgeVlanMap(), netIdsMap));
            }
            if (lanProfilePO.getUntagNetworkIds() != null) {
                lanProfilePO.setUntagNetworkIds(e.a((List)lanProfilePO.getUntagNetworkIds(), (Map)netIdsMap));
            }
            if (lanProfilePO.getUntagBridgeVlanMap() != null) {
                lanProfilePO.setUntagBridgeVlanMap(j.a(lanProfilePO.getUntagBridgeVlanMap(), netIdsMap));
            }
            if (lanProfilePO.getVoiceNetworkId() != null) {
                lanProfilePO.setVoiceNetworkId((String)netIdsMap.get(lanProfilePO.getVoiceNetworkId()));
            }
            netIdsMap.put(originalLanProfileId, Optional.ofNullable(this.lanProfileMaintMongoRepository.a(lanProfilePO)).map(BaseLanProfilePO::getId).orElse(null));
        }));
    }

    public static Map<String, Set<Integer>> transformIds(Map<String, Set<Integer>> oldBridgeVlanMap, Map<String, String> netIdsMap) {
        if (CollectionUtils.isEmpty(oldBridgeVlanMap)) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<Integer>> newBridgeVlanMap = new HashMap<String, Set<Integer>>(oldBridgeVlanMap.size());
        oldBridgeVlanMap.forEach((oldNetId, vlans) -> newBridgeVlanMap.put((String)netIdsMap.get(oldNetId), (Set<Integer>)vlans));
        return newBridgeVlanMap;
    }

    private void handleLanNetwork(@Nonnull c omadacId, @Nonnull Map<String, String> newSiteIdMap, @Nonnull WiredNetworkDTO wiredNetworkDTO, Map<String, Object> restoreCacheMap, Map<String, String> netIdsMap) {
        Map portalIdMap = (Map)restoreCacheMap.get(d.ad.A());
        Optional.ofNullable(wiredNetworkDTO.getLanNetworks()).ifPresent(lanNetworks -> lanNetworks.forEach(lanNetworkPO -> {
            String oldLanNetworkId = lanNetworkPO.getId();
            lanNetworkPO.setOmadacId(omadacId.a());
            if (newSiteIdMap.containsKey(lanNetworkPO.getSiteId())) {
                lanNetworkPO.setSiteId((String)newSiteIdMap.get(lanNetworkPO.getSiteId()));
            }
            if (lanNetworkPO.getTemplateId() != null) {
                lanNetworkPO.setTemplateId((String)netIdsMap.get(lanNetworkPO.getTemplateId()));
            }
            lanNetworkPO.setId(null);
            if (!CollectionUtils.isEmpty((Map)portalIdMap) && portalIdMap.containsKey(lanNetworkPO.getPortalId())) {
                lanNetworkPO.setPortalId((String)portalIdMap.get(lanNetworkPO.getPortalId()));
            }
            a.a((BaseLanNetworkPO)lanNetworkPO);
            this.handleIntegratedGatewayLanNetwork((LanNetworkPO)lanNetworkPO, restoreCacheMap);
            lanNetworkPO = this.lanNetworkMaintMongoRepository.a(lanNetworkPO);
            netIdsMap.put(oldLanNetworkId, lanNetworkPO == null ? null : lanNetworkPO.getId());
        }));
    }

    private void handleIntegratedGatewayLanNetwork(LanNetworkPO lanNetworkPO, Map<String, Object> restoreCacheMap) {
        if (!OmadacType.t()) {
            return;
        }
        String defaultSiteId = (String)restoreCacheMap.get("DEFAULT_SITE");
        if (!Objects.equals(lanNetworkPO.getSiteId(), defaultSiteId)) {
            return;
        }
        OsgPO integratedGateway = (OsgPO)restoreCacheMap.get("integrated_gateway");
        if (integratedGateway == null) {
            return;
        }
        if ("interface".equals(lanNetworkPO.getPurpose())) {
            lanNetworkPO.setDeviceMac(integratedGateway.getMac());
        }
    }

    private void handleLanNetworkTemplate(c omadacId, Map<String, String> newSiteIdMap, WiredNetworkDTO wiredNetworkDTO, Map<String, Object> restoreCacheMap, Map<String, String> netIdsMap) {
        Map portalIdMap = restoreCacheMap.getOrDefault(d.ad.A(), new HashMap());
        Optional.ofNullable(wiredNetworkDTO.getLanNetworksTemplate()).ifPresent(lanNetworks -> lanNetworks.forEach(lanNetworkPO -> {
            String oldLanNetworkId = lanNetworkPO.getId();
            lanNetworkPO.setOmadacId(omadacId.a());
            if (newSiteIdMap.containsKey(lanNetworkPO.getSiteTemplateId())) {
                lanNetworkPO.setSiteTemplateId((String)newSiteIdMap.get(lanNetworkPO.getSiteTemplateId()));
            }
            lanNetworkPO.setId(null);
            if (!CollectionUtils.isEmpty((Map)portalIdMap) && portalIdMap.containsKey(lanNetworkPO.getPortalId())) {
                lanNetworkPO.setPortalId((String)portalIdMap.get(lanNetworkPO.getPortalId()));
            }
            a.a((BaseLanNetworkPO)lanNetworkPO);
            String newNetworkId = this.lanNetworkMaintMongoRepository.a(lanNetworkPO);
            netIdsMap.put(oldLanNetworkId, newNetworkId);
        }));
    }

    private void handleInternet(@Nonnull c omadacId, @Nonnull Map<String, String> newSiteIdMap, @Nonnull Map<String, String> profileMap, @Nonnull WiredNetworkDTO wiredNetworkDTO, String aesKeyInFile) {
        List<InternetPO> InternetPOs = Objects.isNull(wiredNetworkDTO.getInternet()) ? wiredNetworkDTO.getInternetList() : List.of(wiredNetworkDTO.getInternet());
        Optional.ofNullable(InternetPOs).ifPresent(internets -> internets.forEach(internetPO -> {
            internetPO.setOmadacId(omadacId.a());
            if (newSiteIdMap.containsKey(internetPO.getSiteId())) {
                internetPO.setSiteId((String)newSiteIdMap.get(internetPO.getSiteId()));
            }
            internetPO.setId(null);
            this.handleUsbEncrypt((BaseInternetPO)internetPO, aesKeyInFile);
            if (!CollectionUtils.isEmpty((Collection)internetPO.getWanPortIpv4Settings())) {
                internetPO.getWanPortIpv4Settings().forEach(wanPortIpv4SettingPO -> {
                    if (wanPortIpv4SettingPO.getIpv4Pppoe() != null && wanPortIpv4SettingPO.getIpv4Pppoe().getMru() == null) {
                        wanPortIpv4SettingPO.getIpv4Pppoe().setMru(wanPortIpv4SettingPO.getIpv4Pppoe().getMtu());
                    }
                });
            }
            this.handleInternetApnProfile(profileMap, (BaseInternetPO)internetPO);
            this.internetMaintMongoRepository.a(internetPO);
        }));
    }

    private void handleInternetTemplate(@Nonnull c omadacId, @Nonnull Map<String, String> newSiteIdMap, @Nonnull Map<String, String> profileMap, @Nonnull WiredNetworkDTO wiredNetworkDTO, String aesKeyInFile) {
        Optional.ofNullable(wiredNetworkDTO.getInternetTemplate()).ifPresent(internetTemplatePO -> {
            internetTemplatePO.setOmadacId(omadacId.a());
            if (newSiteIdMap.containsKey(internetTemplatePO.getSiteTemplateId())) {
                internetTemplatePO.setSiteTemplateId((String)newSiteIdMap.get(internetTemplatePO.getSiteTemplateId()));
            }
            internetTemplatePO.setId(null);
            this.handleUsbEncrypt((BaseInternetPO)internetTemplatePO, aesKeyInFile);
            internetTemplatePO.getWanPortIpv4Settings().forEach(wanPortIpv4SettingPO -> {
                if (wanPortIpv4SettingPO.getIpv4Pppoe() != null && wanPortIpv4SettingPO.getIpv4Pppoe().getMru() == null) {
                    wanPortIpv4SettingPO.getIpv4Pppoe().setMru(wanPortIpv4SettingPO.getIpv4Pppoe().getMtu());
                }
            });
            this.internetMaintMongoRepository.a(internetTemplatePO);
        });
    }

    private void handleInternetApnProfile(Map<String, String> profileMap, BaseInternetPO internetPO) {
        if (!CollectionUtils.isEmpty((Collection)internetPO.getLteWanSettings())) {
            for (LteWanSettingPO lteWanSettingPO : internetPO.getLteWanSettings()) {
                if (lteWanSettingPO.getDialupSetting() != null && Objects.equals(lteWanSettingPO.getDialupSetting().getApnMode(), 1)) {
                    lteWanSettingPO.getDialupSetting().setApn(profileMap.get(lteWanSettingPO.getDialupSetting().getApn()));
                }
                if (CollectionUtils.isEmpty((Collection)lteWanSettingPO.getDialUpSettings())) continue;
                lteWanSettingPO.getSingleDialupSettingPO(G.a).ifPresent(dialUpSettingPO -> {
                    if (Objects.equals(dialUpSettingPO.getApnMode(), 1)) {
                        dialUpSettingPO.setApn((String)profileMap.get(dialUpSettingPO.getApn()));
                    }
                    if (lteWanSettingPO.getDialupSetting() == null) {
                        lteWanSettingPO.setDataRoaming(dialUpSettingPO.getDataRoaming());
                        lteWanSettingPO.setNetworkMode(dialUpSettingPO.getNetworkMode());
                        lteWanSettingPO.setBandMode(dialUpSettingPO.getBandMode());
                        lteWanSettingPO.setBands(dialUpSettingPO.getBands());
                        DialupSettingPO dialupSettingPO = new DialupSettingPO().setNetSearchMode(dialUpSettingPO.getNetSearchMode()).setIsp(dialUpSettingPO.getIsp()).setIspNum(dialUpSettingPO.getIspNum()).setApnMode(dialUpSettingPO.getApnMode()).setApn(dialUpSettingPO.getApn()).setFailoverTimeout(dialUpSettingPO.getFailoverTimeout()).setDataRoaming(dialUpSettingPO.getDataRoaming()).setNetworkMode(dialUpSettingPO.getNetworkMode()).setBandMode(dialUpSettingPO.getBandMode()).setBands(dialUpSettingPO.getBands());
                        lteWanSettingPO.setDialupSetting(dialupSettingPO);
                    }
                });
                lteWanSettingPO.getSingleDialupSettingPO(G.b).ifPresent(dialUpSettingPO -> {
                    if (Objects.equals(dialUpSettingPO.getApnMode(), 1)) {
                        dialUpSettingPO.setApn((String)profileMap.get(dialUpSettingPO.getApn()));
                    }
                });
            }
        }
    }

    private void handleOsgModelConfig(@Nonnull c omadacId, @Nonnull Map<String, String> newSiteIdMap, @Nonnull WiredNetworkDTO wiredNetworkDTO) {
        List<OsgModelConfigPO> osgModelConfigPOs = Objects.isNull(wiredNetworkDTO.getOsgModelConfig()) ? wiredNetworkDTO.getOsgModelConfigList() : List.of(wiredNetworkDTO.getOsgModelConfig());
        Optional.ofNullable(osgModelConfigPOs).ifPresent(osgModelConfigs -> osgModelConfigs.forEach(osgModelConfig -> {
            osgModelConfig.setOmadacId(omadacId.a());
            if (newSiteIdMap.containsKey(osgModelConfig.getSiteId())) {
                osgModelConfig.setSiteId((String)newSiteIdMap.get(osgModelConfig.getSiteId()));
            }
            osgModelConfig.setId(null);
            this.osgModelConfigMainMongoRepository.a(osgModelConfig);
        }));
    }

    private void handleOsgModelConfigTemplate(@Nonnull c omadacId, @Nonnull Map<String, String> newSiteIdMap, @Nonnull WiredNetworkDTO wiredNetworkDTO) {
        Optional.ofNullable(wiredNetworkDTO.getOsgModelConfigTemplate()).ifPresent(osgModelConfigTemplatePO -> {
            osgModelConfigTemplatePO.setOmadacId(omadacId.a());
            if (newSiteIdMap.containsKey(osgModelConfigTemplatePO.getSiteTemplateId())) {
                osgModelConfigTemplatePO.setSiteTemplateId((String)newSiteIdMap.get(osgModelConfigTemplatePO.getSiteTemplateId()));
            }
            osgModelConfigTemplatePO.setId(null);
            this.osgModelConfigMainMongoRepository.a(osgModelConfigTemplatePO);
        });
    }

    private void handleUsbEncrypt(BaseInternetPO internetPO, String aesKeyInFile) {
        List usbLteSettingPOS = internetPO.getUsbLteSettings();
        if (CollectionUtils.isEmpty((Collection)usbLteSettingPOS)) {
            return;
        }
        for (UsbLteSettingPO usbLteSettingPO : usbLteSettingPOS) {
            if (usbLteSettingPO.getManuallyConfig() != null) {
                ManuallyConfigPO manuallyConfigPO = usbLteSettingPO.getManuallyConfig();
                if (manuallyConfigPO.getEncryptPassword() == null) {
                    manuallyConfigPO.setEncryptPassword(b.c((String)manuallyConfigPO.getPassword()));
                } else if (OmadacType.s() && !T.a((String)aesKeyInFile)) {
                    manuallyConfigPO.setEncryptPassword(b.c((String)b.a((String)manuallyConfigPO.getEncryptPassword(), (String)aesKeyInFile)));
                } else if (!OmadacType.s() && T.a((String)aesKeyInFile)) {
                    manuallyConfigPO.setEncryptPassword(b.c((String)b.e((String)manuallyConfigPO.getEncryptPassword())));
                }
                if (manuallyConfigPO.getEncryptUsername() == null) {
                    manuallyConfigPO.setEncryptUsername(b.c((String)manuallyConfigPO.getUsername()));
                } else if (OmadacType.s() && !T.a((String)aesKeyInFile)) {
                    manuallyConfigPO.setEncryptUsername(b.c((String)b.a((String)manuallyConfigPO.getEncryptUsername(), (String)aesKeyInFile)));
                } else if (!OmadacType.s() && T.a((String)aesKeyInFile)) {
                    manuallyConfigPO.setEncryptUsername(b.c((String)b.e((String)manuallyConfigPO.getEncryptUsername())));
                }
                if (OmadacType.s()) {
                    manuallyConfigPO.setUsername(b.e((String)manuallyConfigPO.getEncryptUsername()));
                    manuallyConfigPO.setPassword(b.e((String)manuallyConfigPO.getEncryptPassword()));
                } else {
                    manuallyConfigPO.setUsername(null);
                    manuallyConfigPO.setPassword(null);
                }
            }
            if (usbLteSettingPO.getEncryptPin() == null) {
                usbLteSettingPO.setEncryptPin(b.c((String)usbLteSettingPO.getPin()));
            } else if (OmadacType.s() && !T.a((String)aesKeyInFile)) {
                usbLteSettingPO.setEncryptPin(b.c((String)b.a((String)usbLteSettingPO.getEncryptPin(), (String)aesKeyInFile)));
            } else if (!OmadacType.s() && T.a((String)aesKeyInFile)) {
                usbLteSettingPO.setEncryptPin(b.c((String)b.e((String)usbLteSettingPO.getEncryptPin())));
            }
            if (OmadacType.s()) {
                usbLteSettingPO.setPin(b.e((String)usbLteSettingPO.getEncryptPin()));
                continue;
            }
            usbLteSettingPO.setPin(null);
        }
    }
}

