/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.wirednetwork.restore.v5;

import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.core.d.j;
import com.tplink.smb.omada.backup.core.unit.siteconfig.wirednetwork.dto.WiredNetworkDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.wirednetwork.restore.v5.a;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.b.b;
import com.tplink.smb.omada.common.util.e;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lannetwork.BaseLanNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lanprofile.BaseLanProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.InternetPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.ManuallyConfigPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.UsbLteSettingPO;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V50200, b=d.WIRED_NETWORK)
public class WiredNetworkRestoreUnitV50200
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WiredNetworkRestoreUnitV50200.class);
    private final g osgModelConfigMainMongoRepository = g.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.a internetMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c lanNetworkMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.e lanProfileMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.e.a();
    private static final WiredNetworkRestoreUnitV50200 instance = new WiredNetworkRestoreUnitV50200();

    private WiredNetworkRestoreUnitV50200() {
    }

    public static WiredNetworkRestoreUnitV50200 getInstance() {
        return instance;
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        WiredNetworkDTO wiredNetworkDTO = (WiredNetworkDTO)jsonParserWrapper.a(WiredNetworkDTO.class);
        if (wiredNetworkDTO == null) {
            log.warn("omadacId={} Wired Network v5 Restore dto is null.", (Object)omadacId.a());
            return;
        }
        Map newSiteIdMap = (Map)restoreCacheMap.computeIfAbsent(d.Q.A(), k2 -> new HashMap());
        Map netIdsMap = (Map)restoreCacheMap.computeIfAbsent(d.af.A(), v2 -> new HashMap());
        String aesKeyInFile = (String)restoreCacheMap.get("AES_KEY_IN_FILE");
        this.handleOsgModelConfig(omadacId, newSiteIdMap, wiredNetworkDTO);
        this.handleInternet(omadacId, newSiteIdMap, wiredNetworkDTO, aesKeyInFile);
        this.handleLanNetwork(omadacId, newSiteIdMap, wiredNetworkDTO, restoreCacheMap, netIdsMap);
        this.handleLanProfile(omadacId, newSiteIdMap, wiredNetworkDTO, restoreCacheMap, netIdsMap);
    }

    private void handleLanProfile(@Nonnull c omadacId, @Nonnull Map<String, String> newSiteIdMap, @Nonnull WiredNetworkDTO wiredNetworkDTO, Map<String, Object> restoreCacheMap, Map<String, String> netIdsMap) {
        Optional.ofNullable(wiredNetworkDTO.getLanProfiles()).ifPresent(lanProfiles -> lanProfiles.forEach(lanProfilePO -> {
            lanProfilePO.setOmadacId(omadacId.a());
            if (newSiteIdMap.containsKey(lanProfilePO.getSiteId())) {
                lanProfilePO.setSiteId((String)newSiteIdMap.get(lanProfilePO.getSiteId()));
            }
            String originalLanProfileId = lanProfilePO.getId();
            lanProfilePO.setId(null);
            lanProfilePO.setNativeNetworkId((String)netIdsMap.get(lanProfilePO.getNativeNetworkId()));
            lanProfilePO.setTagNetworkIds(e.a((List)lanProfilePO.getTagNetworkIds(), (Map)netIdsMap));
            lanProfilePO.setTagBridgeVlanMap(j.a(lanProfilePO.getTagBridgeVlanMap(), netIdsMap));
            lanProfilePO.setUntagNetworkIds(e.a((List)lanProfilePO.getUntagNetworkIds(), (Map)netIdsMap));
            lanProfilePO.setUntagBridgeVlanMap(j.a(lanProfilePO.getUntagBridgeVlanMap(), netIdsMap));
            lanProfilePO.setVoiceNetworkId((String)netIdsMap.get(lanProfilePO.getVoiceNetworkId()));
            netIdsMap.put(originalLanProfileId, Optional.ofNullable(this.lanProfileMaintMongoRepository.a(lanProfilePO)).map(BaseLanProfilePO::getId).orElse(null));
        }));
    }

    public static Map<String, Set<Integer>> transformIds(Map<String, Set<Integer>> oldBridgeVlanMap, Map<String, String> netIdsMap) {
        if (CollectionUtils.isEmpty(oldBridgeVlanMap)) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<Integer>> newBridgeVlanMap = new HashMap<String, Set<Integer>>(oldBridgeVlanMap.size());
        oldBridgeVlanMap.forEach((oldNetId, vlans) -> newBridgeVlanMap.put((String)netIdsMap.get(oldNetId), (Set<Integer>)vlans));
        return newBridgeVlanMap;
    }

    private void handleLanNetwork(@Nonnull c omadacId, @Nonnull Map<String, String> newSiteIdMap, @Nonnull WiredNetworkDTO wiredNetworkDTO, Map<String, Object> restoreCacheMap, Map<String, String> netIdsMap) {
        Map portalIdMap = (Map)restoreCacheMap.get(d.ad.A());
        Optional.ofNullable(wiredNetworkDTO.getLanNetworks()).ifPresent(lanNetworks -> lanNetworks.forEach(lanNetworkPO -> {
            String oldLanNetworkId = lanNetworkPO.getId();
            lanNetworkPO.setOmadacId(omadacId.a());
            if (newSiteIdMap.containsKey(lanNetworkPO.getSiteId())) {
                lanNetworkPO.setSiteId((String)newSiteIdMap.get(lanNetworkPO.getSiteId()));
            }
            lanNetworkPO.setId(null);
            if (!CollectionUtils.isEmpty((Map)portalIdMap) && portalIdMap.containsKey(lanNetworkPO.getPortalId())) {
                lanNetworkPO.setPortalId((String)portalIdMap.get(lanNetworkPO.getPortalId()));
            }
            a.a((BaseLanNetworkPO)lanNetworkPO);
            lanNetworkPO = this.lanNetworkMaintMongoRepository.a(lanNetworkPO);
            netIdsMap.put(oldLanNetworkId, lanNetworkPO == null ? null : lanNetworkPO.getId());
        }));
    }

    private void handleInternet(@Nonnull c omadacId, @Nonnull Map<String, String> newSiteIdMap, @Nonnull WiredNetworkDTO wiredNetworkDTO, String aesKeyInFile) {
        Optional.ofNullable(wiredNetworkDTO.getInternet()).ifPresent(internetPO -> {
            internetPO.setOmadacId(omadacId.a());
            if (newSiteIdMap.containsKey(internetPO.getSiteId())) {
                internetPO.setSiteId((String)newSiteIdMap.get(internetPO.getSiteId()));
            }
            internetPO.setId(null);
            this.handleUsbEncrypt((InternetPO)internetPO, aesKeyInFile);
            internetPO.getWanPortIpv4Settings().forEach(wanPortIpv4SettingPO -> {
                if (wanPortIpv4SettingPO.getIpv4Pppoe() != null && wanPortIpv4SettingPO.getIpv4Pppoe().getMru() == null) {
                    wanPortIpv4SettingPO.getIpv4Pppoe().setMru(wanPortIpv4SettingPO.getIpv4Pppoe().getMtu());
                }
            });
            this.internetMaintMongoRepository.a(internetPO);
        });
    }

    private void handleOsgModelConfig(@Nonnull c omadacId, @Nonnull Map<String, String> newSiteIdMap, @Nonnull WiredNetworkDTO wiredNetworkDTO) {
        Optional.ofNullable(wiredNetworkDTO.getOsgModelConfig()).ifPresent(osgModelConfig -> {
            osgModelConfig.setOmadacId(omadacId.a());
            if (newSiteIdMap.containsKey(osgModelConfig.getSiteId())) {
                osgModelConfig.setSiteId((String)newSiteIdMap.get(osgModelConfig.getSiteId()));
            }
            osgModelConfig.setId(null);
            this.osgModelConfigMainMongoRepository.a(osgModelConfig);
        });
    }

    private void handleUsbEncrypt(InternetPO internetPO, String aesKeyInFile) {
        List usbLteSettingPOS = internetPO.getUsbLteSettings();
        if (CollectionUtils.isEmpty((Collection)usbLteSettingPOS)) {
            return;
        }
        for (UsbLteSettingPO usbLteSettingPO : usbLteSettingPOS) {
            if (usbLteSettingPO.getManuallyConfig() != null) {
                ManuallyConfigPO manuallyConfigPO = usbLteSettingPO.getManuallyConfig();
                if (manuallyConfigPO.getEncryptPassword() == null) {
                    manuallyConfigPO.setEncryptPassword(b.c((String)manuallyConfigPO.getPassword()));
                } else if (OmadacType.s() && !T.a((String)aesKeyInFile)) {
                    manuallyConfigPO.setEncryptPassword(b.c((String)b.a((String)manuallyConfigPO.getEncryptPassword(), (String)aesKeyInFile)));
                } else if (!OmadacType.s() && T.a((String)aesKeyInFile)) {
                    manuallyConfigPO.setEncryptPassword(b.c((String)b.e((String)manuallyConfigPO.getEncryptPassword())));
                }
                if (manuallyConfigPO.getEncryptUsername() == null) {
                    manuallyConfigPO.setEncryptUsername(b.c((String)manuallyConfigPO.getUsername()));
                } else if (OmadacType.s() && !T.a((String)aesKeyInFile)) {
                    manuallyConfigPO.setEncryptUsername(b.c((String)b.a((String)manuallyConfigPO.getEncryptUsername(), (String)aesKeyInFile)));
                } else if (!OmadacType.s() && T.a((String)aesKeyInFile)) {
                    manuallyConfigPO.setEncryptUsername(b.c((String)b.e((String)manuallyConfigPO.getEncryptUsername())));
                }
                if (OmadacType.s()) {
                    manuallyConfigPO.setUsername(b.e((String)manuallyConfigPO.getEncryptUsername()));
                    manuallyConfigPO.setPassword(b.e((String)manuallyConfigPO.getEncryptPassword()));
                } else {
                    manuallyConfigPO.setUsername(null);
                    manuallyConfigPO.setPassword(null);
                }
            }
            if (usbLteSettingPO.getEncryptPin() == null) {
                usbLteSettingPO.setEncryptPin(b.c((String)usbLteSettingPO.getPin()));
            } else if (OmadacType.s() && !T.a((String)aesKeyInFile)) {
                usbLteSettingPO.setEncryptPin(b.c((String)b.a((String)usbLteSettingPO.getEncryptPin(), (String)aesKeyInFile)));
            } else if (!OmadacType.s() && T.a((String)aesKeyInFile)) {
                usbLteSettingPO.setEncryptPin(b.c((String)b.e((String)usbLteSettingPO.getEncryptPin())));
            }
            if (OmadacType.s()) {
                usbLteSettingPO.setPin(b.e((String)usbLteSettingPO.getEncryptPin()));
                continue;
            }
            usbLteSettingPO.setPin(null);
        }
    }
}

