/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.vpn.siteimport;

import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.d.c;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.vpn.dto.VpnDTO;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.vpn.vpn.VpnPO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.d(a=d.VPN)
public class VpnSiteImportUnit
extends com.tplink.smb.omada.backup.api.c {
    private static final VpnSiteImportUnit instance = new VpnSiteImportUnit();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.vpn.d vpnMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.vpn.d.a();
    private static final Integer AUTO_IPSEC = 0;
    private static final Integer SITE_TO_SITE_VPN = 0;

    private VpnSiteImportUnit() {
    }

    public static VpnSiteImportUnit getInstance() {
        return instance;
    }

    public void siteImport(b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, com.tplink.smb.omada.maintenance.common.b.a.a.d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, Map<String, Object> restoreCacheMap) throws IOException, c {
        VpnDTO vpnDTO = (VpnDTO)jsonParserWrapper.a(VpnDTO.class);
        this.siteCopyWrite(vpnDTO, omadacId, newSiteId, siteImportIdCacheMap);
    }

    public void siteCopyWrite(Object dataObject, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, com.tplink.smb.omada.maintenance.common.b.a.a.d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws IOException, c {
        List<VpnPO> vpnPOS = ((VpnDTO)dataObject).getVpns();
        if (CollectionUtils.isEmpty(vpnPOS)) {
            return;
        }
        Map networkIdMap = siteImportIdCacheMap.computeIfAbsent(d.af.A(), k2 -> new HashMap());
        Map vpnMap = siteImportIdCacheMap.computeIfAbsent(d.al.A(), k2 -> new HashMap());
        for (VpnPO vpnPO : vpnPOS) {
            if (SITE_TO_SITE_VPN.equals(vpnPO.getPurpose()) && AUTO_IPSEC.equals(vpnPO.getSiteVpnType())) continue;
            String oldVpnId = vpnPO.getId();
            vpnPO.setId(null);
            vpnPO.setOmadacId(omadacId.a());
            vpnPO.setSiteId(newSiteId.a());
            if (!CollectionUtils.isEmpty((Collection)vpnPO.getNetworkList())) {
                vpnPO.setNetworkList(this.getNetworkList(vpnPO.getNetworkList(), networkIdMap));
            }
            if (Objects.equals(vpnPO.getAuthType(), 1)) {
                Map ldapProfileIdMap = siteImportIdCacheMap.getOrDefault("ldapProfileIdOriginToCurrent", Collections.emptyMap());
                String oldLdapProfileId = vpnPO.getLdapProfile();
                if (oldLdapProfileId != null) {
                    vpnPO.setLdapProfile(ldapProfileIdMap.getOrDefault(oldLdapProfileId, oldLdapProfileId));
                }
            }
            String newVpnId = this.vpnMongoRepository.a(vpnPO);
            vpnMap.put(oldVpnId, newVpnId);
        }
        siteImportIdCacheMap.put(d.al.A(), vpnMap);
    }

    public void siteTemplateCopyWrite(Object dataObject, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, com.tplink.smb.omada.maintenance.common.b.a.a.d newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) throws c, IOException {
    }

    private List<String> getNetworkList(List<String> oldNetworkList, Map<String, String> networkIdMap) {
        if (CollectionUtils.isEmpty(oldNetworkList)) {
            return Collections.emptyList();
        }
        ArrayList<String> newNetworkList = new ArrayList<String>(oldNetworkList.size());
        for (String networkId : oldNetworkList) {
            if (T.a((String)networkIdMap.get(networkId))) continue;
            newNetworkList.add(networkIdMap.get(networkId));
        }
        return newNetworkList;
    }
}

