/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.vpn.restore;

import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.d.c;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.vpn.dto.VpnDTO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.vpn.vpn.VpnPO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V50000, b=d.VPN)
public class VpnRestoreUnitV50000
extends com.tplink.smb.omada.backup.api.b {
    private static final VpnRestoreUnitV50000 instance = new VpnRestoreUnitV50000();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.vpn.d vpnMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.vpn.d.a();

    private VpnRestoreUnitV50000() {
    }

    public static VpnRestoreUnitV50000 getInstance() {
        return instance;
    }

    public void restore(b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) throws IOException, c {
        VpnDTO vpnDTO = (VpnDTO)jsonParserWrapper.a(VpnDTO.class);
        if (CollectionUtils.isEmpty(vpnDTO.getVpns())) {
            return;
        }
        Map vpnMap = (Map)restoreCacheMap.computeIfAbsent(d.al.A(), k2 -> new HashMap());
        Map siteMap = (Map)restoreCacheMap.computeIfAbsent(d.Q.A(), k2 -> new HashMap());
        Map netIdsMap = (Map)restoreCacheMap.computeIfAbsent(d.af.A(), v2 -> new HashMap());
        String omadaId = omadacId.a();
        List<VpnPO> vpns = vpnDTO.getVpns();
        for (VpnPO vpn : vpns) {
            String oldVpnId = vpn.getId();
            vpn.setOmadacId(omadaId);
            vpn.setId(null);
            vpn.setSiteId((String)siteMap.get(vpn.getSiteId()));
            vpn.setNetworkList(this.transNetworks(vpn.getNetworkList(), netIdsMap));
            if (Objects.equals(vpn.getAuthType(), 1)) {
                Map ldapProfileIdMap = restoreCacheMap.getOrDefault("ldapProfileIdOriginToCurrent", Collections.emptyMap());
                String oldLdapProfileId = vpn.getLdapProfile();
                if (oldLdapProfileId != null) {
                    vpn.setLdapProfile(ldapProfileIdMap.getOrDefault(oldLdapProfileId, oldLdapProfileId));
                }
            }
            String newVpnId = this.vpnMongoRepository.a(vpn);
            vpnMap.put(oldVpnId, newVpnId);
        }
        restoreCacheMap.put(d.al.A(), vpnMap);
    }

    public void afterRestore(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) {
        Map siteMap = (Map)restoreCacheMap.computeIfAbsent(d.Q.A(), k2 -> new HashMap());
        List autoIpsecs = this.vpnMongoRepository.d(omadacId);
        for (VpnPO vpnPO : autoIpsecs) {
            vpnPO.setRemoteSite((String)siteMap.get(vpnPO.getRemoteSite()));
            this.vpnMongoRepository.a(vpnPO);
        }
    }

    private List<String> transNetworks(List<String> networkIds, Map<String, String> netIdsMap) {
        if (CollectionUtils.isEmpty(networkIds)) {
            return Collections.emptyList();
        }
        ArrayList<String> saveList = new ArrayList<String>();
        for (String networkId : networkIds) {
            if (!netIdsMap.containsKey(networkId)) continue;
            saveList.add(netIdsMap.get(networkId));
        }
        return saveList;
    }
}

