/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.vpn.restore;

import com.tplink.smb.component.storage.api.repository.FileRepository;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.core.unit.siteconfig.vpn.dto.VpnCertificateDTO;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.vpn.b;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.vpn.vpn.VpnCertificatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.vpn.vpn.VpnPO;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.backup.api.a.c(a=l.V50000, b=com.tplink.smb.omada.backup.api.c.d.VPN_CERTIFICATE)
public class VpnCertificateRestoreUnitV50000
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VpnCertificateRestoreUnitV50000.class);
    private static final VpnCertificateRestoreUnitV50000 instance = new VpnCertificateRestoreUnitV50000();
    private final b vpnCertificateMongoRepository = b.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.vpn.d vpnMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.vpn.d.a();
    private final FileRepository fileRepository = (FileRepository)a.b(FileRepository.class);

    private VpnCertificateRestoreUnitV50000() {
    }

    public static VpnCertificateRestoreUnitV50000 getInstance() {
        return instance;
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        VpnCertificateDTO vpnCertificateDTO = (VpnCertificateDTO)jsonParserWrapper.a(VpnCertificateDTO.class);
        List<VpnCertificatePO> certificates = vpnCertificateDTO.getCertificateList();
        if (CollectionUtils.isEmpty(certificates)) {
            return;
        }
        Map siteMap = (Map)restoreCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Q.A(), k2 -> new HashMap());
        HashMap<String, String> vpnCertificateMap = new HashMap<String, String>();
        Map<String, String> fileId2FileMap = vpnCertificateDTO.getFileId2FileMap();
        for (VpnCertificatePO certificate : certificates) {
            String oldCertificateId = certificate.getId();
            String fileData = fileId2FileMap.get(certificate.getFileId());
            InputStream in = IOUtils.toInputStream((String)fileData, (Charset)StandardCharsets.UTF_8);
            String newFileId = this.fileRepository.saveFile(omadacId.a(), null, certificate.getFileName(), in);
            certificate.setFileId(newFileId);
            certificate.setOmadacId(omadacId.a());
            certificate.setSiteId((String)siteMap.get(certificate.getSiteId()));
            certificate.setId(null);
            String newCertificateId = this.vpnCertificateMongoRepository.a(certificate);
            vpnCertificateMap.put(oldCertificateId, newCertificateId);
        }
        String siteId = certificates.get(0).getSiteId();
        this.updateRelatedVpns(omadacId, new d(siteId), restoreCacheMap, vpnCertificateMap);
    }

    private void updateRelatedVpns(c omadacId, d siteId, Map<String, Object> restoreCacheMap, Map<String, String> vpnCertificateMap) {
        Map vpnMap = (Map)restoreCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.al.A(), k2 -> new HashMap());
        if (MapUtils.isEmpty((Map)vpnMap)) {
            return;
        }
        ArrayList vpnIds = new ArrayList(vpnMap.values());
        List vpns = this.vpnMaintMongoRepository.a(omadacId, siteId, vpnIds);
        if (CollectionUtils.isEmpty((Collection)vpns)) {
            return;
        }
        for (VpnPO vpn : vpns) {
            if (StringUtils.isEmpty((CharSequence)vpn.getVpnCertificateId())) continue;
            vpn.setVpnCertificateId(vpnCertificateMap.get(vpn.getVpnCertificateId()));
            this.vpnMaintMongoRepository.a(vpn);
        }
    }
}

