/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.vouchergroup.restore;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.PortalFileBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.vouchergroup.restore.VoucherGroupRestoreHelplerV60000;
import com.tplink.smb.omada.backup.core.unit.siteconfig.vouchergroup.restore.a;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.portal.port.mongo.omada.voucher.VoucherGroupPO;
import com.tplink.smb.omada.portal.port.mongo.omada.voucher.VoucherPatternPO;
import com.tplink.smb.omada.portal.port.mongo.omada.vouchergroup.VoucherGroupMaintRepository;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V60000, b=d.VOUCHER_GROUP)
public class VoucherGroupRestoreUnitV60000
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VoucherGroupRestoreUnitV60000.class);
    public static final String KEY_VOUCHER_GROUPS = "voucherGroups";
    public static final String KEY_VOUCHER_PATTERN_MAP = "voucherLogoIdToFileMap";
    public static final int BATCH_SIZE = 5000;
    private final VoucherGroupMaintRepository voucherGroupMaintRepository = VoucherGroupMaintRepository.getInstance();
    private final VoucherGroupRestoreHelplerV60000 voucherGroupRestoreHelplerV60000 = VoucherGroupRestoreHelplerV60000.a();
    private static final VoucherGroupRestoreUnitV60000 instance = new VoucherGroupRestoreUnitV60000();

    public static VoucherGroupRestoreUnitV60000 getInstance() {
        return instance;
    }

    private VoucherGroupRestoreUnitV60000() {
    }

    public void restore(b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        Map siteMap = (Map)restoreCacheMap.get(d.Q.A());
        Map portalMap = (Map)restoreCacheMap.get(d.ad.A());
        Map rateLimitMap = (Map)restoreCacheMap.get(d.Y.A());
        HashMap<String, String> voucherGrouIdMap = new HashMap<String, String>();
        restoreCacheMap.put(d.aT.A(), voucherGrouIdMap);
        Map wirelessMap = (Map)restoreCacheMap.computeIfAbsent(d.ag.A(), k2 -> new HashMap());
        Map wiredMap = (Map)restoreCacheMap.computeIfAbsent(d.af.A(), k2 -> new HashMap());
        JsonParser jsonParser = jsonParserWrapper.h();
        Map voucherLogoIdToFileMap = null;
        while (JsonToken.END_OBJECT != jsonParser.nextToken()) {
            if (JsonToken.FIELD_NAME != jsonParser.currentToken()) continue;
            String name = jsonParser.getText();
            if (Objects.equals(KEY_VOUCHER_PATTERN_MAP, name)) {
                log.debug("Found voucher pattern map, restoring.");
                jsonParser.nextToken();
                voucherLogoIdToFileMap = (Map)jsonParser.readValueAs((TypeReference)new a(this));
                continue;
            }
            if (!KEY_VOUCHER_GROUPS.equals(name)) {
                jsonParser.nextToken();
                jsonParser.skipChildren();
                log.debug("Restoring {} - Skip unknown JSON member: {}", (Object)d.aT, (Object)name);
                continue;
            }
            log.debug("Restoring {} - Found JSON member: {}, promote restore", (Object)d.aT, (Object)KEY_VOUCHER_GROUPS);
            if (JsonToken.START_ARRAY != jsonParser.nextToken()) {
                jsonParser.skipChildren();
                continue;
            }
            ArrayList<VoucherGroupPO> batch = new ArrayList<VoucherGroupPO>(5000);
            while (JsonToken.END_ARRAY != jsonParser.nextToken()) {
                VoucherGroupPO po = (VoucherGroupPO)jsonParser.readValueAs(VoucherGroupPO.class);
                String oldId = po.getId();
                String newId = this.voucherGroupMaintRepository.nextId();
                po.setId(newId);
                po.setOmadacId(omadacId.a());
                String newSiteId = (String)siteMap.get(po.getSiteId());
                if (newSiteId == null) {
                    log.warn("Restoring clientHistory: Cannot find mapped siteId, omadacId={}, clientHistory: {}", (Object)omadacId, (Object)po);
                    continue;
                }
                po.setSiteId(newSiteId);
                if (!CollectionUtils.isEmpty((Collection)po.getPortals())) {
                    List newPortals = po.getPortals().stream().filter(Objects::nonNull).map(portalMap::get).filter(Objects::nonNull).collect(Collectors.toList());
                    po.setPortals(newPortals);
                }
                po.setRateLimitId((String)Optional.ofNullable(po.getRateLimitId()).map(rateLimitMap::get).orElse(null));
                Optional.ofNullable(po.getPattern()).map(VoucherPatternPO::getSsidList).ifPresent(ssidList -> po.getPattern().setSsidList(ssidList.stream().map(wirelessMap::get).collect(Collectors.toList())));
                Optional.ofNullable(po.getPattern()).map(VoucherPatternPO::getNetworkList).ifPresent(networkList -> po.getPattern().setNetworkList(networkList.stream().map(wiredMap::get).collect(Collectors.toList())));
                batch.add(po);
                voucherGrouIdMap.put(oldId, newId);
                if (voucherLogoIdToFileMap != null) {
                    Optional.ofNullable(po.getPattern()).map(VoucherPatternPO::getLogoPictureId).map(voucherLogoIdToFileMap::get).map(portalFileBKDTO -> this.voucherGroupRestoreHelplerV60000.a(omadacId.a(), newSiteId, (PortalFileBKDTO)portalFileBKDTO)).ifPresent(logoId -> po.getPattern().setLogoPictureId(logoId));
                }
                if (batch.size() < 5000) continue;
                this.voucherGroupMaintRepository.insertAll(batch);
                batch.clear();
            }
            if (batch.size() <= 0) continue;
            this.voucherGroupMaintRepository.insertAll(batch);
        }
    }
}

