/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.vouchergroup.restore;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.portal.port.mongo.omada.voucher.VoucherGroupPO;
import com.tplink.smb.omada.portal.port.mongo.omada.vouchergroup.VoucherGroupMaintRepository;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V51100, b=d.VOUCHER_GROUP)
public class VoucherGroupRestoreUnitV51100
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VoucherGroupRestoreUnitV51100.class);
    public static final String KEY_VOUCHER_GROUPS = "voucherGroups";
    public static final int BATCH_SIZE = 5000;
    private final VoucherGroupMaintRepository voucherGroupMaintRepository = VoucherGroupMaintRepository.getInstance();
    private static final VoucherGroupRestoreUnitV51100 instance = new VoucherGroupRestoreUnitV51100();

    public static VoucherGroupRestoreUnitV51100 getInstance() {
        return instance;
    }

    private VoucherGroupRestoreUnitV51100() {
    }

    public void restore(b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        Map siteMap = (Map)restoreCacheMap.get(d.Q.A());
        Map portalMap = (Map)restoreCacheMap.get(d.ad.A());
        Map rateLimitMap = (Map)restoreCacheMap.get(d.Y.A());
        HashMap<String, String> voucherGrouIdMap = new HashMap<String, String>();
        restoreCacheMap.put(d.aT.A(), voucherGrouIdMap);
        JsonParser jsonParser = jsonParserWrapper.h();
        while (JsonToken.END_OBJECT != jsonParser.nextToken()) {
            if (JsonToken.FIELD_NAME != jsonParser.currentToken()) continue;
            String name = jsonParser.getText();
            if (!KEY_VOUCHER_GROUPS.equals(name)) {
                jsonParser.nextToken();
                jsonParser.skipChildren();
                log.debug("Restoring {} - Skip unknown JSON member: {}", (Object)d.aT, (Object)name);
                continue;
            }
            log.debug("Restoring {} - Found JSON member: {}, promote restore", (Object)d.aT, (Object)KEY_VOUCHER_GROUPS);
            if (JsonToken.START_ARRAY != jsonParser.nextToken()) {
                jsonParser.skipChildren();
                continue;
            }
            ArrayList<VoucherGroupPO> batch = new ArrayList<VoucherGroupPO>(5000);
            while (JsonToken.END_ARRAY != jsonParser.nextToken()) {
                VoucherGroupPO po = (VoucherGroupPO)jsonParser.readValueAs(VoucherGroupPO.class);
                String oldId = po.getId();
                String newId = this.voucherGroupMaintRepository.nextId();
                po.setId(newId);
                po.setOmadacId(omadacId.a());
                String newSiteId = (String)siteMap.get(po.getSiteId());
                if (newSiteId == null) {
                    log.warn("Restoring clientHistory: Cannot find mapped siteId, omadacId={}, clientHistory: {}", (Object)omadacId, (Object)po);
                    continue;
                }
                po.setSiteId(newSiteId);
                if (!CollectionUtils.isEmpty((Collection)po.getPortals())) {
                    List newPortals = po.getPortals().stream().filter(Objects::nonNull).map(portalMap::get).filter(Objects::nonNull).collect(Collectors.toList());
                    po.setPortals(newPortals);
                }
                po.setRateLimitId((String)Optional.ofNullable(po.getRateLimitId()).map(rateLimitMap::get).orElse(null));
                batch.add(po);
                voucherGrouIdMap.put(oldId, newId);
                if (batch.size() < 5000) continue;
                this.voucherGroupMaintRepository.insertAll(batch);
                batch.clear();
            }
            if (batch.size() <= 0) continue;
            this.voucherGroupMaintRepository.insertAll(batch);
        }
    }
}

