/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.voucher.siteimport;

import com.tplink.smb.omada.backup.core.unit.siteconfig.voucher.VoucherBKDTO;
import com.tplink.smb.omada.common.omadac.config.a.b;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.portal.port.mongo.omada.hotspot.HotspotSiteSettingMaintRepository;
import com.tplink.smb.omada.portal.port.mongo.omada.hotspot.HotspotSiteSettingPO;
import com.tplink.smb.omada.portal.port.mongo.omada.hotspot.VoucherSummaryPO;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.backup.api.a.d(a=com.tplink.smb.omada.backup.api.c.d.VOUCHER)
public class VoucherSiteImportUnit
extends com.tplink.smb.omada.backup.api.c {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VoucherSiteImportUnit.class);
    private final com.tplink.smb.omada.portal.port.mongo.omada.voucher.c voucherRepository = com.tplink.smb.omada.portal.port.mongo.omada.voucher.c.a();
    private final HotspotSiteSettingMaintRepository hotspotSiteSettingMaintRepository = HotspotSiteSettingMaintRepository.getInstance();
    private static final VoucherSiteImportUnit instance = new VoucherSiteImportUnit();

    public static VoucherSiteImportUnit getInstance() {
        return instance;
    }

    private VoucherSiteImportUnit() {
    }

    public void siteImport(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        VoucherBKDTO dto = (VoucherBKDTO)jsonParserWrapper.a(VoucherBKDTO.class);
        Map<String, String> portalMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.ad.A());
        Map<String, String> rateLimitMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.Y.A());
        Map voucherGroupMap = (Map)restoreCacheMap.get(com.tplink.smb.omada.backup.api.c.d.aT.A());
        AtomicLong count = new AtomicLong(0L);
        AtomicLong totalDuration = new AtomicLong(0L);
        AtomicReference<BigDecimal> totalAmount = new AtomicReference<BigDecimal>(new BigDecimal("0"));
        if (!CollectionUtils.isEmpty(dto.getVouchers())) {
            if ((long)dto.getVouchers().size() + this.voucherRepository.b(omadacId) > b.l() || (long)dto.getVouchers().size() > b.m()) {
                log.warn("voucher number is over limit, donnot import omadacid {}, siteid {}", (Object)omadacId.a(), (Object)newSiteId.a());
                return;
            }
            ArrayList voucherpos = new ArrayList();
            dto.getVouchers().forEach(obj -> {
                obj.setId(null);
                obj.setOmadacId(omadacId.a());
                obj.setSiteId(newSiteId.a());
                if (obj.getVoucherGroupId() != null) {
                    obj.setVoucherGroupId((String)voucherGroupMap.get(obj.getVoucherGroupId()));
                }
                if (!CollectionUtils.isEmpty((Collection)obj.getPortals())) {
                    ArrayList portals = new ArrayList(16);
                    portals.addAll(obj.getPortals().stream().map(portalMap::get).collect(Collectors.toList()));
                    obj.setPortals(portals);
                }
                if (obj.getRateLimitId() != null) {
                    obj.setRateLimitId((String)rateLimitMap.get(obj.getRateLimitId()));
                }
                voucherpos.add(obj);
                count.addAndGet(1L);
                totalDuration.addAndGet(obj.getDuration());
                if (obj.getUnitPrice() != null) {
                    totalAmount.updateAndGet(amount -> amount.add(new BigDecimal(obj.getUnitPrice())));
                }
            });
            this.voucherRepository.a(voucherpos);
        }
        HotspotSiteSettingPO siteSettingPO = this.hotspotSiteSettingMaintRepository.findByOmadacIdAndSiteId(omadacId, newSiteId).orElseGet(() -> new HotspotSiteSettingPO().setOmadacId(omadacId.a()).setSiteId(newSiteId.a()).setCurrency(null).setCreatedVoucherSummary(null));
        siteSettingPO.setCreatedVoucherSummary(new VoucherSummaryPO().setCount(Long.valueOf(count.get())).setDuration(Long.valueOf(totalDuration.get())).setAmount(totalAmount.get().stripTrailingZeros().toPlainString()));
        this.hotspotSiteSettingMaintRepository.save(siteSettingPO);
    }

    public void siteCopyWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
    }

    public void siteTemplateCopyWrite(Object dataObject, c omadacId, d newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c, IOException {
    }
}

