/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.voucher.restore;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.portal.port.mongo.omada.hotspot.HotspotSiteSettingMaintRepository;
import com.tplink.smb.omada.portal.port.mongo.omada.hotspot.HotspotSiteSettingPO;
import com.tplink.smb.omada.portal.port.mongo.omada.hotspot.VoucherSummaryPO;
import com.tplink.smb.omada.portal.port.mongo.omada.voucher.VoucherPO;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V51100, b=com.tplink.smb.omada.backup.api.c.d.VOUCHER)
public class VoucherRestoreUnitV51100
extends com.tplink.smb.omada.backup.api.b {
    private static final int ONE_PAGE_SIZE = 5000;
    private final com.tplink.smb.omada.portal.port.mongo.omada.voucher.c voucherRepository = com.tplink.smb.omada.portal.port.mongo.omada.voucher.c.a();
    private final HotspotSiteSettingMaintRepository hotspotSiteSettingMaintRepository = HotspotSiteSettingMaintRepository.getInstance();
    private static final VoucherRestoreUnitV51100 instance = new VoucherRestoreUnitV51100();

    public static VoucherRestoreUnitV51100 getInstance() {
        return instance;
    }

    private VoucherRestoreUnitV51100() {
    }

    public void restore(b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        Map siteMap = (Map)restoreCacheMap.get(com.tplink.smb.omada.backup.api.c.d.Q.A());
        Map portalMap = (Map)restoreCacheMap.get(com.tplink.smb.omada.backup.api.c.d.ad.A());
        Map rateLimitMap = (Map)restoreCacheMap.get(com.tplink.smb.omada.backup.api.c.d.Y.A());
        Map voucherGroupMap = (Map)restoreCacheMap.get(com.tplink.smb.omada.backup.api.c.d.aT.A());
        JsonParser jsonParser = jsonParserWrapper.h();
        while (jsonParser.nextToken() != JsonToken.START_ARRAY) {
            jsonParser.nextToken();
        }
        HashMap<d, a> summaryMap = new HashMap<d, a>();
        ArrayList<VoucherPO> list = new ArrayList<VoucherPO>(5000);
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            VoucherPO obj = (VoucherPO)jsonParser.readValueAs(VoucherPO.class);
            obj.setId(null);
            obj.setOmadacId(omadacId.a());
            obj.setSiteId((String)siteMap.get(obj.getSiteId()));
            a calculator = summaryMap.computeIfAbsent(new d(obj.getSiteId()), key -> new a());
            calculator.a.addAndGet(1L);
            calculator.c.addAndGet(obj.getDuration());
            if (obj.getUnitPrice() != null) {
                calculator.b.updateAndGet(amount -> amount.add(new BigDecimal(obj.getUnitPrice())));
            }
            if (!CollectionUtils.isEmpty((Collection)obj.getPortals())) {
                ArrayList portals = new ArrayList(16);
                portals.addAll(obj.getPortals().stream().map(portalMap::get).collect(Collectors.toList()));
                obj.setPortals(portals);
            }
            if (obj.getRateLimitId() != null) {
                obj.setRateLimitId((String)rateLimitMap.get(obj.getRateLimitId()));
            }
            if (obj.getVoucherGroupId() != null) {
                obj.setVoucherGroupId((String)voucherGroupMap.get(obj.getVoucherGroupId()));
            }
            list.add(obj);
            if (list.size() < 5000) continue;
            this.voucherRepository.a(list);
            list.clear();
        }
        this.voucherRepository.a(list);
        this.updateCreatedVoucherSummary(omadacId, summaryMap);
    }

    public void updateCreatedVoucherSummary(c omadacId, Map<d, a> summaryMap) {
        if (CollectionUtils.isEmpty(summaryMap)) {
            return;
        }
        summaryMap.forEach((siteId, voucherSummaryCalculator) -> {
            HotspotSiteSettingPO po = this.hotspotSiteSettingMaintRepository.findByOmadacIdAndSiteId(omadacId, siteId).orElseGet(() -> new HotspotSiteSettingPO().setOmadacId(omadacId.a()).setSiteId(siteId.a()).setCurrency(null).setCreatedVoucherSummary(null));
            po.setCreatedVoucherSummary(new VoucherSummaryPO().setCount(Long.valueOf(voucherSummaryCalculator.a.get())).setAmount(voucherSummaryCalculator.b.get().stripTrailingZeros().toPlainString()).setDuration(Long.valueOf(voucherSummaryCalculator.c.get())));
            this.hotspotSiteSettingMaintRepository.save(po);
        });
    }

    private static class a {
        private final AtomicLong a = new AtomicLong(0L);
        private final AtomicReference<BigDecimal> b = new AtomicReference<BigDecimal>(new BigDecimal("0"));
        private final AtomicLong c = new AtomicLong(0L);

        private a() {
        }
    }
}

