/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.transmission.siteimport;

import com.tplink.smb.omada.backup.api.c.n;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.transmission.dto.TransmissionBKO;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.e;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.bandwidthctrl.BandwidthCtrlRulePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.bandwidthctrl.BandwidthCtrlRuleTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.bandwidthctrl.BaseBandwidthCtrlRulePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.disablenat.BaseDisableNatPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.disablenat.DisableNatPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.disablenat.DisableNatTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.f;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.h;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.i;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.l;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.otonat.BaseOtoNatPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.otonat.OtoNatPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.otonat.OtoNatTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.policyrouting.BasePolicyRoutingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.policyrouting.PolicyRoutingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.policyrouting.PolicyRoutingTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.portforwarding.BasePortForwardingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.portforwarding.PortForwardingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.portforwarding.PortForwardingTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.sessionlimit.BaseSessionLimitRulePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.sessionlimit.SessionLimitRulePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.sessionlimit.SessionLimitTemplateRulePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.staticrouting.BaseStaticRoutingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.staticrouting.StaticRoutingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.staticrouting.StaticRoutingTemplatePO;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.d(a=com.tplink.smb.omada.backup.api.c.d.TRANSMISSION)
public class TransmissionSiteImportUnit
extends com.tplink.smb.omada.backup.api.c {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransmissionSiteImportUnit.class);
    private static TransmissionSiteImportUnit instance = new TransmissionSiteImportUnit();
    private final l transmissionSettingMongoRepository = l.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.d osgStaticRoutingMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.d.a();
    private final g policyRoutingMongoRepository = g.a();
    private final h portForwardingMongoRepository = h.a();
    private final i sessionLimitRuleMongoRepository = i.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.a bandwidthCtrlRuleMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.c disableNatMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.c.a();
    private final f otoNatMongoRepository = f.a();
    private final e getEntryIdService = (e)a.b(e.class);

    private TransmissionSiteImportUnit() {
    }

    public static TransmissionSiteImportUnit getInstance() {
        return instance;
    }

    public void siteImport(b jsonParserWrapper, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        TransmissionBKO backupTransmission = (TransmissionBKO)jsonParserWrapper.a(TransmissionBKO.class);
        this.siteCopyWrite(backupTransmission, omadacId, newSiteId, siteImportIdCacheMap);
    }

    public void siteCopyWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        TransmissionBKO backupTransmission = (TransmissionBKO)dataObject;
        Optional.ofNullable(backupTransmission.getTransmissionSetting()).ifPresent(po -> {
            po.setOmadacId(omadacId.a());
            po.setSiteId(newSiteId.a());
            po.setTemplateId(null);
            po.setAlgOverride(null);
            this.transmissionSettingMongoRepository.a(omadacId, newSiteId).ifPresent(exists -> po.setId(exists.getId()));
            this.transmissionSettingMongoRepository.a(po);
        });
        this.handleOsgStaticRouting(new ArrayList<StaticRoutingPO>(backupTransmission.getStaticRoutings()), omadacId, newSiteId.a(), siteImportIdCacheMap, n.a, true);
        this.handlePolicyRouting(new ArrayList<PolicyRoutingPO>(backupTransmission.getPolicyRoutings()), omadacId, newSiteId.a(), siteImportIdCacheMap, n.a, true);
        this.handlePortForwarding(new ArrayList<PortForwardingPO>(backupTransmission.getPortForwardings()), omadacId, newSiteId.a(), n.a, true, siteImportIdCacheMap);
        this.handleSessionLimitRule(new ArrayList<SessionLimitRulePO>(backupTransmission.getSessionLimitRules()), omadacId, newSiteId.a(), siteImportIdCacheMap, n.a, true);
        this.handleBandwidthCtrlRule(new ArrayList<BandwidthCtrlRulePO>(backupTransmission.getBandwidthCtrlRules()), omadacId, newSiteId.a(), siteImportIdCacheMap, n.a, true);
        this.handleOtoNat(new ArrayList<OtoNatPO>(backupTransmission.getOtoNats()), omadacId, newSiteId.a(), n.a, true);
        this.handleDisableNat(new ArrayList<DisableNatPO>(backupTransmission.getDisableNats()), omadacId, newSiteId.a(), siteImportIdCacheMap, n.a, true);
    }

    public void siteTemplateCopyWrite(Object dataObject, c omadacId, d newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        TransmissionBKO backupTransmission = (TransmissionBKO)dataObject;
        Optional.ofNullable(backupTransmission.getTransmissionSettingTemplate()).ifPresent(po -> {
            po.setId(null);
            po.setOmadacId(omadacId.a());
            po.setSiteTemplateId(newSiteTemplateId.a());
            this.transmissionSettingMongoRepository.a(omadacId, newSiteTemplateId.a()).ifPresent(exists -> po.setId(exists.getId()));
            this.transmissionSettingMongoRepository.a(po);
        });
        this.handleOsgStaticRouting(new ArrayList<StaticRoutingTemplatePO>(backupTransmission.getStaticRoutingsTemplate()), omadacId, newSiteTemplateId.a(), siteImportIdCacheMap, n.b, false);
        this.handlePolicyRouting(new ArrayList<PolicyRoutingTemplatePO>(backupTransmission.getPolicyRoutingsTemplate()), omadacId, newSiteTemplateId.a(), siteImportIdCacheMap, n.b, false);
        this.handlePortForwarding(new ArrayList<PortForwardingTemplatePO>(backupTransmission.getPortForwardingsTemplate()), omadacId, newSiteTemplateId.a(), n.b, false, siteImportIdCacheMap);
        this.handleSessionLimitRule(new ArrayList<SessionLimitTemplateRulePO>(backupTransmission.getSessionLimitRulesTemplate()), omadacId, newSiteTemplateId.a(), siteImportIdCacheMap, n.b, false);
        this.handleBandwidthCtrlRule(new ArrayList<BandwidthCtrlRuleTemplatePO>(backupTransmission.getBandwidthCtrlRulesTemplate()), omadacId, newSiteTemplateId.a(), siteImportIdCacheMap, n.b, false);
        this.handleOtoNat(new ArrayList<OtoNatTemplatePO>(backupTransmission.getOtoNatsTemplate()), omadacId, newSiteTemplateId.a(), n.b, false);
        this.handleDisableNat(new ArrayList<DisableNatTemplatePO>(backupTransmission.getDisableNatsTemplate()), omadacId, newSiteTemplateId.a(), siteImportIdCacheMap, n.b, false);
    }

    private void handleOsgStaticRouting(List<BaseStaticRoutingPO> staticRoutingPOS, @Nonnull c omadacId, @Nonnull String siteId, Map<String, Map<String, String>> siteImportIdCacheMap, n typeEnum, boolean siteCopyWrite) {
        if (CollectionUtils.isEmpty(staticRoutingPOS)) {
            return;
        }
        staticRoutingPOS.forEach(staticRoutingPO -> {
            staticRoutingPO.setId(null);
            staticRoutingPO.setOmadacId(omadacId.a());
            staticRoutingPO.setInterfaceNetId((String)((Map)siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.af.A())).get(staticRoutingPO.getInterfaceNetId()));
            staticRoutingPO.setVpnId((String)siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.al.A(), k2 -> new HashMap()).get(staticRoutingPO.getVpnId()));
            if (staticRoutingPO.getVirtualWanId() != null) {
                staticRoutingPO.setVirtualWanId((String)siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), k2 -> new HashMap()).get(staticRoutingPO.getVirtualWanId()));
            }
            if (n.b.equals((Object)typeEnum)) {
                StaticRoutingTemplatePO templatePO = (StaticRoutingTemplatePO)staticRoutingPO;
                templatePO.setSiteTemplateId(siteId);
            } else {
                StaticRoutingPO po = (StaticRoutingPO)staticRoutingPO;
                po.setSiteId(siteId);
                if (siteCopyWrite) {
                    po.setTemplateId(null);
                    po.setOverride(null);
                }
                this.rebuildEntryId(po);
            }
        });
        this.osgStaticRoutingMongoRepository.a(staticRoutingPOS);
    }

    private void handlePolicyRouting(@Nonnull List<BasePolicyRoutingPO> policyRoutingPOS, @Nonnull c omadacId, @Nonnull String siteId, Map<String, Map<String, String>> siteImportIdCacheMap, n typeEnum, boolean siteCopyWrite) {
        if (CollectionUtils.isEmpty(policyRoutingPOS)) {
            return;
        }
        policyRoutingPOS.forEach(policyRoutingPO -> {
            policyRoutingPO.setId(null);
            policyRoutingPO.setOmadacId(omadacId.a());
            policyRoutingPO.setVpnId((String)siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.al.A(), k2 -> new HashMap()).get(policyRoutingPO.getVpnId()));
            if (!CollectionUtils.isEmpty((Collection)policyRoutingPO.getVpnIds())) {
                ArrayList<String> vpnIds = new ArrayList<String>();
                for (String vpnId : policyRoutingPO.getVpnIds()) {
                    vpnIds.add((String)siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.al.A(), k2 -> new HashMap()).get(vpnId));
                }
                policyRoutingPO.setVpnIds(vpnIds);
            }
            if (!CollectionUtils.isEmpty((Collection)policyRoutingPO.getVirtualWanIds())) {
                ArrayList<String> virtualWanIds = new ArrayList<String>();
                for (String virtualWanId : policyRoutingPO.getVirtualWanIds()) {
                    virtualWanIds.add((String)siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), k2 -> new HashMap()).get(virtualWanId));
                }
                policyRoutingPO.setVirtualWanIds(virtualWanIds);
            }
            if (n.b.equals((Object)typeEnum)) {
                PolicyRoutingTemplatePO templatePO = (PolicyRoutingTemplatePO)policyRoutingPO;
                templatePO.setSiteTemplateId(siteId);
            } else {
                PolicyRoutingPO po = (PolicyRoutingPO)policyRoutingPO;
                po.setSiteId(siteId);
                if (siteCopyWrite) {
                    po.setTemplateId(null);
                    po.setOverride(null);
                }
                if (po.getEntryId() == null) {
                    po.setEntryId(this.getEntryIdService.a(omadacId.a(), siteId, PolicyRoutingPO.class));
                }
            }
            switch (policyRoutingPO.getSourceType()) {
                case 0: {
                    policyRoutingPO.setSourceIds(com.tplink.smb.omada.common.util.e.a((List)policyRoutingPO.getSourceIds(), (Map)((Map)siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.af.A()))));
                    break;
                }
                case 1: 
                case 2: {
                    policyRoutingPO.setSourceIds(com.tplink.smb.omada.common.util.e.a((List)policyRoutingPO.getSourceIds(), (Map)((Map)siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.Y.A()))));
                    break;
                }
                default: {
                    log.error("import policy routing failed in omadac {}. invalid parameter sourceType {}", (Object)omadacId, (Object)policyRoutingPO.getSourceType());
                }
            }
            switch (policyRoutingPO.getDestinationType()) {
                case 0: {
                    policyRoutingPO.setDestinationIds(com.tplink.smb.omada.common.util.e.a((List)policyRoutingPO.getDestinationIds(), (Map)((Map)siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.af.A()))));
                    break;
                }
                case 1: 
                case 2: 
                case 9: 
                case 10: {
                    policyRoutingPO.setDestinationIds(com.tplink.smb.omada.common.util.e.a((List)policyRoutingPO.getDestinationIds(), (Map)((Map)siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.Y.A()))));
                    break;
                }
                default: {
                    log.error("import policy routing failed in omadac {}. invalid parameter destinationType {}", (Object)omadacId, (Object)policyRoutingPO.getDestinationType());
                }
            }
        });
        this.policyRoutingMongoRepository.a(policyRoutingPOS);
    }

    private void handlePortForwarding(List<BasePortForwardingPO> portForwardingPOS, @Nonnull c omadacId, @Nonnull String siteId, n typeEnum, boolean siteCopyWrite, Map<String, Map<String, String>> siteImportIdCacheMap) {
        if (CollectionUtils.isEmpty(portForwardingPOS)) {
            return;
        }
        Map netIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), v2 -> new HashMap());
        portForwardingPOS.forEach(po -> {
            po.setId(null);
            po.setOmadacId(omadacId.a());
            if (n.b.equals((Object)typeEnum)) {
                PortForwardingTemplatePO templatePO = (PortForwardingTemplatePO)po;
                if (!CollectionUtils.isEmpty((Collection)templatePO.getVirtualWanId())) {
                    templatePO.setVirtualWanId(po.getVirtualWanId().stream().map(netIdMap::get).filter(Objects::nonNull).toList());
                }
                templatePO.setSiteTemplateId(siteId);
            } else {
                PortForwardingPO portForwardingPO = (PortForwardingPO)po;
                portForwardingPO.setSiteId(siteId);
                if (!CollectionUtils.isEmpty((Collection)portForwardingPO.getVirtualWanId())) {
                    portForwardingPO.setVirtualWanId(po.getVirtualWanId().stream().map(netIdMap::get).filter(Objects::nonNull).toList());
                }
                if (siteCopyWrite) {
                    portForwardingPO.setTemplateId(null);
                    portForwardingPO.setOverride(null);
                }
                if (portForwardingPO.getEntryId() == null) {
                    portForwardingPO.setEntryId(this.getEntryIdService.a(omadacId.a(), siteId, PortForwardingPO.class));
                }
            }
        });
        this.portForwardingMongoRepository.a(portForwardingPOS);
    }

    private void handleOtoNat(List<BaseOtoNatPO> otoNatPOS, @Nonnull c omadacId, @Nonnull String siteId, n typeEnum, boolean siteCopyWrite) {
        if (CollectionUtils.isEmpty(otoNatPOS)) {
            return;
        }
        otoNatPOS.forEach(po -> {
            po.setId(null);
            po.setOmadacId(omadacId.a());
            if (n.b.equals((Object)typeEnum)) {
                OtoNatTemplatePO templatePO = (OtoNatTemplatePO)po;
                templatePO.setSiteTemplateId(siteId);
            } else {
                OtoNatPO otoNatPO = (OtoNatPO)po;
                otoNatPO.setSiteId(siteId);
                if (siteCopyWrite) {
                    otoNatPO.setTemplateId(null);
                    otoNatPO.setOverride(null);
                }
                if (otoNatPO.getEntryId() == null) {
                    otoNatPO.setEntryId(this.getEntryIdService.a(omadacId.a(), siteId, OtoNatPO.class));
                }
            }
        });
        this.otoNatMongoRepository.a(otoNatPOS);
    }

    private void handleDisableNat(List<BaseDisableNatPO> disableNatPOS, @Nonnull c omadacId, @Nonnull String siteId, Map<String, Map<String, String>> siteImportIdCacheMap, n typeEnum, boolean siteCopyWrite) {
        if (CollectionUtils.isEmpty(disableNatPOS)) {
            return;
        }
        Map netIdsMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), v2 -> new HashMap());
        disableNatPOS.forEach(po -> {
            po.setId(null);
            po.setOmadacId(omadacId.a());
            po.setLanList(po.getLanList().stream().map(netIdsMap::get).collect(Collectors.toList()));
            if (n.b.equals((Object)typeEnum)) {
                DisableNatTemplatePO templatePO = (DisableNatTemplatePO)po;
                templatePO.setSiteTemplateId(siteId);
            } else {
                DisableNatPO disableNatPO = (DisableNatPO)po;
                disableNatPO.setSiteId(siteId);
                if (siteCopyWrite) {
                    disableNatPO.setTemplateId(null);
                    disableNatPO.setOverride(null);
                }
                if (disableNatPO.getEntryId() == null) {
                    disableNatPO.setEntryId(this.getEntryIdService.a(omadacId.a(), siteId, DisableNatPO.class));
                }
            }
        });
        this.disableNatMaintMongoRepository.a(disableNatPOS);
    }

    private void handleSessionLimitRule(List<BaseSessionLimitRulePO> sessionLimitRulePOS, @Nonnull c omadacId, @Nonnull String siteId, Map<String, Map<String, String>> siteImportIdCacheMap, n typeEnum, boolean siteCopyWrite) {
        if (CollectionUtils.isEmpty(sessionLimitRulePOS)) {
            return;
        }
        sessionLimitRulePOS.forEach(po -> {
            po.setId(null);
            po.setOmadacId(omadacId.a());
            if (n.b.equals((Object)typeEnum)) {
                SessionLimitTemplateRulePO templateRulePO = (SessionLimitTemplateRulePO)po;
                templateRulePO.setSiteTemplateId(siteId);
            } else {
                SessionLimitRulePO sessionLimitRulePO = (SessionLimitRulePO)po;
                sessionLimitRulePO.setSiteId(siteId);
                if (siteCopyWrite) {
                    sessionLimitRulePO.setTemplateId(null);
                    sessionLimitRulePO.setOverride(null);
                }
                if (sessionLimitRulePO.getEntryId() == null) {
                    sessionLimitRulePO.setEntryId(this.getEntryIdService.a(omadacId.a(), siteId, SessionLimitRulePO.class));
                }
            }
            switch (po.getSourceType()) {
                case 0: {
                    po.setSourceIds(com.tplink.smb.omada.common.util.e.a((List)po.getSourceIds(), (Map)((Map)siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.af.A()))));
                    break;
                }
                case 1: {
                    po.setSourceIds(com.tplink.smb.omada.common.util.e.a((List)po.getSourceIds(), (Map)((Map)siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.Y.A()))));
                    break;
                }
                default: {
                    log.error("import session limit rule failed in omadac {}. invalid parameter sourceType {}", (Object)omadacId, (Object)po.getSourceType());
                }
            }
        });
        this.sessionLimitRuleMongoRepository.a(sessionLimitRulePOS);
    }

    private void handleBandwidthCtrlRule(List<BaseBandwidthCtrlRulePO> bandwidthCtrlRulePOS, @Nonnull c omadacId, @Nonnull String siteId, Map<String, Map<String, String>> siteImportIdCacheMap, n typeEnum, boolean siteCopyWrite) {
        if (CollectionUtils.isEmpty(bandwidthCtrlRulePOS)) {
            return;
        }
        bandwidthCtrlRulePOS.forEach(po -> {
            po.setId(null);
            po.setOmadacId(omadacId.a());
            if (n.b.equals((Object)typeEnum)) {
                BandwidthCtrlRuleTemplatePO templatePO = (BandwidthCtrlRuleTemplatePO)po;
                templatePO.setSiteTemplateId(siteId);
            } else {
                BandwidthCtrlRulePO bandwidthCtrlRulePO = (BandwidthCtrlRulePO)po;
                bandwidthCtrlRulePO.setSiteId(siteId);
                if (siteCopyWrite) {
                    bandwidthCtrlRulePO.setTemplateId(null);
                    bandwidthCtrlRulePO.setOverride(null);
                }
                if (bandwidthCtrlRulePO.getEntryId() == null) {
                    bandwidthCtrlRulePO.setEntryId(this.getEntryIdService.a(omadacId.a(), siteId, BandwidthCtrlRulePO.class));
                }
            }
            switch (po.getSourceType()) {
                case 0: {
                    po.setSourceIds(com.tplink.smb.omada.common.util.e.a((List)po.getSourceIds(), (Map)((Map)siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.af.A()))));
                    break;
                }
                case 1: {
                    po.setSourceIds(com.tplink.smb.omada.common.util.e.a((List)po.getSourceIds(), (Map)((Map)siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.Y.A()))));
                    break;
                }
                default: {
                    log.error("import bandwidth ctrl rule failed in omadac {}. invalid parameter sourceType {}", (Object)omadacId, (Object)po.getSourceType());
                }
            }
        });
        this.bandwidthCtrlRuleMongoRepository.a(bandwidthCtrlRulePOS);
    }

    private void rebuildEntryId(StaticRoutingPO po) {
        if (po.getEntryId() == null) {
            log.info("rebuildEntryId for StaticRouting{}, omadacId{}", (Object)po.getId(), (Object)po.getOmadacId());
            po.setEntryId(this.getEntryIdService.a(po.getOmadacId(), po.getSiteId(), StaticRoutingPO.class));
        }
    }
}

