/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.transmission.restore;

import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.transmission.dto.TransmissionBKO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.e;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.bandwidthctrl.BaseBandwidthCtrlRulePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.f;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.h;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.i;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.policyrouting.BasePolicyRoutingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.sessionlimit.BaseSessionLimitRulePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.staticrouting.StaticRoutingPO;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V51520, b=d.TRANSMISSION)
public class TransmissionRestoreUnitV51520
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransmissionRestoreUnitV51520.class);
    private static TransmissionRestoreUnitV51520 instance = new TransmissionRestoreUnitV51520();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.l transmissionSettingMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.l.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.d osgStaticRoutingMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.d.a();
    private final g policyRoutingMongoRepository = g.a();
    private final h portForwardingMongoRepository = h.a();
    private final i sessionLimitRuleMongoRepository = i.a();
    private final a bandwidthCtrlRuleMongoRepository = a.a();
    private final f otoNatMongoRepository = f.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.c disableNatMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.c.a();
    private final e getEntryIdService = (e)com.tplink.smb.omada.common.spring.a.b(e.class);

    private TransmissionRestoreUnitV51520() {
    }

    public static TransmissionRestoreUnitV51520 getInstance() {
        return instance;
    }

    public void restore(b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        TransmissionBKO transmissionBKO = (TransmissionBKO)jsonParserWrapper.a(TransmissionBKO.class);
        Map siteMap = (Map)restoreCacheMap.computeIfAbsent(d.Q.A(), key -> new HashMap());
        Map lanNetworkMap = (Map)restoreCacheMap.computeIfAbsent(d.af.A(), key -> new HashMap());
        Map vpnMap = (Map)restoreCacheMap.computeIfAbsent(d.al.A(), key -> new HashMap());
        Map profileMap = (Map)restoreCacheMap.computeIfAbsent(d.Y.A(), k2 -> new HashMap());
        Map transTemplateIdMap = (Map)restoreCacheMap.computeIfAbsent(d.au.A(), key -> new HashMap());
        Map netIdMap = (Map)restoreCacheMap.computeIfAbsent(d.af.A(), key -> new HashMap());
        Optional.ofNullable(transmissionBKO.getTransmissionSetting()).ifPresent(po -> {
            po.setOmadacId(omadacId.a());
            po.setSiteId((String)siteMap.get(po.getSiteId()));
            if (po.getTemplateId() != null) {
                String oldTemplateId = po.getTemplateId();
                po.setTemplateId((String)transTemplateIdMap.get(oldTemplateId));
            }
            po.setId(null);
            this.transmissionSettingMongoRepository.a(po);
        });
        Optional.ofNullable(transmissionBKO.getTransmissionSettingTemplate()).ifPresent(po -> {
            String oldId = po.getId();
            po.setOmadacId(omadacId.a());
            po.setSiteTemplateId((String)siteMap.get(po.getSiteTemplateId()));
            po.setId(null);
            String newId = this.transmissionSettingMongoRepository.a(po).getId();
            transTemplateIdMap.put(oldId, newId);
        });
        Optional.ofNullable(transmissionBKO.getStaticRoutings()).ifPresent(staticRoutingPOS -> {
            staticRoutingPOS.forEach(po -> {
                po.setOmadacId(omadacId.a());
                po.setSiteId((String)siteMap.get(po.getSiteId()));
                po.setInterfaceNetId((String)lanNetworkMap.get(po.getInterfaceNetId()));
                po.setVpnId((String)vpnMap.get(po.getVpnId()));
                po.setVirtualWanId((String)netIdMap.get(po.getVirtualWanId()));
                this.rebuildEntryId((StaticRoutingPO)po);
                if (po.getTemplateId() != null) {
                    String oldTemplateId = po.getTemplateId();
                    po.setTemplateId((String)transTemplateIdMap.get(oldTemplateId));
                }
            });
            this.osgStaticRoutingMongoRepository.a(new ArrayList(staticRoutingPOS));
        });
        Optional.ofNullable(transmissionBKO.getStaticRoutingsTemplate()).ifPresent(staticRoutingTemplatePOS -> staticRoutingTemplatePOS.forEach(po -> {
            String oldId = po.getId();
            po.setOmadacId(omadacId.a());
            po.setSiteTemplateId((String)siteMap.get(po.getSiteTemplateId()));
            po.setInterfaceNetId((String)lanNetworkMap.get(po.getInterfaceNetId()));
            po.setVpnId((String)vpnMap.get(po.getVpnId()));
            po.setVirtualWanId((String)netIdMap.get(po.getVirtualWanId()));
            po.setId(null);
            String newId = this.osgStaticRoutingMongoRepository.a(po);
            transTemplateIdMap.put(oldId, newId);
        }));
        Optional.ofNullable(transmissionBKO.getPolicyRoutings()).ifPresent(policyRoutingPOS -> {
            policyRoutingPOS.forEach(po -> {
                po.setOmadacId(omadacId.a());
                po.setSiteId((String)siteMap.get(po.getSiteId()));
                this.handlePolicyRouting((BasePolicyRoutingPO)po, lanNetworkMap, profileMap);
                po.setVpnId((String)vpnMap.get(po.getVpnId()));
                if (!CollectionUtils.isEmpty((Collection)po.getVpnIds())) {
                    po.setVpnIds(po.getVpnIds().stream().map(vpnMap::get).filter(Objects::nonNull).collect(Collectors.toList()));
                }
                if (!CollectionUtils.isEmpty((Collection)po.getVirtualWanIds())) {
                    po.setVirtualWanIds(po.getVirtualWanIds().stream().map(netIdMap::get).filter(Objects::nonNull).collect(Collectors.toList()));
                }
                if (po.getTemplateId() != null) {
                    String oldTemplateId = po.getTemplateId();
                    po.setTemplateId((String)transTemplateIdMap.get(oldTemplateId));
                }
            });
            this.policyRoutingMongoRepository.a(new ArrayList(policyRoutingPOS));
        });
        Optional.ofNullable(transmissionBKO.getPolicyRoutingsTemplate()).ifPresent(policyRoutingTemplatePOS -> policyRoutingTemplatePOS.forEach(po -> {
            String oldId = po.getId();
            po.setOmadacId(omadacId.a());
            po.setSiteTemplateId((String)siteMap.get(po.getSiteTemplateId()));
            this.handlePolicyRouting((BasePolicyRoutingPO)po, lanNetworkMap, profileMap);
            po.setVpnId((String)vpnMap.get(po.getVpnId()));
            if (!CollectionUtils.isEmpty((Collection)po.getVpnIds())) {
                po.setVpnIds(po.getVpnIds().stream().map(vpnMap::get).filter(Objects::nonNull).collect(Collectors.toList()));
            }
            if (!CollectionUtils.isEmpty((Collection)po.getVirtualWanIds())) {
                po.setVirtualWanIds(po.getVirtualWanIds().stream().map(netIdMap::get).filter(Objects::nonNull).collect(Collectors.toList()));
            }
            po.setId(null);
            String newId = this.policyRoutingMongoRepository.a(po).getId();
            transTemplateIdMap.put(oldId, newId);
        }));
        Optional.ofNullable(transmissionBKO.getPortForwardings()).ifPresent(portForwardingPOS -> {
            portForwardingPOS.forEach(po -> {
                po.setOmadacId(omadacId.a());
                po.setSiteId((String)siteMap.get(po.getSiteId()));
                if (!CollectionUtils.isEmpty((Collection)po.getVirtualWanId())) {
                    po.setVirtualWanId(po.getVirtualWanId().stream().map(netIdMap::get).filter(Objects::nonNull).toList());
                }
                if (po.getTemplateId() != null) {
                    String oldTemplateId = po.getTemplateId();
                    po.setTemplateId((String)transTemplateIdMap.get(oldTemplateId));
                }
            });
            this.portForwardingMongoRepository.a(new ArrayList(portForwardingPOS));
        });
        Optional.ofNullable(transmissionBKO.getPortForwardingsTemplate()).ifPresent(portForwardingTemplatePOS -> portForwardingTemplatePOS.forEach(po -> {
            String oldId = po.getId();
            po.setOmadacId(omadacId.a());
            po.setSiteTemplateId((String)siteMap.get(po.getSiteTemplateId()));
            if (!CollectionUtils.isEmpty((Collection)po.getVirtualWanId())) {
                po.setVirtualWanId(po.getVirtualWanId().stream().map(netIdMap::get).filter(Objects::nonNull).toList());
            }
            po.setId(null);
            String newId = this.portForwardingMongoRepository.a(po).getId();
            transTemplateIdMap.put(oldId, newId);
        }));
        Optional.ofNullable(transmissionBKO.getSessionLimitRules()).ifPresent(sessionLimitRulePOS -> {
            sessionLimitRulePOS.forEach(po -> {
                po.setOmadacId(omadacId.a());
                po.setSiteId((String)siteMap.get(po.getSiteId()));
                this.handleSessionLimitRule((BaseSessionLimitRulePO)po, lanNetworkMap, profileMap);
                if (po.getTemplateId() != null) {
                    String oldTemplateId = po.getTemplateId();
                    po.setTemplateId((String)transTemplateIdMap.get(oldTemplateId));
                }
            });
            this.sessionLimitRuleMongoRepository.a(new ArrayList(sessionLimitRulePOS));
        });
        Optional.ofNullable(transmissionBKO.getSessionLimitRulesTemplate()).ifPresent(sessionLimitTemplateRulePOS -> sessionLimitTemplateRulePOS.forEach(po -> {
            String oldId = po.getId();
            po.setOmadacId(omadacId.a());
            po.setSiteTemplateId((String)siteMap.get(po.getSiteTemplateId()));
            this.handleSessionLimitRule((BaseSessionLimitRulePO)po, lanNetworkMap, profileMap);
            po.setId(null);
            String newId = this.sessionLimitRuleMongoRepository.a(po).getId();
            transTemplateIdMap.put(oldId, newId);
        }));
        Optional.ofNullable(transmissionBKO.getBandwidthCtrlRules()).ifPresent(bandwidthCtrlRulePOS -> {
            bandwidthCtrlRulePOS.forEach(po -> {
                po.setOmadacId(omadacId.a());
                po.setSiteId((String)siteMap.get(po.getSiteId()));
                this.handleBandwidthCtrlRule((BaseBandwidthCtrlRulePO)po, lanNetworkMap, profileMap);
                if (po.getTemplateId() != null) {
                    String oldTemplateId = po.getTemplateId();
                    po.setTemplateId((String)transTemplateIdMap.get(oldTemplateId));
                }
            });
            this.bandwidthCtrlRuleMongoRepository.a(new ArrayList(bandwidthCtrlRulePOS));
        });
        Optional.ofNullable(transmissionBKO.getBandwidthCtrlRulesTemplate()).ifPresent(bandwidthCtrlRuleTemplatePOS -> bandwidthCtrlRuleTemplatePOS.forEach(po -> {
            String oldId = po.getId();
            po.setOmadacId(omadacId.a());
            po.setSiteTemplateId((String)siteMap.get(po.getSiteTemplateId()));
            this.handleBandwidthCtrlRule((BaseBandwidthCtrlRulePO)po, lanNetworkMap, profileMap);
            po.setId(null);
            String newId = this.bandwidthCtrlRuleMongoRepository.a(po).getId();
            transTemplateIdMap.put(oldId, newId);
        }));
        Optional.ofNullable(transmissionBKO.getOtoNats()).ifPresent(otoNatPOS -> {
            otoNatPOS.forEach(po -> {
                po.setOmadacId(omadacId.a());
                po.setSiteId((String)siteMap.get(po.getSiteId()));
                if (po.getTemplateId() != null) {
                    String oldTemplateId = po.getTemplateId();
                    po.setTemplateId((String)transTemplateIdMap.get(oldTemplateId));
                }
            });
            this.otoNatMongoRepository.a(new ArrayList(otoNatPOS));
        });
        Optional.ofNullable(transmissionBKO.getOtoNatsTemplate()).ifPresent(otoNatTemplatePOS -> otoNatTemplatePOS.forEach(po -> {
            String oldId = po.getId();
            po.setOmadacId(omadacId.a());
            po.setSiteTemplateId((String)siteMap.get(po.getSiteTemplateId()));
            po.setId(null);
            String newId = this.otoNatMongoRepository.a(po).getId();
            transTemplateIdMap.put(oldId, newId);
        }));
        Optional.ofNullable(transmissionBKO.getDisableNats()).ifPresent(disableNatPOS -> {
            disableNatPOS.forEach(po -> {
                po.setId(null);
                po.setOmadacId(omadacId.a());
                po.setSiteId((String)siteMap.get(po.getSiteId()));
                po.setLanList(po.getLanList().stream().map(lanNetworkMap::get).collect(Collectors.toList()));
                if (po.getTemplateId() != null) {
                    String oldTemplateId = po.getTemplateId();
                    po.setTemplateId((String)transTemplateIdMap.get(oldTemplateId));
                }
            });
            this.disableNatMongoRepository.a(new ArrayList(disableNatPOS));
        });
        Optional.ofNullable(transmissionBKO.getDisableNatsTemplate()).ifPresent(disableNatTemplatePOS -> disableNatTemplatePOS.forEach(po -> {
            String oldId = po.getId();
            po.setOmadacId(omadacId.a());
            po.setSiteTemplateId((String)siteMap.get(po.getSiteTemplateId()));
            po.setLanList(po.getLanList().stream().map(lanNetworkMap::get).collect(Collectors.toList()));
            po.setId(null);
            String newId = this.disableNatMongoRepository.a(po).getId();
            transTemplateIdMap.put(oldId, newId);
        }));
        restoreCacheMap.put(d.au.A(), transTemplateIdMap);
    }

    private void handlePolicyRouting(@Nonnull BasePolicyRoutingPO po, Map<String, String> lanNetworkMap, Map<String, String> profileMap) {
        switch (po.getSourceType()) {
            case 0: {
                po.setSourceIds(po.getSourceIds().stream().map(lanNetworkMap::get).collect(Collectors.toList()));
                break;
            }
            case 1: 
            case 2: {
                po.setSourceIds(po.getSourceIds().stream().map(profileMap::get).collect(Collectors.toList()));
                break;
            }
        }
        switch (po.getDestinationType()) {
            case 0: {
                po.setDestinationIds(po.getDestinationIds().stream().map(lanNetworkMap::get).collect(Collectors.toList()));
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: {
                po.setDestinationIds(po.getDestinationIds().stream().map(profileMap::get).collect(Collectors.toList()));
                break;
            }
        }
    }

    private void handleSessionLimitRule(@Nonnull BaseSessionLimitRulePO po, Map<String, String> lanNetworkMap, Map<String, String> profileMap) {
        switch (po.getSourceType()) {
            case 0: {
                po.setSourceIds(po.getSourceIds().stream().map(lanNetworkMap::get).collect(Collectors.toList()));
                break;
            }
            case 1: {
                po.setSourceIds(po.getSourceIds().stream().map(profileMap::get).collect(Collectors.toList()));
                break;
            }
        }
    }

    private void handleBandwidthCtrlRule(@Nonnull BaseBandwidthCtrlRulePO po, Map<String, String> lanNetworkMap, Map<String, String> profileMap) {
        switch (po.getSourceType()) {
            case 0: {
                po.setSourceIds(po.getSourceIds().stream().map(lanNetworkMap::get).collect(Collectors.toList()));
                break;
            }
            case 1: {
                po.setSourceIds(po.getSourceIds().stream().map(profileMap::get).collect(Collectors.toList()));
                break;
            }
        }
    }

    private void handleDisableNat(c omadacId, Map<String, String> newSiteIdMap, TransmissionBKO transmissionBKO, Map<String, String> netIdsMap) {
        Optional.ofNullable(transmissionBKO.getDisableNats()).ifPresent(disableNatPOS -> {
            disableNatPOS.forEach(po -> {
                po.setId(null);
                po.setOmadacId(omadacId.a());
                po.setSiteId((String)newSiteIdMap.get(po.getSiteId()));
                po.setLanList(po.getLanList().stream().map(netIdsMap::get).collect(Collectors.toList()));
            });
            this.disableNatMongoRepository.a(new ArrayList(disableNatPOS));
        });
    }

    private void rebuildEntryId(StaticRoutingPO po) {
        if (po.getEntryId() == null) {
            log.info("rebuildEntryId for StaticRouting{}, omadacId{}", (Object)po.getId(), (Object)po.getOmadacId());
            po.setEntryId(this.getEntryIdService.a(po.getOmadacId(), po.getSiteId(), StaticRoutingPO.class));
        }
    }
}

