/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.transmission.restore;

import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.transmission.dto.TransmissionBKO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.e;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.bandwidthctrl.BandwidthCtrlRulePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.f;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.h;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.i;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.policyrouting.PolicyRoutingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.sessionlimit.SessionLimitRulePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.staticrouting.StaticRoutingPO;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V50000, b=d.TRANSMISSION)
public class TransmissionRestoreUnitV50000
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransmissionRestoreUnitV50000.class);
    private static TransmissionRestoreUnitV50000 instance = new TransmissionRestoreUnitV50000();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.l transmissionSettingMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.l.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.d osgStaticRoutingMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.d.a();
    private final g policyRoutingMongoRepository = g.a();
    private final h portForwardingMongoRepository = h.a();
    private final i sessionLimitRuleMongoRepository = i.a();
    private final a bandwidthCtrlRuleMongoRepository = a.a();
    private final f otoNatMongoRepository = f.a();
    private final e getEntryIdService = (e)com.tplink.smb.omada.common.spring.a.b(e.class);
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.c disableNatMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.c.a();

    private TransmissionRestoreUnitV50000() {
    }

    public static TransmissionRestoreUnitV50000 getInstance() {
        return instance;
    }

    public void restore(b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        TransmissionBKO transmissionBKO = (TransmissionBKO)jsonParserWrapper.a(TransmissionBKO.class);
        Map siteMap = (Map)restoreCacheMap.computeIfAbsent(d.Q.A(), key -> new HashMap());
        Map lanNetworkMap = (Map)restoreCacheMap.computeIfAbsent(d.af.A(), key -> new HashMap());
        Map vpnMap = (Map)restoreCacheMap.computeIfAbsent(d.al.A(), key -> new HashMap());
        Map profileMap = (Map)restoreCacheMap.computeIfAbsent(d.Y.A(), k2 -> new HashMap());
        Optional.ofNullable(transmissionBKO.getTransmissionSetting()).ifPresent(po -> {
            po.setOmadacId(omadacId.a());
            po.setSiteId((String)siteMap.get(po.getSiteId()));
            this.transmissionSettingMongoRepository.a(po);
        });
        Optional.ofNullable(transmissionBKO.getStaticRoutings()).ifPresent(staticRoutingPOS -> {
            staticRoutingPOS.forEach(po -> {
                po.setOmadacId(omadacId.a());
                po.setSiteId((String)siteMap.get(po.getSiteId()));
                po.setInterfaceNetId((String)lanNetworkMap.get(po.getInterfaceNetId()));
                po.setVpnId((String)vpnMap.get(po.getVpnId()));
                if (po.getVirtualWanId() != null) {
                    po.setVirtualWanId((String)lanNetworkMap.get(po.getVirtualWanId()));
                }
                this.rebuildEntryId((StaticRoutingPO)po);
            });
            this.osgStaticRoutingMongoRepository.a(new ArrayList(staticRoutingPOS));
        });
        Optional.ofNullable(transmissionBKO.getPolicyRoutings()).ifPresent(policyRoutingPOS -> {
            policyRoutingPOS.forEach(po -> {
                po.setOmadacId(omadacId.a());
                po.setSiteId((String)siteMap.get(po.getSiteId()));
                this.handlePolicyRouting((PolicyRoutingPO)po, lanNetworkMap, profileMap);
                if (!CollectionUtils.isEmpty((Collection)po.getVirtualWanIds())) {
                    ArrayList<String> virtualWanIds = new ArrayList<String>();
                    for (String virtualWanId : po.getVirtualWanIds()) {
                        virtualWanIds.add((String)lanNetworkMap.get(virtualWanId));
                    }
                    po.setVirtualWanIds(virtualWanIds);
                }
                po.setVpnId((String)vpnMap.get(po.getVpnId()));
                if (!CollectionUtils.isEmpty((Collection)po.getVpnIds())) {
                    po.setVpnIds(po.getVpnIds().stream().map(vpnMap::get).filter(Objects::nonNull).collect(Collectors.toList()));
                }
            });
            this.policyRoutingMongoRepository.a(new ArrayList(policyRoutingPOS));
        });
        Optional.ofNullable(transmissionBKO.getPortForwardings()).ifPresent(portForwardingPOS -> {
            portForwardingPOS.forEach(po -> {
                po.setOmadacId(omadacId.a());
                po.setSiteId((String)siteMap.get(po.getSiteId()));
            });
            this.portForwardingMongoRepository.a(new ArrayList(portForwardingPOS));
        });
        Optional.ofNullable(transmissionBKO.getSessionLimitRules()).ifPresent(sessionLimitRulePOS -> {
            sessionLimitRulePOS.forEach(po -> {
                po.setOmadacId(omadacId.a());
                po.setSiteId((String)siteMap.get(po.getSiteId()));
                this.handleSessionLimitRule((SessionLimitRulePO)po, lanNetworkMap, profileMap);
            });
            this.sessionLimitRuleMongoRepository.a(new ArrayList(sessionLimitRulePOS));
        });
        Optional.ofNullable(transmissionBKO.getBandwidthCtrlRules()).ifPresent(bandwidthCtrlRulePOS -> {
            bandwidthCtrlRulePOS.forEach(po -> {
                po.setOmadacId(omadacId.a());
                po.setSiteId((String)siteMap.get(po.getSiteId()));
                this.handleBandwidthCtrlRule((BandwidthCtrlRulePO)po, lanNetworkMap, profileMap);
            });
            this.bandwidthCtrlRuleMongoRepository.a(new ArrayList(bandwidthCtrlRulePOS));
        });
        Optional.ofNullable(transmissionBKO.getOtoNats()).ifPresent(otoNatPOS -> {
            otoNatPOS.forEach(po -> {
                po.setOmadacId(omadacId.a());
                po.setSiteId((String)siteMap.get(po.getSiteId()));
            });
            this.otoNatMongoRepository.a(new ArrayList(otoNatPOS));
        });
        this.handleDisableNat(omadacId, siteMap, transmissionBKO, lanNetworkMap);
    }

    private void handlePolicyRouting(@Nonnull PolicyRoutingPO po, Map<String, String> lanNetworkMap, Map<String, String> profileMap) {
        switch (po.getSourceType()) {
            case 0: {
                po.setSourceIds(po.getSourceIds().stream().map(lanNetworkMap::get).collect(Collectors.toList()));
                break;
            }
            case 1: 
            case 2: {
                po.setSourceIds(po.getSourceIds().stream().map(profileMap::get).collect(Collectors.toList()));
                break;
            }
        }
        switch (po.getDestinationType()) {
            case 0: {
                po.setDestinationIds(po.getDestinationIds().stream().map(lanNetworkMap::get).collect(Collectors.toList()));
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: {
                po.setDestinationIds(po.getDestinationIds().stream().map(profileMap::get).collect(Collectors.toList()));
                break;
            }
        }
    }

    private void handleSessionLimitRule(@Nonnull SessionLimitRulePO po, Map<String, String> lanNetworkMap, Map<String, String> profileMap) {
        switch (po.getSourceType()) {
            case 0: {
                po.setSourceIds(po.getSourceIds().stream().map(lanNetworkMap::get).collect(Collectors.toList()));
                break;
            }
            case 1: {
                po.setSourceIds(po.getSourceIds().stream().map(profileMap::get).collect(Collectors.toList()));
                break;
            }
        }
    }

    private void handleBandwidthCtrlRule(@Nonnull BandwidthCtrlRulePO po, Map<String, String> lanNetworkMap, Map<String, String> profileMap) {
        switch (po.getSourceType()) {
            case 0: {
                po.setSourceIds(po.getSourceIds().stream().map(lanNetworkMap::get).collect(Collectors.toList()));
                break;
            }
            case 1: {
                po.setSourceIds(po.getSourceIds().stream().map(profileMap::get).collect(Collectors.toList()));
                break;
            }
        }
    }

    private void handleDisableNat(c omadacId, Map<String, String> newSiteIdMap, TransmissionBKO transmissionBKO, Map<String, String> netIdsMap) {
        Optional.ofNullable(transmissionBKO.getDisableNats()).ifPresent(disableNatPOS -> {
            disableNatPOS.forEach(po -> {
                po.setId(null);
                po.setOmadacId(omadacId.a());
                po.setSiteId((String)newSiteIdMap.get(po.getSiteId()));
                po.setLanList(po.getLanList().stream().map(netIdsMap::get).collect(Collectors.toList()));
            });
            this.disableNatMaintMongoRepository.a(new ArrayList(disableNatPOS));
        });
    }

    private void rebuildEntryId(StaticRoutingPO po) {
        if (po.getEntryId() == null) {
            log.info("rebuildEntryId for StaticRouting{}, omadacId{}", (Object)po.getId(), (Object)po.getOmadacId());
            po.setEntryId(this.getEntryIdService.a(po.getOmadacId(), po.getSiteId(), StaticRoutingPO.class));
        }
    }
}

