/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.stack.siteimport;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.d.a;
import com.tplink.smb.omada.backup.core.unit.siteconfig.stack.dto.OswStackBackupDTO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.device.LocationPO;
import com.tplink.smb.omada.manager.port.mongo.device.cliconfig.CliSettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.cliconfig.DecodeCliPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.AbstractOswPortSettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswQosConfigPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.j;
import com.tplink.smb.omada.manager.port.mongo.device.osw.lag.OswLagPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.port.OswPortPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.q;
import com.tplink.smb.omada.manager.port.mongo.device.osw.s;
import com.tplink.smb.omada.manager.port.mongo.device.osw.staticroute.OswStaticRoutingPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.t;
import com.tplink.smb.omada.manager.port.mongo.device.osw.x;
import com.tplink.smb.omada.manager.stack.port.mongo.stack.OswStackMemberPO;
import com.tplink.smb.omada.manager.stack.port.mongo.stack.OswStackPO;
import com.tplink.smb.omada.manager.stack.port.mongo.stack.StackSettingPO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.IterableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.d(a=com.tplink.smb.omada.backup.api.c.d.OSW_STACK)
public class OswStackSiteImportUnit
extends com.tplink.smb.omada.backup.api.c {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OswStackSiteImportUnit.class);
    private final s oswStackMaintMongoRepository = s.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.osw.a oswLagMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.osw.a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c lanNetworkMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c.a();
    private final j oswNetworkMaintMongoRepository = j.a();
    private final t oswStaticRoutingMaintMongoRepository = t.a();
    private final q oswPortMaintMongoRepository = q.a();
    private static final OswStackSiteImportUnit instance = new OswStackSiteImportUnit();
    private final x oswVrfMaintMongoRepository = x.a();

    private OswStackSiteImportUnit() {
    }

    public static OswStackSiteImportUnit getInstance() {
        return instance;
    }

    public void siteImport(b jsonParserWrapper, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        JsonParser jsonParser = jsonParserWrapper.h();
        jsonParser.nextToken();
        Map cliConfigMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.aD.A(), key -> new HashMap());
        Map oswProfileMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.ah.A(), k2 -> new HashMap());
        Map portTagIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.av.A(), k2 -> new HashMap());
        Map vrfIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Z.A(), v2 -> new HashMap());
        boolean skipDevice = Boolean.TRUE.equals(restoreCacheMap.get("skipDevice"));
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            Map<String, String> mapMap;
            OswStackPO oswStackPO;
            OswStackBackupDTO dto = (OswStackBackupDTO)jsonParserWrapper.a(OswStackBackupDTO.class);
            if (skipDevice || (oswStackPO = dto.getStack()) == null || oswStackPO.getStackSetting() == null) continue;
            StackSettingPO stackSetting = oswStackPO.getStackSetting();
            OswStackPO oswStackPOInDb = this.oswStackMaintMongoRepository.c(omadacId.a(), oswStackPO.getStackId());
            if (oswStackPOInDb != null) {
                log.info("Stack: {} is already exists in the database, skip it.", (Object)oswStackPOInDb.getStackId());
                continue;
            }
            Map<String, String> lanNetworkMaps = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.af.A());
            this.handleMvlanNetwork(stackSetting, omadacId, lanNetworkMaps);
            Map<Integer, String> lagIdNumMap = this.handleOswStackLags(dto.getOswLagPOS(), omadacId, newSiteId, lanNetworkMaps, portTagIdMap);
            this.handleOswPort(omadacId, newSiteId, oswStackPO, lagIdNumMap);
            LocationPO location = stackSetting.getLocation();
            if (location != null && !CollectionUtils.isEmpty(mapMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.aI.A()))) {
                String mapIdNew = mapMap.get(location.getMapId());
                location.setMapId(mapIdNew);
            }
            oswStackPO.setId(null);
            oswStackPO.setSiteId(newSiteId.a());
            oswStackPO.setOmadacId(omadacId.a());
            this.handleStackCli(oswStackPO.getStackSetting().getCliSetting(), cliConfigMap);
            this.handleStackSwitchQos(stackSetting, oswProfileMap);
            this.oswStackMaintMongoRepository.a(oswStackPO);
            this.handleOswVlanIf(dto, omadacId, newSiteId, lanNetworkMaps, vrfIdMap);
            this.handleOswStaticRouting(dto, omadacId, newSiteId, vrfIdMap);
        }
    }

    private void handleOswPort(c omadacId, d newSiteId, OswStackPO oswStackPO, Map<Integer, String> lagIdNumMap) {
        if (CollectionUtils.isEmpty(lagIdNumMap)) {
            return;
        }
        Set<Integer> lagSet = lagIdNumMap.keySet();
        if (CollectionUtils.isEmpty((Collection)oswStackPO.getMembers())) {
            return;
        }
        List members = oswStackPO.getMembers().stream().map(OswStackMemberPO::getMac).collect(Collectors.toList());
        List oswPortPOList = this.oswPortMaintMongoRepository.a(omadacId.a(), members);
        ArrayList<OswPortPO> modified = new ArrayList<OswPortPO>();
        for (OswPortPO oswPortPO : oswPortPOList) {
            if (!Objects.nonNull(oswPortPO.getLag()) || !lagSet.contains(oswPortPO.getLag())) continue;
            oswPortPO.setLagId(lagIdNumMap.get(oswPortPO.getLag()));
            modified.add(oswPortPO);
        }
        if (!CollectionUtils.isEmpty(modified)) {
            this.oswPortMaintMongoRepository.a(modified);
        }
    }

    private void handleStackSwitchQos(StackSettingPO stackSetting, Map<String, String> profileMap) {
        OswQosConfigPO qosConfig = stackSetting.getQosConfig();
        if (Objects.isNull(qosConfig)) {
            return;
        }
        if (Objects.nonNull(qosConfig.getDscpDot1pMappingId())) {
            qosConfig.setDscpDot1pMappingId(profileMap.get(qosConfig.getDscpDot1pMappingId()));
        }
        if (Objects.nonNull(qosConfig.getDot1pQueueMappingId())) {
            qosConfig.setDot1pQueueMappingId(profileMap.get(qosConfig.getDot1pQueueMappingId()));
        }
        if (Objects.nonNull(qosConfig.getQueueSchedulerMappingId())) {
            qosConfig.setQueueSchedulerMappingId(profileMap.get(qosConfig.getQueueSchedulerMappingId()));
        }
    }

    private void handleStackCli(CliSettingPO cliSetting, Map<String, String> cliConfigMap) {
        if (Objects.nonNull(cliSetting) && !CollectionUtils.isEmpty((Collection)cliSetting.getCliConfigs())) {
            for (DecodeCliPO decodeCli : cliSetting.getCliConfigs()) {
                decodeCli.setConfigId(cliConfigMap.getOrDefault(decodeCli.getConfigId(), decodeCli.getConfigId()));
            }
        }
    }

    private Map<Integer, String> handleOswStackLags(List<OswLagPO> oswLags, c omadacId, d newSiteId, Map<String, String> lanNetworkMaps, Map<String, String> portTagIdMap) {
        HashMap<Integer, String> lagIdMap = new HashMap<Integer, String>(12);
        if (!CollectionUtils.isEmpty(oswLags)) {
            ArrayList<OswLagPO> oswLagRealList = new ArrayList<OswLagPO>();
            for (OswLagPO oswLagPO2 : oswLags) {
                oswLagPO2.setId(null);
                oswLagPO2.setSiteId(newSiteId.a());
                oswLagPO2.setLanProfileId(lanNetworkMaps.get(oswLagPO2.getLanProfileId()));
                a.a((AbstractOswPortSettingPO)oswLagPO2, portTagIdMap);
                a.b((AbstractOswPortSettingPO)oswLagPO2, lanNetworkMaps);
                oswLagPO2.setOmadacId(omadacId.a());
                oswLagRealList.add(oswLagPO2);
            }
            List oswLagPOS = IterableUtils.toList((Iterable)this.oswLagMaintMongoRepository.a(oswLagRealList));
            if (!CollectionUtils.isEmpty((Collection)oswLagPOS)) {
                oswLagPOS.forEach(oswLagPO -> lagIdMap.put(oswLagPO.getLag(), oswLagPO.getId()));
            }
        }
        return lagIdMap;
    }

    private void handleMvlanNetwork(StackSettingPO stackSetting, c omadacId, Map<String, String> lanNetworkMaps) {
        if (stackSetting.getMvlanNetworkId() != null && !CollectionUtils.isEmpty(lanNetworkMaps)) {
            this.lanNetworkMaintMongoRepository.a(omadacId.a(), lanNetworkMaps.get(stackSetting.getMvlanNetworkId())).ifPresent(lanNetworkPO -> stackSetting.setMvlanNetworkId(lanNetworkPO.getId()));
        }
    }

    private void handleOswVlanIf(OswStackBackupDTO dto, c omadacId, d newSiteId, Map<String, String> lanNetworkMaps, Map<String, String> vrfIdMap) {
        List<OswNetworkPO> vlanIfs = dto.getVlanIfs();
        if (!CollectionUtils.isEmpty(vlanIfs)) {
            for (OswNetworkPO oswNetwork : vlanIfs) {
                oswNetwork.setId(null);
                oswNetwork.setOmadacId(omadacId.a());
                oswNetwork.setSite(newSiteId.a());
                oswNetwork.setLanNetworkId(lanNetworkMaps.get(oswNetwork.getLanNetworkId()));
                oswNetwork.setVrfId(vrfIdMap.get(oswNetwork.getVrfId()));
                if (oswNetwork.getDhcpServer() != null) {
                    oswNetwork.getDhcpServer().setVrfId(vrfIdMap.get(oswNetwork.getDhcpServer().getVrfId()));
                }
                if (oswNetwork.getDhcpRelay() == null) continue;
                oswNetwork.getDhcpRelay().setVrfId(vrfIdMap.get(oswNetwork.getDhcpRelay().getVrfId()));
            }
            this.oswNetworkMaintMongoRepository.a(vlanIfs);
        }
    }

    private void handleOswStaticRouting(OswStackBackupDTO dto, c omadacId, d newSiteId, Map<String, String> vrfIdMap) {
        List<OswStaticRoutingPO> staticRoutings = dto.getStaticRoutings();
        if (!CollectionUtils.isEmpty(staticRoutings)) {
            for (OswStaticRoutingPO oswStaticRoutingPO : staticRoutings) {
                oswStaticRoutingPO.setId(null);
                oswStaticRoutingPO.setOmadacId(omadacId.a());
                oswStaticRoutingPO.setSiteId(newSiteId.a());
                oswStaticRoutingPO.setVrfId(vrfIdMap.get(oswStaticRoutingPO.getVrfId()));
                oswStaticRoutingPO.setNextHopVrfId(vrfIdMap.get(oswStaticRoutingPO.getNextHopVrfId()));
            }
            this.oswStaticRoutingMaintMongoRepository.a(staticRoutings);
        }
    }

    public void siteCopyWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
    }

    public void siteTemplateCopyWrite(Object dataObject, c omadacId, d newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c, IOException {
    }
}

