/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.stack.restore;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.d.a;
import com.tplink.smb.omada.backup.core.unit.siteconfig.stack.dto.OswStackBackupDTO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.manager.port.mongo.device.cliconfig.CliSettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.cliconfig.DecodeCliPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.AbstractOswPortSettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswQosConfigPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.j;
import com.tplink.smb.omada.manager.port.mongo.device.osw.lag.OswLagPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.port.OswPortPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.q;
import com.tplink.smb.omada.manager.port.mongo.device.osw.s;
import com.tplink.smb.omada.manager.port.mongo.device.osw.staticroute.OswStaticRoutingPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.t;
import com.tplink.smb.omada.manager.port.mongo.device.osw.x;
import com.tplink.smb.omada.manager.stack.port.mongo.stack.OswStackMemberPO;
import com.tplink.smb.omada.manager.stack.port.mongo.stack.OswStackPO;
import com.tplink.smb.omada.manager.stack.port.mongo.stack.StackSettingPO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.IterableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V51200, b=d.OSW_STACK)
public class OswStackRestoreUnitV51200
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OswStackRestoreUnitV51200.class);
    private static final OswStackRestoreUnitV51200 instance = new OswStackRestoreUnitV51200();
    private final s oswStackMaintMongoRepository = s.a();
    private final j oswNetworkMaintMongoRepository = j.a();
    private final t oswStaticRoutingMaintMongoRepository = t.a();
    private final q oswPortMaintMongoRepository = q.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.osw.a oswLagMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.osw.a.a();
    private final x oswVrfMaintMongoRepository = x.a();

    public static OswStackRestoreUnitV51200 getInstance() {
        return instance;
    }

    private OswStackRestoreUnitV51200() {
    }

    public void restore(b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        boolean lanNetworkInvalid;
        log.debug("Start to restore stack, OmadacId: {}", (Object)omadacId);
        Map lanNetworkIdMap = (Map)restoreCacheMap.get(d.af.A());
        Map siteIdMaps = (Map)restoreCacheMap.get(d.Q.A());
        Map mapIdMap = restoreCacheMap.getOrDefault(d.aI.A(), new HashMap());
        Map cliConfigMap = (Map)restoreCacheMap.computeIfAbsent(d.aD.A(), key -> new HashMap());
        Map oswProfileMap = (Map)restoreCacheMap.computeIfAbsent(d.ah.A(), k2 -> new HashMap());
        Map portTagIdMap = (Map)restoreCacheMap.computeIfAbsent(d.av.A(), k2 -> new HashMap());
        Map vrfIdMap = (Map)restoreCacheMap.computeIfAbsent(d.Z.A(), v2 -> new HashMap());
        boolean siteInvalid = siteIdMaps == null;
        boolean bl = lanNetworkInvalid = lanNetworkIdMap == null;
        if (siteInvalid || lanNetworkInvalid) {
            log.info("V52000 Failed to restore stack in omadac {} because of Failed get lanNetworkInfo maps from restore cache. reason: siteIdMaps is null {} or lanNetworkInfoMaps is null {}.", new Object[]{omadacId, siteInvalid, lanNetworkInvalid});
            throw new com.tplink.smb.omada.backup.api.d.c("Reason: siteIdMaps is null " + siteInvalid + "or lanNetworkInfoMaps is null." + lanNetworkInvalid);
        }
        JsonParser jsonParser = jsonParserWrapper.h();
        jsonParser.nextToken();
        boolean skipDevice = Boolean.TRUE.equals(restoreCacheMap.get("skipDevice"));
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            OswStackBackupDTO dto = (OswStackBackupDTO)jsonParser.readValueAs(OswStackBackupDTO.class);
            if (skipDevice) continue;
            if (dto == null || dto.getStack() == null || dto.getStack().getStackSetting() == null) {
                log.debug("OmadacId: {}, Skip stack restore.", (Object)omadacId);
                continue;
            }
            OswStackPO stack = dto.getStack();
            StackSettingPO stackSetting = stack.getStackSetting();
            if (Objects.nonNull(stackSetting.getLocation())) {
                stackSetting.getLocation().setMapId((String)mapIdMap.get(stackSetting.getLocation().getMapId()));
            }
            stackSetting.setMvlanNetworkId((String)lanNetworkIdMap.get(stackSetting.getMvlanNetworkId()));
            stack.setOmadacId(omadacId.a());
            String siteId = (String)siteIdMaps.get(stack.getSiteId());
            stack.setSiteId(siteId);
            Map<Integer, String> lagIdNumMap = this.handleStackLag(dto.getOswLagPOS(), omadacId, siteId, lanNetworkIdMap, portTagIdMap);
            this.handleOswPort(omadacId, siteId, stack, lagIdNumMap);
            this.handleOswVlanIf(dto, omadacId, siteId, lanNetworkIdMap, vrfIdMap);
            this.handleOswStaticRouting(dto, omadacId, siteId, vrfIdMap);
            stack.setId(null);
            this.handleStackCli(dto.getStack().getStackSetting().getCliSetting(), cliConfigMap);
            this.handleStackSwitchQos(stackSetting, oswProfileMap);
            this.oswStackMaintMongoRepository.a(stack);
        }
    }

    private void handleStackSwitchQos(StackSettingPO stackSetting, Map<String, String> profileMap) {
        OswQosConfigPO qosConfig = stackSetting.getQosConfig();
        if (Objects.isNull(qosConfig)) {
            return;
        }
        if (Objects.nonNull(qosConfig.getDscpDot1pMappingId())) {
            qosConfig.setDscpDot1pMappingId(profileMap.get(qosConfig.getDscpDot1pMappingId()));
        }
        if (Objects.nonNull(qosConfig.getDot1pQueueMappingId())) {
            qosConfig.setDot1pQueueMappingId(profileMap.get(qosConfig.getDot1pQueueMappingId()));
        }
        if (Objects.nonNull(qosConfig.getQueueSchedulerMappingId())) {
            qosConfig.setQueueSchedulerMappingId(profileMap.get(qosConfig.getQueueSchedulerMappingId()));
        }
    }

    private void handleOswPort(c omadacId, String siteId, OswStackPO stack, Map<Integer, String> lagIdNumMap) {
        if (CollectionUtils.isEmpty(lagIdNumMap)) {
            return;
        }
        Set<Integer> lagSet = lagIdNumMap.keySet();
        if (CollectionUtils.isEmpty((Collection)stack.getMembers())) {
            return;
        }
        List members = stack.getMembers().stream().map(OswStackMemberPO::getMac).collect(Collectors.toList());
        List oswPortPOList = this.oswPortMaintMongoRepository.a(omadacId.a(), members);
        ArrayList<OswPortPO> modified = new ArrayList<OswPortPO>();
        for (OswPortPO oswPortPO : oswPortPOList) {
            if (!Objects.nonNull(oswPortPO.getLag()) || !lagSet.contains(oswPortPO.getLag())) continue;
            oswPortPO.setLagId(lagIdNumMap.get(oswPortPO.getLag()));
            modified.add(oswPortPO);
        }
        if (!CollectionUtils.isEmpty(modified)) {
            this.oswPortMaintMongoRepository.a(modified);
        }
    }

    private void handleStackCli(CliSettingPO cliSetting, Map<String, String> cliConfigMap) {
        if (Objects.nonNull(cliSetting) && !CollectionUtils.isEmpty((Collection)cliSetting.getCliConfigs())) {
            for (DecodeCliPO decodeCli : cliSetting.getCliConfigs()) {
                decodeCli.setConfigId(cliConfigMap.getOrDefault(decodeCli.getConfigId(), decodeCli.getConfigId()));
            }
        }
    }

    private Map<Integer, String> handleStackLag(List<OswLagPO> oswLags, c omadacId, String siteId, Map<String, String> lanNetworkIdMap, Map<String, String> portTagIdMap) {
        HashMap<Integer, String> lagIdNumMap = new HashMap<Integer, String>(12);
        if (!CollectionUtils.isEmpty(oswLags)) {
            for (OswLagPO oswLag : oswLags) {
                lagIdNumMap.put(oswLag.getLag(), oswLag.getId());
                oswLag.setId(null);
                oswLag.setOmadacId(omadacId.a());
                oswLag.setSiteId(siteId);
                oswLag.setLanProfileId(lanNetworkIdMap.get(oswLag.getLanProfileId()));
                a.a((AbstractOswPortSettingPO)oswLag, portTagIdMap);
                a.b((AbstractOswPortSettingPO)oswLag, lanNetworkIdMap);
            }
            List oswLagPOS = IterableUtils.toList((Iterable)this.oswLagMaintMongoRepository.a(oswLags));
            if (!CollectionUtils.isEmpty((Collection)oswLagPOS)) {
                oswLagPOS.stream().forEach(oswLagPO -> {
                    String id = (String)lagIdNumMap.get(oswLagPO.getLag());
                    if (id != null) {
                        lagIdNumMap.replace(oswLagPO.getLag(), oswLagPO.getId());
                    }
                });
            }
        }
        return lagIdNumMap;
    }

    private void handleOswVlanIf(OswStackBackupDTO dto, c omadacId, String siteId, Map<String, String> lanNetworkIdMap, Map<String, String> vrfIdMap) {
        List<OswNetworkPO> vlanIfs = dto.getVlanIfs();
        if (!CollectionUtils.isEmpty(vlanIfs)) {
            for (OswNetworkPO oswNetwork : vlanIfs) {
                oswNetwork.setId(null);
                oswNetwork.setOmadacId(omadacId.a());
                oswNetwork.setSite(siteId);
                oswNetwork.setLanNetworkId(lanNetworkIdMap.get(oswNetwork.getLanNetworkId()));
                oswNetwork.setVrfId(vrfIdMap.get(oswNetwork.getVrfId()));
                if (oswNetwork.getDhcpServer() != null) {
                    oswNetwork.getDhcpServer().setVrfId(vrfIdMap.get(oswNetwork.getDhcpServer().getVrfId()));
                }
                if (oswNetwork.getDhcpRelay() == null) continue;
                oswNetwork.getDhcpRelay().setVrfId(vrfIdMap.get(oswNetwork.getDhcpRelay().getVrfId()));
            }
            this.oswNetworkMaintMongoRepository.a(vlanIfs);
        }
    }

    private void handleOswStaticRouting(OswStackBackupDTO dto, c omadacId, String siteId, Map<String, String> vrfIdMap) {
        List<OswStaticRoutingPO> staticRoutings = dto.getStaticRoutings();
        if (CollectionUtils.isEmpty(staticRoutings)) {
            return;
        }
        for (OswStaticRoutingPO oswStaticRoutingPO : staticRoutings) {
            oswStaticRoutingPO.setId(null);
            oswStaticRoutingPO.setOmadacId(omadacId.a());
            oswStaticRoutingPO.setSiteId(siteId);
            oswStaticRoutingPO.setVrfId(vrfIdMap.get(oswStaticRoutingPO.getVrfId()));
            oswStaticRoutingPO.setNextHopVrfId(vrfIdMap.get(oswStaticRoutingPO.getNextHopVrfId()));
        }
        this.oswStaticRoutingMaintMongoRepository.a(staticRoutings);
    }
}

