/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.sslVpn.siteimport;

import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.sslVpn.dto.SslVpnDTO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.e;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.f;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.lock.SslVpnLockPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.resource.SslVpnResourceGroupPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.resource.SslVpnResourcePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.server.SslVpnServerPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.user.SslVpnUserGroupPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.user.SslVpnUserPO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.d(a=com.tplink.smb.omada.backup.api.c.d.SSL_VPN)
public class SslVpnSiteImportUnit
extends com.tplink.smb.omada.backup.api.c {
    private static final SslVpnSiteImportUnit instance = new SslVpnSiteImportUnit();
    private final e sslVpnServerRepository = e.a();
    private final g sslVpnUserRepository = g.a();
    private final f sslVpnUserGroupRepository = f.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.d sslVpnResourceRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.d.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.c sslVpnResourceGroupRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.b sslVpnLockRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.b.a();

    private SslVpnSiteImportUnit() {
    }

    public static SslVpnSiteImportUnit getInstance() {
        return instance;
    }

    public void siteImport(b jsonParserWrapper, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        SslVpnDTO sslVpnDTO = (SslVpnDTO)jsonParserWrapper.a(SslVpnDTO.class);
        this.siteCopyWrite(sslVpnDTO, omadacId, newSiteId, siteImportIdCacheMap);
    }

    public void siteCopyWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        if (dataObject == null || dataObject.getClass() != SslVpnDTO.class) {
            return;
        }
        SslVpnDTO sslVpnDTO = (SslVpnDTO)dataObject;
        this.handleResource(omadacId, newSiteId, sslVpnDTO.getResources(), siteImportIdCacheMap);
        this.handleResourceGroup(omadacId, newSiteId, sslVpnDTO.getResourceGroups(), siteImportIdCacheMap);
        if (!CollectionUtils.isEmpty(sslVpnDTO.getResources())) {
            this.handleResourceAfterGroup(omadacId, new d(sslVpnDTO.getResources().get(0).getSiteId()), siteImportIdCacheMap);
        }
        this.handleUserGroup(omadacId, newSiteId, sslVpnDTO.getUserGroups(), siteImportIdCacheMap);
        this.handleUser(omadacId, newSiteId, sslVpnDTO.getUsers(), siteImportIdCacheMap);
        this.handleLock(omadacId, newSiteId, sslVpnDTO.getLocks());
        this.handleServer(omadacId, newSiteId, sslVpnDTO.getServer(), siteImportIdCacheMap);
    }

    public void siteTemplateCopyWrite(Object dataObject, c omadacId, d newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c, IOException {
    }

    private void handleServer(c omadacId, d siteId, SslVpnServerPO server, Map<String, Map<String, String>> restoreCacheMap) {
        if (server == null) {
            return;
        }
        server.setId(null);
        server.setOmadacId(omadacId.a());
        server.setSiteId(siteId.a());
        if (server.getAuthType() == 1 && server.getRadiusSetting() != null) {
            Map radiusIdsMap = restoreCacheMap.computeIfAbsent("radiusProfileIdOriginToCurrent", v2 -> new HashMap());
            server.getRadiusSetting().setRadiusProfile((String)radiusIdsMap.get(server.getRadiusSetting().getRadiusProfile()));
            Map<String, String> userGroupIdMap = restoreCacheMap.get("SSL_VPN_USER_GROUP_ID_MAP");
            server.getRadiusSetting().setDefaultGroup(userGroupIdMap.get(server.getRadiusSetting().getDefaultGroup()));
        }
        if (server.getAuthType() == 2 && server.getLdapSetting() != null) {
            Map ldapProfileIdMap = restoreCacheMap.getOrDefault("ldapProfileIdOriginToCurrent", Collections.emptyMap());
            String oldLdapProfileId = server.getLdapSetting().getProfileId();
            if (oldLdapProfileId != null) {
                server.getLdapSetting().setProfileId(ldapProfileIdMap.getOrDefault(oldLdapProfileId, oldLdapProfileId));
            }
            Map<String, String> userGroupIdMap = restoreCacheMap.get("SSL_VPN_USER_GROUP_ID_MAP");
            server.getLdapSetting().setDefaultGroup(userGroupIdMap.get(server.getLdapSetting().getDefaultGroup()));
        }
        this.sslVpnServerRepository.b(server);
    }

    private void handleUser(c omadacId, d siteId, List<SslVpnUserPO> users, Map<String, Map<String, String>> restoreCacheMap) {
        if (CollectionUtils.isEmpty(users)) {
            return;
        }
        Map<String, String> userGroupIdMap = restoreCacheMap.get("SSL_VPN_USER_GROUP_ID_MAP");
        for (SslVpnUserPO sslVpnUserPO : users) {
            sslVpnUserPO.setId(null);
            sslVpnUserPO.setOmadacId(omadacId.a());
            sslVpnUserPO.setSiteId(siteId.a());
            sslVpnUserPO.setGroupId(userGroupIdMap.get(sslVpnUserPO.getGroupId()));
            this.sslVpnUserRepository.b(sslVpnUserPO);
        }
    }

    private void handleUserGroup(c omadacId, d siteId, List<SslVpnUserGroupPO> userGroups, Map<String, Map<String, String>> restoreCacheMap) {
        HashMap<String, String> userGroupIdMap = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(userGroups)) {
            restoreCacheMap.put("SSL_VPN_USER_GROUP_ID_MAP", userGroupIdMap);
            return;
        }
        Map<String, String> resourceGroupIdMap = restoreCacheMap.get("SSL_VPN_RESOURCE_GROUP_ID_MAP");
        resourceGroupIdMap.put("resourceGroupAll", "resourceGroupAll");
        resourceGroupIdMap.put("resourceGroupLan", "resourceGroupLan");
        for (SslVpnUserGroupPO sslVpnUserGroupPO : userGroups) {
            String oldId = sslVpnUserGroupPO.getId();
            sslVpnUserGroupPO.setId(null);
            sslVpnUserGroupPO.setOmadacId(omadacId.a());
            sslVpnUserGroupPO.setSiteId(siteId.a());
            ArrayList newResourceGroupIds = CollectionUtils.isEmpty((Collection)sslVpnUserGroupPO.getResourceGroups()) ? new ArrayList() : sslVpnUserGroupPO.getResourceGroups().stream().map(resourceGroupIdMap::get).collect(Collectors.toList());
            sslVpnUserGroupPO.setResourceGroups(newResourceGroupIds);
            String newId = this.sslVpnUserGroupRepository.b(sslVpnUserGroupPO);
            userGroupIdMap.put(oldId, newId);
        }
        restoreCacheMap.put("SSL_VPN_USER_GROUP_ID_MAP", userGroupIdMap);
    }

    private void handleResource(c omadacId, d siteId, List<SslVpnResourcePO> resources, Map<String, Map<String, String>> restoreCacheMap) {
        HashMap<String, String> resourceIdMap = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(resources)) {
            restoreCacheMap.put("SSL_VPN_RESOURCE_ID_MAP", resourceIdMap);
            return;
        }
        for (SslVpnResourcePO sslVpnResourcePO : resources) {
            String oldId = sslVpnResourcePO.getId();
            sslVpnResourcePO.setId(null);
            sslVpnResourcePO.setOmadacId(omadacId.a());
            sslVpnResourcePO.setSiteId(siteId.a());
            String newId = this.sslVpnResourceRepository.b(sslVpnResourcePO);
            resourceIdMap.put(oldId, newId);
        }
        restoreCacheMap.put("SSL_VPN_RESOURCE_ID_MAP", resourceIdMap);
    }

    private void handleResourceAfterGroup(c omadacId, d siteId, Map<String, Map<String, String>> restoreCacheMap) {
        List resources = this.sslVpnResourceRepository.a(omadacId, siteId);
        if (CollectionUtils.isEmpty((Collection)resources)) {
            return;
        }
        Map<String, String> resourceGourpIdMap = restoreCacheMap.get("SSL_VPN_RESOURCE_GROUP_ID_MAP");
        for (SslVpnResourcePO sslVpnResourcePO : resources) {
            ArrayList newResourceGroupIds = CollectionUtils.isEmpty((Collection)sslVpnResourcePO.getResourceGroups()) ? new ArrayList() : sslVpnResourcePO.getResourceGroups().stream().map(resourceGourpIdMap::get).collect(Collectors.toList());
            sslVpnResourcePO.setResourceGroups(newResourceGroupIds);
            if (CollectionUtils.isEmpty(newResourceGroupIds)) continue;
            this.sslVpnResourceRepository.b(sslVpnResourcePO);
        }
    }

    private void handleResourceGroup(c omadacId, d siteId, List<SslVpnResourceGroupPO> resourceGroups, Map<String, Map<String, String>> restoreCacheMap) {
        HashMap<String, String> resourceGroupIdMap = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(resourceGroups)) {
            restoreCacheMap.put("SSL_VPN_RESOURCE_GROUP_ID_MAP", resourceGroupIdMap);
            return;
        }
        Map<String, String> resourceIdMap = restoreCacheMap.get("SSL_VPN_RESOURCE_ID_MAP");
        resourceGroupIdMap.put("resourceGroupAll", "resourceGroupAll");
        resourceGroupIdMap.put("resourceGroupLan", "resourceGroupLan");
        for (SslVpnResourceGroupPO sslVpnResourceGroupPO : resourceGroups) {
            String oldId = sslVpnResourceGroupPO.getId();
            sslVpnResourceGroupPO.setId(null);
            sslVpnResourceGroupPO.setOmadacId(omadacId.a());
            sslVpnResourceGroupPO.setSiteId(siteId.a());
            ArrayList newResourceIds = CollectionUtils.isEmpty((Collection)sslVpnResourceGroupPO.getResources()) ? new ArrayList() : sslVpnResourceGroupPO.getResources().stream().map(resourceIdMap::get).collect(Collectors.toList());
            sslVpnResourceGroupPO.setResources(newResourceIds);
            String newId = this.sslVpnResourceGroupRepository.b(sslVpnResourceGroupPO);
            resourceGroupIdMap.put(oldId, newId);
        }
        restoreCacheMap.put("SSL_VPN_RESOURCE_GROUP_ID_MAP", resourceGroupIdMap);
    }

    private void handleLock(c omadacId, d siteId, List<SslVpnLockPO> locks) {
        if (CollectionUtils.isEmpty(locks)) {
            return;
        }
        for (SslVpnLockPO sslVpnLockPO : locks) {
            sslVpnLockPO.setOmadacId(omadacId.a());
            sslVpnLockPO.setSiteId(siteId.a());
            sslVpnLockPO.setId(null);
        }
        this.sslVpnLockRepository.b(locks);
    }
}

