/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.sslVpn.restore;

import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.sslVpn.dto.SslVpnDTO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.e;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.f;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.lock.SslVpnLockPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.resource.SslVpnResourceGroupPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.resource.SslVpnResourcePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.server.SslVpnServerPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.user.SslVpnUserGroupPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.user.SslVpnUserPO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V50400, b=com.tplink.smb.omada.backup.api.c.d.SSL_VPN)
public class SslVpnRestoreUnitV50400
extends com.tplink.smb.omada.backup.api.b {
    private static final SslVpnRestoreUnitV50400 instance = new SslVpnRestoreUnitV50400();
    private final e sslVpnServerRepository = e.a();
    private final g sslVpnUserRepository = g.a();
    private final f sslVpnUserGroupRepository = f.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.d sslVpnResourceRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.d.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.c sslVpnResourceGroupRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.b sslVpnLockRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.b.a();

    private SslVpnRestoreUnitV50400() {
    }

    public static SslVpnRestoreUnitV50400 getInstance() {
        return instance;
    }

    public void restore(b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        SslVpnDTO sslVpnDTO = (SslVpnDTO)jsonParserWrapper.a(SslVpnDTO.class);
        if (sslVpnDTO == null) {
            return;
        }
        Map siteMap = (Map)restoreCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Q.A(), k2 -> new HashMap());
        Map radiusIdsMap = (Map)restoreCacheMap.computeIfAbsent("radiusProfileIdOriginToCurrent", v2 -> new HashMap());
        this.handleResource(omadacId, siteMap, sslVpnDTO.getResources(), restoreCacheMap);
        this.handleResourceGroup(omadacId, siteMap, sslVpnDTO.getResourceGroups(), restoreCacheMap);
        if (!CollectionUtils.isEmpty(sslVpnDTO.getResources())) {
            this.handleResourceAfterGroup(omadacId, new d(sslVpnDTO.getResources().get(0).getSiteId()), restoreCacheMap);
        }
        this.handleUserGroup(omadacId, siteMap, sslVpnDTO.getUserGroups(), restoreCacheMap);
        this.handleUser(omadacId, siteMap, sslVpnDTO.getUsers(), restoreCacheMap);
        this.handleLock(omadacId, siteMap, sslVpnDTO.getLocks());
        this.handleServer(omadacId, siteMap, radiusIdsMap, sslVpnDTO.getServer(), restoreCacheMap);
    }

    private void handleServer(c omadacId, Map<String, String> siteMap, Map<String, String> radiusIdsMap, SslVpnServerPO server, Map<String, Object> restoreCacheMap) {
        if (server == null) {
            return;
        }
        server.setId(null);
        server.setOmadacId(omadacId.a());
        server.setSiteId(siteMap.get(server.getSiteId()));
        if (server.getAuthType() == 1 && server.getRadiusSetting() != null) {
            server.getRadiusSetting().setRadiusProfile(radiusIdsMap.get(server.getRadiusSetting().getRadiusProfile()));
            Map userGroupIdMap = (Map)restoreCacheMap.get("SSL_VPN_USER_GROUP_ID_MAP");
            server.getRadiusSetting().setDefaultGroup((String)userGroupIdMap.get(server.getRadiusSetting().getDefaultGroup()));
        } else if (server.getAuthType() == 2) {
            Map ldapProfileIdMap = restoreCacheMap.getOrDefault("ldapProfileIdOriginToCurrent", Collections.emptyMap());
            String oldLdapProfileId = server.getLdapSetting().getProfileId();
            if (oldLdapProfileId != null) {
                server.getLdapSetting().setProfileId(ldapProfileIdMap.getOrDefault(oldLdapProfileId, oldLdapProfileId));
            }
            Map userGroupIdMap = (Map)restoreCacheMap.get("SSL_VPN_USER_GROUP_ID_MAP");
            server.getLdapSetting().setDefaultGroup((String)userGroupIdMap.get(server.getLdapSetting().getDefaultGroup()));
        }
        this.sslVpnServerRepository.b(server);
    }

    private void handleUser(c omadacId, Map<String, String> siteMap, List<SslVpnUserPO> users, Map<String, Object> restoreCacheMap) {
        if (CollectionUtils.isEmpty(users)) {
            return;
        }
        Map userGroupIdMap = (Map)restoreCacheMap.get("SSL_VPN_USER_GROUP_ID_MAP");
        for (SslVpnUserPO sslVpnUserPO : users) {
            sslVpnUserPO.setId(null);
            sslVpnUserPO.setOmadacId(omadacId.a());
            sslVpnUserPO.setSiteId(siteMap.get(sslVpnUserPO.getSiteId()));
            sslVpnUserPO.setGroupId((String)userGroupIdMap.get(sslVpnUserPO.getGroupId()));
            this.sslVpnUserRepository.b(sslVpnUserPO);
        }
    }

    private void handleUserGroup(c omadacId, Map<String, String> siteMap, List<SslVpnUserGroupPO> userGroups, Map<String, Object> restoreCacheMap) {
        HashMap<String, String> userGroupIdMap = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(userGroups)) {
            restoreCacheMap.put("SSL_VPN_USER_GROUP_ID_MAP", userGroupIdMap);
            return;
        }
        Map resourceGroupIdMap = (Map)restoreCacheMap.get("SSL_VPN_RESOURCE_GROUP_ID_MAP");
        resourceGroupIdMap.put("resourceGroupAll", "resourceGroupAll");
        resourceGroupIdMap.put("resourceGroupLan", "resourceGroupLan");
        for (SslVpnUserGroupPO sslVpnUserGroupPO : userGroups) {
            String oldId = sslVpnUserGroupPO.getId();
            sslVpnUserGroupPO.setId(null);
            sslVpnUserGroupPO.setOmadacId(omadacId.a());
            sslVpnUserGroupPO.setSiteId(siteMap.get(sslVpnUserGroupPO.getSiteId()));
            ArrayList newResourceGroupIds = CollectionUtils.isEmpty((Collection)sslVpnUserGroupPO.getResourceGroups()) ? new ArrayList() : sslVpnUserGroupPO.getResourceGroups().stream().map(resourceGroupIdMap::get).collect(Collectors.toList());
            sslVpnUserGroupPO.setResourceGroups(newResourceGroupIds);
            String newId = this.sslVpnUserGroupRepository.b(sslVpnUserGroupPO);
            userGroupIdMap.put(oldId, newId);
        }
        restoreCacheMap.put("SSL_VPN_USER_GROUP_ID_MAP", userGroupIdMap);
    }

    private void handleResource(c omadacId, Map<String, String> siteMap, List<SslVpnResourcePO> resources, Map<String, Object> restoreCacheMap) {
        HashMap<String, String> resourceIdMap = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(resources)) {
            restoreCacheMap.put("SSL_VPN_RESOURCE_ID_MAP", resourceIdMap);
            return;
        }
        for (SslVpnResourcePO sslVpnResourcePO : resources) {
            String oldId = sslVpnResourcePO.getId();
            sslVpnResourcePO.setId(null);
            sslVpnResourcePO.setOmadacId(omadacId.a());
            sslVpnResourcePO.setSiteId(siteMap.get(sslVpnResourcePO.getSiteId()));
            String newId = this.sslVpnResourceRepository.b(sslVpnResourcePO);
            resourceIdMap.put(oldId, newId);
        }
        restoreCacheMap.put("SSL_VPN_RESOURCE_ID_MAP", resourceIdMap);
    }

    private void handleResourceAfterGroup(c omadacId, d siteId, Map<String, Object> restoreCacheMap) {
        List resources = this.sslVpnResourceRepository.a(omadacId, siteId);
        if (CollectionUtils.isEmpty((Collection)resources)) {
            return;
        }
        Map resourceGourpIdMap = (Map)restoreCacheMap.get("SSL_VPN_RESOURCE_GROUP_ID_MAP");
        for (SslVpnResourcePO sslVpnResourcePO : resources) {
            ArrayList newResourceGroupIds = CollectionUtils.isEmpty((Collection)sslVpnResourcePO.getResourceGroups()) ? new ArrayList() : sslVpnResourcePO.getResourceGroups().stream().map(resourceGourpIdMap::get).collect(Collectors.toList());
            sslVpnResourcePO.setResourceGroups(newResourceGroupIds);
            if (CollectionUtils.isEmpty(newResourceGroupIds)) continue;
            this.sslVpnResourceRepository.b(sslVpnResourcePO);
        }
    }

    private void handleResourceGroup(c omadacId, Map<String, String> siteMap, List<SslVpnResourceGroupPO> resourceGroups, Map<String, Object> restoreCacheMap) {
        HashMap<String, String> resourceGroupIdMap = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(resourceGroups)) {
            restoreCacheMap.put("SSL_VPN_RESOURCE_GROUP_ID_MAP", resourceGroupIdMap);
            return;
        }
        Map resourceIdMap = (Map)restoreCacheMap.get("SSL_VPN_RESOURCE_ID_MAP");
        for (SslVpnResourceGroupPO sslVpnResourceGroupPO : resourceGroups) {
            String oldId = sslVpnResourceGroupPO.getId();
            sslVpnResourceGroupPO.setId(null);
            sslVpnResourceGroupPO.setOmadacId(omadacId.a());
            sslVpnResourceGroupPO.setSiteId(siteMap.get(sslVpnResourceGroupPO.getSiteId()));
            ArrayList newResourceIds = CollectionUtils.isEmpty((Collection)sslVpnResourceGroupPO.getResources()) ? new ArrayList() : sslVpnResourceGroupPO.getResources().stream().map(resourceIdMap::get).collect(Collectors.toList());
            sslVpnResourceGroupPO.setResources(newResourceIds);
            String newId = this.sslVpnResourceGroupRepository.b(sslVpnResourceGroupPO);
            resourceGroupIdMap.put(oldId, newId);
        }
        restoreCacheMap.put("SSL_VPN_RESOURCE_GROUP_ID_MAP", resourceGroupIdMap);
    }

    private void handleLock(c omadacId, Map<String, String> siteMap, List<SslVpnLockPO> locks) {
        if (CollectionUtils.isEmpty(locks)) {
            return;
        }
        for (SslVpnLockPO sslVpnLockPO : locks) {
            sslVpnLockPO.setOmadacId(omadacId.a());
            sslVpnLockPO.setSiteId(siteMap.get(sslVpnLockPO.getSiteId()));
            sslVpnLockPO.setId(null);
        }
        this.sslVpnLockRepository.b(locks);
    }
}

