/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.site.restore;

import com.tplink.nbu.common.utils.CollectionUtil;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.c.n;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.site.dto.SiteBackupDTO;
import com.tplink.smb.omada.common.constant.P;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.DeleteSiteListDTO;
import com.tplink.smb.omada.manager.port.mongo.configuration.omadac.OmadacPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.ntp.NtpPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.BaseSitePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.SitePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.sitetemplate.SiteTemplatePO;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.backup.api.a.c(a=l.V51520, b=d.SITE)
public class SiteRestoreUnitV51520
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SiteRestoreUnitV51520.class);
    private static final SiteRestoreUnitV51520 instance = new SiteRestoreUnitV51520();
    private final g siteMongoRepository = g.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.c omadacMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.d siteLimitMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.d.a();
    private final com.tplink.smb.omada.manager.configuration.api.internal.site.a siteInternalApiService = (com.tplink.smb.omada.manager.configuration.api.internal.site.a)a.b(com.tplink.smb.omada.manager.configuration.api.internal.site.a.class);
    private final com.tplink.smb.omada.manager.port.mongo.configuration.sitetemplate.b siteTemplateMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.sitetemplate.b.a();

    private SiteRestoreUnitV51520() {
    }

    public static SiteRestoreUnitV51520 getInstance() {
        return instance;
    }

    public void restore(b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        try {
            SiteBackupDTO siteDTO = (SiteBackupDTO)jsonParserWrapper.a(SiteBackupDTO.class);
            this.buildDefaultParam(omadacId, siteDTO);
            n typeEnum = n.a((Integer)siteDTO.getSiteType());
            HashMap<String, Integer> siteTypeMap = new HashMap<String, Integer>();
            siteTypeMap.put(siteDTO.getId(), typeEnum.a());
            restoreCacheMap.put("siteTypeMap", siteTypeMap);
            if (n.b.equals((Object)typeEnum)) {
                this.doSiteTemplateRestore(siteDTO, omadacId, restoreCacheMap);
            } else {
                this.doSiteRestore(siteDTO, omadacId, restoreCacheMap);
            }
        }
        catch (Exception e2) {
            log.warn("Site v5.x restore failed, skip this site, omadacId = {}", (Object)omadacId, (Object)e2);
        }
    }

    private void doSiteRestore(SiteBackupDTO siteDTO, c omadacId, Map<String, Object> restoreCacheMap) {
        Optional optionalOmadacPO;
        Long count = this.siteMongoRepository.a(omadacId, n.a);
        if (count >= (long)this.siteLimitMaintMongoRepository.a(omadacId, n.a)) {
            ArrayList list = (ArrayList)restoreCacheMap.computeIfAbsent("siteOverLimit", k2 -> new ArrayList());
            list.add(siteDTO.getId());
            restoreCacheMap.put("siteOverLimit", list);
            log.warn("site size {} has reached maximum in omadac {}.", (Object)count, (Object)omadacId);
            return;
        }
        Map siteMap = (Map)restoreCacheMap.computeIfAbsent(d.Q.A(), key -> new HashMap());
        SitePO po = siteDTO.toPO();
        po.setOmadacId(omadacId.a());
        if (siteDTO.getSiteTemplateId() != null) {
            po.setSiteTemplateId((String)siteMap.get(siteDTO.getSiteTemplateId()));
        }
        if (OmadacType.s()) {
            po.setMapToken(null);
            po.setUseGlobalMapToken(Boolean.valueOf(true));
        }
        if (po.getCategory() == null) {
            po.setCategory(Optional.ofNullable(restoreCacheMap.get("omadaCategory")).orElse(com.tplink.smb.omada.common.f.b.d.a()).toString());
        }
        if ((optionalOmadacPO = this.omadacMongoRepository.a(omadacId)).isPresent()) {
            OmadacPO omadacPO = (OmadacPO)optionalOmadacPO.get();
            if (po.getScenario() == null) {
                List scenarios = omadacPO.getSiteScenario().getScenarios();
                po.setScenario(CollectionUtil.isEmpty((Collection)scenarios) ? "Office" : (String)scenarios.get(0));
            }
            String newSiteId = this.siteMongoRepository.a((BaseSitePO)po);
            siteMap.put(siteDTO.getId(), newSiteId);
            restoreCacheMap.put(d.Q.A(), siteMap);
            restoreCacheMap.put("currentSiteId", newSiteId);
            if (OmadacType.t() && Boolean.TRUE.equals(po.getPrimary())) {
                restoreCacheMap.put("DEFAULT_SITE", newSiteId);
            }
            if (Objects.nonNull(omadacPO.getMapTokenSharedSites())) {
                omadacPO.getMapTokenSharedSites().remove(siteDTO.getId());
                omadacPO.getMapTokenSharedSites().add(newSiteId);
            }
            this.omadacMongoRepository.a(omadacPO);
        }
    }

    private void doSiteTemplateRestore(SiteBackupDTO siteDTO, c omadacId, Map<String, Object> restoreCacheMap) {
        Map siteMap = (Map)restoreCacheMap.computeIfAbsent(d.Q.A(), key -> new HashMap());
        SiteTemplatePO po = siteDTO.toTemplatePO();
        po.setOmadacId(omadacId.a());
        String newSiteTemplateId = this.siteTemplateMaintMongoRepository.a(po);
        siteMap.put(siteDTO.getId(), newSiteTemplateId);
        restoreCacheMap.put(d.Q.A(), siteMap);
        restoreCacheMap.put("currentSiteId", newSiteTemplateId);
    }

    private void buildDefaultParam(@Nonnull c omadacId, @Nonnull SiteBackupDTO siteBackupDTO) {
        if (siteBackupDTO.getPrimary() == null) {
            siteBackupDTO.setPrimary(false);
        }
        if (siteBackupDTO.getTimeZone() == null) {
            siteBackupDTO.setTimeZone(P.E.a());
        }
        if (siteBackupDTO.getNtp() == null) {
            NtpPO ntpPO = this.omadacMongoRepository.a(omadacId).map(OmadacPO::getNtp).orElse(NtpPO.builder().enable(Boolean.valueOf(false)).build());
            siteBackupDTO.setNtp(ntpPO);
        }
    }

    public void afterCompatible(c omadacId, Map<String, Object> restoreCacheMap) {
        ArrayList siteIdList = (ArrayList)restoreCacheMap.get("siteOverLimit");
        DeleteSiteListDTO deleteSiteListDTO = new DeleteSiteListDTO();
        deleteSiteListDTO.setOmadacId(omadacId.a());
        deleteSiteListDTO.setIdList((List)siteIdList);
        this.siteInternalApiService.a(deleteSiteListDTO);
    }
}

