/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.site.restore;

import com.tplink.nbu.common.utils.CollectionUtil;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.c.n;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.site.dto.SiteBackupDTO;
import com.tplink.smb.omada.common.constant.P;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.DeleteSiteListDTO;
import com.tplink.smb.omada.manager.port.mongo.configuration.omadac.OmadacPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.ntp.NtpPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.BaseSitePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.SitePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.g;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.backup.api.a.c(a=l.V50000, b=d.SITE)
public class SiteRestoreUnitV50000
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SiteRestoreUnitV50000.class);
    private static final SiteRestoreUnitV50000 instance = new SiteRestoreUnitV50000();
    private final g siteMongoRepository = g.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.c omadacMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.d siteLimitMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.d.a();
    private final com.tplink.smb.omada.manager.configuration.api.internal.site.a siteInternalApiService = (com.tplink.smb.omada.manager.configuration.api.internal.site.a)a.b(com.tplink.smb.omada.manager.configuration.api.internal.site.a.class);

    private SiteRestoreUnitV50000() {
    }

    public static SiteRestoreUnitV50000 getInstance() {
        return instance;
    }

    public void restore(b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        try {
            SiteBackupDTO siteDTO = (SiteBackupDTO)jsonParserWrapper.a(SiteBackupDTO.class);
            this.buildDefaultParam(omadacId, siteDTO);
            Long count = this.siteMongoRepository.a(omadacId, n.a);
            if (count >= (long)this.siteLimitMaintMongoRepository.a(omadacId, n.a)) {
                ArrayList list = (ArrayList)restoreCacheMap.computeIfAbsent("siteOverLimit", k2 -> new ArrayList());
                list.add(siteDTO.getId());
                restoreCacheMap.put("siteOverLimit", list);
                log.warn("site size {} has reached maximum in omadac {}.", (Object)count, (Object)omadacId);
                return;
            }
            Map siteMap = (Map)restoreCacheMap.computeIfAbsent(d.Q.A(), key -> new HashMap());
            SitePO po = siteDTO.toPO();
            po.setOmadacId(omadacId.a());
            if (OmadacType.s()) {
                po.setMapToken(null);
                po.setUseGlobalMapToken(Boolean.valueOf(true));
            }
            po.setCategory(Optional.ofNullable(siteDTO.getCategory()).orElse(com.tplink.smb.omada.common.f.b.d.a()));
            Optional optionalOmadacPO = this.omadacMongoRepository.a(omadacId);
            if (optionalOmadacPO.isPresent()) {
                OmadacPO omadacPO = (OmadacPO)optionalOmadacPO.get();
                if (po.getScenario() == null) {
                    List scenarios = omadacPO.getSiteScenario().getScenarios();
                    po.setScenario(CollectionUtil.isEmpty((Collection)scenarios) ? "Office" : (String)scenarios.get(0));
                }
                String newSiteId = this.siteMongoRepository.a((BaseSitePO)po);
                siteMap.put(siteDTO.getId(), newSiteId);
                restoreCacheMap.put(d.Q.A(), siteMap);
                restoreCacheMap.put("currentSiteId", newSiteId);
                if (OmadacType.t() && Boolean.TRUE.equals(po.getPrimary())) {
                    restoreCacheMap.put("DEFAULT_SITE", newSiteId);
                }
                if (Objects.nonNull(omadacPO.getMapTokenSharedSites())) {
                    omadacPO.getMapTokenSharedSites().remove(siteDTO.getId());
                    omadacPO.getMapTokenSharedSites().add(newSiteId);
                }
                this.omadacMongoRepository.a(omadacPO);
            }
        }
        catch (Exception e2) {
            log.warn("Site v5.x restore failed, skip this site, omadacId = {}", (Object)omadacId, (Object)e2);
        }
    }

    private void buildDefaultParam(@Nonnull c omadacId, @Nonnull SiteBackupDTO siteBackupDTO) {
        if (siteBackupDTO.getPrimary() == null) {
            siteBackupDTO.setPrimary(false);
        }
        if (siteBackupDTO.getTimeZone() == null) {
            siteBackupDTO.setTimeZone(P.E.a());
        }
        if (siteBackupDTO.getNtp() == null) {
            NtpPO ntpPO = this.omadacMongoRepository.a(omadacId).map(OmadacPO::getNtp).orElse(NtpPO.builder().enable(Boolean.valueOf(false)).build());
            siteBackupDTO.setNtp(ntpPO);
        }
    }

    public void afterCompatible(c omadacId, Map<String, Object> restoreCacheMap) {
        ArrayList siteIdList = (ArrayList)restoreCacheMap.get("siteOverLimit");
        DeleteSiteListDTO deleteSiteListDTO = new DeleteSiteListDTO();
        deleteSiteListDTO.setOmadacId(omadacId.a());
        deleteSiteListDTO.setIdList((List)siteIdList);
        this.siteInternalApiService.a(deleteSiteListDTO);
    }
}

