/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.sim.siteimport;

import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.d.c;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.sim.dto.SimDTO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sim.SimSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sim.SimSettingTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sim.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sim.sms.setting.SimSmsSettingPO;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.d(a=d.SIM)
public class SimSiteImportUnit
extends com.tplink.smb.omada.backup.api.c {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimSiteImportUnit.class);
    private static final SimSiteImportUnit instance = new SimSiteImportUnit();
    private final a simSettingRepository = a.a();

    private SimSiteImportUnit() {
    }

    public static SimSiteImportUnit getInstance() {
        return instance;
    }

    public void siteImport(b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, com.tplink.smb.omada.maintenance.common.b.a.a.d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, Map<String, Object> restoreCacheMap) throws IOException, c {
        SimDTO sim = (SimDTO)jsonParserWrapper.a(SimDTO.class);
        if (sim == null || CollectionUtils.isEmpty(sim.getSettingList())) {
            return;
        }
        for (SimSettingPO setting : sim.getSettingList()) {
            this.handleSetting(omadacId, newSiteId, setting, siteImportIdCacheMap, false);
        }
    }

    public void siteCopyWrite(Object dataObject, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, com.tplink.smb.omada.maintenance.common.b.a.a.d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws IOException, c {
        if (dataObject == null || dataObject.getClass() != SimDTO.class) {
            return;
        }
        SimDTO sim = (SimDTO)dataObject;
        if (CollectionUtils.isEmpty(sim.getSettingList())) {
            return;
        }
        for (SimSettingPO setting : sim.getSettingList()) {
            this.handleSetting(omadacId, newSiteId, setting, siteImportIdCacheMap, true);
        }
    }

    public void siteTemplateCopyWrite(Object dataObject, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, com.tplink.smb.omada.maintenance.common.b.a.a.d newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) throws c, IOException {
        if (dataObject == null || dataObject.getClass() != SimDTO.class) {
            return;
        }
        SimDTO sim = (SimDTO)dataObject;
        if (sim.getSettingTemplate() == null) {
            return;
        }
        SimSettingTemplatePO settingTemplate = sim.getSettingTemplate();
        settingTemplate.setOmadacId(omadacId.a());
        settingTemplate.setSiteTemplateId(newSiteTemplateId.a());
        settingTemplate.setId(null);
        Optional.ofNullable(settingTemplate.getSmsSetting()).map(SimSmsSettingPO::getPolicySetting).ifPresent(policy -> {
            if (policy.getMailServer() != null) {
                Map mailServerIdMap = (Map)siteImportIdCacheMap.get("mailServerIdMap");
                if (mailServerIdMap == null || mailServerIdMap.get(policy.getMailServer()) == null) {
                    log.warn("{} {} the correct Mail Server ID is not existed.", (Object)omadacId, (Object)newSiteTemplateId);
                    return;
                }
                settingTemplate.getSmsSetting().getPolicySetting().setMailServer((String)mailServerIdMap.get(policy.getMailServer()));
            }
        });
        this.simSettingRepository.a(settingTemplate);
    }

    private void handleSetting(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, com.tplink.smb.omada.maintenance.common.b.a.a.d siteId, SimSettingPO setting, Map<String, Map<String, String>> restoreCacheMap, boolean isSiteCopy) {
        if (setting == null || isSiteCopy && setting.getMac() != null) {
            return;
        }
        setting.setId(null);
        setting.setOmadacId(omadacId.a());
        setting.setSiteId(siteId.a());
        setting.setOverride(null);
        setting.setTemplateId(null);
        Optional.ofNullable(setting.getSmsSetting()).map(SimSmsSettingPO::getPolicySetting).ifPresent(policy -> {
            if (policy.getMailServer() != null) {
                Map mailServerIdMap = (Map)restoreCacheMap.get("mailServerIdMap");
                if (mailServerIdMap == null || mailServerIdMap.get(policy.getMailServer()) == null) {
                    log.warn("{} {} the correct Mail Server ID is not existed.", (Object)omadacId, (Object)siteId);
                    return;
                }
                setting.getSmsSetting().getPolicySetting().setMailServer((String)mailServerIdMap.get(policy.getMailServer()));
            }
        });
        this.simSettingRepository.b(setting);
    }
}

