/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.sim.restore;

import com.tplink.smb.ecsp.common.util.StringUtils;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.sim.a;
import com.tplink.smb.omada.backup.core.unit.siteconfig.sim.dto.SimDTO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sim.SimSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sim.SimSettingTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sim.quota.SimQuotaSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sim.sms.setting.SimSmsSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sim.sms.setting.routercommand.AccessItemPO;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V51520, b=d.SIM)
public class SimRestoreUnitV51520
extends com.tplink.smb.omada.backup.api.b {
    private static final SimRestoreUnitV51520 instance = new SimRestoreUnitV51520();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.sim.a simSettingRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.sim.a.a();

    private SimRestoreUnitV51520() {
    }

    public static SimRestoreUnitV51520 getInstance() {
        return instance;
    }

    public void restore(b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        SimDTO simDTO = (SimDTO)jsonParserWrapper.a(SimDTO.class);
        if (simDTO == null) {
            return;
        }
        Map siteMap = (Map)restoreCacheMap.computeIfAbsent(d.Q.A(), k2 -> new HashMap());
        Map simMap = (Map)restoreCacheMap.computeIfAbsent("SimSiteSetting", k2 -> new HashMap());
        this.handleSiteTemplateSimSetting(omadacId, siteMap, simDTO, simMap, restoreCacheMap);
        this.handleSiteSimSetting(omadacId, siteMap, simDTO, restoreCacheMap);
        restoreCacheMap.put("SimSiteSetting", simMap);
    }

    private void handleSiteTemplateSimSetting(c omadacId, Map<String, String> siteMap, SimDTO simDTO, Map<String, String> simMap, Map<String, Object> restoreCacheMap) {
        if (simDTO.getSettingTemplate() == null) {
            return;
        }
        SimSettingTemplatePO settingTemplate = simDTO.getSettingTemplate();
        String oldTemplateId = settingTemplate.getId();
        settingTemplate.setId(null);
        settingTemplate.setOmadacId(omadacId.a());
        settingTemplate.setSiteTemplateId(siteMap.get(settingTemplate.getSiteTemplateId()));
        this.handleAccessItemEncryption(settingTemplate.getSmsSetting());
        this.handleQuotaDataEncryption(settingTemplate.getQuotaSetting());
        this.handleQuotaDataEncryption(settingTemplate.getSim2QuotaSetting());
        this.handleQuotaMessageEncryption(settingTemplate.getQuotaSetting());
        this.handleQuotaMessageEncryption(settingTemplate.getSim2QuotaSetting());
        if (settingTemplate.getSmsSetting() != null && settingTemplate.getSmsSetting().getPolicySetting() != null && !a.a.equals(settingTemplate.getSmsSetting().getPolicySetting().getInboxPolicy())) {
            Map mailServerIdMap = (Map)restoreCacheMap.get("mailServerIdMap");
            if (mailServerIdMap == null) {
                return;
            }
            settingTemplate.getSmsSetting().getPolicySetting().setMailServer((String)mailServerIdMap.get(settingTemplate.getSmsSetting().getPolicySetting().getMailServer()));
        }
        simMap.put(oldTemplateId, this.simSettingRepository.a(settingTemplate));
    }

    private void handleSiteSimSetting(c omadacId, Map<String, String> siteMap, SimDTO simDTO, Map<String, Object> restoreCacheMap) {
        if (simDTO.getSetting() == null) {
            return;
        }
        Map simMap = (Map)restoreCacheMap.get("SimSiteSetting");
        SimSettingPO setting = simDTO.getSetting();
        setting.setId(null);
        setting.setOmadacId(omadacId.a());
        setting.setSiteId(siteMap.get(setting.getSiteId()));
        setting.setTemplateId((String)simMap.get(setting.getTemplateId()));
        this.handleAccessItemEncryption(setting.getSmsSetting());
        this.handleQuotaDataEncryption(setting.getQuotaSetting());
        this.handleQuotaDataEncryption(setting.getSim2QuotaSetting());
        this.handleQuotaMessageEncryption(setting.getQuotaSetting());
        this.handleQuotaMessageEncryption(setting.getSim2QuotaSetting());
        if (setting.getSmsSetting() != null && setting.getSmsSetting().getPolicySetting() != null && !a.a.equals(setting.getSmsSetting().getPolicySetting().getInboxPolicy())) {
            Map mailServerIdMap = (Map)restoreCacheMap.get("mailServerIdMap");
            if (mailServerIdMap == null) {
                return;
            }
            setting.getSmsSetting().getPolicySetting().setMailServer((String)mailServerIdMap.get(setting.getSmsSetting().getPolicySetting().getMailServer()));
        }
        this.simSettingRepository.b(setting);
    }

    private void handleAccessItemEncryption(SimSmsSettingPO simSmsSettingPO) {
        if (simSmsSettingPO != null && simSmsSettingPO.getRouterCommand() != null && simSmsSettingPO.getRouterCommand().getAccess() != null && !CollectionUtils.isEmpty((Collection)simSmsSettingPO.getRouterCommand().getAccess().getAccesses())) {
            List accesses = simSmsSettingPO.getRouterCommand().getAccess().getAccesses();
            for (AccessItemPO access : accesses) {
                if (StringUtils.isNull((String)access.getPhone())) continue;
                access.setEncryptPhone(access.getPhone());
                access.setPhone(null);
            }
        }
    }

    private void handleQuotaDataEncryption(SimQuotaSettingPO simQuotaSettingPO) {
        if (simQuotaSettingPO != null && simQuotaSettingPO.getDataSetting() != null && !StringUtils.isNull((String)simQuotaSettingPO.getDataSetting().getPhone())) {
            simQuotaSettingPO.getDataSetting().setEncryptPhone(simQuotaSettingPO.getDataSetting().getPhone());
            simQuotaSettingPO.getDataSetting().setPhone(null);
        }
    }

    private void handleQuotaMessageEncryption(SimQuotaSettingPO simQuotaSettingPO) {
        if (simQuotaSettingPO != null && simQuotaSettingPO.getSmsSetting() != null && !StringUtils.isNull((String)simQuotaSettingPO.getSmsSetting().getPhone())) {
            simQuotaSettingPO.getSmsSetting().setEncryptPhone(simQuotaSettingPO.getSmsSetting().getPhone());
            simQuotaSettingPO.getSmsSetting().setPhone(null);
        }
    }
}

