/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.restore;

import com.tplink.smb.component.schedule.api.ScheduleCenter;
import com.tplink.smb.component.schedule.api.TaskKey;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.DdnsSettingBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.DnsCacheSettingBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.ServiceSettingDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.SnmpSettingBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.SshServerSettingBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.UpnpSettingBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.dnsproxy.DnsProxySettingBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.iptv.IptvSettingBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.restore.a;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.maintenance.common.config.SchedulerCustomProperties;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osg.BaseOsgSiteSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.ddns.DdnsPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.dhcpreservation.DhcpReservationPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.dnsproxy.DnsOverridePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.dnsproxy.DnsProxyPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.iptv.IptvSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.mdns.MdnsRulePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.poeschedule.PortPoeSchedulePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.portschedule.PortStatusSchedulePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.rebootschedule.RebootSchedulePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.scheduleupgrade.ScheduleUpgradePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.upnp.UpnpSettingPO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V51400, b=com.tplink.smb.omada.backup.api.c.d.SERVICE)
public class ServiceSettingRestoreUnitV51400
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceSettingRestoreUnitV51400.class);
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.ddns.a ddnsMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.ddns.a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.component.common.b commonSiteSettingMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.component.common.b.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osg.a osgSiteSettingMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osg.a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.a serviceScheduleMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.a.a();
    private final a restartTaskPublisher = (a)com.tplink.smb.omada.common.spring.a.b(a.class);
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.dhcpreservation.a dhcpReservationMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.dhcpreservation.a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.mdns.a mdnsRuleMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.mdns.a.a();
    private final SchedulerCustomProperties schedulerCustomProperties = (SchedulerCustomProperties)com.tplink.smb.omada.common.spring.a.b(SchedulerCustomProperties.class);
    private final ScheduleCenter scheduleCenter = (ScheduleCenter)com.tplink.smb.omada.common.spring.a.b(ScheduleCenter.class);
    private static final ServiceSettingRestoreUnitV51400 instance = new ServiceSettingRestoreUnitV51400();
    private static final String REBOOT_TASK_NAME = "manager_reboot";
    private static final String POE_TASK_NAME = "manager_poe";
    private static final String PORT_TASK_NAME = "manager_port";
    private static final String SCHEDULE_UPGRADE_TASK_NAME = "manager_schedule_upgrade";
    private static final int MDNS_RULE_AP_TYPE = 0;
    private static final int MDNS_RULE_OSG_TYPE = 1;
    private static final String TIME_FORMAT = "yyyy-MM-dd HH:mm";

    private ServiceSettingRestoreUnitV51400() {
    }

    public static ServiceSettingRestoreUnitV51400 getInstance() {
        return instance;
    }

    public void restore(b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        DnsCacheSettingBackupDTO dnsCacheSetting;
        DdnsSettingBackupDTO ddnsSetting;
        DnsProxySettingBackupDTO dnsProxySetting;
        IptvSettingBackupDTO iptvSetting;
        UpnpSettingBackupDTO upnpSetting;
        List<DhcpReservationPO> dhcpReservationPOList;
        ServiceSettingDTO serviceSettingDTO = (ServiceSettingDTO)jsonParserWrapper.a(ServiceSettingDTO.class);
        Map siteMap = (Map)restoreCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Q.A(), k2 -> new HashMap());
        Map lanNetworkIdMap = (Map)restoreCacheMap.get(com.tplink.smb.omada.backup.api.c.d.af.A());
        List<DdnsPO> ddnsPOList = serviceSettingDTO.getDdnss();
        if (!CollectionUtils.isEmpty(ddnsPOList)) {
            ddnsPOList.forEach(ddnsPO -> {
                ddnsPO.setOmadacId(omadacId.a());
                ddnsPO.setSiteId((String)siteMap.get(ddnsPO.getSiteId()));
                ddnsPO.setId(null);
            });
            this.ddnsMaintMongoRepository.a(ddnsPOList);
        }
        if (!CollectionUtils.isEmpty(dhcpReservationPOList = serviceSettingDTO.getDhcpReservations())) {
            dhcpReservationPOList.forEach(dhcpReservationPO -> {
                dhcpReservationPO.setOmadacId(omadacId.a());
                dhcpReservationPO.setSiteId((String)siteMap.get(dhcpReservationPO.getSiteId()));
                dhcpReservationPO.setLanNetworkId((String)lanNetworkIdMap.get(dhcpReservationPO.getLanNetworkId()));
                dhcpReservationPO.setId(null);
            });
            this.dhcpReservationMaintMongoRepository.a(dhcpReservationPOList);
        }
        SnmpSettingBackupDTO snmpSetting = serviceSettingDTO.getSnmpSetting();
        SshServerSettingBackupDTO sshServerSetting = serviceSettingDTO.getSshSetting();
        if (Objects.nonNull(snmpSetting) && Objects.nonNull(sshServerSetting)) {
            d newSiteId = new d((String)siteMap.get(snmpSetting.getSiteId()));
            this.commonSiteSettingMongoRepository.a(omadacId, newSiteId).ifPresent(commonSiteSetting -> {
                commonSiteSetting.setSnmp(snmpSetting.toPO());
                commonSiteSetting.setSsh(sshServerSetting.toPO());
                this.commonSiteSettingMongoRepository.a(commonSiteSetting);
            });
        }
        if (Objects.nonNull(upnpSetting = serviceSettingDTO.getUpnpSetting())) {
            d newSiteId = new d((String)siteMap.get(upnpSetting.getSiteId()));
            this.osgSiteSettingMongoRepository.a(omadacId, newSiteId).ifPresent(osgSiteSetting -> {
                UpnpSettingPO upnpSettingPO = upnpSetting.toPO();
                if (!CollectionUtils.isEmpty((Collection)upnpSettingPO.getNetworkIds())) {
                    ArrayList newNetworkIds = new ArrayList();
                    upnpSettingPO.getNetworkIds().forEach(oldNetworkId -> newNetworkIds.add((String)lanNetworkIdMap.get(oldNetworkId)));
                    upnpSettingPO.setNetworkIds(newNetworkIds);
                }
                osgSiteSetting.setUpnp(upnpSettingPO);
                this.osgSiteSettingMongoRepository.a((BaseOsgSiteSettingPO)osgSiteSetting);
            });
        }
        if (Objects.nonNull(iptvSetting = serviceSettingDTO.getIptvSetting())) {
            d newSiteId = new d((String)siteMap.get(iptvSetting.getSiteId()));
            this.osgSiteSettingMongoRepository.a(omadacId, newSiteId).ifPresent(osgSiteSetting -> {
                IptvSettingPO iptvSettingPO = iptvSetting.toPO();
                iptvSettingPO.getIgmp().setWanPortId(iptvSettingPO.getIgmp().getWanPortId());
                if (iptvSettingPO.getIgmp() != null && iptvSettingPO.getIgmp().getVirtualWanId() != null) {
                    iptvSettingPO.getIgmp().setVirtualWanId((String)((Map)restoreCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), k2 -> new HashMap())).get(iptvSettingPO.getIgmp().getVirtualWanId()));
                }
                iptvSettingPO.getIptv().setWanPortId(iptvSettingPO.getIptv().getWanPortId());
                osgSiteSetting.setIptv(iptvSettingPO);
                this.osgSiteSettingMongoRepository.a((BaseOsgSiteSettingPO)osgSiteSetting);
            });
        }
        if (Objects.nonNull(dnsProxySetting = serviceSettingDTO.getDnsProxySetting())) {
            d newSiteId = new d((String)siteMap.get(dnsProxySetting.getSiteId()));
            this.osgSiteSettingMongoRepository.a(omadacId, newSiteId).ifPresent(osgSiteSetting -> {
                DnsProxyPO dnsProxyPO = dnsProxySetting.toPO();
                this.handleDNSOverride(lanNetworkIdMap, dnsProxyPO);
                osgSiteSetting.setDnsProxy(dnsProxyPO);
                this.osgSiteSettingMongoRepository.a((BaseOsgSiteSettingPO)osgSiteSetting);
            });
        }
        if (Objects.nonNull(ddnsSetting = serviceSettingDTO.getDdnsSetting())) {
            d newSiteId = new d((String)siteMap.get(ddnsSetting.getSiteId()));
            this.osgSiteSettingMongoRepository.a(omadacId, newSiteId).ifPresent(osgSiteSetting -> {
                osgSiteSetting.setDdns(ddnsSetting.toPO());
                this.osgSiteSettingMongoRepository.a((BaseOsgSiteSettingPO)osgSiteSetting);
            });
        }
        if (Objects.nonNull(dnsCacheSetting = serviceSettingDTO.getDnsCacheSetting())) {
            d newSiteId = new d((String)siteMap.get(dnsCacheSetting.getSiteId()));
            this.osgSiteSettingMongoRepository.a(omadacId, newSiteId).ifPresent(osgSiteSetting -> {
                osgSiteSetting.setDnsCache(dnsCacheSetting.toPO());
                this.osgSiteSettingMongoRepository.a((BaseOsgSiteSettingPO)osgSiteSetting);
            });
        }
        Map profileMap = (Map)restoreCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Y.A(), k2 -> new HashMap());
        String omadaId = omadacId.a();
        this.restoreRebootSch(serviceSettingDTO, omadaId, siteMap);
        this.restorePoeSch(serviceSettingDTO, omadaId, siteMap, profileMap);
        this.restorePortStatusSch(serviceSettingDTO, omadaId, siteMap, profileMap);
        this.restoreScheduleUpgrade(serviceSettingDTO, omadaId, siteMap);
        this.restoreMdnsRule(serviceSettingDTO, omadaId, siteMap, profileMap, lanNetworkIdMap);
    }

    private void handleDNSOverride(Map<String, String> lanNetworkIdMap, DnsProxyPO dnsProxyPO) {
        if (Objects.equals(4, dnsProxyPO.getType()) && Objects.nonNull(dnsProxyPO.getDnsOverride())) {
            DnsOverridePO dnsOverridePO = dnsProxyPO.getDnsOverride();
            List newApplyNetwork = dnsOverridePO.getApplyNetwork().stream().map(lanNetworkIdMap::get).collect(Collectors.toList());
            dnsOverridePO.setApplyNetwork(newApplyNetwork);
            dnsProxyPO.setDnsOverride(dnsOverridePO);
        }
    }

    public void afterCompatible(c omadacId, Map<String, Object> restoreCacheMap) {
        this.restartTaskPublisher.a(omadacId.a());
    }

    private void restorePoeSch(ServiceSettingDTO serviceSettingDTO, String omadaId, Map<String, String> siteMap, Map<String, String> profileMap) {
        List<PortPoeSchedulePO> poeSchs = serviceSettingDTO.getPoeSchs();
        if (CollectionUtils.isEmpty(poeSchs)) {
            return;
        }
        ArrayList<PortPoeSchedulePO> poeSchedulePOS = new ArrayList<PortPoeSchedulePO>(poeSchs.size());
        for (PortPoeSchedulePO poeSchedulePO : poeSchs) {
            poeSchedulePO.setOmadacId(omadaId);
            poeSchedulePO.setSiteId(siteMap.get(poeSchedulePO.getSiteId()));
            poeSchedulePO.setScheduleProfileId(profileMap.get(poeSchedulePO.getScheduleProfileId()));
            poeSchedulePO.setId(ObjectId.get().toString());
            int partitionIndex = Math.abs(poeSchedulePO.getId().hashCode() % this.schedulerCustomProperties.getShardingSizeOf(POE_TASK_NAME));
            poeSchedulePO.setPartitionIndex(Integer.valueOf(partitionIndex));
            poeSchedulePOS.add(poeSchedulePO);
        }
        this.serviceScheduleMaintMongoRepository.c(poeSchedulePOS);
    }

    private void restorePortStatusSch(ServiceSettingDTO serviceSettingDTO, String omadaId, Map<String, String> siteMap, Map<String, String> profileMap) {
        List<PortStatusSchedulePO> portSchs = serviceSettingDTO.getPortStatusSchs();
        if (CollectionUtils.isEmpty(portSchs)) {
            return;
        }
        ArrayList<PortStatusSchedulePO> portStatusSchedulePOS = new ArrayList<PortStatusSchedulePO>(portSchs.size());
        for (PortStatusSchedulePO portStatusSchedulePO : portSchs) {
            portStatusSchedulePO.setOmadacId(omadaId);
            portStatusSchedulePO.setSiteId(siteMap.get(portStatusSchedulePO.getSiteId()));
            portStatusSchedulePO.setScheduleProfileId(profileMap.get(portStatusSchedulePO.getScheduleProfileId()));
            portStatusSchedulePO.setId(ObjectId.get().toString());
            int partitionIndex = Math.abs(portStatusSchedulePO.getId().hashCode() % this.schedulerCustomProperties.getShardingSizeOf(PORT_TASK_NAME));
            portStatusSchedulePO.setPartitionIndex(Integer.valueOf(partitionIndex));
            portStatusSchedulePOS.add(portStatusSchedulePO);
        }
        this.serviceScheduleMaintMongoRepository.f(portStatusSchedulePOS);
    }

    private void restoreRebootSch(ServiceSettingDTO serviceSettingDTO, String omadaId, Map<String, String> siteMap) {
        List<RebootSchedulePO> rebootSchs = serviceSettingDTO.getRebootSchs();
        if (CollectionUtils.isEmpty(rebootSchs)) {
            return;
        }
        ArrayList<RebootSchedulePO> rebootSchedulePOS = new ArrayList<RebootSchedulePO>(rebootSchs.size());
        for (RebootSchedulePO rebootSchedulePO : rebootSchs) {
            rebootSchedulePO.setOmadacId(omadaId);
            rebootSchedulePO.setSiteId(siteMap.get(rebootSchedulePO.getSiteId()));
            rebootSchedulePO.setId(ObjectId.get().toString());
            int partitionIndex = Math.abs(rebootSchedulePO.getId().hashCode() % this.schedulerCustomProperties.getShardingSizeOf(REBOOT_TASK_NAME));
            rebootSchedulePO.setPartitionIndex(Integer.valueOf(partitionIndex));
            rebootSchedulePOS.add(rebootSchedulePO);
        }
        this.serviceScheduleMaintMongoRepository.a(rebootSchedulePOS);
    }

    private void restoreScheduleUpgrade(ServiceSettingDTO serviceSettingDTO, String omadaId, Map<String, String> siteMap) {
        List<ScheduleUpgradePO> scheduleUpgrades = serviceSettingDTO.getScheduleUpgrades();
        if (CollectionUtils.isEmpty(scheduleUpgrades)) {
            return;
        }
        int partitionIndex = 0;
        ArrayList<ScheduleUpgradePO> scheduleUpgradePOS = new ArrayList<ScheduleUpgradePO>(scheduleUpgrades.size());
        for (ScheduleUpgradePO po : scheduleUpgrades) {
            this.scheduleCenter.deleteTask(new TaskKey(SCHEDULE_UPGRADE_TASK_NAME, po.getId()));
            po.setOmadacId(omadaId);
            po.setSiteId(siteMap.get(po.getSiteId()));
            po.setId(ObjectId.get().toString());
            if (OmadacType.s()) {
                partitionIndex = Math.abs(po.getId().hashCode() % this.schedulerCustomProperties.getShardingSizeOf(SCHEDULE_UPGRADE_TASK_NAME));
            }
            po.setPartitionIndex(Integer.valueOf(partitionIndex));
            scheduleUpgradePOS.add(po);
        }
        this.serviceScheduleMaintMongoRepository.e(scheduleUpgradePOS);
    }

    private void restoreMdnsRule(ServiceSettingDTO serviceSettingDTO, String omadaId, Map<String, String> siteMap, Map<String, String> profileMap, Map<String, String> lanNetworkIdMap) {
        List<MdnsRulePO> mdnsRules = serviceSettingDTO.getMdnsRules();
        if (CollectionUtils.isEmpty(mdnsRules)) {
            return;
        }
        ArrayList<MdnsRulePO> mdnsRulePOList = new ArrayList<MdnsRulePO>(mdnsRules.size());
        for (MdnsRulePO mdnsRulePO : mdnsRules) {
            mdnsRulePO.setOmadacId(omadaId);
            mdnsRulePO.setSiteId(siteMap.get(mdnsRulePO.getSiteId()));
            mdnsRulePO.setId(null);
            if (mdnsRulePO.getType().equals(0) && mdnsRulePO.getApMdnsRule() != null) {
                this.handleApMdnsRule(mdnsRulePO, profileMap);
            }
            if (mdnsRulePO.getType().equals(1) && mdnsRulePO.getOsgMdnsRule() != null) {
                this.handleOsgMdnsRule(mdnsRulePO, lanNetworkIdMap, profileMap);
            }
            mdnsRulePOList.add(mdnsRulePO);
        }
        this.mdnsRuleMaintMongoRepository.a(mdnsRulePOList);
    }

    private void handleApMdnsRule(MdnsRulePO mdnsRulePO, Map<String, String> profileMap) {
        List profileIds = mdnsRulePO.getApMdnsRule().getProfileIds();
        ArrayList<String> newProfileIds = new ArrayList<String>();
        for (String profileId : profileIds) {
            if (profileId == null) continue;
            newProfileIds.add(profileMap.getOrDefault(profileId, profileId));
        }
        mdnsRulePO.getApMdnsRule().setProfileIds(newProfileIds);
    }

    private void handleOsgMdnsRule(MdnsRulePO mdnsRulePO, Map<String, String> lanNetworkIdMap, Map<String, String> profileMap) {
        List clientNetworks;
        List serviceNetworks;
        List profileIds;
        List networkIds = mdnsRulePO.getOsgMdnsRule().getNetworkIds();
        if (!CollectionUtils.isEmpty((Collection)networkIds)) {
            ArrayList<String> newNetworkIds = new ArrayList<String>();
            for (Object networkId : networkIds) {
                String newNetworkId = lanNetworkIdMap.get(networkId);
                newNetworkIds.add(newNetworkId);
            }
            mdnsRulePO.getOsgMdnsRule().setNetworkIds(newNetworkIds);
        }
        if (!CollectionUtils.isEmpty((Collection)(profileIds = mdnsRulePO.getOsgMdnsRule().getProfileIds()))) {
            ArrayList<String> newProfileIds = new ArrayList<String>();
            for (Object profileId : profileIds) {
                newProfileIds.add(profileMap.getOrDefault(profileId, (String)profileId));
            }
            mdnsRulePO.getOsgMdnsRule().setProfileIds(newProfileIds);
        }
        if (!CollectionUtils.isEmpty((Collection)(serviceNetworks = mdnsRulePO.getOsgMdnsRule().getServiceNetworks()))) {
            ArrayList<String> newServiceNetworks = new ArrayList<String>();
            for (String networkId : serviceNetworks) {
                newServiceNetworks.add(lanNetworkIdMap.get(networkId));
            }
            mdnsRulePO.getOsgMdnsRule().setServiceNetworks(newServiceNetworks);
        }
        if (!CollectionUtils.isEmpty((Collection)(clientNetworks = mdnsRulePO.getOsgMdnsRule().getClientNetworks()))) {
            ArrayList<String> newClientNetworks = new ArrayList<String>();
            for (String networkId : clientNetworks) {
                newClientNetworks.add(lanNetworkIdMap.get(networkId));
            }
            mdnsRulePO.getOsgMdnsRule().setClientNetworks(newClientNetworks);
        }
    }

    public void afterRestore(c omadacId, Map<String, Object> restoreCacheMap) {
        List scheduleUpgradePOS;
        List rebootSchedulePOS;
        if (!OmadacType.t()) {
            return;
        }
        String defaultSiteId = (String)restoreCacheMap.get("DEFAULT_SITE");
        if (defaultSiteId == null) {
            log.warn("default siteId is null when handle ServiceSettingRestoreUnitV50100");
            return;
        }
        String sourceOsgMac = (String)restoreCacheMap.get("integrated_gateway_mac_in_backup_file");
        String targetOsgMac = (String)restoreCacheMap.get("integrated_gateway_mac_self");
        List poeSchedulePOS = this.serviceScheduleMaintMongoRepository.b(omadacId, new d(defaultSiteId));
        if (!CollectionUtils.isEmpty((Collection)poeSchedulePOS)) {
            for (Object poeSchedulePO : poeSchedulePOS) {
                Map poePortsMap = poeSchedulePO.getPoePortsMap();
                if (CollectionUtils.isEmpty((Map)poePortsMap)) continue;
                Set ports = null;
                for (Map.Entry entry : poePortsMap.entrySet()) {
                    if (!((String)entry.getKey()).equals(sourceOsgMac)) continue;
                    ports = (Set)entry.getValue();
                }
                if (ports == null) continue;
                poePortsMap.remove(sourceOsgMac);
                poePortsMap.put(targetOsgMac, ports);
            }
            this.serviceScheduleMaintMongoRepository.c(poeSchedulePOS);
        }
        if (!CollectionUtils.isEmpty((Collection)(rebootSchedulePOS = this.serviceScheduleMaintMongoRepository.a(omadacId, new d(defaultSiteId))))) {
            for (RebootSchedulePO rebootSchedulePO : rebootSchedulePOS) {
                if (CollectionUtils.isEmpty((Collection)rebootSchedulePO.getDeviceMacs())) continue;
                Collections.replaceAll(rebootSchedulePO.getDeviceMacs(), sourceOsgMac, targetOsgMac);
            }
            this.serviceScheduleMaintMongoRepository.a(rebootSchedulePOS);
        }
        if (!CollectionUtils.isEmpty((Collection)(scheduleUpgradePOS = this.serviceScheduleMaintMongoRepository.c(omadacId, new d(defaultSiteId))))) {
            for (ScheduleUpgradePO scheduleUpgradePO : scheduleUpgradePOS) {
                if (CollectionUtils.isEmpty((Collection)scheduleUpgradePO.getDeviceMacs())) continue;
                Collections.replaceAll(scheduleUpgradePO.getDeviceMacs(), sourceOsgMac, targetOsgMac);
            }
            this.serviceScheduleMaintMongoRepository.e(scheduleUpgradePOS);
        }
    }
}

