/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.restore;

import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.DdnsSettingBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.MdnsSettingBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.ServiceSettingDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.SnmpSettingBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.SshServerSettingBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.UpnpSettingBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.iptv.IptvSettingBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.restore.a;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osg.BaseOsgSiteSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.ddns.DdnsPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.dhcpreservation.DhcpReservationPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.iptv.IptvSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.mdns.MdnsSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.poeschedule.PortPoeSchedulePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.rebootschedule.RebootSchedulePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.scheduleupgrade.ScheduleUpgradePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.upnp.UpnpSettingPO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V50100, b=com.tplink.smb.omada.backup.api.c.d.SERVICE)
public class ServiceSettingRestoreUnitV50100
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceSettingRestoreUnitV50100.class);
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.ddns.a ddnsMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.ddns.a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.component.common.b commonSiteSettingMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.component.common.b.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osg.a osgSiteSettingMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osg.a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.a serviceScheduleMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.a.a();
    private final a restartTaskPublisher = (a)com.tplink.smb.omada.common.spring.a.b(a.class);
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.dhcpreservation.a dhcpReservationMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.dhcpreservation.a.a();
    private static final ServiceSettingRestoreUnitV50100 instance = new ServiceSettingRestoreUnitV50100();

    private ServiceSettingRestoreUnitV50100() {
    }

    public static ServiceSettingRestoreUnitV50100 getInstance() {
        return instance;
    }

    public void restore(b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        DdnsSettingBackupDTO ddnsSetting;
        IptvSettingBackupDTO iptvSetting;
        MdnsSettingBackupDTO mdnsSetting;
        UpnpSettingBackupDTO upnpSetting;
        List<DhcpReservationPO> dhcpReservationPOList;
        ServiceSettingDTO serviceSettingDTO = (ServiceSettingDTO)jsonParserWrapper.a(ServiceSettingDTO.class);
        Map siteMap = (Map)restoreCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Q.A(), k2 -> new HashMap());
        Map lanNetworkIdMap = (Map)restoreCacheMap.get(com.tplink.smb.omada.backup.api.c.d.af.A());
        List<DdnsPO> ddnsPOList = serviceSettingDTO.getDdnss();
        if (!CollectionUtils.isEmpty(ddnsPOList)) {
            ddnsPOList.forEach(ddnsPO -> {
                ddnsPO.setOmadacId(omadacId.a());
                ddnsPO.setSiteId((String)siteMap.get(ddnsPO.getSiteId()));
                ddnsPO.setId(null);
            });
            this.ddnsMaintMongoRepository.a(ddnsPOList);
        }
        if (!CollectionUtils.isEmpty(dhcpReservationPOList = serviceSettingDTO.getDhcpReservations())) {
            dhcpReservationPOList.forEach(dhcpReservationPO -> {
                dhcpReservationPO.setOmadacId(omadacId.a());
                dhcpReservationPO.setSiteId((String)siteMap.get(dhcpReservationPO.getSiteId()));
                dhcpReservationPO.setLanNetworkId((String)lanNetworkIdMap.get(dhcpReservationPO.getLanNetworkId()));
                dhcpReservationPO.setId(null);
            });
            this.dhcpReservationMaintMongoRepository.a(dhcpReservationPOList);
        }
        SnmpSettingBackupDTO snmpSetting = serviceSettingDTO.getSnmpSetting();
        SshServerSettingBackupDTO sshServerSetting = serviceSettingDTO.getSshSetting();
        if (Objects.nonNull(snmpSetting) && Objects.nonNull(sshServerSetting)) {
            d newSiteId = new d((String)siteMap.get(snmpSetting.getSiteId()));
            this.commonSiteSettingMongoRepository.a(omadacId, newSiteId).ifPresent(commonSiteSetting -> {
                commonSiteSetting.setSnmp(snmpSetting.toPO());
                commonSiteSetting.setSsh(sshServerSetting.toPO());
                this.commonSiteSettingMongoRepository.a(commonSiteSetting);
            });
        }
        if (Objects.nonNull(upnpSetting = serviceSettingDTO.getUpnpSetting())) {
            d newSiteId = new d((String)siteMap.get(upnpSetting.getSiteId()));
            this.osgSiteSettingMongoRepository.a(omadacId, newSiteId).ifPresent(osgSiteSetting -> {
                UpnpSettingPO upnpSettingPO = upnpSetting.toPO();
                if (!CollectionUtils.isEmpty((Collection)upnpSettingPO.getNetworkIds())) {
                    ArrayList newNetworkIds = new ArrayList();
                    upnpSettingPO.getNetworkIds().forEach(oldNetworkId -> newNetworkIds.add((String)lanNetworkIdMap.get(oldNetworkId)));
                    upnpSettingPO.setNetworkIds(newNetworkIds);
                }
                osgSiteSetting.setUpnp(upnpSettingPO);
                this.osgSiteSettingMongoRepository.a((BaseOsgSiteSettingPO)osgSiteSetting);
            });
        }
        if (Objects.nonNull(mdnsSetting = serviceSettingDTO.getMdnsSetting())) {
            d newSiteId = new d((String)siteMap.get(mdnsSetting.getSiteId()));
            this.osgSiteSettingMongoRepository.a(omadacId, newSiteId).ifPresent(osgSiteSetting -> {
                MdnsSettingPO mdnsSettingPO = mdnsSetting.toPO();
                if (!CollectionUtils.isEmpty((Collection)mdnsSettingPO.getNetworkIds())) {
                    ArrayList newNetworkIds = new ArrayList();
                    mdnsSettingPO.getNetworkIds().forEach(oldNetworkId -> newNetworkIds.add((String)lanNetworkIdMap.get(oldNetworkId)));
                    mdnsSettingPO.setNetworkIds(newNetworkIds);
                }
                osgSiteSetting.setMdns(mdnsSettingPO);
                this.osgSiteSettingMongoRepository.a((BaseOsgSiteSettingPO)osgSiteSetting);
            });
        }
        if (Objects.nonNull(iptvSetting = serviceSettingDTO.getIptvSetting())) {
            d newSiteId = new d((String)siteMap.get(iptvSetting.getSiteId()));
            this.osgSiteSettingMongoRepository.a(omadacId, newSiteId).ifPresent(osgSiteSetting -> {
                IptvSettingPO iptvSettingPO = iptvSetting.toPO();
                iptvSettingPO.getIgmp().setWanPortId(iptvSettingPO.getIgmp().getWanPortId());
                iptvSettingPO.getIptv().setWanPortId(iptvSettingPO.getIptv().getWanPortId());
                osgSiteSetting.setIptv(iptvSettingPO);
                this.osgSiteSettingMongoRepository.a((BaseOsgSiteSettingPO)osgSiteSetting);
            });
        }
        if (Objects.nonNull(ddnsSetting = serviceSettingDTO.getDdnsSetting())) {
            d newSiteId = new d((String)siteMap.get(ddnsSetting.getSiteId()));
            this.osgSiteSettingMongoRepository.a(omadacId, newSiteId).ifPresent(osgSiteSetting -> {
                osgSiteSetting.setDdns(ddnsSetting.toPO());
                this.osgSiteSettingMongoRepository.a((BaseOsgSiteSettingPO)osgSiteSetting);
            });
        }
        Map profileMap = (Map)restoreCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Y.A(), k2 -> new HashMap());
        String omadaId = omadacId.a();
        this.restoreRebootSch(serviceSettingDTO, omadaId, siteMap);
        this.restorePoeSch(serviceSettingDTO, omadaId, siteMap, profileMap);
        this.restoreScheduleUpgrade(serviceSettingDTO, omadaId, siteMap);
    }

    public void afterCompatible(c omadacId, Map<String, Object> restoreCacheMap) {
        this.restartTaskPublisher.a(omadacId.a());
    }

    private void restorePoeSch(ServiceSettingDTO serviceSettingDTO, String omadaId, Map<String, String> siteMap, Map<String, String> profileMap) {
        List<PortPoeSchedulePO> poeSchs = serviceSettingDTO.getPoeSchs();
        if (CollectionUtils.isEmpty(poeSchs)) {
            return;
        }
        ArrayList<PortPoeSchedulePO> poeSchedulePOS = new ArrayList<PortPoeSchedulePO>(poeSchs.size());
        for (PortPoeSchedulePO poeSchedulePO : poeSchs) {
            poeSchedulePO.setOmadacId(omadaId);
            poeSchedulePO.setSiteId(siteMap.get(poeSchedulePO.getSiteId()));
            poeSchedulePO.setScheduleProfileId(profileMap.get(poeSchedulePO.getScheduleProfileId()));
            poeSchedulePO.setId(null);
            poeSchedulePOS.add(poeSchedulePO);
        }
        this.serviceScheduleMaintMongoRepository.c(poeSchedulePOS);
    }

    private void restoreRebootSch(ServiceSettingDTO serviceSettingDTO, String omadaId, Map<String, String> siteMap) {
        List<RebootSchedulePO> rebootSchs = serviceSettingDTO.getRebootSchs();
        if (CollectionUtils.isEmpty(rebootSchs)) {
            return;
        }
        ArrayList<RebootSchedulePO> rebootSchedulePOS = new ArrayList<RebootSchedulePO>(rebootSchs.size());
        for (RebootSchedulePO rebootSchedulePO : rebootSchs) {
            rebootSchedulePO.setOmadacId(omadaId);
            rebootSchedulePO.setSiteId(siteMap.get(rebootSchedulePO.getSiteId()));
            rebootSchedulePO.setId(null);
            rebootSchedulePOS.add(rebootSchedulePO);
        }
        this.serviceScheduleMaintMongoRepository.a(rebootSchedulePOS);
    }

    private void restoreScheduleUpgrade(ServiceSettingDTO serviceSettingDTO, String omadaId, Map<String, String> siteMap) {
        List<ScheduleUpgradePO> scheduleUpgrades = serviceSettingDTO.getScheduleUpgrades();
        if (CollectionUtils.isEmpty(scheduleUpgrades)) {
            return;
        }
        ArrayList<ScheduleUpgradePO> scheduleUpgradePOS = new ArrayList<ScheduleUpgradePO>(scheduleUpgrades.size());
        for (ScheduleUpgradePO scheduleUpgradePO : scheduleUpgrades) {
            scheduleUpgradePO.setOmadacId(omadaId);
            scheduleUpgradePO.setSiteId(siteMap.get(scheduleUpgradePO.getSiteId()));
            scheduleUpgradePO.setId(null);
            scheduleUpgradePOS.add(scheduleUpgradePO);
        }
        this.serviceScheduleMaintMongoRepository.e(scheduleUpgradePOS);
    }

    public void afterRestore(c omadacId, Map<String, Object> restoreCacheMap) {
        List scheduleUpgradePOS;
        List rebootSchedulePOS;
        if (!OmadacType.t()) {
            return;
        }
        String defaultSiteId = (String)restoreCacheMap.get("DEFAULT_SITE");
        if (defaultSiteId == null) {
            log.warn("default siteId is null when handle ServiceSettingRestoreUnitV50100");
            return;
        }
        String sourceOsgMac = (String)restoreCacheMap.get("integrated_gateway_mac_in_backup_file");
        String targetOsgMac = (String)restoreCacheMap.get("integrated_gateway_mac_self");
        List poeSchedulePOS = this.serviceScheduleMaintMongoRepository.b(omadacId, new d(defaultSiteId));
        if (!CollectionUtils.isEmpty((Collection)poeSchedulePOS)) {
            for (Object poeSchedulePO : poeSchedulePOS) {
                Map poePortsMap = poeSchedulePO.getPoePortsMap();
                if (CollectionUtils.isEmpty((Map)poePortsMap)) continue;
                Set ports = null;
                for (Map.Entry entry : poePortsMap.entrySet()) {
                    if (!((String)entry.getKey()).equals(sourceOsgMac)) continue;
                    ports = (Set)entry.getValue();
                }
                if (ports == null) continue;
                poePortsMap.remove(sourceOsgMac);
                poePortsMap.put(targetOsgMac, ports);
            }
            this.serviceScheduleMaintMongoRepository.c(poeSchedulePOS);
        }
        if (!CollectionUtils.isEmpty((Collection)(rebootSchedulePOS = this.serviceScheduleMaintMongoRepository.a(omadacId, new d(defaultSiteId))))) {
            for (RebootSchedulePO rebootSchedulePO : rebootSchedulePOS) {
                if (CollectionUtils.isEmpty((Collection)rebootSchedulePO.getDeviceMacs())) continue;
                Collections.replaceAll(rebootSchedulePO.getDeviceMacs(), sourceOsgMac, targetOsgMac);
            }
            this.serviceScheduleMaintMongoRepository.a(rebootSchedulePOS);
        }
        if (!CollectionUtils.isEmpty((Collection)(scheduleUpgradePOS = this.serviceScheduleMaintMongoRepository.c(omadacId, new d(defaultSiteId))))) {
            for (ScheduleUpgradePO scheduleUpgradePO : scheduleUpgradePOS) {
                if (CollectionUtils.isEmpty((Collection)scheduleUpgradePO.getDeviceMacs())) continue;
                Collections.replaceAll(scheduleUpgradePO.getDeviceMacs(), sourceOsgMac, targetOsgMac);
            }
            this.serviceScheduleMaintMongoRepository.e(scheduleUpgradePOS);
        }
    }
}

