/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting;

import com.tplink.smb.omada.backup.api.c.h;
import com.tplink.smb.omada.backup.api.c.n;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.DdnsSettingBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.DnsCacheSettingBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.QuickActionSettingBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.ServiceSettingDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.SnmpSettingBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.SnmpTemplateSettingBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.SshServerSettingBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.SshServerTemplateSettingBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.UpnpSettingBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.dnsproxy.DnsProxySettingBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.iptv.IptvSettingBackupDTO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.common.b;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.ddns.a;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.a(a=com.tplink.smb.omada.backup.api.c.d.SERVICE)
public class ServiceSettingBackupUnit
extends com.tplink.smb.omada.backup.api.b.d<ServiceSettingDTO> {
    private final a ddnsMaintMongoRepository = a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.a serviceScheduleMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.a.a();
    private final b commonSiteSettingMongoRepository = b.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osg.a osgSiteSettingMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osg.a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.dhcpreservation.a dhcpReservationMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.dhcpreservation.a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.mdns.a mdnsRuleMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.mdns.a.a();
    private static final ServiceSettingBackupUnit instance = new ServiceSettingBackupUnit();

    private ServiceSettingBackupUnit() {
    }

    public static ServiceSettingBackupUnit getInstance() {
        return instance;
    }

    public ServiceSettingDTO readFromDB(c omadacId, d siteId, boolean siteTemplateRead) throws com.tplink.smb.omada.backup.api.d.a {
        ServiceSettingDTO serviceSettingDTO = new ServiceSettingDTO();
        if (siteTemplateRead) {
            serviceSettingDTO.setSiteSettingEnumValue(n.b.a());
        } else {
            serviceSettingDTO.setSiteSettingEnumValue(n.a.a());
        }
        List dhcpReservationPOList = this.dhcpReservationMaintMongoRepository.a(omadacId, siteId);
        if (!CollectionUtils.isEmpty((Collection)dhcpReservationPOList)) {
            serviceSettingDTO.setDhcpReservations(dhcpReservationPOList);
        }
        if (siteTemplateRead) {
            List mdnsRuleTemplatePOList = this.mdnsRuleMaintMongoRepository.a(omadacId, siteId.a());
            if (!CollectionUtils.isEmpty((Collection)mdnsRuleTemplatePOList)) {
                serviceSettingDTO.setMdnsRuleTemplates(mdnsRuleTemplatePOList);
            }
        } else {
            List mdnsRulePOList = this.mdnsRuleMaintMongoRepository.a(omadacId, siteId);
            if (!CollectionUtils.isEmpty((Collection)mdnsRulePOList)) {
                serviceSettingDTO.setMdnsRules(mdnsRulePOList);
            }
        }
        if (siteTemplateRead) {
            this.commonSiteSettingMongoRepository.a(omadacId, siteId.a()).ifPresent(commonSiteSettingTemplate -> {
                serviceSettingDTO.setSnmpTemplateSetting(SnmpTemplateSettingBackupDTO.fromPO(commonSiteSettingTemplate.getSnmp(), siteId));
                serviceSettingDTO.setSshServerTemplateSetting(SshServerTemplateSettingBackupDTO.fromPO(commonSiteSettingTemplate.getSsh(), siteId));
            });
            this.fillRebootSchTemplate(serviceSettingDTO, omadacId, siteId.a());
        } else {
            this.commonSiteSettingMongoRepository.a(omadacId, siteId).ifPresent(commonSiteSetting -> {
                serviceSettingDTO.setSnmpSetting(SnmpSettingBackupDTO.fromPO(commonSiteSetting.getSnmp(), siteId));
                serviceSettingDTO.setSshSetting(SshServerSettingBackupDTO.fromPO(commonSiteSetting.getSsh(), siteId));
                if (commonSiteSetting.getQuickAction() != null) {
                    serviceSettingDTO.setQuickActionSetting(QuickActionSettingBackupDTO.fromPO(commonSiteSetting.getQuickAction(), siteId));
                }
            });
        }
        if (siteTemplateRead) {
            ddnsPOList = this.ddnsMaintMongoRepository.a(omadacId, siteId.a());
            if (!CollectionUtils.isEmpty((Collection)ddnsPOList)) {
                serviceSettingDTO.setDdnssTemplate(ddnsPOList);
            }
            this.osgSiteSettingMongoRepository.a(omadacId, siteId.a()).ifPresent(osgSiteSettingTemplate -> {
                serviceSettingDTO.setUpnpSetting(UpnpSettingBackupDTO.fromTemplatePO(osgSiteSettingTemplate.getUpnp(), siteId));
                serviceSettingDTO.setIptvSetting(IptvSettingBackupDTO.fromTemplatePO(osgSiteSettingTemplate.getIptv(), siteId));
                serviceSettingDTO.setDdnsSetting(DdnsSettingBackupDTO.fromTemplatePO(osgSiteSettingTemplate.getDdns(), siteId));
                serviceSettingDTO.setDnsProxySetting(DnsProxySettingBackupDTO.fromTemplatePO(osgSiteSettingTemplate.getDnsProxy(), siteId));
                serviceSettingDTO.setDnsCacheSetting(DnsCacheSettingBackupDTO.fromTemplatePO(osgSiteSettingTemplate.getDnsCache(), siteId));
            });
        } else {
            ddnsPOList = this.ddnsMaintMongoRepository.a(omadacId, siteId);
            if (!CollectionUtils.isEmpty((Collection)ddnsPOList)) {
                serviceSettingDTO.setDdnss(ddnsPOList);
            }
            this.osgSiteSettingMongoRepository.a(omadacId, siteId).ifPresent(osgSiteSetting -> {
                serviceSettingDTO.setUpnpSetting(UpnpSettingBackupDTO.fromPO(osgSiteSetting.getUpnp(), siteId));
                serviceSettingDTO.setIptvSetting(IptvSettingBackupDTO.fromPO(osgSiteSetting.getIptv(), siteId));
                serviceSettingDTO.setDdnsSetting(DdnsSettingBackupDTO.fromPO(osgSiteSetting.getDdns(), siteId));
                serviceSettingDTO.setDnsProxySetting(DnsProxySettingBackupDTO.fromPO(osgSiteSetting.getDnsProxy(), siteId));
                serviceSettingDTO.setDnsCacheSetting(DnsCacheSettingBackupDTO.fromPO(osgSiteSetting.getDnsCache(), siteId));
            });
        }
        this.fillRebootSch(serviceSettingDTO, omadacId, siteId);
        this.fillPoeSch(serviceSettingDTO, omadacId, siteId, siteTemplateRead);
        this.fillPortStatusSch(serviceSettingDTO, omadacId, siteId, siteTemplateRead);
        this.fillScheduleUpgrade(serviceSettingDTO, omadacId, siteId);
        return serviceSettingDTO;
    }

    private void fillPortStatusSch(ServiceSettingDTO serviceSettingDTO, c omadacId, d siteId, boolean siteTemplateRead) {
        if (siteTemplateRead) {
            List portStatusScheduleTemplatePOS = this.serviceScheduleMaintMongoRepository.c(omadacId, siteId.a());
            serviceSettingDTO.setPortStatusSchsTemplate(portStatusScheduleTemplatePOS);
        } else {
            List portStatusSchedulePOS = this.serviceScheduleMaintMongoRepository.g(omadacId, siteId);
            serviceSettingDTO.setPortStatusSchs(portStatusSchedulePOS);
        }
    }

    private void fillPoeSch(ServiceSettingDTO serviceSettingDTO, c omadacId, d siteId, boolean siteTemplateRead) {
        if (siteTemplateRead) {
            List poeScheduleTemplatePOS = this.serviceScheduleMaintMongoRepository.b(omadacId, siteId.a());
            serviceSettingDTO.setPoeSchsTemplate(poeScheduleTemplatePOS);
        } else {
            List poeSchedulePOS = this.serviceScheduleMaintMongoRepository.b(omadacId, siteId);
            serviceSettingDTO.setPoeSchs(poeSchedulePOS);
        }
    }

    private void fillRebootSch(ServiceSettingDTO serviceSettingDTO, c omadacId, d siteId) {
        List rebootSchedulePOS = this.serviceScheduleMaintMongoRepository.a(omadacId, siteId);
        serviceSettingDTO.setRebootSchs(rebootSchedulePOS);
    }

    private void fillRebootSchTemplate(ServiceSettingDTO serviceSettingDTO, c omadacId, String siteTemplateId) {
        List rebootSchedulePOS = this.serviceScheduleMaintMongoRepository.a(omadacId, siteTemplateId);
        serviceSettingDTO.setRebootSchsTemplate(rebootSchedulePOS);
    }

    private void fillScheduleUpgrade(ServiceSettingDTO serviceSettingDTO, c omadacId, d siteId) {
        List scheduleUpgradePOS = this.serviceScheduleMaintMongoRepository.c(omadacId, siteId);
        serviceSettingDTO.setScheduleUpgrades(scheduleUpgradePOS);
    }

    public void backup(com.tplink.smb.omada.backup.api.e.a wrapper, c omadacId, d siteId, com.tplink.smb.omada.backup.api.c.d keyEnum, h backupTypeEnum) throws IOException, com.tplink.smb.omada.backup.api.d.a {
        ServiceSettingDTO element = this.readFromDB(omadacId, siteId, false);
        if (element != null) {
            if (h.e.equals((Object)backupTypeEnum)) {
                element.setDdnss(Collections.emptyList());
                if (element.getSnmpSetting() != null) {
                    element.getSnmpSetting().setUsername(null);
                    element.getSnmpSetting().setPassword(null);
                    element.getSnmpSetting().setCommunityString(null);
                }
            }
            wrapper.a(keyEnum.A(), (Object)element);
        }
    }
}

