/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.ppskpage.restore;

import com.tplink.smb.component.storage.api.repository.FileRepository;
import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.c.n;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.PortalFileBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.ppskpage.dto.PPSKPageBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.ppskpage.dto.PPSKPageDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.ppskpage.dto.PPSKPageTemplateDTO;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.common.util.b.c;
import com.tplink.smb.omada.portal.port.mongo.omada.ppskpage.PPSKPageMaintRepository;
import com.tplink.smb.omada.portal.port.mongo.omada.ppskpage.PPSKPagePO;
import com.tplink.smb.omada.portal.port.mongo.omada.ppskpage.PPSKPageTemplateMaintRepository;
import com.tplink.smb.omada.portal.port.mongo.omada.ppskpage.PPSKPageTemplatePO;
import com.tplink.smb.omada.portal.port.mongo.omada.ppskpage.picture.PPSKPicturePO;
import com.tplink.smb.omada.portal.port.mongo.omada.ppskpage.picture.PPSKPictureTemplatePO;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.backup.api.a.c(a=l.V60100, b=d.PPSK_PAGE)
public class PPSKPageRestoreUnitV60100
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PPSKPageRestoreUnitV60100.class);
    private static final PPSKPageRestoreUnitV60100 instance = new PPSKPageRestoreUnitV60100();
    private final PPSKPageMaintRepository ppskPageMaintRepository = PPSKPageMaintRepository.getInstance();
    private final PPSKPageTemplateMaintRepository ppskPageTemplateMaintRepository = PPSKPageTemplateMaintRepository.getInstance();
    private FileRepository clientFileRepository = (FileRepository)a.b(FileRepository.class);
    private final com.tplink.smb.omada.backup.core.unit.siteconfig.portal.b portalFileRestoreRestrict = (com.tplink.smb.omada.backup.core.unit.siteconfig.portal.b)a.b(com.tplink.smb.omada.backup.core.unit.siteconfig.portal.b.class);

    private PPSKPageRestoreUnitV60100() {
    }

    public static PPSKPageRestoreUnitV60100 getInstance() {
        return instance;
    }

    public void restore(b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        PPSKPageBackupDTO backupDTO = (PPSKPageBackupDTO)jsonParserWrapper.a(PPSKPageBackupDTO.class);
        this.restorePageTemplate(backupDTO.getTemplateDtoList(), omadacId, restoreCacheMap);
    }

    private void restorePage(List<PPSKPageDTO> dtoList, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        Map siteIdMap = restoreCacheMap.getOrDefault(d.Q.A(), Collections.emptyMap());
        Map pageIdMap = (Map)restoreCacheMap.computeIfAbsent(d.ae.A(), key -> new HashMap());
        Map portalFileTemplateIdMap = (Map)restoreCacheMap.computeIfAbsent("portalFileTemplateIdMap", k2 -> new HashMap());
        for (PPSKPageDTO dto : dtoList) {
            String currentSiteId = (String)siteIdMap.get(dto.getPpskPage().getSiteId());
            if (currentSiteId == null) {
                log.error("Restoring Portals: Cannot find mapped siteId by v5 backup portal {}.", (Object)dto.getPpskPage().getId());
                throw new com.tplink.smb.omada.backup.api.d.c("Cannot find mapped siteId.");
            }
            PPSKPagePO po = dto.getPpskPage();
            String oldId = po.getId();
            po.setOmadacId(omadacId.a());
            po.setSiteId(currentSiteId);
            if (dto.getMoblieBackgroundPic() != null && po.getBackground() != null && po.getBackground().getPicture() != null && po.getBackground().getPicture().getMobilePictureId() != null) {
                po.getBackground().getPicture().setMobilePictureId(this.restorePic(omadacId.a(), currentSiteId, dto.getMoblieBackgroundPic(), portalFileTemplateIdMap, n.a));
            }
            if (dto.getPcBackgroundPic() != null && po.getBackground() != null && po.getBackground().getPicture() != null && po.getBackground().getPicture().getPcPictureId() != null) {
                po.getBackground().getPicture().setPcPictureId(this.restorePic(omadacId.a(), currentSiteId, dto.getPcBackgroundPic(), portalFileTemplateIdMap, n.a));
            }
            if (dto.getLogoPic() != null && po.getLogo() != null && po.getLogo().getPictureId() != null) {
                po.getLogo().setPictureId(this.restorePic(omadacId.a(), currentSiteId, dto.getLogoPic(), portalFileTemplateIdMap, n.a));
            }
            PPSKPagePO newPO = this.ppskPageMaintRepository.insert(po);
            pageIdMap.put(oldId, newPO.getId());
        }
    }

    private void restorePageTemplate(List<PPSKPageTemplateDTO> templateDtoList, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) {
        if (CollectionUtils.isEmpty(templateDtoList)) {
            return;
        }
        Map siteIdMap = restoreCacheMap.getOrDefault(d.Q.A(), Collections.emptyMap());
        Map pageIdMap = (Map)restoreCacheMap.computeIfAbsent(d.ae.A(), key -> new HashMap());
        Map portalFileTemplateIdMap = (Map)restoreCacheMap.computeIfAbsent("portalFileTemplateIdMap", k2 -> new HashMap());
        for (PPSKPageTemplateDTO dto : templateDtoList) {
            String currentSiteId = (String)siteIdMap.get(dto.getPpskPageTemplate().getSiteTemplateId());
            if (currentSiteId == null) {
                log.error("Restoring Portals: Cannot find mapped siteId by v5 backup portal {}.", (Object)dto.getPpskPageTemplate().getId());
                throw new com.tplink.smb.omada.backup.api.d.c("Cannot find mapped siteId.");
            }
            PPSKPageTemplatePO templatePO = dto.getPpskPageTemplate();
            String oldId = templatePO.getId();
            templatePO.setOmadacId(omadacId.a());
            templatePO.setSiteTemplateId(currentSiteId);
            if (dto.getMoblieBackgroundPicTemplate() != null && templatePO.getBackground() != null && templatePO.getBackground().getPicture() != null && templatePO.getBackground().getPicture().getMobilePictureId() != null) {
                templatePO.getBackground().getPicture().setMobilePictureId(this.restorePic(omadacId.a(), currentSiteId, dto.getMoblieBackgroundPicTemplate(), portalFileTemplateIdMap, n.b));
            }
            if (dto.getPcBackgroundPicTemplate() != null && templatePO.getBackground() != null && templatePO.getBackground().getPicture() != null && templatePO.getBackground().getPicture().getPcPictureId() != null) {
                templatePO.getBackground().getPicture().setPcPictureId(this.restorePic(omadacId.a(), currentSiteId, dto.getPcBackgroundPicTemplate(), portalFileTemplateIdMap, n.b));
            }
            if (dto.getLogoPicTemplate() != null && templatePO.getLogo() != null && templatePO.getLogo().getPictureId() != null) {
                templatePO.getLogo().setPictureId(this.restorePic(omadacId.a(), currentSiteId, dto.getLogoPicTemplate(), portalFileTemplateIdMap, n.b));
            }
            PPSKPageTemplatePO newPO = this.ppskPageTemplateMaintRepository.insert(templatePO);
            pageIdMap.put(oldId, newPO.getId());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String restorePic(@Nonnull String omadacId, @Nonnull String siteId, @Nullable PortalFileBKDTO pic, Map<String, String> portalFileTemplateIdMap, n type) {
        if (pic == null) {
            return null;
        }
        byte[] bytes = c.b((String)pic.getFileContent());
        if (this.portalFileRestoreRestrict.a(omadacId, bytes.length)) {
            log.info("Portal picture reached file storage limit, skip this picture. File size: {} bytes.", (Object)bytes.length);
            return null;
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
            String prefix = omadacId + "/" + siteId;
            String fileId = this.clientFileRepository.saveFile(prefix, null, pic.getFileName(), (InputStream)in);
            if (fileId == null) {
                log.warn("Failed to save file into FileRepository, skip this file :{}, Omadac: {}, Site: {}.", new Object[]{pic.getFileName(), omadacId, siteId});
                String string = null;
                return string;
            }
            if (type == n.b) {
                PPSKPictureTemplatePO templatePO = (PPSKPictureTemplatePO)new PPSKPictureTemplatePO().setOmadacId(omadacId).setFileName(pic.getFileName()).setExpireTime(Long.valueOf(0L)).setFileId(fileId).setFileSize(Long.valueOf(bytes.length)).setTemp(Boolean.valueOf(false));
                templatePO.setSiteTemplateId(siteId);
                PPSKPictureTemplatePO inserted = this.ppskPageTemplateMaintRepository.insertPicTemplate(templatePO);
                if (pic.getId() != null) {
                    portalFileTemplateIdMap.put(pic.getId(), inserted.getId());
                }
                String string = inserted.getId();
                return string;
            }
            PPSKPicturePO picturePO = (PPSKPicturePO)new PPSKPicturePO().setOmadacId(omadacId).setFileName(pic.getFileName()).setExpireTime(Long.valueOf(0L)).setFileId(fileId).setFileSize(Long.valueOf(bytes.length)).setTemp(Boolean.valueOf(false));
            picturePO.setSiteId(siteId);
            picturePO.setTemplateId(pic.getTemplateId() == null ? null : (String)portalFileTemplateIdMap.getOrDefault(pic.getTemplateId(), null));
            picturePO.setOverride(pic.getOverride());
            PPSKPicturePO inserted = this.ppskPageMaintRepository.insertPic(picturePO);
            String string = inserted.getId();
            return string;
        }
        catch (IOException ex) {
            log.error("Failed to transform backup portal picture content of {}, Omadac: {}, Site: {}", new Object[]{pic.getFileName(), omadacId, siteId});
            return null;
        }
    }
}

