/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.ppskpage;

import com.tplink.smb.component.storage.api.repository.FileRepository;
import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.backup.api.c.n;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.PortalFileBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.ppskpage.dto.PPSKPageBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.ppskpage.dto.PPSKPageDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.ppskpage.dto.PPSKPageTemplateDTO;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.common.util.b.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.portal.port.mongo.omada.ppskpage.PPSKPageMaintRepository;
import com.tplink.smb.omada.portal.port.mongo.omada.ppskpage.PPSKPagePO;
import com.tplink.smb.omada.portal.port.mongo.omada.ppskpage.PPSKPageTemplateMaintRepository;
import com.tplink.smb.omada.portal.port.mongo.omada.ppskpage.PPSKPageTemplatePO;
import com.tplink.smb.omada.portal.port.mongo.omada.ppskpage.picture.PPSKPicturePO;
import com.tplink.smb.omada.portal.port.mongo.omada.ppskpage.picture.PPSKPictureTemplatePO;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.backup.api.a.d(a=com.tplink.smb.omada.backup.api.c.d.PPSK_PAGE)
public class PPSKPageSiteImportUnit
extends com.tplink.smb.omada.backup.api.c {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PPSKPageSiteImportUnit.class);
    private static final PPSKPageSiteImportUnit instance = new PPSKPageSiteImportUnit();
    private final PPSKPageMaintRepository ppskPageMaintRepository = PPSKPageMaintRepository.getInstance();
    private final PPSKPageTemplateMaintRepository ppskPageTemplateMaintRepository = PPSKPageTemplateMaintRepository.getInstance();
    private FileRepository clientFileRepository = (FileRepository)a.b(FileRepository.class);
    private final com.tplink.smb.omada.backup.core.unit.siteconfig.portal.b portalFileRestoreRestrict = (com.tplink.smb.omada.backup.core.unit.siteconfig.portal.b)a.b(com.tplink.smb.omada.backup.core.unit.siteconfig.portal.b.class);

    private PPSKPageSiteImportUnit() {
    }

    public static PPSKPageSiteImportUnit getInstance() {
        return instance;
    }

    public void siteImport(b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        PPSKPageBackupDTO backupDTO = (PPSKPageBackupDTO)jsonParserWrapper.a(PPSKPageBackupDTO.class);
        this.siteCopyWrite(backupDTO, omadacId, newSiteId, siteImportIdCacheMap);
    }

    public void siteCopyWrite(Object dataObject, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        PPSKPageBackupDTO backupDTO = (PPSKPageBackupDTO)dataObject;
        if (backupDTO == null || CollectionUtils.isEmpty(backupDTO.getDtoList())) {
            return;
        }
        Map pageIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.ae.A(), key -> new HashMap());
        for (PPSKPageDTO dto : backupDTO.getDtoList()) {
            PPSKPagePO po = dto.getPpskPage();
            String oldId = po.getId();
            if (dto.getMoblieBackgroundPic() != null && po.getBackground() != null && po.getBackground().getPicture() != null && po.getBackground().getPicture().getMobilePictureId() != null) {
                po.getBackground().getPicture().setMobilePictureId(this.restorePicBySiteImport(omadacId.a(), newSiteId.a(), dto.getMoblieBackgroundPic(), true));
            }
            if (dto.getPcBackgroundPic() != null && po.getBackground() != null && po.getBackground().getPicture() != null && po.getBackground().getPicture().getPcPictureId() != null) {
                po.getBackground().getPicture().setPcPictureId(this.restorePicBySiteImport(omadacId.a(), newSiteId.a(), dto.getPcBackgroundPic(), true));
            }
            if (dto.getLogoPic() != null && po.getLogo() != null && po.getLogo().getPictureId() != null) {
                po.getLogo().setPictureId(this.restorePicBySiteImport(omadacId.a(), newSiteId.a(), dto.getLogoPic(), true));
            }
            po.setTemplateId(null);
            po.setOverride(null);
            PPSKPagePO newPO = this.ppskPageMaintRepository.insert(po);
            pageIdMap.put(oldId, newPO.getId());
        }
    }

    public void siteTemplateCopyWrite(Object dataObject, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        PPSKPageBackupDTO backupDTO = (PPSKPageBackupDTO)dataObject;
        if (backupDTO == null || CollectionUtils.isEmpty(backupDTO.getTemplateDtoList())) {
            return;
        }
        Map pageIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.ae.A(), key -> new HashMap());
        Map portalFileTemplateIdMap = siteImportIdCacheMap.computeIfAbsent("portalFileTemplateIdMap", k2 -> new HashMap());
        for (PPSKPageTemplateDTO dto : backupDTO.getTemplateDtoList()) {
            PPSKPageTemplatePO po = dto.getPpskPageTemplate();
            String oldId = po.getId();
            if (dto.getMoblieBackgroundPicTemplate() != null && po.getBackground() != null && po.getBackground().getPicture() != null && po.getBackground().getPicture().getMobilePictureId() != null) {
                po.getBackground().getPicture().setMobilePictureId(this.restorePic(omadacId.a(), newSiteTemplateId.a(), dto.getMoblieBackgroundPicTemplate(), portalFileTemplateIdMap, n.b));
            }
            if (dto.getPcBackgroundPicTemplate() != null && po.getBackground() != null && po.getBackground().getPicture() != null && po.getBackground().getPicture().getPcPictureId() != null) {
                po.getBackground().getPicture().setPcPictureId(this.restorePic(omadacId.a(), newSiteTemplateId.a(), dto.getPcBackgroundPicTemplate(), portalFileTemplateIdMap, n.b));
            }
            if (dto.getLogoPicTemplate() != null && po.getLogo() != null && po.getLogo().getPictureId() != null) {
                po.getLogo().setPictureId(this.restorePic(omadacId.a(), newSiteTemplateId.a(), dto.getLogoPicTemplate(), portalFileTemplateIdMap, n.b));
            }
            PPSKPageTemplatePO newPO = this.ppskPageTemplateMaintRepository.insert(po);
            pageIdMap.put(oldId, newPO.getId());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String restorePic(@Nonnull String omadacId, @Nonnull String siteId, @Nullable PortalFileBKDTO pic, Map<String, String> portalFileTemplateIdMap, n type) {
        if (pic == null) {
            return null;
        }
        byte[] bytes = c.b((String)pic.getFileContent());
        if (this.portalFileRestoreRestrict.a(omadacId, bytes.length)) {
            log.info("Portal picture reached file storage limit, skip this picture. File size: {} bytes.", (Object)bytes.length);
            return null;
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
            String prefix = omadacId + "/" + siteId;
            String fileId = this.clientFileRepository.saveFile(prefix, null, pic.getFileName(), (InputStream)in);
            if (fileId == null) {
                log.warn("Failed to save file into FileRepository, skip this file :{}, Omadac: {}, Site: {}.", new Object[]{pic.getFileName(), omadacId, siteId});
                String string = null;
                return string;
            }
            if (type == n.b) {
                PPSKPictureTemplatePO templatePO = (PPSKPictureTemplatePO)new PPSKPictureTemplatePO().setOmadacId(omadacId).setFileName(pic.getFileName()).setExpireTime(Long.valueOf(0L)).setFileId(fileId).setFileSize(Long.valueOf(bytes.length)).setTemp(Boolean.valueOf(false));
                templatePO.setSiteTemplateId(siteId);
                PPSKPictureTemplatePO inserted = this.ppskPageTemplateMaintRepository.insertPicTemplate(templatePO);
                if (pic.getId() != null) {
                    portalFileTemplateIdMap.put(pic.getId(), inserted.getId());
                }
                String string = inserted.getId();
                return string;
            }
            PPSKPicturePO picturePO = (PPSKPicturePO)new PPSKPicturePO().setOmadacId(omadacId).setFileName(pic.getFileName()).setExpireTime(Long.valueOf(0L)).setFileId(fileId).setFileSize(Long.valueOf(bytes.length)).setTemp(Boolean.valueOf(false));
            picturePO.setSiteId(siteId);
            picturePO.setTemplateId(pic.getTemplateId() == null ? null : (String)portalFileTemplateIdMap.getOrDefault(pic.getTemplateId(), null));
            picturePO.setOverride(pic.getOverride());
            PPSKPicturePO inserted = this.ppskPageMaintRepository.insertPic(picturePO);
            String string = inserted.getId();
            return string;
        }
        catch (IOException ex) {
            log.error("Failed to transform backup portal picture content of {}, Omadac: {}, Site: {}", new Object[]{pic.getFileName(), omadacId, siteId});
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String restorePicBySiteImport(@Nonnull String omadacId, @Nonnull String siteId, @Nullable PortalFileBKDTO pic, boolean needUnbind) {
        if (pic == null) {
            return null;
        }
        byte[] bytes = c.b((String)pic.getFileContent());
        if (this.portalFileRestoreRestrict.a(omadacId, bytes.length)) {
            log.info("Portal picture reached file storage limit, skip this picture. File size: {} bytes.", (Object)bytes.length);
            return null;
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
            String prefix = omadacId + "/" + siteId;
            String fileId = this.clientFileRepository.saveFile(prefix, null, pic.getFileName(), (InputStream)in);
            if (fileId == null) {
                log.warn("Failed to save file into FileRepository, skip this file :{}, Omadac: {}, Site: {}.", new Object[]{pic.getFileName(), omadacId, siteId});
                String string = null;
                return string;
            }
            PPSKPicturePO picturePO = (PPSKPicturePO)new PPSKPicturePO().setOmadacId(omadacId).setFileName(pic.getFileName()).setExpireTime(Long.valueOf(0L)).setFileId(fileId).setFileSize(Long.valueOf(bytes.length)).setTemp(Boolean.valueOf(false));
            picturePO.setSiteId(siteId);
            picturePO.setOverride(pic.getOverride()).setTemplateId(pic.getTemplateId());
            if (needUnbind) {
                pic.setOverride(null).setTemplateId(null);
            }
            PPSKPicturePO inserted = this.ppskPageMaintRepository.insertPic(picturePO);
            String string = inserted.getId();
            return string;
        }
        catch (IOException ex) {
            log.error("Failed to transform backup portal picture content of {}, Omadac: {}, Site: {}", new Object[]{pic.getFileName(), omadacId, siteId});
            return null;
        }
    }
}

