/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.ppskpage;

import com.tplink.smb.component.storage.api.repository.FileRepository;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.PortalFileBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.ppskpage.dto.PPSKPageBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.ppskpage.dto.PPSKPageDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.ppskpage.dto.PPSKPageTemplateDTO;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.c.x;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.file.PortalFilePO;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.file.PortalFileTemplatePO;
import com.tplink.smb.omada.portal.port.mongo.omada.ppskpage.PPSKPageMaintRepository;
import com.tplink.smb.omada.portal.port.mongo.omada.ppskpage.PPSKPagePO;
import com.tplink.smb.omada.portal.port.mongo.omada.ppskpage.PPSKPageTemplateMaintRepository;
import com.tplink.smb.omada.portal.port.mongo.omada.ppskpage.PPSKPageTemplatePO;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.backup.api.a.a(a=com.tplink.smb.omada.backup.api.c.d.PPSK_PAGE)
public class PPSKPageBackupUnit
extends com.tplink.smb.omada.backup.api.b.d<PPSKPageBackupDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PPSKPageBackupUnit.class);
    private static final PPSKPageBackupUnit instance = new PPSKPageBackupUnit();
    private final PPSKPageMaintRepository ppskPageMaintRepository = PPSKPageMaintRepository.getInstance();
    private final PPSKPageTemplateMaintRepository ppskPageTemplateMaintRepository = PPSKPageTemplateMaintRepository.getInstance();
    private FileRepository clientFileRepository = (FileRepository)a.b(FileRepository.class);

    private PPSKPageBackupUnit() {
    }

    public static PPSKPageBackupUnit getInstance() {
        return instance;
    }

    public PPSKPageBackupDTO readFromDB(c omadacId, d siteId, boolean siteTemplateRead) throws IOException, com.tplink.smb.omada.backup.api.d.a {
        if (siteTemplateRead) {
            return this.backupPpskPageTemplate(omadacId, siteId);
        }
        return this.backupPpskPage(omadacId, siteId);
    }

    private PPSKPageBackupDTO backupPpskPage(c omadacId, d siteId) {
        List poList = this.ppskPageMaintRepository.findBackupPO(omadacId, siteId);
        ArrayList<PPSKPageDTO> dtoList = new ArrayList<PPSKPageDTO>(poList.size());
        for (PPSKPagePO po : poList) {
            PPSKPageDTO dto = new PPSKPageDTO(po);
            if (po.getBackground() != null && po.getBackground().getPicture() != null && po.getBackground().getPicture().getMobilePictureId() != null) {
                dto.setMoblieBackgroundPic(this.backupPic(omadacId, siteId, po.getBackground().getPicture().getMobilePictureId(), x.a));
            }
            if (po.getBackground() != null && po.getBackground().getPicture() != null && po.getBackground().getPicture().getPcPictureId() != null) {
                dto.setPcBackgroundPic(this.backupPic(omadacId, siteId, po.getBackground().getPicture().getPcPictureId(), x.a));
            }
            if (po.getLogo() != null && po.getLogo().getPictureId() != null) {
                dto.setLogoPic(this.backupPic(omadacId, siteId, po.getLogo().getPictureId(), x.a));
            }
            dtoList.add(dto);
        }
        return new PPSKPageBackupDTO().setDtoList(dtoList);
    }

    private PPSKPageBackupDTO backupPpskPageTemplate(c omadacId, d siteId) {
        List poList = this.ppskPageTemplateMaintRepository.findBackupPO(omadacId, siteId);
        ArrayList<PPSKPageTemplateDTO> dtoList = new ArrayList<PPSKPageTemplateDTO>(poList.size());
        for (PPSKPageTemplatePO po : poList) {
            PPSKPageTemplateDTO dto = new PPSKPageTemplateDTO(po);
            if (po.getBackground() != null && po.getBackground().getPicture() != null && po.getBackground().getPicture().getMobilePictureId() != null) {
                dto.setMoblieBackgroundPicTemplate(this.backupPic(omadacId, siteId, po.getBackground().getPicture().getMobilePictureId(), x.b));
            }
            if (po.getBackground() != null && po.getBackground().getPicture() != null && po.getBackground().getPicture().getPcPictureId() != null) {
                dto.setPcBackgroundPicTemplate(this.backupPic(omadacId, siteId, po.getBackground().getPicture().getPcPictureId(), x.b));
            }
            if (po.getLogo() != null && po.getLogo().getPictureId() != null) {
                dto.setLogoPicTemplate(this.backupPic(omadacId, siteId, po.getLogo().getPictureId(), x.b));
            }
            dtoList.add(dto);
        }
        return new PPSKPageBackupDTO().setTemplateDtoList(dtoList);
    }

    private PortalFileBKDTO backupPic(@Nonnull c omadacId, @Nonnull d siteId, @Nullable String picId, x type) {
        if (picId == null) {
            return null;
        }
        if (type == x.a) {
            return Optional.ofNullable(this.ppskPageMaintRepository.findPpskPic(omadacId, siteId, picId)).map(this::fromPortalFilePO).orElse(null);
        }
        return Optional.ofNullable(this.ppskPageTemplateMaintRepository.findPpskPic(omadacId, siteId, picId)).map(this::fromPortalFileTemplatePO).orElse(null);
    }

    @Nullable
    private PortalFileBKDTO fromPortalFilePO(@Nonnull PortalFilePO pagePO) {
        PortalFileBKDTO portalFileBKDTO;
        block8: {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            OutputStream encOs = Base64.getEncoder().wrap(os);
            try {
                this.clientFileRepository.readFile(pagePO.getFileId(), encOs);
                encOs.close();
                portalFileBKDTO = new PortalFileBKDTO().setFileName(pagePO.getFileName()).setFileContent(os.toString(StandardCharsets.UTF_8)).setOverride(pagePO.getOverride()).setTemplateId(pagePO.getTemplateId());
                if (encOs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (encOs != null) {
                        try {
                            encOs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    log.error("Failed to read file to base64 when backing up file: {}", (Object)pagePO, (Object)e2);
                    return null;
                }
            }
            encOs.close();
        }
        return portalFileBKDTO;
    }

    @Nullable
    private PortalFileBKDTO fromPortalFileTemplatePO(@Nonnull PortalFileTemplatePO pagePO) {
        PortalFileBKDTO portalFileBKDTO;
        block8: {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            OutputStream encOs = Base64.getEncoder().wrap(os);
            try {
                this.clientFileRepository.readFile(pagePO.getFileId(), encOs);
                encOs.close();
                portalFileBKDTO = new PortalFileBKDTO().setId(pagePO.getId()).setFileName(pagePO.getFileName()).setFileContent(os.toString(StandardCharsets.UTF_8));
                if (encOs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (encOs != null) {
                        try {
                            encOs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    log.error("Failed to read file to base64 when backing up file: {}", (Object)pagePO, (Object)e2);
                    return null;
                }
            }
            encOs.close();
        }
        return portalFileBKDTO;
    }
}

