/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.portal.v51200;

import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.FreeAuthPolicyBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.MultiPortalBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.PortalAccessControlBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.PortalBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.v51200.PortalRestoreHelperV51200;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.portal.api.internal.b;
import com.tplink.smb.omada.portal.port.mongo.omada.access.PortalAccessControlPO;
import com.tplink.smb.omada.portal.port.mongo.omada.freeauthpolicy.FreeAuthPolicyPO;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.PortalMaintRepository;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.PortalPO;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.f;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V51200, b=d.PORTAL)
public class PortalRestoreUnitV51200
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PortalRestoreUnitV51200.class);
    private static final PortalRestoreUnitV51200 instance = new PortalRestoreUnitV51200();
    private final PortalMaintRepository portalMaintRepository = PortalMaintRepository.getInstance();
    private final f portalTemplateMaintMongoRepository = f.a();
    private final PortalRestoreHelperV51200 portalBackupRestoreHelper = (PortalRestoreHelperV51200)a.b(PortalRestoreHelperV51200.class);
    private final b disconnectRequestInternalService = (b)a.b(b.class);
    private final com.tplink.smb.omada.portal.api.internal.c freeAuthInternalApiService = (com.tplink.smb.omada.portal.api.internal.c)a.b(com.tplink.smb.omada.portal.api.internal.c.class);

    private PortalRestoreUnitV51200() {
    }

    public static PortalRestoreUnitV51200 getInstance() {
        return instance;
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        MultiPortalBKDTO backupDTO = (MultiPortalBKDTO)jsonParserWrapper.a(MultiPortalBKDTO.class);
        this.restorePortals(backupDTO.getPortalSettings(), omadacId, restoreCacheMap);
        HashMap<String, String> freeAuthPolicyIdMap = new HashMap<String, String>();
        this.restoreFreeAuthPolicies(backupDTO.getFreeAuthPolicies(), omadacId, restoreCacheMap, freeAuthPolicyIdMap);
        this.restoreAccessControl(backupDTO.getPortalAccessControl(), omadacId, restoreCacheMap, freeAuthPolicyIdMap);
    }

    private void restoreFreeAuthPolicies(List<FreeAuthPolicyBackupDTO> freeAuthPolicies, c omadacId, Map<String, Object> restoreCacheMap, Map<String, String> freeAuthPolicyIdMap) {
        if (CollectionUtils.isEmpty(freeAuthPolicies)) {
            return;
        }
        Map siteIdMap = restoreCacheMap.getOrDefault(d.Q.A(), Collections.emptyMap());
        for (FreeAuthPolicyBackupDTO freeAuthPolicyDTO : freeAuthPolicies) {
            String currentSiteId = (String)siteIdMap.get(freeAuthPolicyDTO.getSiteId());
            if (currentSiteId == null) {
                log.error("Restoring FreeAuthPolicies: Cannot find mapped siteId by v5 backup freeAuthPolicy {}.", (Object)freeAuthPolicyDTO);
                throw new com.tplink.smb.omada.backup.api.d.c("Cannot find mapped siteId.");
            }
            FreeAuthPolicyPO po = FreeAuthPolicyBackupDTO.toPO(omadacId.a(), currentSiteId, freeAuthPolicyDTO);
            FreeAuthPolicyPO inserted = this.portalMaintRepository.insertFreeAuthPolicy(po);
            freeAuthPolicyIdMap.put(freeAuthPolicyDTO.getId(), inserted.getId());
        }
    }

    private void restoreAccessControl(PortalAccessControlBKDTO accessControlDTO, c omadacId, Map<String, Object> restoreCacheMap, Map<String, String> freeAuthPolicyIdMap) {
        if (accessControlDTO == null) {
            return;
        }
        Map siteIdMap = restoreCacheMap.getOrDefault(d.Q.A(), Collections.emptyMap());
        String currentSiteId = (String)siteIdMap.get(accessControlDTO.getSiteId());
        if (currentSiteId == null) {
            log.error("Restoring Portals: Cannot find mapped siteId by v5 backup portal {}.", (Object)accessControlDTO);
            throw new com.tplink.smb.omada.backup.api.d.c("Cannot find mapped siteId.");
        }
        List newPreAuthAccessPolicyIds = Optional.ofNullable(accessControlDTO.getPreAuthAccessPolicyIds()).map(list -> list.stream().map(freeAuthPolicyIdMap::get).filter(Objects::nonNull).collect(Collectors.toList())).orElse(new ArrayList());
        List newFreeAuthClientPolicyIds = Optional.ofNullable(accessControlDTO.getFreeAuthClientPolicyIds()).map(list -> list.stream().map(freeAuthPolicyIdMap::get).filter(Objects::nonNull).collect(Collectors.toList())).orElse(new ArrayList());
        PortalAccessControlPO po = PortalAccessControlBKDTO.toPO(omadacId.a(), currentSiteId, (List<String>)newPreAuthAccessPolicyIds, (List<String>)newFreeAuthClientPolicyIds, accessControlDTO);
        this.portalMaintRepository.insertAccessControl(po);
    }

    private void restorePortals(List<PortalBKDTO> portalSettings, c omadacId, Map<String, Object> restoreCacheMap) {
        if (CollectionUtils.isEmpty(portalSettings)) {
            return;
        }
        Map siteIdMap = restoreCacheMap.getOrDefault(d.Q.A(), Collections.emptyMap());
        Map portalIdMap = (Map)restoreCacheMap.computeIfAbsent(d.ad.A(), key -> new HashMap());
        for (PortalBKDTO portalDTO : portalSettings) {
            Map radiusProfileIdMap;
            String currentSiteId = (String)siteIdMap.get(portalDTO.getSiteId());
            if (currentSiteId == null) {
                log.error("Restoring Portals: Cannot find mapped siteId by v5 backup portal {}.", (Object)portalDTO.getId());
                throw new com.tplink.smb.omada.backup.api.d.c("Cannot find mapped siteId.");
            }
            PortalPO po = this.portalBackupRestoreHelper.a(omadacId.a(), currentSiteId, portalDTO);
            if (po.getExternalRadius() != null) {
                radiusProfileIdMap = restoreCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", Collections.emptyMap());
                po.getExternalRadius().setRadiusProfileId((String)radiusProfileIdMap.get(po.getExternalRadius().getRadiusProfileId()));
            }
            if (po.getHotspotRadius() != null) {
                radiusProfileIdMap = restoreCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", Collections.emptyMap());
                po.getHotspotRadius().setRadiusProfileId((String)radiusProfileIdMap.get(po.getHotspotRadius().getRadiusProfileId()));
            }
            if (po.getLdap() != null) {
                Map ldapProfileIdMap = restoreCacheMap.getOrDefault("ldapProfileIdOriginToCurrent", Collections.emptyMap());
                po.getLdap().setLdapProfileId((String)ldapProfileIdMap.get(po.getLdap().getLdapProfileId()));
            }
            PortalPO inserted = this.portalMaintRepository.insertPortal(po);
            portalIdMap.put(portalDTO.getId(), inserted.getId());
        }
    }

    public void afterCompatible(c omadacId, Map<String, Object> restoreCacheMap) {
        this.disconnectRequestInternalService.b(omadacId.a(), null);
    }

    public void afterRestore(c omadacId, Map<String, Object> restoreCacheMap) {
        Collection siteIds = restoreCacheMap.getOrDefault(d.Q.A(), Collections.emptyMap()).values();
        this.freeAuthInternalApiService.a(omadacId.a(), siteIds);
    }
}

