/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.portal;

import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.V51520.PortalRestoreHelperV51520;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.FreeAuthPolicyBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.FreeAuthPolicyTemplateBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.MultiPortalBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.PortalAccessControlBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.PortalAccessControlTemplateBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.PortalBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.PortalTemplateBKDTO;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.portal.api.internal.b;
import com.tplink.smb.omada.portal.port.mongo.omada.access.PortalAccessControlPO;
import com.tplink.smb.omada.portal.port.mongo.omada.access.PortalAccessControlTemplatePO;
import com.tplink.smb.omada.portal.port.mongo.omada.freeauthpolicy.FreeAuthPolicyPO;
import com.tplink.smb.omada.portal.port.mongo.omada.freeauthpolicy.FreeAuthPolicyTemplatePO;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.PortalMaintRepository;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.PortalPO;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.PortalTemplatePO;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.f;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.d(a=com.tplink.smb.omada.backup.api.c.d.PORTAL)
public class PortalSiteImportUnit
extends com.tplink.smb.omada.backup.api.c {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PortalSiteImportUnit.class);
    private static final PortalSiteImportUnit instance = new PortalSiteImportUnit();
    private static final String PORTAL_ACCESS_CONTROL_CACHE_NAME = "portal:access.control";
    private static final String KEY_OMADAC_ID = "omadac.id";
    private static final String KEY_SITE_ID = "site.id";
    private final PortalMaintRepository portalMaintRepository = PortalMaintRepository.getInstance();
    private final f portalTemplateMaintMongoRepository = f.a();
    private final PortalRestoreHelperV51520 portalBackupRestoreHelper = (PortalRestoreHelperV51520)a.b(PortalRestoreHelperV51520.class);
    private final b disconnectRequestInternalService = (b)a.b(b.class);
    private final CacheService cacheService = (CacheService)a.b(CacheService.class);

    private PortalSiteImportUnit() {
    }

    public static PortalSiteImportUnit getInstance() {
        return instance;
    }

    public void siteImport(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        MultiPortalBKDTO portalBKDTO = (MultiPortalBKDTO)jsonParserWrapper.a(MultiPortalBKDTO.class);
        this.siteCopyWrite(portalBKDTO, omadacId, newSiteId, siteImportIdCacheMap);
    }

    public void siteCopyWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        MultiPortalBKDTO backupDTO = (MultiPortalBKDTO)dataObject;
        this.restorePortals(backupDTO.getPortalSettings(), omadacId, newSiteId, siteImportIdCacheMap);
        HashMap<String, String> freeAuthPolicyIdMap = new HashMap<String, String>();
        this.restoreFreeAuthPolicies(backupDTO.getFreeAuthPolicies(), omadacId, newSiteId, freeAuthPolicyIdMap);
        this.restoreAccessControl(backupDTO.getPortalAccessControl(), omadacId, newSiteId, freeAuthPolicyIdMap);
        this.disconnectRequestInternalService.b(omadacId.a(), newSiteId.a());
    }

    public void siteTemplateCopyWrite(Object dataObject, c omadacId, d newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        MultiPortalBKDTO backupDTO = (MultiPortalBKDTO)dataObject;
        this.restorePortalTemplateToTemplate(backupDTO.getPortalSettingsTemplate(), omadacId, newSiteTemplateId, siteImportIdCacheMap);
        HashMap<String, String> freeAuthPolicyIdMap = new HashMap<String, String>();
        this.restoreFreeAuthPoliciesTemplateToTemplate(backupDTO.getFreeAuthPoliciesTemplate(), omadacId, newSiteTemplateId, freeAuthPolicyIdMap);
        this.restoreAccessControlTemplateToTemplate(backupDTO.getPortalAccessControlTemplate(), omadacId, newSiteTemplateId, freeAuthPolicyIdMap);
        this.disconnectRequestInternalService.b(omadacId.a(), newSiteTemplateId.a());
    }

    private void restoreFreeAuthPoliciesTemplateToTemplate(List<FreeAuthPolicyTemplateBackupDTO> freeAuthPolicies, c omadacId, d siteTemplateId, Map<String, String> freeAuthPolicyIdMap) {
        if (CollectionUtils.isEmpty(freeAuthPolicies)) {
            return;
        }
        for (FreeAuthPolicyTemplateBackupDTO freeAuthPolicyDTO : freeAuthPolicies) {
            FreeAuthPolicyTemplatePO po = FreeAuthPolicyBackupDTO.toTemplatePO(omadacId.a(), siteTemplateId.a(), freeAuthPolicyDTO);
            po.setId(null);
            FreeAuthPolicyTemplatePO inserted = this.portalTemplateMaintMongoRepository.a(po);
            freeAuthPolicyIdMap.put(freeAuthPolicyDTO.getId(), inserted.getId());
        }
    }

    private void restoreFreeAuthPolicies(List<FreeAuthPolicyBackupDTO> freeAuthPolicies, c omadacId, d newSiteId, Map<String, String> freeAuthPolicyIdMap) {
        if (CollectionUtils.isEmpty(freeAuthPolicies)) {
            return;
        }
        for (FreeAuthPolicyBackupDTO freeAuthPolicyDTO : freeAuthPolicies) {
            FreeAuthPolicyPO po = FreeAuthPolicyBackupDTO.toPO(omadacId.a(), newSiteId.a(), freeAuthPolicyDTO);
            po.setOverride(null);
            po.setTemplateId(null);
            FreeAuthPolicyPO inserted = this.portalMaintRepository.insertFreeAuthPolicy(po);
            freeAuthPolicyIdMap.put(freeAuthPolicyDTO.getId(), inserted.getId());
        }
    }

    private void restoreAccessControl(PortalAccessControlBKDTO accessControlDTO, c omadacId, d newSiteId, Map<String, String> freeAuthPolicyIdMap) {
        if (accessControlDTO == null) {
            return;
        }
        List newPreAuthAccessPolicyIds = Optional.ofNullable(accessControlDTO.getPreAuthAccessPolicyIds()).map(list -> list.stream().map(freeAuthPolicyIdMap::get).filter(Objects::nonNull).collect(Collectors.toList())).orElse(new ArrayList());
        List newFreeAuthClientPolicyIds = Optional.ofNullable(accessControlDTO.getFreeAuthClientPolicyIds()).map(list -> list.stream().map(freeAuthPolicyIdMap::get).filter(Objects::nonNull).collect(Collectors.toList())).orElse(new ArrayList());
        PortalAccessControlPO po = PortalAccessControlBKDTO.toPO(omadacId.a(), newSiteId.a(), (List<String>)newPreAuthAccessPolicyIds, (List<String>)newFreeAuthClientPolicyIds, accessControlDTO);
        po.setOverride(null);
        po.setTemplateId(null);
        Optional optCurrentAccessControl = this.portalMaintRepository.findAccessControl(omadacId, newSiteId);
        if (optCurrentAccessControl.isPresent()) {
            po.setId(((PortalAccessControlPO)optCurrentAccessControl.get()).getId());
            this.portalMaintRepository.saveAccessControl(po);
        } else {
            this.portalMaintRepository.insertAccessControl(po);
        }
    }

    private void restoreAccessControlTemplateToTemplate(PortalAccessControlTemplateBKDTO accessControlDTO, c omadacId, d siteTemplateId, Map<String, String> freeAuthPolicyIdMap) {
        if (accessControlDTO == null) {
            return;
        }
        List newPreAuthAccessPolicyIds = Optional.ofNullable(accessControlDTO.getPreAuthAccessPolicyIds()).map(list -> list.stream().map(freeAuthPolicyIdMap::get).filter(Objects::nonNull).collect(Collectors.toList())).orElse(new ArrayList());
        List newFreeAuthClientPolicyIds = Optional.ofNullable(accessControlDTO.getFreeAuthClientPolicyIds()).map(list -> list.stream().map(freeAuthPolicyIdMap::get).filter(Objects::nonNull).collect(Collectors.toList())).orElse(new ArrayList());
        PortalAccessControlTemplatePO po = PortalAccessControlBKDTO.toTemplatePO(omadacId.a(), siteTemplateId.a(), newPreAuthAccessPolicyIds, newFreeAuthClientPolicyIds, accessControlDTO);
        po.setId(null);
        Optional optCurrentAccessControl = this.portalTemplateMaintMongoRepository.b(omadacId, siteTemplateId);
        if (optCurrentAccessControl.isPresent()) {
            po.setId(((PortalAccessControlTemplatePO)optCurrentAccessControl.get()).getId());
            this.portalTemplateMaintMongoRepository.b(po);
        } else {
            this.portalTemplateMaintMongoRepository.a(po);
        }
        this.cacheService.deleteKey(PORTAL_ACCESS_CONTROL_CACHE_NAME, this.buildCacheKey(omadacId, siteTemplateId));
    }

    private void restorePortals(List<PortalBKDTO> portalSettings, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) {
        if (CollectionUtils.isEmpty(portalSettings)) {
            return;
        }
        Map portalIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.ad.A(), key -> new HashMap());
        for (PortalBKDTO portalDTO : portalSettings) {
            Map radiusProfileIdMap;
            PortalPO po = this.portalBackupRestoreHelper.a(omadacId.a(), newSiteId.a(), portalDTO);
            if (po.getExternalRadius() != null) {
                radiusProfileIdMap = siteImportIdCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", Collections.emptyMap());
                po.getExternalRadius().setRadiusProfileId((String)radiusProfileIdMap.get(po.getExternalRadius().getRadiusProfileId()));
            }
            if (po.getHotspotRadius() != null) {
                radiusProfileIdMap = siteImportIdCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", Collections.emptyMap());
                po.getHotspotRadius().setRadiusProfileId((String)radiusProfileIdMap.get(po.getHotspotRadius().getRadiusProfileId()));
            }
            if (po.getLdap() != null) {
                Map ldapProfileIdMap = siteImportIdCacheMap.getOrDefault("ldapProfileIdOriginToCurrent", Collections.emptyMap());
                po.getLdap().setLdapProfileId((String)ldapProfileIdMap.get(po.getLdap().getLdapProfileId()));
            }
            po.setTemplateId(null);
            po.setOverride(null);
            PortalPO inserted = this.portalMaintRepository.insertPortal(po);
            portalIdMap.put(portalDTO.getId(), inserted.getId());
        }
    }

    private void restorePortalTemplateToTemplate(List<PortalTemplateBKDTO> portalSettings, c omadacId, d newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) {
        if (CollectionUtils.isEmpty(portalSettings)) {
            return;
        }
        Map portalIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.ad.A(), key -> new HashMap());
        Map portalFileTemplateIdMap = siteImportIdCacheMap.computeIfAbsent("portalFileTemplateIdMap", k2 -> new HashMap());
        for (PortalTemplateBKDTO portalDTO : portalSettings) {
            Map radiusProfileIdMap;
            PortalTemplatePO po = this.portalBackupRestoreHelper.a(omadacId.a(), newSiteTemplateId.a(), portalDTO, (Map<String, String>)portalFileTemplateIdMap);
            if (po.getExternalRadius() != null) {
                radiusProfileIdMap = siteImportIdCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", Collections.emptyMap());
                po.getExternalRadius().setRadiusProfileId((String)radiusProfileIdMap.get(po.getExternalRadius().getRadiusProfileId()));
            }
            if (po.getHotspotRadius() != null) {
                radiusProfileIdMap = siteImportIdCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", Collections.emptyMap());
                po.getHotspotRadius().setRadiusProfileId((String)radiusProfileIdMap.get(po.getHotspotRadius().getRadiusProfileId()));
            }
            if (po.getLdap() != null) {
                Map ldapProfileIdMap = siteImportIdCacheMap.getOrDefault("ldapProfileIdOriginToCurrent", Collections.emptyMap());
                po.getLdap().setLdapProfileId((String)ldapProfileIdMap.get(po.getLdap().getLdapProfileId()));
            }
            po.setId(null);
            PortalTemplatePO inserted = this.portalTemplateMaintMongoRepository.a(po);
            portalIdMap.put(portalDTO.getId(), inserted.getId());
        }
    }

    private String buildCacheKey(c omadacId, d siteId) {
        return "omadac.id:" + omadacId.a() + ":site.id" + siteId.a();
    }
}

