/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.portal;

import com.tplink.smb.omada.backup.api.c.h;
import com.tplink.smb.omada.backup.core.d.i;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.a;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.FreeAuthPolicyBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.FreeAuthPolicyTemplateBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.MultiPortalBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.PortalAccessControlBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.PortalAccessControlTemplateBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.PortalBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.PortalTemplateBKDTO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.portal.port.mongo.omada.access.PortalAccessControlPO;
import com.tplink.smb.omada.portal.port.mongo.omada.access.PortalAccessControlTemplatePO;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.PortalMaintRepository;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.PortalPO;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.PortalTemplatePO;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.f;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.backup.api.a.a(a=com.tplink.smb.omada.backup.api.c.d.PORTAL)
public class PortalBackupUnit
extends com.tplink.smb.omada.backup.api.b.d<MultiPortalBKDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PortalBackupUnit.class);
    private static final PortalBackupUnit instance = new PortalBackupUnit();
    private final PortalMaintRepository portalMaintRepository = PortalMaintRepository.getInstance();
    private final f portalTemplateMaintMongoRepository = f.a();
    private final a portalBackupHelper = (a)com.tplink.smb.omada.common.spring.a.b(a.class);

    private PortalBackupUnit() {
    }

    public static PortalBackupUnit getInstance() {
        return instance;
    }

    public MultiPortalBKDTO readFromDB(c omadacId, d siteId, boolean siteTemplateRead) throws IOException, com.tplink.smb.omada.backup.api.d.a {
        MultiPortalBKDTO backupDTO = new MultiPortalBKDTO();
        if (siteTemplateRead) {
            backupDTO.setPortalSettingsTemplate(this.backupPortalTemplates(omadacId, siteId));
            backupDTO.setPortalAccessControlTemplate(this.backupAccessControlTemplate(omadacId, siteId));
            backupDTO.setFreeAuthPoliciesTemplate(this.portalTemplateMaintMongoRepository.c(omadacId, siteId).stream().map(FreeAuthPolicyTemplateBackupDTO::fromPO).collect(Collectors.toList()));
        } else {
            backupDTO.setPortalSettings(this.backupPortals(omadacId, siteId));
            backupDTO.setPortalAccessControl(this.backupAccessControl(omadacId, siteId));
            backupDTO.setFreeAuthPolicies(this.portalMaintRepository.findFreeAuthPolicies(omadacId, siteId).stream().map(FreeAuthPolicyBackupDTO::fromPO).collect(Collectors.toList()));
        }
        return backupDTO;
    }

    @Nullable
    private PortalAccessControlBKDTO backupAccessControl(c omadacId, d siteId) {
        PortalAccessControlPO po = this.portalMaintRepository.findAccessControl(omadacId, siteId).orElse(null);
        if (po == null) {
            log.error("Failed to find PortalAccessControl of Omadac: {}, Site: {}", (Object)omadacId, (Object)siteId);
            return null;
        }
        return PortalAccessControlBKDTO.fromPO(po);
    }

    @Nullable
    private PortalAccessControlTemplateBKDTO backupAccessControlTemplate(c omadacId, d siteId) {
        PortalAccessControlTemplatePO po = this.portalTemplateMaintMongoRepository.b(omadacId, siteId).orElse(null);
        if (po == null) {
            log.error("Failed to find PortalAccessControlTemplate of Omadac: {}, Site: {}", (Object)omadacId, (Object)siteId);
            return null;
        }
        return PortalAccessControlTemplateBKDTO.fromPO(po);
    }

    private List<PortalBKDTO> backupPortals(c omadacId, d siteId) {
        List portals = this.portalMaintRepository.findPortals(omadacId, siteId);
        ArrayList<PortalBKDTO> backups = new ArrayList<PortalBKDTO>(portals.size());
        boolean ignorePics = false;
        for (PortalPO po : portals) {
            PortalBKDTO backup = this.portalBackupHelper.a(po, ignorePics);
            backups.add(backup);
        }
        return backups;
    }

    private List<PortalTemplateBKDTO> backupPortalTemplates(c omadacId, d siteId) {
        List portals = this.portalTemplateMaintMongoRepository.a(omadacId, siteId);
        ArrayList<PortalTemplateBKDTO> backups = new ArrayList<PortalTemplateBKDTO>(portals.size());
        boolean ignorePics = false;
        for (PortalTemplatePO po : portals) {
            PortalTemplateBKDTO backup = this.portalBackupHelper.a(po, ignorePics);
            backups.add(backup);
        }
        return backups;
    }

    public void backup(com.tplink.smb.omada.backup.api.e.a wrapper, c omadacId, d siteId, com.tplink.smb.omada.backup.api.c.d keyEnum, h backupTypeEnum) throws IOException, com.tplink.smb.omada.backup.api.d.a {
        MultiPortalBKDTO element = this.readFromDB(omadacId, siteId, false);
        if (element != null) {
            if (h.e.equals((Object)backupTypeEnum)) {
                wrapper.b().writeFieldName(keyEnum.A());
                wrapper.c();
                wrapper.a("portalSettings");
                if (element.getPortalSettings() != null) {
                    element.getPortalSettings().forEach(portalBKDTO -> {
                        if (portalBKDTO.getSms() != null) {
                            portalBKDTO.getSms().setSid(null);
                            portalBKDTO.getSms().setAuthToken(null);
                            portalBKDTO.getSms().setPhoneNum(null);
                        }
                        portalBKDTO.setSimplePassword(null);
                        portalBKDTO.setLandingUrl(i.a(portalBKDTO.getLandingUrl()));
                        if (portalBKDTO.getExternalRadius() != null) {
                            portalBKDTO.getExternalRadius().setExternalUrl(null);
                        }
                        portalBKDTO.setFacebook(null);
                        if (portalBKDTO.getGoogle() != null) {
                            portalBKDTO.getGoogle().setClientId(null);
                            portalBKDTO.getGoogle().setClientSecret(null);
                        }
                        try {
                            wrapper.b().writeObject(portalBKDTO);
                        }
                        catch (IOException e2) {
                            log.warn("Backup portal support error, skip", (Throwable)e2);
                        }
                    });
                }
                wrapper.f();
                wrapper.d();
                wrapper.a("portalAccessControl", (Object)element.getPortalAccessControl());
                wrapper.a("freeAuthPolicies", element.getFreeAuthPolicies());
            } else {
                wrapper.a(keyEnum.A(), (Object)element);
            }
        }
    }
}

