/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.osw.siteimport;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.omada.backup.api.c.n;
import com.tplink.smb.omada.backup.core.unit.siteconfig.DeviceRestoreInfoMapsDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.osw.dto.OswBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.osw.dto.OswBatchSaveDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.osw.dto.OswDeviceListBKDTO;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.constant.r;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.omadac.config.a.b;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lannetwork.BaseLanNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lannetwork.LanNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lanprofile.LanProfilePO;
import com.tplink.smb.omada.manager.port.mongo.device.DeviceMaintRepository;
import com.tplink.smb.omada.manager.port.mongo.device.DevicePO;
import com.tplink.smb.omada.manager.port.mongo.device.LocationPO;
import com.tplink.smb.omada.manager.port.mongo.device.cliconfig.CliSettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.cliconfig.DecodeCliPO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.c;
import com.tplink.smb.omada.manager.port.mongo.device.osw.AbstractOswPortSettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.BaseOswNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswIpSettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswIpv6SettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswNetworkTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswQosConfigPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.e;
import com.tplink.smb.omada.manager.port.mongo.device.osw.j;
import com.tplink.smb.omada.manager.port.mongo.device.osw.lag.OswLagPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.lag.OswLagTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.loopbackinterface.OswLoopbackInterfacePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.port.OswPortPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.port.OswPortTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.q;
import com.tplink.smb.omada.manager.port.mongo.device.osw.staticroute.OswStaticRoutingPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.staticroute.OswStaticRoutingTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.t;
import com.tplink.smb.omada.manager.port.mongo.device.osw.x;
import com.tplink.smb.omada.portal.port.mongo.omada.a.a;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.IterableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.d(a=com.tplink.smb.omada.backup.api.c.d.SWITCH)
public class OswSiteImportUnit
extends com.tplink.smb.omada.backup.api.c {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OswSiteImportUnit.class);
    private final e oswMaintMongoRepository = e.a();
    private final q oswPortMaintMongoRepository = q.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.osw.a oswLagMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.osw.a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c lanNetworkMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c.a();
    private final j oswNetworkMaintMongoRepository = j.a();
    private final t oswStaticRoutingMaintMongoRepository = t.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.osw.c oswLoopbackInterfaceMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.osw.c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.e lanProfileMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.e.a();
    private final a getSequenceNumService = (a)com.tplink.smb.omada.common.spring.a.b(a.class);
    private final com.tplink.smb.omada.manager.port.mongo.device.olt.b oltMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.olt.b.a();
    private final DeviceMaintRepository deviceMaintRepository = DeviceMaintRepository.getInstance();
    private final c osgMaintMongoRepository = c.a();
    private final x oswVrfMaintMongoRepository = x.a();
    private static final OswSiteImportUnit instance = new OswSiteImportUnit();

    private OswSiteImportUnit() {
    }

    public static OswSiteImportUnit getInstance() {
        return instance;
    }

    public void siteImport(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        JsonParser jsonParser = jsonParserWrapper.h();
        jsonParser.nextToken();
        Set macsToForget = restoreCacheMap.getOrDefault(com.tplink.smb.omada.backup.api.c.d.D.A(), new HashSet());
        DeviceRestoreInfoMapsDTO deviceRestoreInfoMapsDTO = (DeviceRestoreInfoMapsDTO)restoreCacheMap.computeIfAbsent("deviceOmadacRefer", key -> new DeviceRestoreInfoMapsDTO(new HashMap<String, String>(32)));
        Map cliConfigMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.aD.A(), key -> new HashMap());
        Map oswProfileMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.ah.A(), k2 -> new HashMap());
        Map portTagIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.av.A(), k2 -> new HashMap());
        Map vrfIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Z.A(), key -> new HashMap());
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            Map<String, String> mapMap;
            OswPO oswPOInDb;
            OswBackupDTO dto = (OswBackupDTO)jsonParserWrapper.a(OswBackupDTO.class);
            OswPO oswPO = dto.getOsw();
            if (oswPO == null) continue;
            if (OmadacType.y()) {
                if (this.deviceMaintRepository.countDeviceNumber(omadacId.a()) + 4L * this.oltMaintMongoRepository.c(omadacId.a(), DeviceTypeEnum.d.b()) - this.osgMaintMongoRepository.d(omadacId) >= (long)b.s()) {
                    macsToForget.add(oswPO.getMac());
                }
            } else if (!OmadacType.s() && this.oswMaintMongoRepository.c(omadacId.a(), DeviceTypeEnum.c.b()) >= (long)b.u()) {
                macsToForget.add(oswPO.getMac());
            }
            if ((oswPOInDb = this.oswMaintMongoRepository.d(omadacId.a(), oswPO.getMac())) != null) continue;
            Map<String, String> lanNetworkMaps = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.af.A());
            this.handleMvlanNetwork(oswPO, omadacId, lanNetworkMaps);
            Map<Integer, String> lagIdMap = this.handleOswLags(dto.getOswLagPOS(), omadacId, newSiteId, lanNetworkMaps, portTagIdMap);
            this.handleOswPorts(dto.getOswPortPOS(), omadacId, newSiteId, lanNetworkMaps, portTagIdMap, lagIdMap);
            LocationPO location = oswPO.getLocation();
            if (location != null && !CollectionUtils.isEmpty(mapMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.aI.A()))) {
                String mapIdNew = mapMap.get(location.getMapId());
                location.setMapId(mapIdNew);
            }
            oswPO.setSiteId(newSiteId.a());
            oswPO.setId(null);
            oswPO.setTemplateId(null);
            oswPO.setOverride(null);
            oswPO.setOmadacId(omadacId.a());
            this.handleDeviceCli(oswPO.getCliSetting(), cliConfigMap);
            this.handleOswSwitchQos(oswPO.getQosConfig(), oswProfileMap);
            this.oswMaintMongoRepository.a(oswPO);
            this.handleOswVlanIf(dto, omadacId, newSiteId, lanNetworkMaps, vrfIdMap);
            this.handleOswStaticRouting(dto, omadacId, newSiteId, vrfIdMap);
            this.handleOswLoopbackInterface(dto, omadacId, newSiteId);
            deviceRestoreInfoMapsDTO.getDeviceControllerIdOmadacMapper().put(oswPO.getMac(), oswPO.getControllerId());
        }
    }

    public void siteTemplateCopyWrite(Object dataObject, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        OswDeviceListBKDTO oswDeviceListBKDTO = (OswDeviceListBKDTO)dataObject;
        if (Objects.isNull(oswDeviceListBKDTO) || CollectionUtils.isEmpty(oswDeviceListBKDTO.getOswBackupDTOList())) {
            log.debug("The Osw in the siteTemplateCopyWrite are empty and do not need to be replicated");
            return;
        }
        Map oswDeviceTemplateIdMap = siteImportIdCacheMap.computeIfAbsent("deviceTemplateIdMap", k2 -> new HashMap());
        Map vrfIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Z.A(), key -> new HashMap());
        for (OswBackupDTO oswBackupDTO : oswDeviceListBKDTO.getOswBackupDTOList()) {
            Map lanNetworkMaps = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), v2 -> new HashMap(2));
            Map cliConfigMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.aD.A(), key -> new HashMap());
            Map portTagIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.av.A(), k2 -> new HashMap());
            this.copyOswTemplatePO(omadacId, newSiteTemplateId, oswBackupDTO, lanNetworkMaps, oswDeviceTemplateIdMap, cliConfigMap);
            HashMap<Integer, String> lagTemplateIdMap = new HashMap<Integer, String>(12);
            this.copyOswLagsTemplatePO(omadacId, newSiteTemplateId, oswBackupDTO, lanNetworkMaps, portTagIdMap, oswDeviceTemplateIdMap, lagTemplateIdMap);
            this.copyOswPortsTemplatePO(omadacId, newSiteTemplateId, oswBackupDTO, lanNetworkMaps, portTagIdMap, oswDeviceTemplateIdMap, lagTemplateIdMap);
            this.copyOswNetworksTemplatePO(omadacId, newSiteTemplateId, oswBackupDTO, lanNetworkMaps, oswDeviceTemplateIdMap, vrfIdMap);
            this.copyStaticRoutingsTemplatePO(omadacId, newSiteTemplateId, oswBackupDTO, oswDeviceTemplateIdMap, vrfIdMap);
        }
        siteImportIdCacheMap.put("deviceTemplateIdMap", oswDeviceTemplateIdMap);
    }

    private void handleOswWithOldTemplate(OswPO oswPO, OswBackupDTO oswBackupDTO, OswBatchSaveDTO oswBatchSaveDTO, Map<String, String> lanNetworkIdMap) {
        HashMap portTemplateMap = new HashMap();
        HashMap lagTemplateMap = new HashMap();
        HashMap staticRoutingTemplateMap = new HashMap();
        HashMap networkTemplateMap = new HashMap();
        oswBackupDTO.getOswPortTemplatePOS().forEach(oswPortTemplatePO -> portTemplateMap.put(oswPortTemplatePO.getId(), oswPortTemplatePO));
        oswBackupDTO.getOswLagTemplatePOS().forEach(oswLagTemplatePO -> lagTemplateMap.put(oswLagTemplatePO.getId(), oswLagTemplatePO));
        oswBackupDTO.getStaticRoutingTemplates().forEach(oswStaticRoutingTemplatePO -> staticRoutingTemplateMap.put(oswStaticRoutingTemplatePO.getId(), oswStaticRoutingTemplatePO));
        oswBackupDTO.getVlanIfTemplates().forEach(oswNetworkTemplatePO -> networkTemplateMap.put(oswNetworkTemplatePO.getId(), oswNetworkTemplatePO));
        HashMap<Integer, String> newLagMap = new HashMap<Integer, String>();
        OswTemplatePO oswTemplate = oswBackupDTO.getOswTemplate();
        oswPO.setMvlanNetworkId(lanNetworkIdMap.getOrDefault(oswTemplate.getMvlanNetworkId(), oswTemplate.getMvlanNetworkId()));
        oswPO.setOverride(Boolean.valueOf(false));
        oswPO.setTemplateId(oswTemplate.getId());
        oswBatchSaveDTO.getBatchSaveOsw().add(oswPO);
        List<OswLagTemplatePO> oswLagTemplatePOS = oswBackupDTO.getOswLagTemplatePOS();
        List<OswPortTemplatePO> oswPortTemplatePOS = oswBackupDTO.getOswPortTemplatePOS();
        List<OswNetworkTemplatePO> vlanIfTemplates = oswBackupDTO.getVlanIfTemplates();
        List<OswStaticRoutingTemplatePO> staticRoutingTemplates = oswBackupDTO.getStaticRoutingTemplates();
        if (log.isDebugEnabled()) {
            log.debug("sync copy vlanIfTemplates {}, omadacId {}, siteId{}, mac {}", new Object[]{com.tplink.smb.omada.common.util.x.a(vlanIfTemplates), oswPO.getOmadacId(), oswPO.getSiteId(), oswPO.getMac()});
        }
        this.handleOswLagsWithTemplate(oswLagTemplatePOS, oswPO, lanNetworkIdMap, newLagMap, oswBatchSaveDTO.getBatchSaveOswLagPO());
        this.handleOswPortsWithTemplate(oswPortTemplatePOS, oswPO, lanNetworkIdMap, newLagMap, oswBatchSaveDTO.getBatchSaveOswPortPO());
        this.handleVlanIfsWithTemplate(vlanIfTemplates, oswPO, lanNetworkIdMap, oswBatchSaveDTO.getBatchSaveOswNetworkPO());
        if (log.isDebugEnabled()) {
            log.debug("sync copy handleVlanIfsWithTemplate {}, omadacId {}, siteId{}, mac {}", new Object[]{com.tplink.smb.omada.common.util.x.a(oswBatchSaveDTO.getBatchSaveOswNetworkPO()), oswPO.getOmadacId(), oswPO.getSiteId(), oswPO.getMac()});
        }
        this.handleStaticRoutingsWithTemplate(staticRoutingTemplates, oswPO, oswBatchSaveDTO.getBatchSaveStaticRoutingPO());
    }

    private void copyStaticRoutingsTemplatePO(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteTemplateId, OswBackupDTO oswBackupDTO, Map<String, String> oswDeviceTemplateIdMap, Map<String, String> vrfIdMap) {
        List<OswStaticRoutingTemplatePO> oswStaticRoutingTemplateList = oswBackupDTO.getStaticRoutingTemplates();
        if (!CollectionUtils.isEmpty(oswStaticRoutingTemplateList)) {
            ArrayList<OswStaticRoutingTemplatePO> oswPortsRealList = new ArrayList<OswStaticRoutingTemplatePO>();
            for (OswStaticRoutingTemplatePO oswStaticRoutingTemplatePO : oswStaticRoutingTemplateList) {
                oswStaticRoutingTemplatePO.setId(null);
                oswStaticRoutingTemplatePO.setSiteTemplateId(newSiteTemplateId.a());
                oswStaticRoutingTemplatePO.setDeviceTemplateId(oswDeviceTemplateIdMap.getOrDefault(oswStaticRoutingTemplatePO.getDeviceTemplateId(), oswStaticRoutingTemplatePO.getDeviceTemplateId()));
                oswStaticRoutingTemplatePO.setMac(oswDeviceTemplateIdMap.getOrDefault(oswStaticRoutingTemplatePO.getDeviceTemplateId(), oswStaticRoutingTemplatePO.getDeviceTemplateId()));
                oswStaticRoutingTemplatePO.setEntryId(Integer.valueOf(this.getSequenceNumService.a(omadacId.a(), newSiteTemplateId.a(), OswStaticRoutingTemplatePO.class)));
                oswStaticRoutingTemplatePO.setOmadacId(omadacId.a());
                oswStaticRoutingTemplatePO.setVrfId(vrfIdMap.get(oswStaticRoutingTemplatePO.getVrfId()));
                oswStaticRoutingTemplatePO.setNextHopVrfId(vrfIdMap.get(oswStaticRoutingTemplatePO.getNextHopVrfId()));
                oswPortsRealList.add(oswStaticRoutingTemplatePO);
            }
            this.oswStaticRoutingMaintMongoRepository.a(new ArrayList(oswPortsRealList), n.b);
        }
    }

    private void copyOswNetworksTemplatePO(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteTemplateId, OswBackupDTO oswBackupDTO, Map<String, String> lanNetworkMaps, Map<String, String> oswDeviceTemplateIdMap, Map<String, String> vrfIdMap) {
        List<OswNetworkTemplatePO> vlanIfTemplates = oswBackupDTO.getVlanIfTemplates();
        if (!CollectionUtils.isEmpty(vlanIfTemplates)) {
            HashSet<String> vrfIds = new HashSet<String>();
            ArrayList<OswNetworkTemplatePO> vlanIfs = new ArrayList<OswNetworkTemplatePO>();
            for (OswNetworkTemplatePO oswNetworkTemplatePO : vlanIfTemplates) {
                oswNetworkTemplatePO.setId(null);
                oswNetworkTemplatePO.setDeviceTemplateId(oswDeviceTemplateIdMap.getOrDefault(oswNetworkTemplatePO.getDeviceTemplateId(), oswNetworkTemplatePO.getDeviceTemplateId()));
                oswNetworkTemplatePO.setSiteTemplateId(newSiteTemplateId.a());
                oswNetworkTemplatePO.setLanNetworkId(lanNetworkMaps.getOrDefault(oswNetworkTemplatePO.getLanNetworkId(), oswNetworkTemplatePO.getLanNetworkId()));
                oswNetworkTemplatePO.setOmadacId(omadacId.a());
                oswNetworkTemplatePO.setVrfId(vrfIdMap.get(oswNetworkTemplatePO.getVrfId()));
                vrfIds.add(oswNetworkTemplatePO.getVrfId());
                if (oswNetworkTemplatePO.getDhcpServer() != null) {
                    oswNetworkTemplatePO.getDhcpServer().setVrfId(vrfIdMap.get(oswNetworkTemplatePO.getDhcpServer().getVrfId()));
                    vrfIds.add(oswNetworkTemplatePO.getDhcpServer().getVrfId());
                }
                if (oswNetworkTemplatePO.getDhcpRelay() != null) {
                    oswNetworkTemplatePO.getDhcpRelay().setVrfId(vrfIdMap.get(oswNetworkTemplatePO.getDhcpRelay().getVrfId()));
                    vrfIds.add(oswNetworkTemplatePO.getDhcpServer().getVrfId());
                }
                vlanIfs.add(oswNetworkTemplatePO);
            }
            Map vrfMap = this.oswVrfMaintMongoRepository.a(omadacId, newSiteTemplateId.a(), vrfIds, n.b);
            vlanIfs.forEach(vlanIf -> {
                vlanIf.setVrf((String)vrfMap.get(vlanIf.getVrfId()));
                if (vlanIf.getDhcpServer() != null && vlanIf.getDhcpServer().getVrfId() != null) {
                    vlanIf.getDhcpServer().setVrf((String)vrfMap.get(vlanIf.getDhcpServer().getVrfId()));
                }
                if (vlanIf.getDhcpRelay() != null && vlanIf.getDhcpRelay().getVrfId() != null) {
                    vlanIf.getDhcpRelay().setVrf((String)vrfMap.get(vlanIf.getDhcpRelay().getVrfId()));
                }
            });
            this.oswNetworkMaintMongoRepository.a(new ArrayList(vlanIfs), n.b);
        }
    }

    private void copyOswPortsTemplatePO(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteTemplateId, OswBackupDTO oswBackupDTO, Map<String, String> lanNetworkMaps, Map<String, String> portTagIdMap, Map<String, String> oswDeviceTemplateIdMap, Map<Integer, String> lagTemplateIdMap) {
        List<OswPortTemplatePO> oswPortTemplatePOS = oswBackupDTO.getOswPortTemplatePOS();
        if (!CollectionUtils.isEmpty(oswPortTemplatePOS)) {
            ArrayList<OswPortTemplatePO> oswPortsRealList = new ArrayList<OswPortTemplatePO>();
            for (OswPortTemplatePO oswPortPO : oswPortTemplatePOS) {
                oswPortPO.setId(null);
                oswPortPO.setSiteTemplateId(newSiteTemplateId.a());
                oswPortPO.setSiteId(newSiteTemplateId.a());
                oswPortPO.setDeviceTemplateId(oswDeviceTemplateIdMap.getOrDefault(oswPortPO.getDeviceTemplateId(), oswPortPO.getDeviceTemplateId()));
                oswPortPO.setOswMac(oswDeviceTemplateIdMap.getOrDefault(oswPortPO.getDeviceTemplateId(), oswPortPO.getDeviceTemplateId()));
                oswPortPO.setLanProfileId(lanNetworkMaps.get(oswPortPO.getLanProfileId()));
                com.tplink.smb.omada.backup.core.d.a.a((AbstractOswPortSettingPO)oswPortPO, portTagIdMap);
                com.tplink.smb.omada.backup.core.d.a.b((AbstractOswPortSettingPO)oswPortPO, lanNetworkMaps);
                oswPortPO.setLagId(lagTemplateIdMap.get(oswPortPO.getLag()));
                oswPortPO.setOmadacId(omadacId.a());
                oswPortsRealList.add(oswPortPO);
            }
            this.oswPortMaintMongoRepository.a(new ArrayList(oswPortsRealList), n.b);
        }
    }

    private void copyOswLagsTemplatePO(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteTemplateId, OswBackupDTO oswBackupDTO, Map<String, String> lanNetworkMaps, Map<String, String> portTagIdMap, Map<String, String> oswDeviceTemplateIdMap, Map<Integer, String> lagTemplateIdMap) {
        List<OswLagTemplatePO> oswLagTemplatePOS = oswBackupDTO.getOswLagTemplatePOS();
        if (!CollectionUtils.isEmpty(oswLagTemplatePOS)) {
            ArrayList<OswLagTemplatePO> oswLagRealList = new ArrayList<OswLagTemplatePO>();
            for (OswLagTemplatePO oswLagPO2 : oswLagTemplatePOS) {
                oswLagPO2.setId(null);
                oswLagPO2.setSiteId(newSiteTemplateId.a());
                oswLagPO2.setSiteTemplateId(newSiteTemplateId.a());
                oswLagPO2.setDeviceTemplateId(oswDeviceTemplateIdMap.getOrDefault(oswLagPO2.getDeviceTemplateId(), oswLagPO2.getDeviceTemplateId()));
                oswLagPO2.setOswMac(oswDeviceTemplateIdMap.getOrDefault(oswLagPO2.getDeviceTemplateId(), oswLagPO2.getDeviceTemplateId()));
                oswLagPO2.setLanProfileId(lanNetworkMaps.get(oswLagPO2.getLanProfileId()));
                com.tplink.smb.omada.backup.core.d.a.a((AbstractOswPortSettingPO)oswLagPO2, portTagIdMap);
                com.tplink.smb.omada.backup.core.d.a.b((AbstractOswPortSettingPO)oswLagPO2, lanNetworkMaps);
                oswLagPO2.setOmadacId(omadacId.a());
                oswLagRealList.add(oswLagPO2);
            }
            List oswLagPOS = IterableUtils.toList((Iterable)this.oswLagMaintMongoRepository.a(new ArrayList(oswLagRealList), n.b));
            if (!CollectionUtils.isEmpty((Collection)oswLagPOS)) {
                oswLagPOS.forEach(oswLagPO -> lagTemplateIdMap.put(oswLagPO.getLag(), oswLagPO.getId()));
            }
        }
    }

    private void copyOswTemplatePO(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteTemplateId, OswBackupDTO oswBackupDTO, Map<String, String> lanNetworkMaps, Map<String, String> oswDeviceTemplateIdMap, Map<String, String> cliConfigMap) {
        ArrayList batchSaveOsw = new ArrayList();
        Optional.ofNullable(oswBackupDTO.getOswTemplate()).ifPresent(oswTemplatePO -> {
            String oldOswDeviceTemplateId = oswTemplatePO.getId();
            oswTemplatePO.setOmadacId(omadacId.a());
            oswTemplatePO.setSiteTemplateId(newSiteTemplateId.a());
            oswTemplatePO.setSiteId(newSiteTemplateId.a());
            this.handleMvlanNetworkTemplate((OswTemplatePO)oswTemplatePO, omadacId, lanNetworkMaps);
            String newDeviceTemplateId = this.oswMaintMongoRepository.c();
            oswTemplatePO.setDeviceTemplateId(newDeviceTemplateId);
            oswTemplatePO.setMac(newDeviceTemplateId);
            oswTemplatePO.setId(newDeviceTemplateId);
            this.handleDeviceCli(oswTemplatePO.getCliSetting(), cliConfigMap);
            batchSaveOsw.add(oswTemplatePO);
            oswDeviceTemplateIdMap.put(oldOswDeviceTemplateId, newDeviceTemplateId);
        });
        this.oswMaintMongoRepository.a(new ArrayList(batchSaveOsw), n.b);
    }

    private void handleOswSwitchQos(OswQosConfigPO qosConfig, Map<String, String> profileMap) {
        if (Objects.nonNull(qosConfig)) {
            if (Objects.nonNull(qosConfig.getDscpDot1pMappingId())) {
                qosConfig.setDscpDot1pMappingId(profileMap.get(qosConfig.getDscpDot1pMappingId()));
            }
            if (Objects.nonNull(qosConfig.getDot1pQueueMappingId())) {
                qosConfig.setDot1pQueueMappingId(profileMap.get(qosConfig.getDot1pQueueMappingId()));
            }
            if (Objects.nonNull(qosConfig.getQueueSchedulerMappingId())) {
                qosConfig.setQueueSchedulerMappingId(profileMap.get(qosConfig.getQueueSchedulerMappingId()));
            }
        }
    }

    private void handleOswSaveWithTemplate(OswBatchSaveDTO oswBatchSaveDTO) {
        this.oswMaintMongoRepository.a(oswBatchSaveDTO.getBatchSaveOsw());
        this.oswLagMaintMongoRepository.a(oswBatchSaveDTO.getBatchSaveOswLagPO());
        this.oswPortMaintMongoRepository.a(oswBatchSaveDTO.getBatchSaveOswPortPO());
        this.oswNetworkMaintMongoRepository.a(oswBatchSaveDTO.getBatchSaveOswNetworkPO());
        if (log.isDebugEnabled()) {
            log.debug(" handleOswSaveWithTemplate getBatchSaveOsw{} , getBatchSaveOswNetworkPO{}", (Object)com.tplink.smb.omada.common.util.x.a(oswBatchSaveDTO.getBatchSaveOsw()), (Object)com.tplink.smb.omada.common.util.x.a(oswBatchSaveDTO.getBatchSaveOswNetworkPO()));
        }
        this.oswStaticRoutingMaintMongoRepository.a(oswBatchSaveDTO.getBatchSaveStaticRoutingPO());
    }

    private void handleOswPOWithTemplate(OswBackupDTO oswBackupDTO, List<OswPO> oswList, Map<String, String> lanNetworkIdMap, OswBatchSaveDTO oswBatchSaveDTO) {
        ArrayList<OswPO> batchSaveOsw = new ArrayList<OswPO>();
        ArrayList<OswLagPO> batchSaveOswLagPO = new ArrayList<OswLagPO>();
        ArrayList<OswPortPO> batchSaveOswPortPO = new ArrayList<OswPortPO>();
        ArrayList<OswNetworkPO> batchSaveOswNetworkPO = new ArrayList<OswNetworkPO>();
        ArrayList<OswStaticRoutingPO> batchSaveStaticRoutingPO = new ArrayList<OswStaticRoutingPO>();
        oswList.forEach(oswPO -> {
            HashMap<Integer, String> newLagMap = new HashMap<Integer, String>();
            OswTemplatePO oswTemplate = oswBackupDTO.getOswTemplate();
            com.tplink.smb.omada.manager.port.mongo.device.osw.d.a((OswPO)oswPO, (OswTemplatePO)oswTemplate);
            oswPO.setMvlanNetworkId(lanNetworkIdMap.getOrDefault(oswTemplate.getMvlanNetworkId(), oswTemplate.getMvlanNetworkId()));
            oswPO.setOverride(Boolean.valueOf(false));
            oswPO.setTemplateId(oswTemplate.getId());
            batchSaveOsw.add((OswPO)oswPO);
            List<OswLagTemplatePO> oswLagTemplatePOS = oswBackupDTO.getOswLagTemplatePOS();
            List<OswPortTemplatePO> oswPortTemplatePOS = oswBackupDTO.getOswPortTemplatePOS();
            List<OswNetworkTemplatePO> vlanIfTemplates = oswBackupDTO.getVlanIfTemplates();
            List<OswStaticRoutingTemplatePO> staticRoutingTemplates = oswBackupDTO.getStaticRoutingTemplates();
            if (log.isDebugEnabled()) {
                log.debug("sync copy vlanIfTemplates {}, omadacId {}, siteId{}, mac {}", new Object[]{com.tplink.smb.omada.common.util.x.a(vlanIfTemplates), oswPO.getOmadacId(), oswPO.getSiteId(), oswPO.getMac()});
            }
            this.handleOswLagsWithTemplate(oswLagTemplatePOS, (OswPO)oswPO, lanNetworkIdMap, (Map<Integer, String>)newLagMap, (List<OswLagPO>)batchSaveOswLagPO);
            this.handleOswPortsWithTemplate(oswPortTemplatePOS, (OswPO)oswPO, lanNetworkIdMap, (Map<Integer, String>)newLagMap, (List<OswPortPO>)batchSaveOswPortPO);
            this.handleVlanIfsWithTemplate(vlanIfTemplates, (OswPO)oswPO, lanNetworkIdMap, (List<OswNetworkPO>)batchSaveOswNetworkPO);
            if (log.isDebugEnabled()) {
                log.debug("sync copy handleVlanIfsWithTemplate {}, omadacId {}, siteId{}, mac {}", new Object[]{com.tplink.smb.omada.common.util.x.a((Object)batchSaveOswNetworkPO), oswPO.getOmadacId(), oswPO.getSiteId(), oswPO.getMac()});
            }
            this.handleStaticRoutingsWithTemplate(staticRoutingTemplates, (OswPO)oswPO, (List<OswStaticRoutingPO>)batchSaveStaticRoutingPO);
        });
        if (Objects.isNull(oswBatchSaveDTO)) {
            oswBatchSaveDTO = new OswBatchSaveDTO();
        }
        oswBatchSaveDTO.saveAll(batchSaveOsw, batchSaveOswLagPO, batchSaveOswPortPO, batchSaveOswNetworkPO, batchSaveStaticRoutingPO);
    }

    private void handleStaticRoutingsWithTemplate(List<OswStaticRoutingTemplatePO> staticRoutingTemplates, OswPO oswPO, List<OswStaticRoutingPO> batchSaveStaticRoutingPO) {
        staticRoutingTemplates.forEach(oswStaticRoutingTemplatePO -> {
            OswStaticRoutingPO oswStaticRoutingPO = oswStaticRoutingTemplatePO.copyFromTemplate();
            oswStaticRoutingPO.setMac(oswPO.getMac());
            oswStaticRoutingPO.setSiteId(oswPO.getSiteId());
            oswStaticRoutingPO.setOmadacId(oswPO.getOmadacId());
            oswStaticRoutingPO.setEntryId(Integer.valueOf(this.getSequenceNumService.a(oswPO.getOmadacId(), oswPO.getSiteId(), OswStaticRoutingPO.class)));
            batchSaveStaticRoutingPO.add(oswStaticRoutingPO);
        });
    }

    private void handleVlanIfsWithTemplate(List<OswNetworkTemplatePO> vlanIfTemplates, OswPO oswPO, Map<String, String> lanNetworkIdMap, List<OswNetworkPO> batchSaveOswNetworkPO) {
        vlanIfTemplates.forEach(oswNetworkTemplatePO -> {
            OswNetworkPO oswNetworkPO = oswNetworkTemplatePO.copyFromTemplate();
            oswNetworkPO.setMac(oswPO.getMac());
            oswNetworkPO.setSite(oswPO.getSiteId());
            oswNetworkPO.setOmadacId(oswPO.getOmadacId());
            oswNetworkPO.setLanNetworkId(lanNetworkIdMap.getOrDefault(oswNetworkPO.getLanNetworkId(), oswNetworkPO.getLanNetworkId()));
            if (log.isDebugEnabled()) {
                log.debug("handleVlanIfsWithTemplate oswNetworkPO {}", (Object)com.tplink.smb.omada.common.util.x.a((Object)oswNetworkPO));
            }
            batchSaveOswNetworkPO.add(oswNetworkPO);
        });
    }

    private void handleOswPortsWithTemplate(List<OswPortTemplatePO> oswPortTemplatePOS, OswPO oswPO, Map<String, String> lanNetworkIdMap, Map<Integer, String> newLagMap, List<OswPortPO> batchSaveOswPortPO) {
        oswPortTemplatePOS.forEach(oswPortTemplatePO -> {
            OswPortPO oswPortPO = oswPortTemplatePO.copyFromTemplate();
            oswPortPO.setOswMac(oswPO.getMac());
            oswPortPO.setSiteId(oswPO.getSiteId());
            oswPortPO.setOmadacId(oswPO.getOmadacId());
            oswPortPO.setLanProfileId(lanNetworkIdMap.getOrDefault(oswPortPO.getLanProfileId(), oswPortPO.getLanProfileId()));
            oswPortPO.setLagId(newLagMap.getOrDefault(oswPortPO.getLag(), oswPortPO.getLagId()));
            batchSaveOswPortPO.add(oswPortPO);
        });
    }

    private void handleOswLagsWithTemplate(List<OswLagTemplatePO> oswLagTemplatePOS, OswPO oswPO, Map<String, String> lanNetworkIdMap, Map<Integer, String> newLagMap, List<OswLagPO> batchSaveOswLagPO) {
        oswLagTemplatePOS.forEach(oswLagTemplatePO -> {
            OswLagPO oswLagPO = oswLagTemplatePO.copyFromTemplate();
            oswLagPO.setOswMac(oswPO.getMac());
            oswLagPO.setSiteId(oswPO.getSiteId());
            oswLagPO.setOmadacId(oswPO.getOmadacId());
            String newLagId = this.oswLagMaintMongoRepository.b();
            oswLagPO.setId(newLagId);
            oswLagPO.setLanProfileId(lanNetworkIdMap.getOrDefault(oswLagPO.getLanProfileId(), oswLagPO.getLanProfileId()));
            newLagMap.put(oswLagPO.getLag(), newLagId);
            batchSaveOswLagPO.add(oswLagPO);
        });
    }

    private void handleOswSettingRemove(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, List<OswPO> oswList) {
        List macs = oswList.stream().map(DevicePO::getMac).collect(Collectors.toList());
        log.debug("handleOswSettingRemove mac list {}, omadacId {}, siteId {}", new Object[]{macs, omadacId, newSiteId});
        this.oswPortMaintMongoRepository.a(omadacId, newSiteId, macs);
        this.oswLagMaintMongoRepository.a(omadacId, newSiteId, macs);
        this.oswNetworkMaintMongoRepository.a(omadacId, newSiteId, macs);
        this.oswStaticRoutingMaintMongoRepository.a(omadacId, newSiteId, macs);
    }

    private void handleOswSettingRemove(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, String oswMac) {
        log.debug("handleOswSettingRemove switch mac {}, omadacId {}, siteId {}", new Object[]{oswMac, omadacId, newSiteId});
        this.oswPortMaintMongoRepository.a(omadacId, newSiteId, oswMac);
        this.oswLagMaintMongoRepository.a(omadacId, newSiteId, oswMac);
        this.oswNetworkMaintMongoRepository.a(omadacId, newSiteId, oswMac);
        this.oswStaticRoutingMaintMongoRepository.a(omadacId, newSiteId, oswMac);
    }

    private void handleOswWithOutTemplate(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, List<OswPO> oswPOList) {
        Optional defaultLanNetwork = this.lanNetworkMaintMongoRepository.c(omadacId, newSiteId);
        if (!defaultLanNetwork.isPresent()) {
            log.error("Can't find default lanNetwork. {}, {}.", (Object)omadacId, (Object)newSiteId);
            return;
        }
        String defaultLanNetworkId = ((LanNetworkPO)defaultLanNetwork.get()).getId();
        LanProfilePO defaultLanProfile = this.lanProfileMaintMongoRepository.a(omadacId.a(), newSiteId.a());
        if (defaultLanProfile == null) {
            log.error("Can't find default ALL LanProfile. {}, {}.", (Object)omadacId, (Object)newSiteId);
            return;
        }
        List allLanNetowrks = this.lanNetworkMaintMongoRepository.a(omadacId, newSiteId);
        for (OswPO oswPO : oswPOList) {
            this.handleOswPortsWithOutTemplate(omadacId, oswPO, defaultLanProfile);
            this.handleOswLagsWithoutTemplate(omadacId, oswPO, defaultLanProfile);
            this.handleOswVlanIfWithOutTemplate(omadacId, newSiteId, oswPO, allLanNetowrks, defaultLanNetworkId);
        }
        this.oswMaintMongoRepository.a(oswPOList);
    }

    private void handleOswPortsWithOutTemplate(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, OswPO oswPO, LanProfilePO defaultLanProfile) {
        List oswPorts = this.oswPortMaintMongoRepository.b(omadacId.a(), oswPO.getMac());
        if (!CollectionUtils.isEmpty((Collection)oswPorts)) {
            for (OswPortPO oswPortPO : oswPorts) {
                oswPortPO.setLanProfileId(defaultLanProfile.getId());
                oswPortPO.setLanProfileName(defaultLanProfile.getName());
                oswPortPO.setProfileOverrideEnable(Boolean.valueOf(false));
            }
            this.oswPortMaintMongoRepository.a(oswPorts);
        }
    }

    private void handleOswLagsWithoutTemplate(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, OswPO oswPO, LanProfilePO defaultLanProfile) {
        List oswLags = this.oswLagMaintMongoRepository.b(omadacId.a(), oswPO.getMac());
        if (!CollectionUtils.isEmpty((Collection)oswLags)) {
            for (OswLagPO oswLagPO : oswLags) {
                oswLagPO.setLanProfileId(defaultLanProfile.getId());
                oswLagPO.setLanProfileName(defaultLanProfile.getName());
                oswLagPO.setProfileOverrideEnable(Boolean.valueOf(false));
            }
            this.oswLagMaintMongoRepository.a(oswLags);
        }
    }

    private void handleOswVlanIfWithOutTemplate(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, OswPO oswPO, List<LanNetworkPO> allLanNetworks, String defaultLanNetworkId) {
        List existList = this.oswNetworkMaintMongoRepository.a(omadacId.a(), oswPO.getMac());
        Map existLanNetworkIdKeyMap = existList.stream().collect(Collectors.toMap(BaseOswNetworkPO::getLanNetworkId, Function.identity()));
        Map allLanNetworkMap = allLanNetworks.stream().collect(Collectors.toMap(BaseLanNetworkPO::getId, Function.identity()));
        String oldMvlanNetworkId = oswPO.getMvlanNetworkId();
        ArrayList<OswNetworkPO> needToDelete = new ArrayList<OswNetworkPO>();
        ArrayList<OswNetworkPO> needToSave = new ArrayList<OswNetworkPO>();
        if (!CollectionUtils.isEmpty(allLanNetworks)) {
            for (OswNetworkPO exist : existList) {
                if (allLanNetworkMap.containsKey(exist.getLanNetworkId())) {
                    needToSave.add(exist);
                    continue;
                }
                needToDelete.add(exist);
                if (!Objects.equals(oldMvlanNetworkId, exist.getLanNetworkId())) continue;
                if (!existLanNetworkIdKeyMap.containsKey(defaultLanNetworkId)) {
                    LanNetworkPO lanNetworkPO = (LanNetworkPO)allLanNetworkMap.get(defaultLanNetworkId);
                    OswNetworkPO oswNetworkPO = this.buildOswNetworkPO(omadacId, newSiteId, oswPO.getMac(), lanNetworkPO);
                    needToSave.add(oswNetworkPO);
                }
                oswPO.setMvlanNetworkId(defaultLanNetworkId);
                Integer vlan = ((LanNetworkPO)allLanNetworkMap.get(defaultLanNetworkId)).getVlan();
                oswPO.setMvlanBridgeVlan(vlan);
            }
            this.oswNetworkMaintMongoRepository.a(omadacId, needToDelete.stream().map(BaseOswNetworkPO::getId).collect(Collectors.toList()));
            this.oswNetworkMaintMongoRepository.a(needToSave);
        }
    }

    private OswNetworkPO buildOswNetworkPO(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d siteId, String mac, LanNetworkPO lanNetworkPO) {
        OswNetworkPO po = new OswNetworkPO();
        po.setOmadacId(omadacId.a());
        po.setSite(siteId.a());
        po.setMac(mac);
        po.setName(lanNetworkPO.getName());
        po.setStatus(Integer.valueOf(1));
        po.setMode(Integer.valueOf(0));
        po.setVlan(lanNetworkPO.getVlan());
        po.setLanNetworkId(lanNetworkPO.getId());
        OswIpSettingPO oswIpSettingPO = new OswIpSettingPO();
        oswIpSettingPO.setMode(r.b.c);
        oswIpSettingPO.setFallback(Boolean.valueOf(true));
        oswIpSettingPO.setFallbackIp("192.168.0.1");
        oswIpSettingPO.setFallbackMask("255.255.255.0");
        po.setIp(oswIpSettingPO);
        OswIpv6SettingPO oswIpv6SettingPO = new OswIpv6SettingPO();
        oswIpv6SettingPO.setIpv6Enable(Boolean.valueOf(false));
        po.setIpv6(oswIpv6SettingPO);
        return po;
    }

    private void handleDeviceCli(CliSettingPO cliSetting, Map<String, String> cliConfigMap) {
        if (Objects.nonNull(cliSetting) && !CollectionUtils.isEmpty((Collection)cliSetting.getCliConfigs())) {
            for (DecodeCliPO decodeCli : cliSetting.getCliConfigs()) {
                decodeCli.setConfigId(cliConfigMap.getOrDefault(decodeCli.getConfigId(), decodeCli.getConfigId()));
            }
        }
    }

    private Map<Integer, String> handleOswLags(List<OswLagPO> oswLags, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, Map<String, String> lanNetworkMaps, Map<String, String> portTagIdMap) {
        HashMap<Integer, String> lagIdMap = new HashMap<Integer, String>(12);
        if (!CollectionUtils.isEmpty(oswLags)) {
            ArrayList<OswLagPO> oswLagRealList = new ArrayList<OswLagPO>();
            for (OswLagPO oswLagPO2 : oswLags) {
                oswLagPO2.setId(null);
                oswLagPO2.setSiteId(newSiteId.a());
                oswLagPO2.setLanProfileId(lanNetworkMaps.get(oswLagPO2.getLanProfileId()));
                com.tplink.smb.omada.backup.core.d.a.a((AbstractOswPortSettingPO)oswLagPO2, portTagIdMap);
                com.tplink.smb.omada.backup.core.d.a.b((AbstractOswPortSettingPO)oswLagPO2, lanNetworkMaps);
                oswLagPO2.setOmadacId(omadacId.a());
                oswLagRealList.add(oswLagPO2);
            }
            List oswLagPOS = IterableUtils.toList((Iterable)this.oswLagMaintMongoRepository.a(oswLagRealList));
            if (!CollectionUtils.isEmpty((Collection)oswLagPOS)) {
                oswLagPOS.forEach(oswLagPO -> lagIdMap.put(oswLagPO.getLag(), oswLagPO.getId()));
            }
        }
        return lagIdMap;
    }

    private void handleOswPorts(List<OswPortPO> oswPorts, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, Map<String, String> lanNetworkMaps, Map<String, String> portTagIdMap, Map<Integer, String> lagIdMap) {
        if (!CollectionUtils.isEmpty(oswPorts)) {
            ArrayList<OswPortPO> oswPortsRealList = new ArrayList<OswPortPO>();
            for (OswPortPO oswPortPO : oswPorts) {
                oswPortPO.setId(null);
                oswPortPO.setSiteId(newSiteId.a());
                oswPortPO.setLanProfileId(lanNetworkMaps.get(oswPortPO.getLanProfileId()));
                com.tplink.smb.omada.backup.core.d.a.a((AbstractOswPortSettingPO)oswPortPO, portTagIdMap);
                com.tplink.smb.omada.backup.core.d.a.b((AbstractOswPortSettingPO)oswPortPO, lanNetworkMaps);
                oswPortPO.setLagId(lagIdMap.get(oswPortPO.getLag()));
                oswPortPO.setOmadacId(omadacId.a());
                oswPortsRealList.add(oswPortPO);
            }
            this.oswPortMaintMongoRepository.a(oswPortsRealList);
        }
    }

    private void handleMvlanNetwork(OswPO oswPO, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, String> lanNetworkMaps) {
        if (oswPO.getMvlanNetworkId() != null && !CollectionUtils.isEmpty(lanNetworkMaps)) {
            this.lanNetworkMaintMongoRepository.a(omadacId.a(), lanNetworkMaps.get(oswPO.getMvlanNetworkId())).ifPresent(lanNetworkPO -> oswPO.setMvlanNetworkId(lanNetworkPO.getId()));
        }
    }

    private void handleMvlanNetworkTemplate(OswTemplatePO oswTemplatePO, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, String> lanNetworkMaps) {
        if (oswTemplatePO.getMvlanNetworkId() != null && !CollectionUtils.isEmpty(lanNetworkMaps)) {
            this.lanNetworkMaintMongoRepository.b(omadacId.a(), lanNetworkMaps.get(oswTemplatePO.getMvlanNetworkId())).ifPresent(lanNetworkPO -> oswTemplatePO.setMvlanNetworkId(lanNetworkPO.getId()));
        }
    }

    private void handleOswVlanIf(OswBackupDTO dto, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, Map<String, String> lanNetworkMaps, Map<String, String> vrfIdMap) {
        List<OswNetworkPO> vlanIfs = dto.getVlanIfs();
        if (!CollectionUtils.isEmpty(vlanIfs)) {
            for (OswNetworkPO oswNetwork : vlanIfs) {
                oswNetwork.setId(null);
                oswNetwork.setOmadacId(omadacId.a());
                oswNetwork.setSite(newSiteId.a());
                oswNetwork.setLanNetworkId(lanNetworkMaps.get(oswNetwork.getLanNetworkId()));
                oswNetwork.setVrfId(vrfIdMap.get(oswNetwork.getVrfId()));
                if (oswNetwork.getDhcpServer() != null) {
                    oswNetwork.getDhcpServer().setVrfId(vrfIdMap.get(oswNetwork.getDhcpServer().getVrfId()));
                }
                if (oswNetwork.getDhcpRelay() == null) continue;
                oswNetwork.getDhcpRelay().setVrfId(vrfIdMap.get(oswNetwork.getDhcpRelay().getVrfId()));
            }
            this.oswNetworkMaintMongoRepository.a(vlanIfs);
        }
    }

    private void handleOswStaticRouting(OswBackupDTO dto, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, Map<String, String> vrfIdMap) {
        List<OswStaticRoutingPO> staticRoutings = dto.getStaticRoutings();
        if (!CollectionUtils.isEmpty(staticRoutings)) {
            for (OswStaticRoutingPO oswStaticRoutingPO : staticRoutings) {
                oswStaticRoutingPO.setId(null);
                oswStaticRoutingPO.setOmadacId(omadacId.a());
                oswStaticRoutingPO.setSiteId(newSiteId.a());
                oswStaticRoutingPO.setVrfId(vrfIdMap.get(oswStaticRoutingPO.getVrfId()));
                oswStaticRoutingPO.setNextHopVrfId(vrfIdMap.get(oswStaticRoutingPO.getNextHopVrfId()));
            }
            this.oswStaticRoutingMaintMongoRepository.a(staticRoutings);
        }
    }

    private void handleOswLoopbackInterface(OswBackupDTO dto, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId) {
        List<OswLoopbackInterfacePO> loopbackInterfacePOS = dto.getLoopbackInterfacePOS();
        if (!CollectionUtils.isEmpty(loopbackInterfacePOS)) {
            for (OswLoopbackInterfacePO oswLoopbackInterfacePO : loopbackInterfacePOS) {
                oswLoopbackInterfacePO.setOmadacId(omadacId.a());
                oswLoopbackInterfacePO.setSiteId(newSiteId.a());
            }
            this.oswLoopbackInterfaceMaintMongoRepository.a(loopbackInterfacePOS);
        }
    }

    public void siteCopyWrite(Object dataObject, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
    }
}

